*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

*  APICKS.PRG

FUNC apicks
   PARA rec_array,top_row,left_col,bot_row,right_col
   *   rec_array[max_size]  &&  Array of recno's selected
   *  vars defined in calling prg:
   *   mtitle
   *   wtitle
   *   wfields              &&  With M->selected as the first field

   PRIVATE mscreen, ;   &&  screen to save
           firstrow, ;  &&  starting row
           mquit , ;    &&  Logical Quit/ not Quit
           keypress,;   &&  ASCII of key pressed
           mloop   ,;   &&  Logical Loop/ not Loop
           mchoice ,;   &&  Character menu choice ... Browse mode
           fchoice ,;   &&  Character menu choice ... Full screen mode
           lastrow ,;   &&  last row displayed in browse
           cur_row ,;   &&  current row of cursor
           max_size,;   &&  Maximum size of rec_array
           array_ptr,;  &&  Pointer to current rec_array element
           end_ptr,;    &&  Pointer to next empty rec_array element
           last_col,;   &&  last column in wfields expansion - used by changed_key()
           white,;      &&  state of color bar
           fill         &&  calc of spaces at end of say for redisplay of wfields

   *  Define array for chosen recno's 
   FOR i = 1 TO LEN(rec_array)               && rec_array defined in calling program
     rec_array[i] = IF(TYPE('rec_array[i]')=[U],0,rec_array[i])
   NEXT
   wfields       = [APICKED(rec_array)+' '+]+wfields
   DO set_browse
   mret = SAVESCR(top_row,MAX(left_col-1,0),MIN(bot_row+1,24),right_col)
   max_size      = LEN(rec_array) && Maximum size of rec_array
   array_ptr     = 1              && Used to find desired element
   end_ptr       = 1              && has to be <= max_size
   default_color = IF(TYPE([default_color])=[U],.T.,default_color)

   * see if any GROUP is specified:
   IF TYPE([M->group_key]) = [U]
      group_key = []
   ENDIF
   IF TYPE([M->group]) = [U]
      group  = IF(EMPTY(M->group_key), [], &group_key)
   ENDIF

   *  Screen 
   CO_PUSH()
   CO_CHG(0,c_frame)
   DRAWSHADOW(top_row,left_col,bot_row,right_col)
   CO_CHG(IF(default_color,c_window,curr_grp),c_frame)
   @ top_row,left_col,bot_row,right_col BOX stdbox
   CO_CHG(curr_grp,c_sayget)
   SCROLL(top_row+1,left_col+1,bot_row-1,right_col-1,0)   && Clears it
   IF ! EMPTY(mtitle)
      mtitle = [ ]+TRIM(LTRIM(mtitle))+[ ]
      xcol = left_col + (((right_col-left_col) - LEN(mtitle)) / 2)
      CO_CHG(curr_grp,c_title)
      @ top_row,xcol SAY mtitle
   ENDIF
   old_screen = SAVESCREEN(24,0,24,79)
   wprompt = IF(TYPE([wprompt])=[U],'Press letter to list from, [Enter] to pick record. [Ctrl Enter] when done',wprompt)
   @ 24,0
   @ 24,0 SAY wprompt

   *  Ready to go 
   CURS_OFF()
   SET MESSAGE TO
   firstrow = top_row+3

   white     = .F.
   mquit     = .F.
   mrepl_ok  = .T.
   DO WHIL ! mquit
       CO_CHG(curr_grp,c_sayget)
       SCROLL(M->top_row+1,M->left_col+1, M->bot_row-1, M->right_col-1,0)
       CO_CHG(curr_grp,c_text)
       @ top_row+2,left_col+3 SAY wtitle
       CO_CHG(curr_grp,c_sayget)
       DO list_em
       mloop = .T.
       DO WHIL mloop
           IF ! M->white
              DO rev_line
           ENDIF

           SET CONS OFF
           WAIT []
           SET CONS ON
           keypress = LASTKEY()
           mchoice = UPPER(CHR(keypress))

           IF keypress =  13
              array_ptr = ASCAN(rec_array,RECNO())
              IF array_ptr = 0     && Didn't find record number, mark as picked
                 IF end_ptr = max_size
                    DO kbhit WITH [Maximum number of records selected.  Any key continues...]
                 ELSE
                    rec_array[end_ptr] = RECNO()
                    end_ptr = end_ptr + 1
                 ENDIF
              ELSE
                 ADEL(rec_array,array_ptr)
                 end_ptr = end_ptr - 1
                 rec_array[max_size] = 0
              ENDIF
              fill = right_col - left_col - 4 - LEN(&wfields)
              @ cur_row,left_col+2 SAY SPAC(2) + &wfields. + SPAC(fill)
              DO rev_line
              M->white = .T.
              KEYBOARD CHR(24)
              LOOP
           ENDIF

           ********** Code to find first record of the letter you press ********
           IF ! CURSORKEY(keypress) .AND. ! ESC() .AND. keypress <> 10
              IF ! EMPTY(INDEXKEY(0))
                 PRIV mrec
                 mrec = RECNO()
                 SET SOFTSEEK ON
                 SEEK UPPER(CHR(LASTKEY()))
                 SET SOFTSEEK OFF
                 IF EOF()
                    GOTO mrec
                    LOOP
                 ENDIF
                 mloop = .F.
                 LOOP
              ENDIF
           ENDIF
           DO rev_line
           DO cursor
           IF keypress = 10
              mloop = .F.
              mquit = .T.
           ENDIF
       ENDDO
   ENDDO
   CO_POP()
   CURS_ON()
   RESTSCREEN(24,0,24,79,old_screen)
RETU mret

FUNC apicked
   PARA rec_array
RETU IF(ASCAN(rec_array,RECNO())<>0,CHR(2),[ ])
