

/*
 * File......   : FCOPY.c
 * Author....   : Peter Kulek
 * Date......   : $Date:   06 Aug 1993  $
 * Revision..   : $Revision:   1.2  $
 * Log file..   : $Logfile:   c:\impala5\c\fcopy.c  $
 * Compuserve ID: 100140,1220
 * 
 * This is an original work by Peter Kulek
 * Copyright (c) 1993  Peter Kulek 
 *
 * Modification history:
 * ---------------------
 * 14 Nov 1993
 * cleaned up code and added true pathname checking
 * $Log:   $
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FCOPY()
 *  $CATEGORY$
 *     DOS
 *  $ONELINER$
 *     Copy one file to another with code block progress evaluation.
 *  $SYNTAX$
 *     F_COPY(cSouce,cDest)                        -> nBytes
 *     F_COPY(cSouce,cDest,lAppend)                -> nBytes 
 *     F_COPY(cSouce,cDest,lAppend,nBuffer)        -> nBytes 
 *     F_COPY(cSouce,cDest,lAppend,bBlock,nBuffer) -> nBytes 
 *  $ARGUMENTS$
 *     <cSource>     Source File Name
 *     <cDest>       Destination Name
 *     <lAppend>     .T. To append Source File To Destination file if 
 *                   it exists.
 *     <bBlock>      Code block to evaluate after every buffer read
 *                   If the code block return a .F. then the copy
 *                   procedure will terminate with a -97 error code.
 *     <nBuffer>     Buffer Size
 *  $RETURNS$
 *     <nBytes>      Number of Bytes Copied
 *                   If Error returns -Ve Value equivalent to
 *                   DOS error codes.
 *
 *  $DESCRIPTION$
 *      This function copies one file to another, much as the 
 *      DOS COPY command does.  This version adds the capability 
 *      to detect if the source and target filespecs, in fact, 
 *      refer to the same file. It will not copy a file onto itself,
 *      and will return an error if that is attempted. For This Feature 
 *      to work DOS Ver above 3 must be used.
 *      It also  evaluates a code block after every buffered write.
 *      F_COPY() uses VM to allocate a large file buffer.        
 *      The buffer size, can be any int sized value up to 
 *      65,534.  It is recommended that the buffer be a multiple 
 *      of the sector size (512 bytes in the current version of DOS),
 *      since reads and writes are more efficient if they involve 
 *      whole sectors.
 *  $EXAMPLES$
 *    function FileCopy(cSource,cDest)
 *    local nRetVal
 *    local bBlock := {|x,y|devpos(24,30),;
 *                    devout('Bytes Copied '+alltrim(str(x))+;
 *                    ' - '+alltrim(str(x/y*100))+' %'),;
 *                    if(inkey()==27,alert('Interupted By User',;
 *                    {'Continue Copying','Cancel Copying'})!=2,NIL)}
 *        if (nRetVal := f_copy(cSource,cDest,.F.,bBlock,4096)) < 0
 *            alert('Error In Copying File')
 *        endif
 *    return(nRetVal)
 *
 *  $END$
 */

#include "extend.h"
#include "clipdefs.h"
#include "filesys.api"
#include "vm.api"
#include "item.api"
#include "impala.h"

#define BUFFER_SIZE 4096   // Can be changed from f_copy parameter 4 or 5
#define IF(x)       if (x) {
#define ELSE        } else {
#define ELSEIF(x)   } else if(x) {
#define ENDIF       }
#define EXIT        break;
#define DOWHILE     while(1) {
#define ENDDO       }

#define FOPEN(x,y)      _fsOpen(x, y)
#define FCREATE(x,y)    _fsCreate(x,y)
#define FCLOSE(x)       _fsClose(x)
#define FREAD(x,y,z)    _fsRead(x,y,z)
#define FSEEK(x,y,z)    _fsSeek(x,y,z)
#define FWRITE(x,y,z)   _fsWrite(x,y,z)
#define FERROR()        _fsError()  

#define MLOCK(x)        _xvlock(x)  
#define MUNLOCK(x)      _xvunlock(x)  

#define MALLOC(x,y)    _xvalloc(x,y)  
#define FREE(x)        _xvfree(x)  
//----------------------------------------------------------------------------
static long _fsCopy(BYTEP ,BYTEP,int,unsigned int ) ;
static int  blockeval(ITEM , ULONG, ULONG) ;
extern int  strcmp (const char *s1, const char *s2) ;
extern int  strlen(BYTEP) ;           // Clipper Internal
extern int  dostruename (BYTEP,BYTEP) ;
//----------------------------------------------------------------------------
CLIPPER F_COPY() {
    unsigned int uiBuff = ISNUM(5) ? _parni(5) : BUFFER_SIZE  ;
    uiBuff = ISNUM(4) ? _parni(4) : uiBuff ;
    IF ( ISCHAR(1) && ISCHAR(2) )
        _retnl( _fsCopy((BYTEP)_parc(1),(BYTEP)_parc(2),_parl(3),uiBuff) );
    ELSE
        _retni(-13); // Invalid Data - Dos Error Equiv
    ENDIF
    return;
} 
//----------------------------------------------------------------------------
static long _fsCopy(BYTEP source,BYTEP dest,int iAppend,unsigned int uiBuff ) {
    HANDLE hSegment ;
    FHANDLE dHANDLE,sHANDLE;
    char    *buffer;
    USHORT  usCount;
    long   ulCount = 0L ;
    long   ulFSize = 0L;
    long   ulDSize = 0L;
    int    iDestDrive  = 0;
    char bSName[128];      // buffer for qualified source name 
    char bDName[128];      // buffer for qualified destination name 
    // Get true names of source and destination in case we try to copy 
    // to same file
    IF ( ! dostruename(source, bSName) && ! dostruename(dest, bDName) ) 
        IF ( strcmp(bSName, bDName) )       // if the names are the same 
            return( -52 ) ;                 // return error 
        ENDIF
    ENDIF
    sHANDLE = FOPEN(source, FO_READ);
    IF( ! FERROR() ) 
        // Could use SplitPath function here
        IF ( strlen( dest) > 2 ) // Check For Drive Letter
            IF ( dest[1] == ':')
                iDestDrive = toupper( dest[0]) - 64 ;//convert to int
            ENDIF    
        ENDIF    
        // Get Source File Size
        ulFSize = FSEEK(sHANDLE,0,FS_END);
        FSEEK(sHANDLE,0,FS_SET);
        IF (iAppend)  // Append to end of Target
            // Check For available diskspace
            IF ( diskfree(iDestDrive) < ulFSize )
                ulCount = -99L ; // Not Enough Disk Space
            ELSE
                dHANDLE = FOPEN(dest,FO_READWRITE);
                IF( FERROR() ) 
                    dHANDLE = FCREATE(dest,FC_NORMAL);
                ELSE
                    FSEEK(dHANDLE,0,FS_END);
                ENDIF
                IF( FERROR() ) 
                    ulCount = -(FERROR()) ;
                ENDIF    
            ENDIF    
        ELSE // Copy over destination if exists
            dHANDLE = FOPEN(dest,FO_READWRITE);
            IF( FERROR() ) 
                IF ( diskfree(iDestDrive) < ulFSize  )
                    ulCount = -99L ; // Not Enough Disk Space
                ENDIF    
            ELSE
                ulDSize = FSEEK(dHANDLE,0,FS_END);
                FSEEK(sHANDLE,0,FS_SET);
                IF ( (diskfree(iDestDrive)+ulDSize) < ulFSize  )
                     ulCount = -99L ; // Not Enough Disk Space
                ENDIF
                FCLOSE(dHANDLE);
            ENDIF
            IF (ulCount == 0)
                dHANDLE = FCREATE(dest,FC_NORMAL);
            ENDIF    
        ENDIF
        IF( ! FERROR() && ulCount == 0 ) 
            IF( hSegment = MALLOC(uiBuff,0) ) 
                DOWHILE  // Copy buffer Till Finished
                    buffer = MLOCK(hSegment) ; // Lock Segment
                    IF(buffer == NULL)
                        ulCount =  -98L ; // Could Not Allocate Memory
                        EXIT
                    ENDIF
                    usCount = FREAD(sHANDLE,buffer,uiBuff);
                    ulCount += (long)usCount;
                    IF (usCount != uiBuff )
                        EXIT   // Less Than Buffer Finish Last Bytes
                    ELSE    
                        MUNLOCK(hSegment); //Unlock Segment to free mem for Block
                    ENDIF
                    FWRITE(dHANDLE,buffer, usCount);
                    IF( FERROR() ) 
                        ulCount = -(FERROR()) ;
                        EXIT
                    ELSE
                        IF (! blockeval(_itemParam(4),ulCount,ulFSize))
                             ulCount = -97L ; // Terminated by user
                             EXIT
                        ENDIF
                    ENDIF
                ENDDO 
                IF (ulCount > 0)  // Finish Last Bytes
                    FWRITE(dHANDLE,buffer,usCount);
                    MUNLOCK(hSegment);
                    IF( FERROR() ) 
                        ulCount = -(FERROR()) ;
                    ELSE
                        IF (! blockeval(_itemParam(4),ulCount,ulFSize))
                             ulCount = -97L ;  // Terminated by user
                        ENDIF
                    ENDIF
                ENDIF    
                FCLOSE(sHANDLE);
                IF( FERROR() ) 
                    ulCount = -(FERROR()) ;
                ENDIF
                FCLOSE(dHANDLE);
                IF( FERROR() ) 
                    ulCount = -(FERROR()) ;
                ENDIF
                DOWHILE
                    IF( _xvlockcount(hSegment) == 0 )
                        EXIT
                    ENDIF
                    MUNLOCK(hSegment);
                ENDDO
            ENDIF
            FREE(hSegment);   
        ELSE     
            FCLOSE(sHANDLE);
        ENDIF
    ELSE
        ulCount =  -(FERROR()) ;
    ENDIF
    return( ulCount );
}
//----------------------------------------------------------------------------
static int blockeval(ITEM block,ULONG count,ULONG size) {
    EVALINFO info;  // Create eval Info
    ITEM     retP;
    int iRet = 1;
    IF( _itemType(block) == BLOCK )
        _evalNew(&info,block); // Create an object of eval
        _evalPutParam(&info,_itemPutNL(NULL,count)); // Put parameter on stack
        _evalPutParam(&info,_itemPutNL(NULL,size)); // Put parameter on stack
        retP = _evalLaunch(&info);   // Eval code block
        _evalRelease(&info);  // Release object
        IF( (_itemType(retP) == LOGICAL) && (! _itemGetL(retP)))
            iRet = 0;  // Exit from Fcopy with false return from Block
        ENDIF
        _itemRelease(retP);  // release parameters from stack       
    ENDIF
    return(iRet);
}



