*:*********************************************************************
*:
*:  S I L V E R F A X         -     SilverClip Communications Library
*:				    FAX task and send info example program.
*:
*:				    Copyright (c) 1992-1993 SilverWare Inc.
*:
*:
*:
*: Procedure file: SWFAX.PRG
*:
*:         System: SWFAX
*:         Author: John P. Halovanic
*:  Last modified: 10/05/92     15:28
*:
*:  Procs & Fncts: MAIN()
*:               : LOADQARRAY()
*:               : QPICKLIST()
*:               : DISPLAYECF()
*:               : DISPLAYFTR()
*:               : DISPEXBLK()
*:               : FDTOD()
*:               : FTTOT()
*:               : MSGSHOW()
*:               : FAXBCKDROP()
*:               : FTRSTAT()
*:               : TYPE2STR()
*:               : CLASS2STR()
*:               : DIRC2STR()
*:               : FAXERROR()
*:
*:*********************************************************************


#include "SWFAX.CH"
#include "INKEY.CH"

#define CRLF		chr(13)+chr(10)
#define NOEVENTS	"   No Events In This QUEUE To Show....   "

MEMVAR cClrBack, cClrInfo, cClrText, cClrTitle
MEMVAR lBoard1, lBoard2, lBoard3, lBoard4, nActive


*!*********************************************************************
*!
*!       Function: MAIN()
*!
*!      Called by: SilverFax.PRG                       
*!
*!          Calls: SETCOLOR()         (function  in CLIPPER.LIB)
*!               : SWFISCAS()         (function  in SLVRCLIP.LIB)
*!               : MSGSHOW()          (function  in SILVERFAX.PRG)
*!               : FAXBCKDROP()       (function  in SWFAX.PRG)
*!               : LOADQARRAY()       (function  in SWFAX.PRG)
*!               : QPICKLIST()        (function  in SWFAX.PRG)
*!               : SWFLCUREV()        (function  in SLVRCLIP.LIB)
*!               : DISPLAYECF()       (function  in SWFAX.PRG)
*!               : DISPEXBLK()        (function  in SWFAX.PRG)
*!
*!*********************************************************************

FUNCTION Main()
LOCAL anTASKQueue[100], anLOGQueue[100], anRECQueue[100]
LOCAL nTASKTot := 0, nLOGTot := 0, nRECTot := 0
LOCAL nIsCAS, nChoice := 1, nCurrent := -1, nReturn := -1
LOCAL nRow1, nCol1, nRow2, nCol2

PUBLIC cClrBack, cClrInfo, cClrText, cClrTitle
PUBLIC lBoard1 := .f., lBoard2 := .f., lBoard3 := .f., lBoard4 := .f., nActive

SET CURSOR OFF
SET key K_F1 to DisplayInfo()

nRow1 := 0
nCol1 := 0
nRow2 := nRow1 + 11
nCol2 := nCol1 + 20


if iscolor()				&& define color variables
   cClrBack  := "W+/B,R/W,  N,W/B,W/B"
   cClrInfo  := "GR+/B,GR+/RB+,N"
   cClrText  := "W+/B,R/W,  N,W/B,W/B"
   cClrTitle := "GR+/BG+,W+/B,N"
   
else
   cClrBack  := "W+/N, I,   W/N,W/N,W/N"
   cClrInfo  := "W+/N, N/W, W/N,W/N,W/N"
   cClrText  := "W/N,  N/W, W/N,W/N,W/N"
   cClrTitle := "N/W, W+/N,W/N,W/N,W/N"
   
endif

setcolor(cClrBack)			&& Set color back-drop
cls

nIsCas := SWFIsCAS()			&& Check for CAS Mgm 1

if nIsCAS == SWFINSTALLED
   lBoard1 := .t.

endif

SWFSetMpx(SWCAS2)
nIsCas := SWFIsCAS()			&& Check for CAS Mgm 2
if nIsCAS == SWFINSTALLED
   lBoard2 := .t.

endif

SWFSetMpx(SWCAS3)
nIsCas := SWFIsCAS()			&& Check for CAS Mgm 3
if nIsCAS == SWFINSTALLED
   lBoard3 := .t.

endif

SWFSetMpx(SWCAS4)
nIsCas := SWFIsCAS()			&& Check for CAS Mgm 4
if nIsCAS == SWFINSTALLED
   lBoard4 := .t.

endif

if (!lBoard1 .and. !lBoard2 .and. !lBoard3 .and. !lBoard4)
   MsgShow(8,"CAS not detected, please verify installation of CAS Manager",.f.,1)
   ?chr(7)+chr(7)+chr(7)
   MsgShow(12,"Returned -> "+str(nIsCAS,4),.f.,1)
   ?chr(7)
   MsgShow(16,"Please check you CONFIG.SYS & AUTOEXEC.BAT for CAS drivers",.f.,0)

   if file("info.txt")
      setcolor(cClrBack)
      cls
      ProductInfo()

   endif
   quit

else
   do case
      case lBoard1
         SWFSetMpx(SWCAS1)		&& Use board 1
	 nActive := 1

      case lBoard2
         SWFSetMpx(SWCAS2)		&& Use board 2
	 nActive := 2

      case lBoard3
         SWFSetMpx(SWCAS3)		&& Use board 3
	 nActive := 3

      case lBoard4
         SWFSetMpx(SWCAS4)		&& Use board 4
	 nActive := 4
    
   endcase
   
endif

set message to 24

do while .t.		&& Main body loop
   setcolor(cClrBack)
   cls
   ?"Processing..."
   FaxBckDrop()
   @2,0  say replicate(chr(196),80)
   @23,0 say replicate(chr(196),80)

   @2,59 say " F1-> Program Info " COLOR cClrTitle
   
   ** Load all events into event arrays **

   LoadQArray(@anTASKQueue,@anLOGQueue,@anRECQueue,@nTASKTot,@nLOGTot,@nRECTot)
  
   @nRow1,nCol1 to nRow2, nCol2 double
   @nRow1,nCol1+1 say " Board "+str(nActive,1)+" Active " COLOR cClrTitle
   @1,22 say SWASYNCVer(1)
   
   @nRow1+1,nCol1+1  prompt " TASK Queue        "  message "  View TASK events. Events in QUEUE-> "+str(nTASKTot,3)
   @row()+1,nCol1+1  prompt " RECEIVE Queue     "  message "  View RECEIVE events. Events in QUEUE-> "+str(nRECTot,3)
   @row()+1,nCol1+1  prompt " LOG Queue         "  message "  View LOG events. Events in QUEUE-> "+str(nLOGTot,3)
   @row()+1,nCol1+1  prompt " Current Event     "  message "  View Current Event."
   @row()+1,nCol1+1  prompt " External Data     "  message "  View External Data Block Information."

   @row()+1,nCol1+1  prompt " Auto-Answer "+;
   			      iif(SWFGRcStat(SWFGET)==0,"(OFF)","(ON) ");
			      			   message "  Turn FAX Auto-Answer On/Off."

   @row()+1,nCol1+1  prompt " CAS Diagnostics   "  message "  RUN CAS Diagnostics."
   @row()+1,nCol1+1  prompt " Send FAX          "  message "  Send a FAX." 
   @row()+1,nCol1+1  prompt " Multi-Plex Number "  message "  Change Active CAS Multi-Plex Number."
   @row()+1,nCol1+1  prompt " Quit              "  message "  Exit SWFAX program."
   menu to nChoice
   
   do case
   case nChoice == 1		&& TASK QUEUE
      if nTASKTot > 0
         QPickList(anTASKQueue,nTASKTot,SWFTASKQ)
         
      else
         MsgShow(10,NOEVENTS,.t.,0)
         
      endif
      
   case nChoice == 2		&& RECEIVE QUEUE
      if nRECTot > 0
         QPickList(anRECQueue,nRECTot,SWFRECEIVEQ)
         
      else
         MsgShow(10,NOEVENTS,.t.,0)
         
      endif
      
   case nChoice == 3		&& LOG QUEUE
      if nLOGTot > 0
         QPickList(anLOGQueue,nLOGTot,SWFLOGQ)
         
      else
         MsgShow(10,NOEVENTS,.t.,0)
         
      endif
      
   case nChoice == 4		&& Current Event
      nReturn := SWFLCurEv(@nCurrent)
      if nReturn == 0
         DisplayECF(nCurrent,-1)		&& -1 used for current
         
      else
         MsgShow(10,"No Events Currently In Progress....",.t.,0)
         
      endif
      
   case nChoice == 5		&& External data block information
      DispExBlk()
      
   case nChoice == 6
      ?chr(7)
      nReturn := SWFGRcStat(SWFGET)
      if nReturn == 0
      	 SWFGRcStat(SWFSET,1)
         MsgShow(3,"Turnning Auto-Answer ON",.t.,1)

      else
      	 SWFGRcStat(SWFSET,0)
         MsgShow(3,"Turnning Auto-Answer OFF",.t.,1)

      endif
      
   case nChoice == 7		&& Run CAS diagnostics
      RunDiag()

   case nChoice == 8		&& Send a Single Fax
      ezcas()

   case nChoice == 9		&& Set CAS Multi-Plex number
      SetBoard()
      

   case nChoice == 10		&& Exit to DOS
      if file("info.txt")
         ProductInfo()

      endif
      exit
      
   endcase
   
enddo

SET CURSOR ON

RETURN(0)





*!*********************************************************************
*!
*!       Function: LOADQARRAY()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!
*!          Calls: SWFGEVCNT()        (function  in SLVRCLIP.LIB)
*!               : SWFLEVARAY()       (function  in SLVRCLIP.LIB)
*!
*! This function loads all event data into the event arrays.
*!
*!*********************************************************************

FUNCTION LoadQArray(anTASKQueue,anLOGQueue,anRECQueue,nTASKTot,nLOGTot,nRECTot)

LOCAL nLoop

for nLoop := 1 to 100
   anTASKQueue[nLoop] := 0
   anLOGQueue[nLoop]  := 0
   anRECQueue[nLoop]  := 0
   
next

*** Load QUEUE Arrays

nTASKTot := SWFGEvCnt(-1,SWFTASKQ)
nRECTot  := SWFGEvCnt(-1,SWFRECEIVEQ)
nLOGTot  := SWFGEvCnt(-1,SWFLOGQ)

SWFLEvAray(SWFANYSTATUS,SWFTASKQ,@anTASKQueue)
SWFLEvAray(SWFANYSTATUS,SWFRECEIVEQ,@anRECQueue)
SWFLEvAray(SWFANYSTATUS,SWFLOGQ,@anLOGQueue)

RETURN(0)





*!*********************************************************************
*!
*!       Function: QPICKLIST()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!
*!          Calls: SAVESCREEN()       (function  in CLIPPER.LIB)
*!               : SWFSETECF()        (function  in SLVRCLIP.LIB)
*!               : SWFLOADECF()       (function  in SLVRCLIP.LIB)
*!               : DIRC2STR()         (function  in SWFAX.PRG)
*!               : CLASS2STR()        (function  in SWFAX.PRG)
*!               : FDTOD()            (function  in SWFAX.PRG)
*!               : FTTOT()            (function  in SWFAX.PRG)
*!               : SETCOLOR()         (function  in CLIPPER.LIB)
*!               : ACHOICE()          (function  in SLVRCLIP.LIB)
*!               : DISPLAYECF()       (function  in SWFAX.PRG)
*!               : RESTSCREEN()       (function  in CLIPPER.LIB)
*!
*! This function generates a pick list of all queues and the events
*! contained within the queues.
*!
*!*********************************************************************

FUNCTION QPickList(anChoices,nTot,nQueue)

LOCAL acChoices[nTot]
LOCAL nPick := -1, nLoop, nRow1, nCol1, nRow2, nCol2, nTemp, cError, cType, cTemp := " UnKnown "
LOCAL cPickScreen, nGoTopMenu := 0

nRow1 := 3
nCol1 := 0
nRow2 := nRow1 + 7
nCol2 := nCol1 + 79

cPickScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

@nRow1,nCol1 to nRow2, nCol2 double
@nRow1+2,nCol1+1 say replicate(chr(196),nCol2-nCol1-1)
@nRow1+1,nCol1+1 say "Event # Type         Message     Date      Time      Name" COLOR cClrInfo

do case
   
case nQueue == SWFTASKQ		&& 0 Take action on Task Queue
   cTemp := " TASK-QUEUE "
   
case nQueue == SWFRECEIVEQ	&& 1 Take action on Receive Queue
   cTemp := " RECEIVE-QUEUE "
   
case nQueue == SWFLOGQ		&& 2 Take action on Log Queue
   cTemp := " LOG-QUEUE "
   
endcase
@nRow1,nCol1+1 say cTemp  COLOR cClrTitle

for nLoop := 1 to nTot
   acChoices[nLoop] := str(anChoices[nLoop],7,0)
   SWFSetECF(0)
   SWFLoadECF(anChoices[nLoop],nQueue)
   
   nTemp := SWFSetECF(1)	&& get event type
   
   cType := Dirc2Str(nTemp)	&& convert the type to string for display
   
   nTemp := SWFSetECF(3)
   if nTemp == 0
      cError := "SUCCESSFUL "
      
   else
      cError := Class2Str(nTemp)
      
   endif

   
   ** show pick list **

   acChoices[nLoop] := acChoices[nLoop]+" "+;
      cType+" "+;
      cError+" "+;
      dtoc(FDToD(SWFSetECF(5)))+"  "+;
      FTToT(SWFSetECF(4))+"  "+;
      substr(SWFSetECF(26),1,24)
next

do while nPick != 0
   setcolor(cClrBack)
   @nRow1+3,nCol1+1 clear to nRow2-1,nCol2-1
   nPick := achoice(nRow1+3,nCol1+1,nRow2-1,nCol2-1,acChoices,.t.,,nPick)
   
   if nPick != 0
      nGoTopMenu := DisplayECF(anChoices[nPick],nQueue)
      if nGoTopMenu == -1
         nPick := 0
         
      endif
      
   endif
   
enddo

restscreen(nRow1,nCol1,nRow2,nCol2,cPickScreen)
RETURN(nPick)





*!*********************************************************************
*!
*!       Function: DISPLAYECF()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!               : QPICKLIST()        (function  in SWFAX.PRG)
*!
*!          Calls: SAVESCREEN()       (function  in CLIPPER.LIB)
*!               : SETCOLOR()         (function  in CLIPPER.LIB)
*!               : SWFSETECF()        (function  in SLVRCLIP.LIB)
*!               : SWFLOADECF()       (function  in SLVRCLIP.LIB)
*!               : SWFGFTRCNT()       (function  in SLVRCLIP.LIB)
*!               : FAXERROR()         (function  in SWFAX.PRG)
*!               : DISPLAYFTR()       (function  in SWFAX.PRG)
*!               : MSGSHOW()          (function  in SWFAX.PRG)
*!               : SWFABRTCUR()       (function  in SLVRCLIP.LIB)
*!               : SWFLCUREV()        (function  in SLVRCLIP.LIB)
*!               : SWFDFILE()         (function  in SLVRCLIP.LIB)
*!               : RESTSCREEN()       (function  in CLIPPER.LIB)
*!
*! This function displays ECF information about the chosen event.
*! Is also call DISPLAYFTR() to show any DTR information for the
*! event.
*!
*!*********************************************************************

FUNCTION DisplayECF(nHandle,nQueue)

LOCAL cECFScreen, nRow1, nCol1, nRow2, nCol2, nKey := 0
LOCAL cError := "", cClass := "", nReturn, nMoveTo := 0

nRow1 := 11
nCol1 := 0
nRow2 := nRow1 + 12
nCol2 := nCol1 + 79

cECFScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

setcolor(cClrBack)
@nRow1,nCol1 clear to nRow2,nCol2
@nRow1,nCol1 to nRow2, nCol2 double
@nRow1,nCol1+1 say " ECF Info - Handle -> "+alltrim(str(nHandle,8))+" " COLOR cClrTitle

if nQueue != -1			&& current event
   SWFSetECF(0)
   SWFLoadECF(nHandle,nQueue)
   
endif


** Heading information **

setcolor(cClrText)
@nRow1+1,nCol1+2 say "To:"
@Row()+1,nCol1+2 say "From:"
@Row()+1,nCol1+2 say "Phone:"
@Row()+1,nCol1+2 say "Total Time:"
@Row()+1,nCol1+2 say "Remote CSID:"
@Row()+1,nCol1+2 say "Total Pages:"
@Row(),nCol1+32  say "Pages So Far:"
@Row(),nCol1+60  say "FTRs:"
@Row()+1,nCol1+2 say "Sataus:"
@Row()+1,nCol1+2 say "Status Type:"

do while .t.
   setcolor(cClrInfo)
   @nRow1+1,nCol1+16  say SWFSetECF(26)			&& To:
   @Row()+1,nCol1+16  say SWFSetECF(27)			&& From:
   @Row()+1,nCol1+16  say SWFSetECF(8)			&& Phone:
   
   @Row()+1,nCol1+16  say str(SWFSetECF(13),2)+":"+;	&& Total Time:
   padl(alltrim(str(SWFSetECF(12),2)),2,"0")+"."+;
      padl(alltrim(str(SWFSetECF(11),2)),2,"0")
   
   @Row()+1,nCol1+16  say SWFSetECF(25)			&& Remote CSID:
   @Row()+1,nCol1+16  say SWFSetECF(14)			&& Total Pages:
   @Row(),nCol1+45    say SWFSetECF(15)			&& Total Pages So Far:
   @Row(),nCol1+73    say str(iif(nQueue == -1,1,SWFGFTRCnt(nHandle,nQueue)),4)
   
   nReturn := SWFSetECF(3)
   
   FAXError(nReturn,@cError,@cClass)		&& Check for error
   
   @Row()+1,nCol1+16  say space(61)
   @Row(),nCol1+16    say cError		&& Status:
   @Row()+1,nCol1+16  say cClass		&& Status Type:
   
   DisplayFTR(nHandle,nQueue)
   
   if nQueue == -1
      MsgShow(6,"Press ESC -> to stop view / F1 -> to abort current event",.f.,.1)
      nKey := inkey(1)
      if nKey == 27
         exit
         
      endif
      
      if nKey == 28
         SWFAbrtCur()				&& Abort current event
         
      endif
      
      if SWFLCurEv(@nHandle) != 0
         exit
      endif
      
   else
      MsgShow(6,"Press ESC -> to stop view / F1 -> to delete event",.f.,.1)
      nKey := inkey(0)

      if nKey == 28				&& Delete event
         nReturn := SWFDFile(nHandle,0,nQueue)
         cError  := FAXError(nReturn,cError,cClass)
         MsgShow(10,cError,.t.,2)
         nMoveTo := -1
         
      endif
      
      exit
      
   endif
   
enddo
restscreen(nRow1,nCol1,nRow2,nCol2,cECFScreen)

RETURN(nMoveTo)





*!*********************************************************************
*!
*!       Function: DISPLAYFTR()
*!
*!      Called by: DISPLAYECF()       (function  in SWFAX.PRG)
*!
*!          Calls: SETCOLOR()         (function  in CLIPPER.LIB)
*!               : SWFSETFTR()        (function  in SLVRCLIP.LIB)
*!               : SWFGFTRCNT()       (function  in SLVRCLIP.LIB)
*!               : SWFLOADFTR()       (function  in SLVRCLIP.LIB)
*!               : TYPE2STR()         (function  in SWFAX.PRG)
*!               : FTRSTAT()          (function  in SWFAX.PRG)
*!
*! This function is called from DISPLAYECF() to show any FTR
*! information for the event.
*!
*!*********************************************************************

FUNCTION DisplayFTR(nHandle,nQueue)

LOCAL nRow1, nCol1, nRow2, nCol2, nKey := 0
LOCAL nFTRs := 1, nLoop

nRow1 := 21
nCol1 := 0
nRow2 := nRow1 + 3
nCol2 := nCol1 + 79

setcolor(cClrText)
@nRow1-1,nCol1+1 say replicate(chr(196),78)

** Heading information **

@nRow1,nCol1+2   say "Type:                 Status:"
@nRow1+1,nCol1+2 say "File Name:"

for nLoop := 1 to nFTRs
   @nRow1-1,nCol1+3 say " FTR # -> "+str(nLoop,4)+" " COLOR cClrTitle
   setcolor(cClrInfo)
   
   if nQueue != -1
      SWFSetFTR(0)				&& Clear FTR table
      nFTRs := SWFGFTRCnt(nHandle,nQueue)
      SWFLoadFTR(nHandle,nQueue,nLoop)		&& Load FTR for FAX
      
   endif
   
   @nRow1,nCol1+8    say Type2Str(SWFSetFTR(1))      && File Type:
   @nRow1,nCol1+32   say FTRStat(SWFSetFTR(3))
   @nRow1+1,nCol1+13 say space(64)
   @nRow1+1,nCol1+13 say SWFSetFTR(8)                && File Name:
   
   if nLoop < nFTRs
      @nRow1-1,nCol1+40 say " Press Any Key for Next FTR " COLOR cClrTitle
      inkey(0)
      
   endif
   
next

if nFTRs != 1					     && Screen fix-up
   setcolor(cClrText)
   @nRow1-1,nCol1+40 say replicate(chr(196),28)
   
endif

RETURN(0)





*!*********************************************************************
*!
*!       Function: DISPEXBLK()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!
*!          Calls: SAVESCREEN()       (function  in CLIPPER.LIB)
*!               : SETCOLOR()         (function  in CLIPPER.LIB)
*!               : SWFGEXDBLK()       (function  in SLVRCLIP.LIB)
*!               : RESTSCREEN()       (function  in CLIPPER.LIB)
*!
*! This function display all external data block information via the 
*! SWFGEXDBLK() function.
*!
*!*********************************************************************

FUNCTION DispExBlk()

LOCAL cBlkScreen
LOCAL nRow1, nCol1, nRow2, nCol2

nRow1 := 11
nCol1 := 0
nRow2 := nRow1 + 7
nCol2 := nCol1 + 79

cBlkScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

setcolor(cClrBack)
@nRow1,nCol1 clear to nRow2,nCol2
@nRow1,nCol1 to nRow2, nCol2 double
@nRow1,nCol1+1 say " External Data Block Info " COLOR cClrTitle

SWFGExDBlk(0)		&& Load data

** Heading information **

setcolor(cClrText)
@nRow1+1, nCol1+2 say "CAS Major Ver.:"
@Row()+1, nCol1+2 say "CAS Minor Ver.:"
@Row()+1, nCol1+2 say "Manager DIR:"
@Row()+1, nCol1+2 say "LOGO File:"
@Row()+1, nCol1+2 say "Default Sender:"
@Row()+1, nCol1+2 say "CCITT String:"

setcolor(cClrInfo)
@nRow1+1, nCol1+18 say SWFGExDBlk(2)
@Row()+1, nCol1+18 say SWFGExDBlk(3)
@Row()+1, nCol1+18 say SWFGExDBlk(4)
@Row()+1, nCol1+18 say SWFGExDBlk(6)
@Row()+1, nCol1+18 say SWFGExDBlk(7)
@Row()+1, nCol1+18 say SWFGExDBlk(8)

inkey(0)

restscreen(nRow1,nCol1,nRow2,nCol2,cBlkScreen)

RETURN(0)





*!*********************************************************************
*!
*!       Function: RUNDIAG()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!
*!          Calls: SAVESCREEN()       (function  in CLIPPER.LIB)
*!               : SETCOLOR()         (function  in CLIPPER.LIB)
*!               : SWFRUNDIAG()       (function  in SLVRCLIP.LIB)
*!               : RESTSCREEN()       (function  in CLIPPER.LIB)
*!
*! This function runs the CAS diagnostics check.
*!
*!*********************************************************************

FUNCTION RunDiag()

LOCAL cDiagScreen, nReturn, cMessage := "", cClass := ""
LOCAL nRow1, nCol1, nRow2, nCol2

nRow1 := 11
nCol1 := 0
nRow2 := nRow1 + 2
nCol2 := nCol1 + 79

cDiagScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

setcolor(cClrBack)
@nRow1,nCol1 clear to nRow2,nCol2
@nRow1,nCol1 to nRow2, nCol2 double
@nRow1,nCol1+1 say " CAS Diagnostics " COLOR cClrTitle

nReturn := SWFRunDiag(SWFSTART)

if nReturn == 0
   @nRow1+1,nCol1+2 say "Diagnostics has started.."

else
   @nRow1+1,nCol1+2 say FAXError(nReturn,@cMessage,@cClass)
   RETURN(nReturn)

endif
inkey(1)

** Monitor diagnostics progress

do while .t.
   nReturn := SWFRunDiag(SWFSTATUS)

   @nRow1+1,nCol1+2 say space(nCol2-nCol1-2)
   do case
      case nReturn == SWFDIAGINPROGRESS
         @nRow1+1,nCol1+2 say "Diagnostics in progress..."

      case nReturn >= 0
         @nRow1+1,nCol1+2 say "Diagnostics finished, all OK..."
         exit

      case nReturn < 0
         @nRow1+1,nCol1+2 say FAXError(nReturn,@cMessage,@cClass)
         exit

   endcase

enddo
inkey(2)

restscreen(nRow1,nCol1,nRow2,nCol2,cDiagScreen)
RETURN(0)








******************************************************************************
******************************************************************************
**
**	 Support Functions
**
******************************************************************************
******************************************************************************





*!*********************************************************************
*!
*!       Function: FDTOD()
*!
*!      Called by: QPICKLIST()        (function  in SWFAX.PRG)
*!
*!          Calls: SWFGETDATE()       (function  in SLVRCLIP.LIB)
*!
*! This function converts a packed binary date to a date() type.
*!
*!*********************************************************************

FUNCTION FDToD(nFaxDate)

LOCAL nDay,nMonth,nYear

SWFGetDate(nFaxDate,@nDay,@nMonth,@nYear)
RETURN(ctod(alltrim(str(nMonth,2))+"/"+alltrim(str(nDay,2))+"/"+alltrim(str(nYear,4))))





*!*********************************************************************
*!
*!       Function: FTTOT()
*!
*!      Called by: QPICKLIST()        (function  in SWFAX.PRG)
*!
*!          Calls: SWFGETTIME()       (function  in SLVRCLIP.LIB)
*!
*! This function converts a packed binary time to a time() type.
*!
*!*********************************************************************

FUNCTION FTToT(nFaxTime)

LOCAL nSec,nHour,nMin,cSec,cMin

SWFGetTime(nFaxTime,@nSec,@nMin,@nHour)
cMin := alltrim(str(nMin,2))
cSec := alltrim(str(nSec,2))

RETURN(str(nHour,2)+":"+padl(cMin,2,"0")+"."+padl(cSec,2,"0"))





*!*********************************************************************
*!
*!       Function: MSGSHOW()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!               : DISPLAYECF()       (function  in SWFAX.PRG)
*!
*!          Calls: SAVESCREEN()       (function  in CLIPPER.LIB)
*!               : SETCOLOR()         (function  in CLIPPER.LIB)
*!               : RESTSCREEN()       (function  in CLIPPER.LIB)
*!
*! This function is for message displays.  (press any key...)
*!
*!*********************************************************************

FUNCTION MsgShow(nRow1,cMessage,lSaveScreen,nSec)

LOCAL cMsgScreen, nCol1, nRow2, nCol2, nLen, nKey

nLen  := len(cMessage)+3
nCol1 := int((80-nLen)/2)
nRow2 := nRow1 + 2
nCol2 := nCol1 + nLen

if lSaveScreen
   cMsgScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
   
endif

setcolor(cClrBack)
@nRow1,nCol1 clear to nRow2, nCol2
@nRow1,nCol1 to nRow2, nCol2 double

setcolor(cClrInfo)
@nRow1+1,nCol1+2 say cMessage

nKey := inkey(nSec)

if lSaveScreen
   restscreen(nRow1,nCol1,nRow2,nCol2,cMsgScreen)
   
endif
RETURN(nKey)





*!*********************************************************************
*!
*!       Function: FAXBCKDROP()
*!
*!      Called by: MAIN()             (function  in SWFAX.PRG)
*!
*!
*! This function displays the screen back-drop information.
*!
*!*********************************************************************

FUNCTION FaxBckDrop()

LOCAL nRow1, nCol1, nRow2, nCol2

nRow1 := 7
nCol1 := 21
nRow2 := nRow1 + 10
nCol2 := nCol1 + 38

@nRow1,nCol1 to nRow2, nCol2 double COLOR cClrBack

@nRow1+2,nCol1+3 say "       S I L V E R F A X"
@Row()+2,nCol1+3 say "SilverClip Communications Library"
@Row()+2,nCol1+3 say "  FAX task info example program."
@Row()+2,nCol1+3 say "Copyright (c) 1993 SilverWare Inc."

RETURN(0)





*!*********************************************************************
*!
*!       Function: FTRSTAT()
*!
*!      Called by: DISPLAYFTR()       (function  in SWFAX.PRG)
*!
*! This function converts the return from SWFSetFTR(3) to a string.
*!
*!*********************************************************************

FUNCTION FTRStat(nStat)

LOCAL cStat := "Reserved        "

do case
case nStat == 0
   cStat := "Untouched       "
   
case nStat == 1
   cStat := "Has been opened "
   
case nStat == 2
   cStat := "Has been moved  "
   
case nStat == 3
   cStat := "Has been deleted"
   
case nStat == 3
   cStat := "Not yet received"
   
endcase

RETURN(cStat)





*!*********************************************************************
*!
*!       Function: TYPE2STR()
*!
*!      Called by: DISPLAYFTR()       (function  in SWFAX.PRG)
*!
*! This function converts the return from SWFSetFTR(1) to a string.
*!
*!*********************************************************************

FUNCTION Type2Str(nType)

LOCAL cType

do case
case nType == SWFASCII          && 0 ASCII file
   cType := "ASCII File"
   
case nType == SWFPCX            && 1 PCX encoded graphics page
   cType := "PCX File  "
   
case nType == SWFDCX            && 2 PCX encoded graphics document
   cType := "DCX File  "
   
otherwise
   cType := "UNKNOWN   "
   
endcase

RETURN(cType)





*!*********************************************************************
*!
*!       Function: CLASS2STR()
*!
*!      Called by: QPICKLIST()        (function  in SWFAX.PRG)
*!               : FAXERROR()         (function  in SWFAX.PRG)
*!
*!          Calls: SWFGETERCL()       (function  in SLVRCLIP.LIB)
*!
*! This function converts a CAS error to the CAS class string.
*!
*!*********************************************************************

FUNCTION Class2Str(nTemp)

LOCAL cError, nRet

nRet := SWFGetErCl(nTemp)

do case
case nRet == 0
   cError := "FAX Warning"
   
case nRet == 1
   cError := "DOS Warning"
   
case nRet == 2
   cError := "FATAL Error"
   
case nRet == 3
   cError := "DOS Error  "
   
case nRet == 4
   cError := "FAX Error  "
   
otherwise
   cError := "UNKNOWN    "
   
endcase

RETURN(cError)





*!*********************************************************************
*!
*!       Function: DIRC2STR()
*!
*!      Called by: QPICKLIST()        (function  in SWFAX.PRG)
*!
*! This function converts the return from SWFSetECF(1) to a string.
*!
*!*********************************************************************

FUNCTION Dirc2Str(nType)

LOCAL cType

do case
case nType == SWFSEND           && 0 Immediate send event
   cType := "SEND        "
   
case nType == SWFRECEIVE        && 1 Immediate receive event
   cType := "RECEIVE     "
   
case nType == SWFPOLLEDSEND     && 2 Polled send event
   cType := "POLL-SEND   "
   
case nType == SWFPOLLEDRECEIVE  && 3 Polled receive event
   cType := "POLL-RECEIVE"
   
case nType == SWFGROUPSEND      && 4 Group send
   cType := "GRP-SEND    "
   
case nType == SWFGROUPRECEIVE   && 5 Group polled receive
   cType := "GRP-RECEIVE "
   
otherwise
   cType := "UNKNOWN-TYPE"
   
endcase

RETURN(cType)





*!*********************************************************************
*!
*!       Function: FAXERROR()
*!
*!      Called by: DISPLAYECF()       (function  in SWFAX.PRG)
*!
*!          Calls: CLASS2STR()        (function  in SWFAX.PRG)
*!
*! This function check for an error and converts the CAS error
*! number to a string.
*!
*!*********************************************************************

FUNCTION FAXError(nError,cMessage,cClass)

cClass := "No Error"

do case
case nError == 0
   cMessage := "Successfully Completed"
   
case nError == 1
   cMessage := "Waiting to be processed"
   
case nError == 2
   cMessage := "Number dialed or event in progress"
   
case nError == 3
   cMessage := "Connection made -- sending"
   
case nError == 4
   cMessage := "Connection made -- receiving"
   
case nError == 5
   cMessage := "Event was aborted"
   
otherwise
   cMessage := "Unknown Error ->"+str(nError,10,0)
   
endcase

if nError < 0
   cClass := Class2Str(nError)
   nError := nError * -1		&& Cast to a positive value
   
   do case
   case nError == 2
      cMessage := "Bad scanline count"
      
   case nError == 3
      cMessage := "Page sent with errors"
      
   case nError == 4
      cMessage := "Received data lost"
      
   case nError == 5
      cMessage := "Invalid or missing logo file"
      
   case nError == 6
      cMessage := "File name does not match NSF header"
      
   case nError == 7
      cMessage := "File size does not match NSF header"
      
   case nError == 257
      cMessage := "Invalid function number"
      
   case nError == 261
      cMessage := "Access denied"
      
   case nError == 262
      cMessage := "Invalid handle"
      
   case nError == 512
      cMessage := "Multiplex handler failed"
      
   case nError == 513
      cMessage := "Unknown command (invalid function number)"
      
   case nError == 514
      cMessage := "Event not found (invalid event handle)"
      
   case nError == 515
      cMessage := "Attempted to Find Next before Find First"
      
   case nError == 216
      cMessage := "No more events"
      
   case nError == 519
      cMessage := "Invalid Queue type (bad Queue number)"
      
   case nError == 520
      cMessage := "Bad Control file"
      
   case nError == 521
      cMessage := "Communication board is busy"
      
   case nError == 522
      cMessage := "Invalid command parameter"
      
   case nError == 523
      cMessage := "Can not uninstall Resident Manager"
      
   case nError == 524
      cMessage := "File already exists"
      
   case nError == 640
      cMessage := "Invalid task type (not a Send or Poll event)"
      
   case nError == 641
      cMessage := "Bad phone number"
      
   case nError == 642
      cMessage := "Bad PCX file header"
      
   case nError == 643
      cMessage := "Unexpected End of File"
      
   case nError == 644
      cMessage := "Unexpected disconnect"
      
   case nError == 645
      cMessage := "Exceeded maximum dialing retries"
      
   case nError == 646
      cMessage := "No files were specified for send event"
      
   case nError == 647
      cMessage := "Communication board time-out"
      
   case nError == 648
      cMessage := "Received more than 1023 pages of data"
      
   case nError == 649
      cMessage := "Manual connect posted too long ago"
      
   case nError == 650
      cMessage := "Hardware command set error"
      
   case nError == 651
      cMessage := "Bad nonstandard NSF header file"
      
   case nError == 770
      cMessage := "File not found"
      
   case nError == 771
      cMessage := "Path not found"
      
   case nError == 1025
      cMessage := "Remote unit not Group 3 compatible"
      
   case nError == 1026
      cMessage := "Remote unit didn't send its capabilities"
      
   case nError == 1027
      cMessage := "Remote unit requested disconnect"
      
   case nError == 1028
      cMessage := "Remote unit isn't a Connection Coprocessor"
      
   case nError == 1029
      cMessage := "Exceeded retrain or fax resend limit"
      
   case nError == 1030
      cMessage := "Line noise or the local and remote don't agree on bit rate"
      
   case nError == 1031
      cMessage := "Remote unit disconnected after receiving data"
      
   case nError == 1032
      cMessage := "No response from remote unit after sending data"
      
   case nError == 1033
      cMessage := "Capabilities of remote unit aren't compatible"
      
   case nError == 1034
      cMessage := "No dial tone - check phone line and cord (V1.2)"
      
   case nError == 1035
      cMessage := "Invalid response from remote unit after sending data"
      
   case nError == 1037
      cMessage := "Phone line dead or remote unit disconnected"
      
   case nError == 1038
      cMessage := "Time-out while waiting for secondary dial tone (V1.2)"
      
   case nError == 1041
      cMessage := "Invalid command from remote after receiving data"
      
   case nError == 1045
      cMessage := "Tried to receive from incompatible hardware"
      
   case nError == 1119
      cMessage := "Unexpected end of file while receiving"
      
   case nError == 1116
      cMessage := "Received data overflowed input buffer"
      
   case nError == 1117
      cMessage := "Remote hardware unexpectedly stopped sending data"
      
   case nError == 1118
      cMessage := "Remote hardware didn't send any data"
      
   case nError == 1122
      cMessage := "Remote hardware took too long to send fax scan line"
      
   case nError == 1123
      cMessage := "Can't get through to remote unit"
      
   case nError == 1124
      cMessage := "User canceled event"
      
   otherwise
      cMessage := "Unknown Error ->"+str(nError,10,0)
      
   endcase
   
endif
RETURN(cMessage)



*!*********************************************************************
*!
*!       Function: EZCAS()
*!
*!      Called by: MAIN()	      (function  in SWFAX.PRG)
*!
*! This function send a single FAX via. the SWSubFile() function.
*!
*!*********************************************************************

FUNCTION EZCAS()

LOCAL cFaxSendTo, cFaxFileName, cFaxPhone, nRow1, nRow2, nCol1, nCol2
LOCAL getlist := {}, nIsCAS, nCASEventHandle, cYNC := "N", cSendFaxScreen
LOCAL cFaxCover, cFaxCover1, cFaxCover2, cFaxCover3, cFaxCover4
LOCAL nCurrent := -1, nReturn

set cursor on

nRow1 := 12
nCol1 := 2
nRow2 := nRow1 + 10
nCol2 := nCol1 + 75

cFaxSendTo   := "Single File Test                          "
cFaxFileName := "c:\                                       "
cFaxPhone    := "406-9999                                  "
cFaxCover1   := "Hello, this is a cover page...            "
cFaxCover2   := "                                          "
cFaxCover3   := "                                          "
cFaxCover4   := "                                          "


setcolor(cClrBack)
cSendFaxScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
@nRow1,nCol1 clear to nRow2,nCol2 
@nRow1,nCol1 to nRow2,nCol2 double

do while cYNC != "Y"
   setcolor(cClrBack)
   @nRow1+1,nCol1+2  say "Send To:                     " get cFaxSendTo
   @row()+1,nCol1+2  say "File to send,(ASCII,PCX,DCX) " get cFaxFileName
   @row()+1,nCol1+2  say "FAX # to dial                " get cFaxPhone
   @row()+1,nCol1+2  say "FAX cover page text Line 1   " get cFaxCover1
   @row()+1,nCol1+2  say "Line 2                       " get cFaxCover2
   @row()+1,nCol1+2  say "Line 3                       " get cFaxCover3
   @row()+1,nCol1+2  say "Line 4                       " get cFaxCover4
   @row()+2,nCol1+2  say "Send (Y/N) or (C)ancel        " get cYNC pict[!] valid(cYNC$"YNC")
   read

   if cYNC == "C"
      return(-1)
   endif

   if !file(alltrim(cFaxFileName))
      MsgShow(6,"File "+alltrim(cFaxFileName)+" not found...",.t.,1)
      cYNC := "N"

   endif

enddo


SWFSSingle(0)		      		&& reset
SWFSSingle(1,SWFFAX200)	      		&& dpi 200
SWFSSingle(2,SWF80NORMAL)	      	&& 80 column
SWFSSingle(5,alltrim(cFaxSendTo))  	&& send to:
SWFSSingle(6,alltrim(cFaxFileName))	&& file to send
SWFSSingle(7,alltrim(cFaxPhone))   	&& FAX # to call
SWFSSingle(9,SWFCOVON)	      		&& set FAX cover

cFaxCover := cFaxCover1+chr(13)+chr(10)+;
             cFaxCover2+chr(13)+chr(10)+;
             cFaxCover3+chr(13)+chr(10)+;
             cFaxCover4+chr(13)+chr(10)

SWFSSingle(10,alltrim(cFaxCover))  && cover text

MsgShow(6,"Sending FAX...",.f.,1)

nCASEventHandle := SWFSubFile()

if nCASEventHandle > 0
   MsgShow(10,"Single FAX sent OK, EventHandle -> "+str(nCASEventHandle,10),.t.,1)

else
   MsgShow(10,"ERROR on sending single FAX, ERROR -> "+str(nCASEventHandle,10),.t.,1)

endif
restscreen(nRow1,nCol1,nRow2,nCol2,cSendFaxScreen)


nReturn := SWFLCurEv(@nCurrent)

if nReturn == 0
   DisplayECF(nCurrent,-1)		&& -1 used for current

endif         

RETURN(0)



*!*********************************************************************
*!
*!       Function: DisplayInfo()
*!
*!      Called by: F1 key press
*!
*! This function displays program and company infomation when the F1 
*! key is pressed.
*!
*!*********************************************************************

FUNCTION DisplayInfo()
LOCAL nRow1 := 5, nCol1 := 5, nRow2 := 18, nCol2 := 74, cInfoScreen := ""

cInfoScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

@nRow1,nCol1 clear to nRow2,nCol2
@nRow1,nCol1 to nRow2, nCol2 double
@nRow1,nCol1+1 say " Program Information " COLOR cClrTitle
@nRow1+1,nCol1+1 say "           SilverWare Inc. product demo for CAS Faxing             "
@row()+1,nCol1+1 say "    This program shows some of the CAS functioality of the the     "
@row()+1,nCol1+1 say "                SilverWare Communications Libraries.               "
@row()+2,nCol1+1 say "  SilverWare provides libraries for Clipper, FoxPRO, dBase III / IV"
@row()+1,nCol1+1 say "                  and all the popular C compilers.                 "
@row()+2,nCol1+1 say "        For more information on all the SilverWare Products        "
@row()+1,nCol1+1 say "    Call (214) 247-0131 and speak to one of our technical staff.   "
@row()+1,nCol1+1 say "             3010 LBJ Freeway #740, Dallas, Tx  75234              "
@row()+2,nCol1+1 say "       This program is available for Clipper, FoxPro and C.        "

inkey(0)
restscreen(nRow1,nCol1,nRow2,nCol2,cInfoScreen)
RETURN(0)




*!*********************************************************************
*!
*!       Function: SetBoard()
*!
*!      Called by: MAIN()       (function  in SWFAX.PRG)
*!
*! This function selects CAS board to be activated.
*!
*!*********************************************************************

FUNCTION SetBoard()

LOCAL cBoardScreen, nRow1, nCol1, nRow2, nCol2, nChoice := nActive

nRow1 := 0
nCol1 := 23
nRow2 := nRow1+5
nCol2 := nCol1+35

cBoardScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

@nRow1,nCol1 clear to nRow2,nCol2
@nRow1,nCol1 to nRow2, nCol2 double
@nRow1,nCol1+1 say " CAS Board " COLOR cClrTitle

@nRow1+1, nCol1+2 prompt "Board 1 -> MPX "+str(SWCAS1,3,0)+" "+iif(lBoard1,"Installed    ","Not Installed")
@nRow1+2, nCol1+2 prompt "Board 2 -> MPX "+str(SWCAS2,3,0)+" "+iif(lBoard2,"Installed    ","Not Installed")
@nRow1+3, nCol1+2 prompt "Board 3 -> MPX "+str(SWCAS3,3,0)+" "+iif(lBoard3,"Installed    ","Not Installed")
@nRow1+4, nCol1+2 prompt "Board 4 -> MPX "+str(SWCAS4,3,0)+" "+iif(lBoard4,"Installed    ","Not Installed")
menu to nChoice

do case
   case nChoice == 1 .and. lBoard1
      SWFSetMpx(SWCAS1)
      nActive := 1

   case nChoice == 2 .and. lBoard2
      SWFSetMpx(SWCAS2)
      nActive := 2

   case nChoice == 3 .and. lBoard3
      SWFSetMpx(SWCAS3)
      nActive := 3

   case nChoice == 4 .and. lBoard4
      SWFSetMpx(SWCAS4)
      nActive := 4

endcase

restscreen(nRow1,nCol1,nRow2,nCol2,cBoardScreen)
RETURN(0)



*!*********************************************************************
*!
*!       Function: ProductInfo()
*!
*!      Called by: MAIN()       (function  in SWFAX.PRG)
*!
*! This function shows SilverWare Inc. product information.
*!
*!*********************************************************************

FUNCTION ProductInfo()

LOCAL cInfo := "", nRow1, nCol1, nRow2, nCol2, cInfoScreen

nRow1 := 12
nCol1 := 10
nRow2 := nRow1+10
nCol2 := nCol1+59

cInfoScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

@nRow1,nCol1 clear to nRow2,nCol2
@nRow1,nCol1 to nRow2, nCol2 double
@nRow1,nCol1+1  say " Product Information " COLOR cClrTitle
@nRow1,nCol2-21 say " Press ESC To QUIT " COLOR cClrTitle
@nRow2,nCol1+1  say " Use PgUp / PgDn " COLOR cClrTitle

cInfo := memoread("info.txt")
memoedit(cInfo,nRow1+1,nCol1+2,nRow2-1,nCol2-1,.f.)

restscreen(nRow1,nCol1,nRow2,nCol2,cInfoScreen)

RETURN(0)

* EOF() SILVERFAX.PRG


