
* FAMPOS.prg
* Patrick Ball (71553,2372 or pball@igc.apc.org), 24.08.93
* simple SQL and string manipulation example for FoxPro 2+, 
* written for Mitch Cameron (CIS 75540,422)
* this file shows how to handle self-joins and outer-joins 
* in Fox SQL, and how to do some simple string manipulation
* to build a couplename from two people's name strings.

* this file will look better if you use a monospace font
* and tab=4 spaces.

* Ok, first make a test table:

create table fampos ( ;
	namefld c(30), fam_id n(4), fam_pos n(2), addressln c(20), phone c(7) ) 

* insert some values
*														name				fam_id	fam_pos	
* family with no second adult
insert into fampos (namefld, fam_id, fam_pos) values ('Smith, Jane',		0001,	1)
insert into fampos (namefld, fam_id, fam_pos) values ('Smith, Bobby',		0001,	3)
* families with two adults, common surname
insert into fampos (namefld, fam_id, fam_pos) values ('Jones, Mary',		0002,	1)
insert into fampos (namefld, fam_id, fam_pos) values ('Jones, Michael',		0002,	2)
insert into fampos (namefld, fam_id, fam_pos) values ('Jones, Mitchell',	0002,	3)
insert into fampos (namefld, fam_id, fam_pos) values ('Hsu, Xiaohe',		0004,	1)
insert into fampos (namefld, fam_id, fam_pos) values ('Hsu, Amy',			0004,	2)
insert into fampos (namefld, fam_id, fam_pos) values ('Hsu, John',			0004,	3)
* families with two adults, different surnames
* 1. modern US version
insert into fampos (namefld, fam_id, fam_pos) values ('Porter, Ronald',		0005,	1)
insert into fampos (namefld, fam_id, fam_pos) values ('Arnett, Harriet',	0005,	2)
insert into fampos (namefld, fam_id, fam_pos) values ('Arnett-Porter, Billy',	0005,	3)
* 2. classical Latin version (note: not handled exactly properly by FUNC couplename(), below)
insert into fampos (namefld, fam_id, fam_pos) values ('Perez, Antonio',		0003,	1)
insert into fampos (namefld, fam_id, fam_pos) values ('Gomez de Perez, Maria',		0003,	2)
insert into fampos (namefld, fam_id, fam_pos) values ('Gomez P., Reynaldo',	0003,	3)
insert into fampos (namefld, fam_id, fam_pos) values ('Gomez P., Jose',		0003,	4)
insert into fampos (namefld, fam_id, fam_pos) values ('Gomez P., Maritza',		0003,	5)

* should be another table with keyfld FAM_ID linking them.
repl addressln with '123 Oak St.',   phone with '6631234' for fampos.FAM_ID=1
repl addressln with '321 Elm St.',   phone with '7641234' for fampos.FAM_ID=2
repl addressln with '456 Pine St.',  phone with '9639589' for fampos.FAM_ID=3
repl addressln with '654 Maple St.', phone with '7692138' for fampos.FAM_ID=4

*	
* problem 1: make a table like this
* Name#1, Name#2, phone

* This involves 2 SQL tricks, a "self-join" and an "outer-join"

* the first part is the "self-join," in which we join the
* table fampos to itself in order to get the fields name1 
* and name2 next to each other.  for b.namefld to be in the list,
* each record has to have fam_pos=2.  That poses a problem for
* families that don't have a #2, adult not head of household in
* residence.  Fox SQL doesn't handle joins well when there is
* nothing to join in one of the tables.  Therefore we just do
* a second query, this time getting all the families (represented 
* by their #1 member) who aren't included in the first row.  
* The union clause appends the results of the second query to 
* the first query.

sele distinct ;
		a.namefld as name1, b.namefld as name2, a.addressln, a.phone ;
	from fampos a, fampos b ;
	where a.fam_id=b.fam_id ;
		and a.fam_pos=1 ;
		and b.fam_pos=2 ;
union sele ;
		a.namefld as name1, space(30) as name2, a.addressln, a.phone ;
	from fampos a ;
	where a.fam_pos=1 ;
		and a.fam_id not in ;
			(sele a.fam_id from fampos a, fampos b where a.fam_id=b.fam_id ;
				and a.fam_pos=1 ;
				and b.fam_pos=2 );
order by 1 ;				
into cursor add_list
	
* doing your name append problem is the next part.
* you want to have the form:
* CommonSurname, FirstGiven and SecondGiven

* see inside the loop for the output routine
hide wind all
acti scre
clear

sele add_list
go top
scan
	
	? padr( couplename() , 60)+add_list.addressln+spac(3)+add_list.phone
	*   ----^^^^^^^^^^ that's the call
	
endscan

RETURN



FUNCTION couplename

* get the comma's position:
m.commapos1 = at(',' , add_list.name1)

* get the surname, i.e., all those chr's up to the comma
m.surname1 = alltrim(left( add_list.name1, m.commapos1-1))

* get the first given name, i.e., all those chr's after the comma
m.given1 = alltrim(substr( add_list.name1, m.commapos1+1))

* get the comma's position for the second person:
m.commapos2 = at(',' , add_list.name2)

* get the first given name, i.e., all those chr's after the comma
m.given2 = alltrim(substr( add_list.name2, m.commapos2+1))

* get the second surname, i.e., all those chr's up to the comma
m.surname2 = alltrim(left( add_list.name2, m.commapos2-1))

* note: if the two people have different surnames, 
* then they should be addressed as:
* Surname, GivenName, and GivenName Surname

* hence the following branching:
do case
case empty(m.surname2)
* case with only one adult in the household
	m.couplename = m.surname1+', '+m.given1
case upper(m.surname1)=upper(m.surname2)
* two adults, same surname
	m.couplename = m.surname1+', '+m.given1+' and '+m.given2
otherwise
* two adults, different surnames
	m.couplename = m.surname1+', '+m.given1+', and '+m.given2+' '+m.surname2
endcase

RETURN m.couplename