*ͻ*
*   System Name:   FIND A FILE LISTING PROGRAM                     *
*   Module Name:   FAF.PRG                                         *
*   Description:   Takes a file skeleton and searches the entire   *
*                  current drive for files matching it.  Then      *
*                  those files are listed in a TBrowse which       *
*                  gives the user the choice of going directly to  *
*                  that directory.  Can also search by date.       *
*   Notes......:   Typing 'FAF /?' on the command line will give   *
*                  the syntax to run the program.  Press F1 while  *
*                  the files are displayed to give you help.       *
*                  Unfortunately since all the information is in   *
*                  arrays, the files found is limited to 4096      *
*                  files.  Pressing ESC during the file search     *
*                  will stop the file search and let you browse    *
*                  the files found at that point.                  *
*                  ** Compile with the /n/w/a switches **          *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   Jan. 23 1991                                    *
*   History....:   No history.  Just bored, so I wrote it.         *
*                                                                  *
*   Copyright..:   (c) Micro Tech Consultant Services, 1991        *
*                  (c) The people at Nantucket Canada, 1991        *
*                  Is this possible?                               *
*ͼ*
#include 'funcs.ch'
#include 'inkey.ch'
****>>>>  Erase the next line when compiling with Clipper 5.01 <<<<****
#include 'its501.ch'
***********************************************************************

//  defines colors depending on whether you use mono or color
#define mYB_BWN		IF( lColor, 'gr+/b', 'w+/n' )
#define mBWB_WN		IF( lColor, 'w+/b', 'w/n' )
#define mBWB_BWN	IF( lColor, 'w+/b', 'w+/n' )
#define mBWC_BNW	IF( lColor, 'w+/bg', 'n+/w' )
#define mYC_NW		IF( lColor, 'gr+/bg', 'n/w' )


STATIC oBrowse
STATIC lColor
STATIC nArrayLen

FUNCTION FAF( cFileSpec, cDateSpec )
	LOCAL aFiles := {}
	LOCAL bDateText
	LOCAL cDateChk, cDefCol, cDir := '', cPartScreen, cRun
	LOCAL dDate1, dDate2
	LOCAL lDate := .F.
	LOCAL nArrPos := 1, nTopRow := 20, nKey := 0, nLoc, nRow := 0
	//  Defines the TBColumn object and the TBrowse object
	LOCAL oColumn := TBCOLUMNNEW( '', { || aFiles[ nArrPos ] } )

	oBrowse := TBROWSENEW( 2, 10, 19, 68 )

	//  Returns a logical TRUE if the adapter is a color adapter and 
	//  FALSE if it is a mono adapter.
	lColor := ISCOLOR()
	//  Turn the cursor off
	SETCURSOR( 0 )

	//  Calls the psuedo function for drawing a background.
	Panel( .F. )

	//  Checks to see if two parameters were passed on the command line
	IF cFileSpec != Nil
		cDateChk := UPPER( IF( cDateSpec == Nil,;
			cFileSpec, cDateSpec ) )
	ENDIF

	//  If no filespec is passed on the command line it will default to
	//  to all files.
	IF cFileSpec == Nil
		cFileSpec := '*.*'

	//  Checks to see if a date parameter was passed.
	ELSEIF LEFT( cDateChk, 3 ) == '/D='

		nTopRow := 19
		cFileSpec := IF( cDateSpec == Nil, '*.*', cFileSpec )

		//  Checks to see if a date parameter is for multiple days
		IF '-' $ cDateChk
			DO CASE
			CASE SUBSTR( cDateChk, 4, 1 ) == '-'
				//  Process 'before date' request
				dDate2 := CTOD( SUBSTR( cDateChk, 5 ) )
				dDate1 := CTOD( '01/01/01' )

				//  Code block for display of date
				bDateText := { | | SETCOLOR( mYB_BWN ),;
					DEVPOS( 21, 23 ), DEVOUT( dDate2 ),;
					SETCOLOR( mBWB_WN ), DEVPOS( 21, 10 ),;
					DEVOUT( 'Files before' ) }

			CASE RIGHT( cDateChk, 1 ) == '-'
				//  Process 'after date' request
				dDate1 := CTOD( SUBSTR( cDateChk, 4,;
					LEN( cDateChk ) - 4 ) )
				dDate2 := CTOD( '12/31/99' )

				//  Code block for display of date
				bDateText := { | | SETCOLOR( mYB_BWN ),;
					DEVPOS( 21, 22 ), DEVOUT( dDate1 ),;
					SETCOLOR( mBWB_WN ), DEVPOS( 21, 10 ),;
					DEVOUT( 'Files after' ) }

			OTHERWISE
				//  Process 'between date' request
				nLoc := AT( '-', cDateChk )
				dDate1 := CTOD( SUBSTR( cDateChk,;
					4, nLoc - 4 ) )
				dDate2 := CTOD( RIGHT( cDateChk,;
					LEN( cDateChk ) -;
					nLoc ) )

				//  Code block for display of dates
				bDateText := { | | SETCOLOR( mBWB_WN ),;
					DEVPOS( 21, 10 ),;
					DEVOUT( 'Files from          to' ),;
					SETCOLOR( mYB_BWN ), DEVPOS( 21, 21 ),;
					DEVOUT( dDate1 ), DEVPOS( 21, 33 ),;
					DEVOUT( dDate2 ), SETCOLOR( mBWB_WN ) }

			ENDCASE

		ELSE
			//  Process 'on date' request
			dDate1 := dDate2 := CTOD( SUBSTR( cDateChk, 4 ) )

			//  Code block for display of date
			bDateText := { | | SETCOLOR( mYB_BWN ),;
				DEVPOS( 21, 19 ), DEVOUT( dDate1 ),;
				SETCOLOR( mBWB_WN ),;
				DEVPOS( 21, 10 ), DEVOUT( 'Files on' ) }

		ENDIF

		//  IF either of the date variables are EMPTY() then the date
		//  is invalid.
		IF EMPTY( dDate1 ) .OR. EMPTY( dDate2 )
			? 'One of the dates are invalid'
			QUIT
		ENDIF
		lDate := .T.

	//  If the info parameter is specified the info screen displays.
	ELSEIF cFileSpec == '/?'
		//  Process info screen for command line options
		InfoScreen()
		QUIT

	ENDIF

	//  Psuedo function that sets up the background display
	Panel( .F. )

	//  Create the Browse section
	oBrowse:nBottom := nTopRow - 1

	//  If the GOTOP() Method is used this code block is evaluated.
	oBrowse:GOTOPBLOCK := { || nArrPos := 1 }

	//  If the GOBOTTOM() Method is used this code block is evaluated.
	oBrowse:GOBOTTOMBLOCK := { || nArrPos := LEN( aFiles ) }
	oBrowse:COLORSPEC := IF( lColor, 'w+/b, gr+/b, n/bg',;
		'w+/n, w/n, n/w' )

	//  If it is a directory row, it displays in a different color.
	oColumn:COLORBLOCK := { || IF( '\' $ aFiles[ nArrPos ], { 2, 3 },;
		{ 1, 3 } ) }
	oColumn:WIDTH := 59
	oBrowse:ADDCOLUMN( oColumn )
	oBrowse:SKIPBLOCK := { | nMove | SkipArray( nMove, @nArrPos,;
		nArrayLen ) }

	SETCOLOR( mBWB_WN )
	//  Expands the found file's browse box onto the screen.
	BoxZoom( 1, 8, 22, 70, mYB_BWN )
	@nTopRow, 9 TO nTopRow, 69
	@1, 32 SAY ' FIND A FILE '

	IF lDate
		//  Display the date information
		EVAL( bDateText )
	ENDIF

	SETCOLOR( mBWB_WN )
	@nTopRow + 1, 10 SAY 'Files:'
	@nTopRow + 1, 56 SAY '0 Files Found'

	SETCOLOR( IF( lColor, 'w+/r', 'n/w' ) )
	@nTopRow + 1, 17 SAY PADR( cFileSpec, 20 )
	SETCOLOR( mYB_BWN )

	cFileSpec += IF( '.' $ cFileSpec, '', '*.*' )

	cPartScreen := SAVESCREEN( 10, 4, 13, 75 )

	//  Display the current directory searched in a box
	BoxShad( 10, 4, 12, 73, mBWC_BNW )

	//  Call the directory function
	GetDirect( cDir, cFileSpec, aFiles, lDate, dDate1, dDate2 )

	IF ! EMPTY( aFiles )
		DISPBEGIN()
		RESTSCREEN( 10, 4, 13, 75, cPartScreen )
		ShowFound( aFiles, .F. )
		DISPEND()

	ELSE
		//  If no files match the criteria, display message
		Panel( .F. )
		SETCOLOR( 'w+/n' )
		@10, 4, 13, 75 BOX REPLICATE( '', 9 )
		BoxZoom( 9, 25, 12, 52, mYB_BWN )
		SETCOLOR( mBWB_BWN )
		@10, 29 SAY 'NO FILES WERE FOUND.'
		@11, 28 SAY 'Press any key to Exit.'
		INKEY( 0 )
		Credit()
		QUIT
	ENDIF

	DO WHILE nKey != K_F10
		//  Redisplay all information that has changed
		DO WHILE ! ( oBrowse:Stabilize() )
		ENDDO

		nKey := INKEY(0)

		DO CASE
		//  Displays the Help Screen if F1 is pressed.
		CASE nKey == K_F1
			HelpScreen()

		//  If F10 is pressed the user is asked whether to exit
		CASE nKey == K_F10
			IF( TimeToExit(), Nil, nKey := 0 )

		CASE nKey == K_DOWN
			oBrowse:Down()

		CASE nKey == K_UP
			oBrowse:UP()

		CASE nKey == K_PGUP
			oBrowse:PageUp()

		CASE nKey == K_PGDN
			oBrowse:PageDown()

		CASE nKey == K_HOME
			oBrowse:GoTop()

		CASE nKey == K_END
			oBrowse:GoBottom()

		CASE nKey == K_ENTER
			//  If ENTER is pressed the program will find
			//  the nearest directory and run DOS's CD to
			//  that directory.
			DO WHILE .T.
				IF '\' $ aFiles[ nArrPos ]
					cRun := TRIM( aFiles[ nArrPos ] )
					cRun := 'CD' + LEFT( cRun,;
						LEN( cRun ) - 1 )
					IF( cRun == 'CD', cRun := 'CD\', Nil )
						RUN ( cRun )
						nKey := K_F10
					EXIT
				ELSE
					--nArrPos
				ENDIF
			ENDDO
		ENDCASE

	ENDDO

	Credit()

	SETCURSOR( 1 )

RETURN Nil



* * * *
*
*	Function GetFile()
*
FUNCTION GetFile( cDir, cFileFind, aFiles )
	LOCAL aDirect
	LOCAL cDirect
	LOCAL lRetVal := .T.
	STATIC nFiles := 0

	//  Retrieve all of the files that match the command line skeleton
	aDirect := DIRECTORY( cDir + cFileFind,;
			IF( cFileFind == '*.*', 'HS', 'DHS' ) )

	//  If aDirect is not empty files were found
	IF !( EMPTY( aDirect ) )
		//  Add the current directory to the aFiles array
		AADD( aFiles, UPPER( cDir ) )

		//  Adds the files found to the aFiles array with the
		//  appropriate info depending on whether it is a file
		//  or Directory
		AEVAL( aDirect, { | p1 | AADD( aFiles,;
			SPACE( 3 ) + IF( 'D' $ p1[ 5 ],;
			UPPER( PADR( p1[ 1 ], 20 ) ),;
			LOWER( PADR( p1[ 1 ], 20 ) ) ) +;
			IF( 'D' $ p1[ 5 ], '   SUB-DIR',;
			PADL( p1[ 2 ], 10 ) ) + SPACE( 3 ) +;
			DTOC( p1[ 3 ] ) + SPACE( 3 ) + LEFT( p1[ 4 ], 5 ) +;
			SPACE( 3 ) +;
			IF( 'D' $ p1[ 5 ], '', LOWER( p1[ 5 ] ) ) ), nFiles++ } )
		ShowFound( aFiles, .T. )

	ENDIF

	//  Displays the number of files found
	@21, 51 SAY nFiles PICT '99,999'
					

	IF INKEY() == K_ESC
		//  If ESCAPE is pressed the program will stop
		//   searching for files
		lRetVal := .F.
	ENDIF

RETURN lRetVal



* * * *
*
*	Function GetDirect()
*
FUNCTION GetDirect( cDir, cFileFind, aFiles, lDate, dDate1, dDate2 )
	LOCAL aDirect := {}, aTemp
	LOCAL cDefColor
	LOCAL lRetVal := .T.
	LOCAL nI, nLen, nLoc

	//  Displays the current directory in a box.
	cDefColor := SETCOLOR( mYC_NW )
	@11, 7 SAY PADR( cDir, 64 )
	SETCOLOR( cDefColor )

	cDir += '\'
	//  Fills aTemp with the current directory information.
	aTemp := DIRECTORY( cDir + "*.*", 'D' )

	//  Quickly scans to determine is there is a Sub-Directory.
	IF ( nLoc := ASCAN( aTemp, { | p1 | 'D' $ p1[ 5 ] } ) ) != 0

		//  Adds the current Sub-Directories to the aDirect array.
		AEVAL( aTemp, { | p1 | IF( 'D' $ p1[ 5 ] .AND.;
			p1[ 1 ] != '.', AADD( aDirect, cDir + p1[ 1 ] ),;
			Nil ) }, nLoc )

		IF lDate
			//  Gets the matching files according to date criteria
			lRetVal := GetDateFile( cDir, cFileFind, aFiles,;
				dDate1, dDate2 )

		ELSE
			//  Gets the matching files
			lRetVal := GetFile( cDir, cFileFind, aFiles )

		ENDIF

		FOR nI := 1 TO LEN( aDirect )
			//  Calls the GetDirect function recursively in order
			//  to get lower Sub-Directories.
			lRetVal := GetDirect( aDirect[ nI ], cFileFind,;
				aFiles,	lDate, dDate1, dDate2 )
			//  IF Getdirect() returns .F., the program will stop
			//  searching for files
			IF ! lRetVal
				EXIT
			ENDIF
		NEXT nI

	ENDIF

RETURN lRetVal



* * * *
*
*	Function GetDateFile()
*
//  If a date parameter is passed then the files are found in this function.
FUNCTION GetDateFile( cDir, cFileFind, aFiles, dDate1, dDate2 )
	LOCAL aDirect
	LOCAL lRetVal := .T.
	STATIC nFiles := 0, nLoc

	aDirect := DIRECTORY( cDir + cFileFind, 'HS' )

	nLoc := ASCAN( aDirect, { | p1 | ( p1[ 3 ] >= MIN( dDate1, dDate2 );
			.AND. p1[ 3 ] <= MAX( dDate1, dDate2 ) ) } )

	IF nLoc != 0

		AADD( aFiles, cDir )

		AEVAL( aDirect, { | p1 | IF( ( p1[ 3 ] >= MIN( dDate1, dDate2 );
			.AND. p1[ 3 ] <= MAX( dDate1, dDate2 ) ),;
			AADD( aFiles,	SPACE( 3 ) +;
			LOWER( PADR( p1[ 1 ], 20 ) ) + PADL( p1[ 2 ], 10 ) +;
			SPACE( 3 ) + DTOC( p1[ 3 ] ) + SPACE( 3 ) +;
			LEFT( p1[ 4 ], 5 ) + SPACE( 3 ) + LOWER( p1[ 5 ] ) ),;
			Nil ), nFiles++ }, nLoc )
		ShowFound( aFiles, .T. )

	ENDIF

	@20, 51 SAY nFiles PICT '99,999'

	IF INKEY() == K_ESC
		//  If ESCAPE is pressed the program will stop
		//  searching for files
		lRetVal := .F.
	ENDIF
		
RETURN lRetVal



* * * *
*
*	Function BoxZoom()
*
//  Expands a box onto the screen.
FUNCTION BoxZoom( nTR, nTC, nBR, nBC, cClrs )
	LOCAL cDefCol
	LOCAL nBCx, nTCx, nBRx, nTRx

	//  Finds the column center of the box
	nBCx := nTCx := ( INT( ( nBC - nTC + 1 ) / 2 ) + nTC )
	//  Finds the row center of the box
	nBRx := nTRx := ( INT( ( nBR - nTR + 1 ) / 2 ) + nTR )

	cDefCol := SETCOLOR( cClrs )

	DO WHILE .T.

		SETCOLOR( 'w+/n' )
		DISPBEGIN()
		@nTRx+1, nTCx+2, nBRx+1, nBCx+2 BOX ''

		SETCOLOR( cClrs )
		//  Draws the box.
		@nTRx, nTCx CLEAR TO nBRx, nBCx
		@nTRx, nTCx TO nBRx, nBCx DOUBLE
		DISPEND()

		//  Checks to see if there is any more expansion.
		IF nTRx == nTR .AND. nTCx == nTC .AND. nBRx == nBR .AND.;
			nBCx == nBC
			EXIT
		ENDIF

		//  Increments the new coordinates accordingly		
		nTRx -= IF( nTRx == nTR, 0, 1 )
		nTCx -= IF( nTCx == nTC, 0, 1 )
		nBRx += IF( nBRx == nBR, 0, 1 )
		nBCx += IF( nBCx == nBC, 0, 1 )

	ENDDO

	SETCOLOR( cDefCol )

RETURN Nil



* * * *
*
*	Function InfoScreen()
*
//  Displays information about command line parameters.
FUNCTION InfoScreen()

	BoxZoom( 2, 3, 22, 74, mYB_BWN )
	DISPBEGIN()

	SETCOLOR( IF( lColor, 'bg+/b', 'w+/n' ) )
	@3, 16 TO 5, 60

	SETCOLOR( mYB_BWN )
	@18, 8 SAY '/d=mm/dd/yr'
	@19, 8 SAY '/d=mm/dd/yr-mm/dd/yr'
	@20, 8 SAY '/d=mm/dd/yr-'
	@21, 8 SAY '/d=-mm/dd/yr'

	SETCOLOR( mBWB_WN )
	@8, 6 SAY 'Without a skeleton, the program will automatically list ' +;
			'all of the'
	@9, 6 SAY 'files on the disk.  With a skeleton the program will ' +;
			'list matching'
	@10, 6 SAY 'files.  Wildcards ? and * are valid.'

	@13, 6 SAY 'Without a skeleton, the program will automatically ' +;
			'list all files'
	@14, 6 SAY 'matching the date(s) specified.  With a skeleton, the ' +;
			'program will'
	@15, 6 SAY 'find files matching the skeleton and matching the date(s)'
	@16, 6 SAY 'specified.'

	@18, 29 SAY '- Find files created on the date'
	@19, 29 SAY '- Find files created between the two dates'
	@20, 29 SAY '- Find files created after the date'
	@21, 29 SAY '- Find files created before the date'

	SETCOLOR( IF( lColor, 'w+/r', 'n/w' ) )
	@7, 6 SAY 'FIND A FILE ( without dates )'
	@12, 6 SAY 'FIND A FILE ( with dates )'
	@4, 18 SAY ' FAF [<skeleton>] [/d=[<date>]-[<date>]] '

	SETCOLOR( mBWB_WN )
	@2, 32 SAY ' FIND A FILE '

	DISPEND()

	INKEY( 10 )

RETURN Nil




* * * *
*
*	Function HelpScreen()
*
//  Displays the help screen.
FUNCTION HelpScreen()
	LOCAL cDefCol, cDefColor := SETCOLOR( IF( lColor, 'w+/r', 'w/n' ) ),;
		cFullScrn := SAVESCREEN( 0, 0, 24, 79 )

	BoxShad( 6, 23, 14, 52, IF( lColor, 'gr+/r', 'w+/n' ) )
	@7, 30 SAY CHR( 25 ) + ' - Down'
	@8, 30 SAY CHR( 24 ) + ' - Up'
	@9, 27 SAY 'PGDN - Page Down'
	@10, 27 SAY 'PGUP - Page Up'
	@12, 26 SAY 'ENTER - Select Directory'
	@13, 28 SAY 'F10 - Exit'

	INKEY( 0 )

	RESTSCREEN( 0, 0, 24, 79, cFullScrn )
	SETCOLOR( cDefColor )

RETURN Nil



* * * *
*
*	Function SkipArray()
*
//   Controls movement through the browse.
FUNCTION SkipArray( nMove, nArrPos, nArrayLength )

	//   Checks to see if the movement will be outside the bounds
	//   of the array and if so, restricts the tbrowse's movements.
	IF nMove > 0
		//   If the current position plus the requested move is
		//   greater than the length of the array return the number
		//   of elements left in the array.
		IF ( nArrPos + nMove ) >  nArrayLength
			nMove := nArrayLength - nArrPos
		ENDIF
	ELSE
		//   If the current position plus the requested move is
		//   pass the start of the array, return the number of 
		//   elements to the start of the array.
		IF ( nArrPos + nMove ) < 1
			nMove := 1 - nArrPos
		ENDIF
	ENDIF

	//  Add the number to move to the array position
	nArrPos += nMove

RETURN nMove



* * * *
*
*	Function TimeToExit()
*
//  Exit Dialog Box
FUNCTION TimeToExit()
	LOCAL cDefCol, cDefColor := SETCOLOR( IF( lColor, 'w+/r', 'w+/n' ) ),;
		cFullScrn := SAVESCREEN( 0, 0, 24, 79 )
	LOCAL nExitCh := 1

	BoxShad( 8, 30, 12, 48, IF( lColor, 'w+/r', 'w+/n' ) )

	@9, 33 SAY 'Do You Really'
	@10, 33 SAY 'Want to Exit?'
	@11, 34 PROMPT ' YES '
	@11, 41 PROMPT ' NO '
	MENU TO nExitCh

	SETCOLOR( cDefColor )
	RESTSCREEN( 0, 0, 24, 79, cFullScrn )

RETURN IF( nExitCh == 1, .T., .F. )



* * * *
*
*	Function ShowFound()
*
//  TBrowse the files found so far
FUNCTION ShowFound( aFiles, lBox )

	DISPBEGIN()
	//  Goto the the bottom file
	oBrowse:GOBOTTOM()
	//  Determine how many files have been found
	nArrayLen := LEN( aFiles )

	//  Loop through until the new files are displayed
	DO WHILE ! ( oBrowse:STABILIZE() )
	ENDDO
	IF lBox
		//  Draws the directory box on the screen
		BoxShad( 10, 4, 12, 73, mBWC_BNW )
	ENDIF
	DISPEND()

RETURN Nil