;*** IMPORTANT: These have to be declared as EXTERNAL in Clipper

;------------------------------------------------------------------------------
; Filename: EXTENDCL.ASM
; Program.: Clipper Extended Library
; Authors.: Mark Fanara
; Date....: 5 - 27 -86
; Notes...: User-defined dBASE functions in 8086 assembly for Clipper.
;
;
;   Functions not in dBASE III or Clipper:
;      INIT_PRN    ::= procedure to initialize printer
;      CURSOR_ON   ::= procedure to turn cursor on
;      CURSOR_OFF  ::= procedure to turn cursor off

   NAME   EXTENDCL

   PUBLIC INIT_PRN
   PUBLIC CURSOR_ON
   PUBLIC CURSOR_OFF


_PROG SEGMENT

         ASSUME CS:_PROG



;------------------------------------------------------------------------------
;  INIT_PRN
;  Syntax: DO INIT_PRN
;  Return: Initializes printer

INIT_PRN PROC FAR

         MOV      AH,1H          ; select initialize printer function
         MOV      DX,0H          ; choose printer
         INT      17H            ; do interupt 17h

         RET

INIT_PRN ENDP
;------------------------------------------------------------------------------
;  CURSOR_ON
;  Syntax: DO CURSOR_ON
;  Return: TURNS CURSOR ON
;  NOTE  : - if you have a Color/Adaptor, start line = 6 & stop line = 7
;		  if you have monochrome, start line = 12 & stop line = 13

CURSOR_ON PROC FAR

          MOV      CH,12          ; START LINE
          MOV      CL,13          ; STOP  LINE
          MOV      AH,01          ; FUNCTION # 1
          INT      10H            ; CALL INT NUMBER 10h

          RET

CURSOR_ON ENDP

;------------------------------------------------------------------------------
;  CURSOR_OFF
;  Syntax: DO CURSOR_OFF
;  Return: TURNS CURSOR OFF

CURSOR_OFF PROC FAR

           MOV      CH,14          ; START LINE
           MOV      CL,07          ; STOP  LINE
           MOV      AH,01          ; FUNCTION # 1
           INT      10H            ; CALL INT NUMBER 10h

           RET

CURSOR_OFF ENDP


_PROG ENDS

         END

; EOF Extendcl.asm -------------------------------------------------------------
                                                                                                                                                                                                                                                                                                                                                                                                                         