;------------------------------------------------------------------------------
; Filename: EXTENDB.ASM
; Program.: Clipper Extended Library
; Authors.: Bob Baker
; Date....: December 16, 1986
; Notice..: Clipper is a trademark of Nantucket.
;           dBASE and dBASE III are trademarks of Ashton-Tate.
; Notes...: User-defined dBASE functions in 8086 assembly for Clipper.
;
;   Functions not in dBASE III or Clipper:
;      ISINS()    ::= True if INSert state active
;      ISCAPS()   ::= True if CAPSlock state active
;      ISNUM()    ::= True if NUMlock state active
;      ISCROLL()  ::= True if SCROLLlock state active
;      GETDRIV()  ::= Number of current drive [0..n]
;
;   Procedures not in dBase III or Clipper:
;      GETDIR     ::= String of Current Directory
;      INSOFF     ::= Turn INS Shift state OFF
;
   NAME   EXTENDB

   PUBLIC ISINS
   PUBLIC ISCAPS
   PUBLIC ISNUM
   PUBLIC ISCROLL
   PUBLIC GETDRIV
   PUBLIC GETDIR
   PUBLIC INSOFF

; Clipper return value calls
   EXTRN   _RETC:FAR    ; return character string
   EXTRN   _RETDS:FAR   ; return date type from date string "YYYYMMDD"
   EXTRN   _RETL:FAR    ; return logical true or false
   EXTRN   _RETNI:FAR   ; return word as numeric
   EXTRN   _RETNL:FAR   ; return double word as numeric
   EXTRN   _RETND:FAR   ; return floating point as numeric

_PROG   SEGMENT BYTE

        ASSUME CS:_PROG,DS:_PROG

NOTICE  DB  "(C) Copyright 1986"

;------------------------------------------------------------------------------
;  ISINS()
;  Syntax: ISINS()
;  Return: Logical true if the INSert state is active (INSert ON)

ISINS   PROC FAR

        MOV  AH,2         ; current shift key status
        INT  16H          ; keyboard I/O

        XOR  BX,BX
        AND  AL,80H       ; bit 7 has the flag
        CMP  AL,0         ; is it zeroed?
        JE   RET_ISINS    ; return false if other than above
        MOV  BX,1         ; true

RET_ISINS:
        PUSH BX           ; put return value on the stack
        CALL _RETL        ; return logical value to Clipper
        POP  BX           ; restore the stack

        RET

ISINS   ENDP


;------------------------------------------------------------------------------
;  ISCAPS()
;  Syntax: ISCAPS()
;  Return: Logical true if the CAPSlock state is active (CAPSlock ON)

ISCAPS  PROC FAR

        MOV  AH,2         ; current shift key status
        INT  16H          ; keyboard I/O

        XOR  BX,BX
        AND  AL,40H       ; bit 7 has the flag
        CMP  AL,0         ; is it zeroed?
        JE   RET_ISCAPS   ; return false if other than above
        MOV  BX,1         ; true

RET_ISCAPS:
        PUSH BX           ; put return value on the stack
        CALL _RETL        ; return logical value to Clipper
        POP  BX           ; restore the stack

        RET

ISCAPS  ENDP


;------------------------------------------------------------------------------
;  ISNUM()
;  Syntax: ISNUM()
;  Return: Logical true if the NUMlock state is active (NUMlock ON)

ISNUM   PROC FAR

        MOV  AH,2         ; current shift key status
        INT  16H          ; keyboard I/O

        XOR  BX,BX
        AND  AL,20H       ; bit 7 has the flag
        CMP  AL,0         ; is it zeroed?
        JE   RET_ISNUM    ; return false if other than above
        MOV  BX,1         ; true

RET_ISNUM:
        PUSH BX           ; put return value on the stack
        CALL _RETL        ; return logical value to Clipper
        POP  BX           ; restore the stack

        RET

ISNUM   ENDP


;------------------------------------------------------------------------------
;  ISCROLL()
;  Syntax: ISCROLL()
;  Return: Logical true if the SCROLLlock state is active (SCROLLlock ON)

ISCROLL PROC FAR

        MOV  AH,2         ; current shift key status
        INT  16H          ; keyboard I/O

        XOR  BX,BX
        AND  AL,10H       ; bit 7 has the flag
        CMP  AL,0         ; is it zeroed?
        JE   RET_ISCROLL  ; return false if other than above
        MOV  BX,1         ; true

RET_ISCROLL:
        PUSH BX           ; put return value on the stack
        CALL _RETL        ; return logical value to Clipper
        POP  BX           ; restore the stack

        RET

ISCROLL ENDP

;------------------------------------------------------------------------------
;  GETDRIV()
;  Syntax: GETDRIV()
;  Return: Drive Letter of current drive (as ASCII integer)

GETDRIV PROC FAR

        MOV  AH,19H       ; function number $19
        INT  21H          ; away we go!
        ADD  AL,"A"       ; convert to ASCII
        CBW               ; Zero High Byte
        MOV  BX,AX
        PUSH BX           ; put return value on the stack
        CALL _RETNI       ; return numeric value to Clipper
        POP  BX           ; restore the stack

        RET

GETDRIV ENDP


;------------------------------------------------------------------------------
;  GETDIR
;  Syntax: CALL GETDIR with memvar (a 64-byte ASCIIZ string)
;  Return: Current Directory

GETDIR  PROC FAR
        PUSH BP
        MOV  BP,SP        ; Set BP to stack frame
        PUSH DS
        PUSH ES
        CLD
        MOV  DL,0         ; for default drive
        LDS  SI,[BP+6]    ; get buffer pointer
        MOV  AH,47H       ; function number $47
        INT  21H          ; off to DOS
        JNC  GD_OK
        MOV  AX,0         ; ...unless there was an error
        MOV  [SI],AX
GD_OK:
        POP  ES
        POP  DS
        POP  BP
        RET

GETDIR  ENDP

;------------------------------------------------------------------------------
;  SCROLLW
;  Syntax: CALL SCROLLW with WORD(dir), WORD(num), WORD(lrow), WORD(lcol),
;                        WORD(rrow), WORD(rcol)
;  Return: Nothing

;SCROLLW PROC FAR
;        PUSH BP
;        MOV  BP,SP        ; Set BP to stack frame
;        PUSH DS
;        PUSH ES
;        CLD
;        MOV  AX,[BP+16]
;        MOV  DL,AL
;        MOV  AX,[BP+14]
;        MOV  DH,AL
;        MOV  AX,[BP+12]
;        MOV  CL,AL
;        MOV  AX,[BP+10]
;        MOV  CH,AL
;        MOV  BX,[BP+8]
;        MOV  AL,BL
;        MOV  BX,[BP+6]
;        MOV  AH,BL
;        MOV  BL,0         ; clear register
;        MOV  BH,07H       ; clear to black
;        INT  10H          ; console I/O
;
;        POP ES
;        POP DS
;        POP BP
;        RET
;
;SCROLLW ENDP
;
;------------------------------------------------------------------------------
;  INSOFF - Turns INS shift state OFF
;  Syntax: CALL INSOFF
;  Return: Nothing

INSOFF  PROC FAR
        PUSH BP
        MOV  BP,SP        ; Set BP to stack frame
        PUSH DS
        PUSH ES
        CLD
        PUSH DS
        MOV AX,40H
        MOV DS,AX
        AND BYTE PTR DS:[17H], 7FH
        POP DS
        POP ES
        POP DS
        POP BP
        RET

INSOFF  ENDP

_PROG   ENDS

        END

; EOF extendb.asm -------------------------------------------------------------
