CLEAR
SET CURSOR OFF
SET KEY 306 TO DISP_MEM
SAVE SCREEN TO MSCREEN
SNUMERIC=123456.789091
SDATE=DATE()
SCHARACTER='HELLO'
SLOGICAL=.F.
@ 1,0 TO 23,79 DOUBLE
@ 8,10 SAY [This is an example of the Display Memory Program.]
WAIT '         Press Alt M to view memory variables, anything else to quit.'
SET KEY 306 TO
SET CURSOR ON
CLEAR
RETURN

*******************************************************************************
* Written by Essor Maso.                                                      *
* A diagnostic tool to view memory variables easily.                          *
* It is assumed that Alt M(Key 306) is set to DISP_MEM.                       *
*******************************************************************************

PROCEDURE DISP_MEM

PARAMETERS _P_N______,_P_L______,_P_V______
PRIVATE VN________,VT________,VR________,MC________,SC________,FH________,;
FL________,MW________,N_________,_P_M______,TB________,LC________
_P_M______=LTRIM(STR(MEMORY(0)))
SAVE TO S_______ ALL EXCEPT _P_*   && Save memory variables
SET KEY 306 TO
SAVE SCREEN TO SC________
FH________=FOPEN('S_______.MEM')  && Open the file and get a handle.
FL________=FSEEK(FH________,0,2)  && Get the length of the file.
FSEEK(FH________,0)  && Go to the beginning of the file.
CLEAR SCREEN
@ 0,0 SAY 'Proc name '+_P_N______+' - Line '+LTRIM(STR(_P_L______,5))+;
          ' - Read Var '+_P_V______
IF FL________<2
* File contains only EOF marker.
 @ 2,0 SAY 'There are no memory variables present.'
ELSE
 STORE 0 TO N_________,TB________
 LC________=2  && Initialize a line counter.
 DO WHILE FSEEK(FH________,0,1)+1<FL________
* Variable specific information is contained in the first 18 bytes of the
* variable packet. The value of the variable is contained from positon 33 on.
  MW________=SPACE(18)
  FREAD(FH________,@MW________,18)  && Get the variable specific information.
* The variable name is in the first 10 position with a CHR(0) terminator.
  VN________=LEFT(MW________,AT(CHR(0),MW________)-1)
* The variable type is in position 12 of the packet.
* C3h is character or memo, CCh is logical, CEh is numeric, C4h is date.
  VT________=SUBS(MW________,12,1)
* For character and logical variables, position 17 and 18 contain the hex
* value for the range of the data. For numeric and date variables, the 
* range is 8. This points to the end of the variable packet.
  VR________=BIN2W(RIGHT(MW________,2))
  IF VT________$CHR(195)+CHR(204)  && Character or Logical
   MC________=14+VR________
   TB________=TB________+VR________
  ELSE                   && Numeric or Date.
   MC________=22
   TB________=TB________+8
  ENDIF
  FSEEK(FH________,MC________,1)   && Go to next packet.
  IF VR________>51.AND.VT________=CHR(195)
   @ LC________,0 SAY VN________
   @ LC________,11 SAY 'TYPE '+TYPE('&VN________')
   @ LC________,20 SAY ["]+LEFT(&VN________,50)+'>'
  ELSE
   @ LC________,0 SAY VN________
   @ LC________,11 SAY 'TYPE '+TYPE('&VN________')
   @ LC________,20 SAY ;
     IF(TYPE('&VN________')='C',["]+&VN________+["],&VN________)
  ENDIF
  LC________=LC________+1
  N_________=N_________+1
  IF ROW()>20
   @ LC________+1,0 SAY 'Press Q TO Quit, anything else to continue'
   INKEY(0)
   IF LASTKEY()=81.OR.LASTKEY()=113
    ERASE S_______.MEM
    RESTORE SCREEN FROM SC________
    SET KEY 306 TO DISP_MEM
    FCLOSE(FH________)
    RETURN
   ELSE
    CLEAR SCREEN
    LC________=2
    @ 0,0 SAY 'Proc name '+_P_N______+' - Line '+LTRIM(STR(_P_L______,5))+;
              ' - Read Var '+_P_V______
   ENDIF
  ENDIF
 ENDDO
ENDIF
ERASE S_______.MEM
@ LC________+1,0 SAY LTRIM(STR(N_________))+' Memory variables-'+_P_M______+;
'k Free memory-'+LTRIM(STR(TB________))+' Bytes used.'
@ LC________+2,0 SAY 'Press any key to continue.'
INKEY(0)
RESTORE SCREEN FROM SC________
SET KEY 306 TO DISP_MEM
FCLOSE(FH________)
RETURN
