//
//        Program: CtrlTime.prg
//        Purpose: Provides Clipper 5.2c a method of evaluating a code block
//                 every nth seconds.
//     Written by: Christopher A. Zielinski,  (CIS: 72723,2701)
//                 (416) 767-9674  9am-5pm  EST  voice/fax
//           Date: 94.01.01
//
//        Compile: Clipper CtrlTime
//           Link: (n/a)
//
//                 Copyright (c) 1994  Christopher A. Zielinski
//


#ifdef TESTING

    REQUEST QOUT

    TimeEval( 1, "{ || NIL }" )
    Inkey( 0 )
    TimeEval( 1, "{ || QOUT( TIME() ) }" )
    Dummy := 3/0
    Inkey( 0 )
    QUIT

#endif


/* ************************************************************************** */
PROCEDURE TimeEval( nEveryNthSec, cCodeBlockAsString )

    //  This is the only procedure to be called by the developer.  Note,
    //  the code block will not be evaluated while the Clipper error system
    //  has control.
    //
    //  Called with more/less parameters, removes TimeEval() from system.
    //
    //  nEveryNthSec --> is how often cCodeBlockAsString is evaluated in terms
    //                   of seconds.
    //
    //  cCodeBlockAsString --> is a string representation of a complete code
    //                         block expression.  Note, the return value of the
    //                         code block will be lost.

    // Capture the current error handler
    STATIC bDefErr

    IF PCount() == 2
        IF bDefErr == NIL

            // Modify is such that cCodeBlockAsString is not evaluated when the
            // Clipper error system has control
            bDefErr := ErrorBlock()
            ErrorBlock( { | oErr |             ;
                _MnTmEval(),                   ;    // Remove clock hook
                EVAL( bDefErr, oErr ),         ;    // Evaluate error handler
                __StartClock( __ClockStats() ) ;    // Restore clock hook
                } )

        END

        // Hook in the code block evaluation to the computers clock
        __StartClock( { nEveryNthSec, cCodeBlockAsString } )

    ELSE

        _MnTmEval()                             // Remove clock hook

        ErrorBlock( bDefErr )                   // Restore error handler
        bDefErr := NIL

        __ClockStats( { 777, "{ || NIL }" } )   // Restore default

    END

RETURN


/* ************************************************************************** */
PROCEDURE __StartClock( aDetails )

    // Save clock details
    __ClockStats( aDetails )

    // Hook in code block evaluation to the computers clock
    _MnTmEval( aDetails[1], aDetails[2] )

RETURN


/* ************************************************************************** */
FUNCTION __ClockStats( aDetails )

    // Try to reduce the impact of mistakes by defaulting to a harmless value
    STATIC aContainer := { 777, "{ || NIL }" }

    // Set/get logic
    IF aDetails != NIL
        aContainer := aDetails
    END

RETURN( aContainer )


/* ************************************************************************** */
EXIT PROCEDURE CZ_UnTime()
    // Unhook code block evaluation from the computers clock
    _MnTmEval()
RETURN


/* ************************************************************************** */
FUNCTION __MacroCl( cBlockStr )
    // Macro compile code block string expression's
RETURN( &( cBlockStr ) )


