FUNCTION ErrorBeep
**  Sound an error-style tone on the speaker
**  Syntax:  ERRORBEEP()
private i
i = 1
do while i < 3
   TONE(300,1)
   TONE(499,1)
   i = i + 1
enddo
return(0)

FUNCTION Color
**  Changes the color
**  Syntax:  COLOR(<expC>)
**  Argument:  'N'  = Normal
**             'BR' = Bright
**             'U'  = Underline
**             'BL' = Bright Blinking
**             'R'  = Reverse
**             'O'  = Odd (Actually the standard default)
parameters i
do case
   case upper(i) = 'N'
   set color to &c_normal
   
   case upper(i) = 'BR'
   set color to &c_bright
   
   case upper(i) = 'U'
   set color to &c_uline
   
   case upper(i) = 'BL'
   set color to &c_blink
   
   case upper(i) = 'R'
   set color to &c_reverse
   
   case upper(i) = 'O'
   set color to &c_odd
endcase
return(0)

FUNCTION getfield
**  Function for use with Achoice()
parameters mode, element, relative
mel = element
mre = relative
return(1)

FUNCTION indexsz
**  Estimate the size of an index based upon the field width,
**  number of records and type (NTX/NDX)
**  Syntax:   INDEXSZ( <expN1>, <expN2>, <expN3> )
**  Arguments:  <expN1> is the field width
**              <expN2> is the number of records
**              <expN3> is the type of index
**                      (1 = NDX, 2 = NTX)
parameters length, no_o_recs, mtype
if mtype = 1
   private m, i, j
   if no_o_recs = 0
      return 1024
   endif
   m  = int( 504 / (length + 8 ) )
   i  = ( no_o_recs / m )
   j = i + 2 
   m  = m + 1
   do while ( i > m )
      i  = int(( i - 1 ) / m ) + 1   
      j = ( j + i )
   enddo
   return ( int(j * 512) )
else
   if no_o_recs == 0
      return 2048
   else
      return ( int(no_o_recs/int(((1020/(length+10))-1)/2))+1 ) * 1024
   endif
endif

FUNCTION dbfsize
**  Returns the size of a database with a certain number of records
**  Syntax:  DBFSIZE( <expN> )
**  Arguments:  <expN> is the number of records in the database
parameters i
return( transform(int (recsize() * i + ((32 * fcount()) + 34)),'9,999,999,999'))

FUNCTION totbyte
**  Custom version of dbfsize to add the size of the current database 
**  with a certain number of records and the size of the index.  Returns
**  a Character string in the form 9,999,999,999.
parameters i, r
return( transform(  int (recsize() * i + ((32 * fcount()) + 34)) + r ,'9,999,999,999'))