*******************************************************************************
* Written by Essor Maso.                                                      *
* A diagnostic tool to view memory variables easily and to obtain the status  *
* on all open files.                                                          *
* Work areas may be 1 to 250, there may be up to 8 relation per work area.    *
* It is assumed that Alt M(Key 306) is set to _DISP_MEM.                      *
*******************************************************************************

PROCEDURE _DISP_MEM

PARAMETERS _P_N______,_P_L______,_P_V______
PRIVATE VN________,VT________,VR________,MC________,SC________,FH________,;
FL________,MW________,N_________,_P_M______,TB________,LC________
_P_M______=LTRIM(STR(MEMORY(0)))
SAVE TO S_______ ALL EXCEPT _P_*   && Save memory variables
SET KEY 306 TO
SAVE SCREEN TO SC________
FH________=FOPEN('S_______.MEM')  && Open the file and get a handle.
FL________=FSEEK(FH________,0,2)  && Get the length of the file.
FSEEK(FH________,0)  && Go to the beginning of the file.
CLEAR SCREEN
I_________=0
@ 0,0 SAY 'Proc name '+_P_N______+' - Line '+LTRIM(STR(_P_L______,5))+;
          ' - Read Var '+_P_V______
LC________=2  && Initialize a line counter.
STORE 0 TO N_________,TB________
IF FL________<2
* File contains only EOF marker.
 @ 2,0 SAY 'There are no memory variables present.'
ELSE
 DO WHILE FSEEK(FH________,0,1)+1<FL________
* Variable specific information is contained in the first 18 bytes of the
* variable packet. The value of the variable is contained from positon 33 on.
  MW________=SPACE(18)
  FREAD(FH________,@MW________,18)  && Get the variable specific information.
* The variable name is in the first 10 position with a CHR(0) terminator.
  VN________=LEFT(MW________,AT(CHR(0),MW________)-1)
* The variable type is in position 12 of the packet.
* C3h is character or memo, CCh is logical, CEh is numeric, C4h is date.
  VT________=SUBS(MW________,12,1)
* For character and logical variables, position 17 and 18 contain the hex
* value for the range of the data. For numeric and date variables, the 
* range is 8. This points to the end of the variable packet.
  VR________=BIN2W(RIGHT(MW________,2))
  IF VT________$CHR(195)+CHR(204)  && Character or Logical
   MC________=14+VR________
   TB________=TB________+VR________
  ELSE                   && Numeric or Date.
   MC________=22
   TB________=TB________+8
  ENDIF
  FSEEK(FH________,MC________,1)   && Go to next packet.
  IF VR________>51.AND.VT________=CHR(195)
   @ LC________,0 SAY VN________
   @ LC________,11 SAY 'TYPE '+TYPE('&VN________')
   @ LC________,20 SAY ["]+LEFT(&VN________,50)+'> '+;
     LTRIM(STR(LEN(&VN________)))
  ELSE
   @ LC________,0 SAY VN________
   @ LC________,11 SAY 'TYPE '+TYPE('&VN________')
   @ LC________,20 SAY ;
     IF(TYPE('&VN________')='C',["]+&VN________+["],IF(TYPE('&VN________')#;
     'L',&VN________,IF(&VN________,'.T.','.F.')))
  ENDIF
  LC________=LC________+1
  N_________=N_________+1
  IF ROW()>20
   @ LC________+1,0 SAY 'Press Q TO Quit, Return to continue.'
   DO WHILE I_________#81.AND.I_________#113.AND.I_________#13
    IF LEN(DTOC(DATE()))=8
     @ 0,72 SAY TIME()
     @ 1,72 SAY DATE()
    ELSE
     @ 0,70 SAY TIME()
     @ 1,70 SAY DATE()
    ENDIF
    @ 2,79 SAY ""
    I_________=INKEY(1)
   ENDDO
   I_________=0
   IF LASTKEY()=81.OR.LASTKEY()=113
    ERASE S_______.MEM
    RESTORE SCREEN FROM SC________
    SET KEY 306 TO _DISP_MEM
    FCLOSE(FH________)
    RETURN
   ELSE
    CLEAR SCREEN
    LC________=2
    @ 0,0 SAY 'Proc name '+_P_N______+' - Line '+LTRIM(STR(_P_L______,5))+;
              ' - Read Var '+_P_V______
   ENDIF
  ENDIF
 ENDDO
ENDIF
ERASE S_______.MEM
@ LC________+1,0 SAY LTRIM(STR(N_________))+' Memory variables-'+_P_M______+;
'k Free memory-'+LTRIM(STR(TB________))+' Bytes used.'
@ LC________+2,0 SAY 'Press Q to Quit, Return to continue.'
DO _V________
CLEAR SCREEN
@ 0,0 SAY 'PROGRAM STATUS:'
LC________=0
?
_SA_______=SELECT()
? 'Active work areas:'
_T________=.F.
FOR _N________=1 TO 250
 IF !EMPTY(ALIAS(_N________))
  _T________=.T.
  SELECT (_N________)
  ?
  ? 'Area '+LTRIM(STR(_N________,3))+' Alias is '+ALIAS()+'-Index order '+;
    LTRIM(STR(INDEXORD(),2))+'-Index Key is '+TRIM(INDEXKEY(INDEXORD()))
  LC________=LC________+2
  DO T_________
  IF LASTKEY()=81.OR.LASTKEY()=113
   EXIT
  ENDIF
  ? 'File size: '+LTRIM(STR(LASTREC()))+', '+;
    'Current record: '+LTRIM(STR(RECNO()))
  LC________=LC________+1
  DO T_________
  IF LASTKEY()=81.OR.LASTKEY()=113
   EXIT
  ENDIF
  ? 'BOF()',BOF(),'-','EOF()',EOF(),'-','FOUND()',FOUND()
  LC________=LC________+1
  DO T_________
  IF LASTKEY()=81.OR.LASTKEY()=113
   EXIT
  ENDIF
  IF !EMPTY(DBFILTER())
   ? 'Filter condition:'+DBFILTER()
   LC________=LC________+1
   DO T_________
   IF LASTKEY()=81.OR.LASTKEY()=113
    EXIT
   ENDIF
  ENDIF
  FOR _R________=1 TO 8
   IF EMPTY(DBRELATION(_R________))
    EXIT
   ENDIF
   ? 'Relation '+STR(_R________,1)+':'+DBRELATION(_R________)+' INTO '+;
     ALIAS(DBRSELECT(_R________))
   LC________=LC________+1
   DO T_________
   IF LASTKEY()=81.OR.LASTKEY()=113
    EXIT
   ENDIF
  NEXT
  IF LASTKEY()=81.OR.LASTKEY()=113
   EXIT
  ENDIF
 ENDIF
NEXT
IF LASTKEY()=81.OR.LASTKEY()=113
 ERASE S_______.MEM
 RESTORE SCREEN FROM SC________
 SET KEY 306 TO _DISP_MEM
 FCLOSE(FH________)
 RETURN
ENDIF
SELECT (_SA_______)
?
IF _T________
 ? 'Current work area '+ALIAS()
ELSE
 ? 'No active work areas'
ENDIF
? 'Press Q to quit.'
DO _V________
RESTORE SCREEN FROM SC________
SET KEY 306 TO _DISP_MEM
FCLOSE(FH________)
RETURN

PROCEDURE T_________
IF LC________=18
 LC________=1
 ?
 ? 'Press Q to Quit, Return to continue.' 
 DO _V________
 @ 3,0 CLEAR                    
 ? 'Area '+LTRIM(STR(_N________,3))+' Alias is '+ALIAS()+'-Index order '+;
   LTRIM(STR(INDEXORD(),2))+'-Index Key is '+TRIM(INDEXKEY(INDEXORD()))
ENDIF               
RETURN            

PROCEDURE _V________
DO WHILE I_________#81.AND.I_________#113.AND.I_________#13
 IF LEN(DTOC(DATE()))=8
  @ 0,72 SAY TIME()
  @ 1,72 SAY DATE()
 ELSE
  @ 0,70 SAY TIME()
  @ 1,70 SAY DATE()
 ENDIF
 @ 2,79 SAY ""
 I_________=INKEY(1)
ENDDO
I_________=0
RETURN
