/***
*	Errorsys.prg
*	Standard Clipper 5.0 error handler
*	Copyright (c) 1990 Nantucket Corp.  All rights reserved.
*
*	Compile:  /m/n/w
*/

#include "error.ch"

/* put messages to STDERR */
#command ? <list,...>   =>  ?? Chr(13) + Chr(10) ; ?? <list>
#command ?? <list,...>  =>  OutErr(<list>)


/***
*	ErrorSys()
*
*	Note:  automatically executes at startup
*/

proc ErrorSys()
	ErrorBlock( {|e| DefError(e)} )
return


/***
*	DefError()
*/
static func DefError(e)
local i

	if ( e:genCode == EG_OPEN .and. NetErr() .and. e:canDefault )
		/* driver default */
		return (.f.)									/* NOTE */
	end

	/* put a message to STDOUT */
	? "Error"

	if ( !Empty(e:subsystem()) )
		?? " " + e:subsystem() + "/" + Ltrim(Str(e:subCode()))
	end

	if ( !Empty(e:description()) )
		?? "  " + e:description()
	end

	if ( !Empty(e:operation()) )
		?? ": " + e:operation()
	end

	if ( !Empty(e:filename()) )
		?? ": " + e:filename()
	end


	if ( e:genCode == EG_OPEN .or. e:genCode == EG_CREATE )
		?? "  (DOS error " + Ltrim(Str(e:osCode)) + ")"
	end


	/* traceback */
	i := 2
	while ( !Empty(ProcName(i)) )
		? "Called from", Trim(ProcName(i)) + ;
			"(" + Alltrim(Str(ProcLine(i))) + ")  "

		i++
	end
*******************************************************************
* Logic to Record the Errors on Disk
*******************************************************************
       isub := 2
       m_data := Trim(ProcName(isub))+' Line '+alltrim(Str(procline(isub))) +' '+;
       e:description+' '+e:operation

       M_ERRMSG = DTOC(DATE()) + "  " + TIME() + "  " + M_data + ;
       ", Select: " + LTRIM(STR(SELECT())) + ", Alias: " + ALIAS() +CHR(13)+CHR(10)

       M_ERRHNDL = FOPEN("F_ERROR.LOG",2)
       IF M_ERRHNDL = -1
          M_ERRHNDL = FCREATE("F_ERROR.LOG")
      ENDIF
      IF M_ERRHNDL != -1
         FSEEK(M_ERRHNDL, 0, 2)
         FWRITE(M_ERRHNDL, M_ERRMSG)
         FCLOSE(M_ERRHNDL)
         SAVE TO F_ERROR
      ENDIF

      ALTD()

*******************************************************************
      ERRORLEVEL(1)
      QUIT

return (.f.)

