/***
*
*  ErrInsp.prg
*	The Error Inspector, a diagnostic error handler.
*
*  Copyright (c) 1992 Nantucket Corp.  All rights reserved
*
*/

// default path for the error information database...if the Description 
// option is not available on the View menu, this manifest constant should 
// be changed to the path name where ERRINFO.DBF and ERRINFO.NTX reside.
// 
#define EI_ERRINFO_PATH  "\ERRINSP\"

/***
*
*	InfoPath()
*
*	Returns path name where ERRINFO.DBF and ERRINFO.NTX reside. 
*
*/
FUNCTION InfoPath()

	RETURN ( EI_ERRINFO_PATH )

/***
*
*	ErrorSys()
*
*	Automatically executes at startup. This default error block points
*	the way to the active error handler.
*
*/
PROCEDURE ErrorSys()

	ERRORBLOCK( {|oErr| ErrInspector( oErr ) } )

	RETURN

/***
*
*	ShellBlock() --> bShellBlock
*
*	Returns code block to be executed whenever the "DOS Shell" option is
*  selected from the Error Inspector menu. The Error Inspector simply
*  issues a RUN command by default; however, the code block returned
*  by this function may be modified to reference the DOS shell command
*  of your choice.
*
*/
FUNCTION ShellBlock()

	RETURN ( {|| DefShell() } )


