* ͻ ͻ
*  Program: ENVIRON.PRG        Function  for maintaining "global" settings
*     Date: 07/25/91           throughout an application.                 
*   Author: James J. Killeen                                              
* ͼ ͼ

**
* ENV() allows for the loading of variables from a text file, and also
* provides a means for storing variables that can be accessed throughout 
* an application while keeping them STATIC.
*
*    SYNTAX: env( var, [set_to] )
*
*    VAR is the variable whose value will be returned. It does not have to
* follow variable naming conventions and can be any unique group of characters.
* If it does not already exist, it will be added and set to the value of
* SET_TO. If it DOES exist, and SET_TO is passed as a parameter, then VAR will
* be asssigned to SET_TO. If VAR is a file name (it includes a '.' in the string)
* then that file will be parsed and all the variables will be loaded into
* env(). Explicitly passing a NIL as the value of SET_TO, will delete a
* variable that already exists. All assignments stored in a "setup" file must
* be in the following format: varName=Value. In addition comments are
* supported using the '//' format if they are separated by at least one space
* from the value. Example:  fs_path=\data\mystuff\       // Data path
*
*    Examples of usage: env( "setup.sys" )
*                       set default to env( "fs_path" )
*                       env( "prev_record", recno() )
*                       env( "temporary setting", NIL)
**
FUNCTION env( var, set_to )
STATIC varList := {}
LOCAL rtnValue := NIL, position, pos, value, i

   var := upper(var)
   if '.' $ var
      if file(var)                        && if file is found
         load_file(var,varList)           && load it into the list.
      endif
   else
      position := ascan(varList, { | x | x[1] == var } )
      if position != 0                          && it was found
         rtnValue := varList[position, 2]
         if set_to != NIL
            varList[position, 2] := set_to
         elseif pcount() == 2                   && set_to was passed as NIL
            adel(varList, position)             
         endif
      else
         aadd( varList, {var, set_to} )         && add to the array
      endif
   endif

RETURN rtnValue

STATIC FUNCTION load_file(var, varList)
LOCAL handle, nlines, f_string, eq_pos, value, i

   handle := FOPEN(var,0)                 && open in read only mode
   nlines := flinecount(handle)           && get # of lines in file
   for i = 1 to nlines                    && parse file for each
      f_string := freadline(handle)       && read next line
      eq_pos := at("=",f_string)          && find equal sign
      if eq_pos == 0                      && if there's no
         loop                             &&   equal sign - skip it
      endif                               && parse out variable
      VAR := upper(left(f_string,eq_pos-1))  && get variable name
      value := substr(f_string,eq_pos+1,len(f_string)-eq_pos)
      if " //" $ value                  
         value := left(value, at(" //", value) )  && Remove any comments
      endif
      aadd( varList, {var, value} )       && add to the array
   next
   fclose(handle)                         && Close up shop

return NIL
