* Program Name: encoder.prg
* Author: Jonathan Cole

CLEAR

* SET KEY 9 TO tab                      && If you have GETIT, use this for
                                        && tabbing between columns
SELECT 1
USE Document
SELECT 2
USE Paragrfs

* array to hold selection (y or n) for each paragraph.
* the next line won't work if deleted records are on the Paragrfs file.
DECLARE paragraph[reccount()]
*--------------------------show what's on file------------------------------*
dfltln = 5                              && default for ln; first row to use.
ln     = dfltln                         && ln is the current row
clmn   = 1                              && initialize column to 1 of possible 3 (1, 27, 53).
first  = .T.                            && if first, then starting a new column.

DO WHILE .T.
   * mod 16 is used in the next line for 16 prompts per column (3 columns)
   DO WHILE ((RECNO()%16 <> 1) .OR. (first)) .AND. ! EOF()
      first = .F.

      *	char is character in encoded string where this paragraph is stored.
      *	x is 1 or 0; corresponding to whether or not this paragraph is chosen.

      char = SUBSTR(Document->Paracode,LEN(Document->Paracode)-INT(RECNO()/8)+IF(RECNO()%8<>0,0,1),1)

      X = INT(ASC(char)/2^(IF(RECNO()%8<>0,RECNO()%8,8) - 1))
      IF X/2 =INT(X/2)
         paragraph[recno()] = .F.
      ELSE
         paragraph[recno()] = .T.
      ENDIF

      @ ln, clmn SAY Paragrfs->Name + " :"
      @ ln, clmn + 23 SAY paragraph[recno()] PICTURE "y"

      ln=ln+1
      SKIP
   ENDDO

   IF clmn = 53
      EXIT                              && end of this page
   ENDIF

   clmn = IF(clmn = 1,27,53)
   first = .T.
   ln = dfltln
ENDDO

*-------------------------- get changes --------------------*
ln = dfltln
clmn = 1                                && initialize column to 1 of possible 3.
first = .T.                             && if first, then starting a new column.
GO TOP
DO WHILE .T.
   DO WHILE ((RECNO()%16 <> 1) .OR. (first)) .AND. ! EOF()
      first = .F.
      @ ln, clmn SAY Paragrfs->Name + " :"
      @ ln, clmn + 23 GET paragraph[recno()] PICTURE "y"

      SKIP
      ln=ln+1
   ENDDO
   IF clmn = 53
      EXIT                              && end of this page full
   ENDIF
   clmn = IF(clmn = 1,27,53)
   first = .T.
   ln = dfltln
ENDDO

READ

*------------------------ encode data ----------------------*
GO TOP
notfirst = .F.                          && is this the first paragraph being processed.
TOTAL = 0                               && ascii code to store in Paracode
nxtchar = LEN(Document->Paracode)       && next character in code to replace
FOR nxtpara = 1 TO Paragrfs->(reccount())  && nxtpara = next paragraph to evaluate

   * every 8 paragraphs move 1 character left in Paracode.
   IF (nxtpara%8 = 1 .AND. notfirst)
      REPLACE Document->Paracode WITH STUFF(Document->Paracode,nxtchar,1,CHR(TOTAL))
      nxtchar = nxtchar - 1
      TOTAL = 0
   ENDIF
   notfirst = .T.

   IF paragraph[nxtpara]
      TOTAL = TOTAL + 2^((IF(nxtpara%8<>0,nxtpara%8,8))-1)
   ENDIF
NEXT
* write the last one
REPLACE Document->Paracode WITH STUFF(Document->Paracode,nxtchar,1,CHR(TOTAL))
*----------*
PROCEDURE tab
   PRIVATE current
   current = n_gotoget()
   n_gotoget(IF(current<33,current+16,current-32))
RETURN
