/*
     hllclp.c

     Clipper interface to HLLC.

     D. Rifkind  25 May 90

     Use and redistribute freely.  Requires extor.obj from the
     "C goodies" package.

     Compile under Microsoft C with:

          cl -c -AL -Ox -Zl hllclp.c

     Compile under Turbo C with:

          tcc -c -ml hllclp.c
*/

extern int _parinfo(int);
extern int _parni(int, ...);
extern char *_parc(int, ...);
extern void _storni(int, int, ...);
extern void _retni(int);
extern int hllc(int, char *, int *, int *);

#define CL_STRING   0x1            /* string */
#define CL_NUMERIC  0x2            /* numeric */
#define CL_MPTR     0x20           /* pass by reference */


/*
     nRetVal = HLLCLP(nFunc, @cBuffer, @nLength, @nParam)

     nRetVal   Return value from HLLC
     nFunc     Function code
     cBuffer   Data buffer (by reference)
     nLength   Buffer length (by reference)
     nParam    Other parameter (by reference)
*/

void pascal HLLCLP(void)
{
     int func, length, param;
     char *buffer;

     /* HLLC manages to trash the DI register, causing  */
     /* trouble for clipper which is using it for other */
     /* purposes.  Setting up dummy register variables  */
     /* makes the compiler save and restore SI and DI.  */
     register int SI = 0, DI = 0;

     /* Check parameter types */
     if (_parinfo(1) != CL_NUMERIC ||
               _parinfo(2) != (CL_STRING | CL_MPTR) ||
               _parinfo(3) != (CL_NUMERIC | CL_MPTR) ||
               _parinfo(4) != (CL_NUMERIC | CL_MPTR)) {

          _retni(-999);                 /* error return */

     } else {

          func = _parni(1);
          buffer = _parc(2);
          length = _parni(3);
          param = _parni(4);

          _retni(hllc(func, buffer, &length, &param));

          _storni(length, 3);
          _storni(param, 4);
     }
}

/* end of hllclp.c */
