* An edit function for Clipper
* Refer to September 1986 Data Based Advisor
* page 62-65 for article and code
* made some minor changes in error reporting, pretty up boxes on 
* screen, and use of the EMPTY(memvar) function instead of IF "" = memvar
* done by R. F. Hicks 8/17/86

* set up for command line parm passing
PARAMETER FILE

* Flag set when file contains memo fields
memoflag = .F.

* Arbitrary limit on number of fields in a file set to 128
* this is equal to DB3 - Clipper can go to 1024
limit = 128

* init constants
cntrl_u = 21
cntrl_home = 29
esc = 27
pageup = 18
pagedown = 3
bel = CHR(7)

* set up array & dimension
declare FIELD[limit]

* begin the real thing
CLEAR

* get filename by checking
*    1. for command line parameter
IF EMPTY(FILE)
   FILE = SPACE(12)
   SET INTENSITY OFF
   @ 23,0 SAY 'Name of file to EDIT: ' GET FILE PICTURE "@!";
   valid .NOT. EMPTY(FILE)
   READ
   @ 23,0
   SET INTENSITY ON
ENDIF

CLEAR

* verify existence of file
FILE = IF(AT(".",FILE)<>0,FILE,TRIM(FILE)+'.DBF')  && one line iif
IF .NOT. FILE("&file")
   ? bel
   @ 23,0 SAY 'File not found!'
   RETURN
ENDIF

USE &FILE

* load field names into array
FOR n = 1 TO limit
   FIELD[n] = FIELDNAME(n)
   IF EMPTY(FIELD[n])
      lastfield = n-1
      n = limit+1 && force exit from loop
   ENDIF
NEXT

* calculate number of 'pages' needed to show all fields
pagemax = lastfield + (1 * INT(lastfield/14))
maxpage = IF(pagemax/15 = INT(pagemax/15),pagemax/15,INT(pagemax/15)+1)
page = 1

* use SET KEY command to set interupts
SET KEY cntrl_u TO del
SET KEY cntrl_home TO memoread

DO WHILE .T.  && here goes the real thing!!
   record = 0
   SET INTENSITY OFF
   @ 23,0 SAY 'Record number to edit: ' GET record PICTURE "@Z";
   valid not_2_many(record)
   READ
   SET INTENSITY ON
   IF EMPTY(record)  && empty for numeric vars is 0
      EXIT
   ENDIF
   GO record
   DO WHILE .T.
      * following three variables are used when an interupt
      * (^U or ^HOME) is generated during a read
      interupt = .F.
      temp_var = ""
      contents = ""
      CLEAR
      @ 1,0 SAY 'Record No. '
      @ 3,1 SAY "  CURSOR   <-- -->           UP   DOWN       DELETE "+;
      "     Insert Mode:  Ins"
      @ 4,1 SAY "   Char:            Field:             Char:   "+;
      "Del    Exit/Save:    Esc"
      @ 5,1 SAY "   Line:  Home End   Page:  PgUp  PgDn    Field:  ^Y "+;
      "    Memo:        ^Home"
      @ 6,1 SAY "   Word:    ^  ^     Help:   F1           Record: ^U "
      @ 4,16 SAY CHR(26)
      @ 6,14 SAY CHR(27)
      @ 6,17 SAY CHR(26)
      DO boxing

      IF DELETED()
         @ 1,45 SAY 'Del'
      ENDIF
      @ 1,11 SAY RECNO()
      * Calculate first and last fields on page display
      * then, if not memo field, set up get statement
      begin = IF(page = 1,0,(15*(page-1))-(1*(page-1)))
      FOR i = 1 TO IF(lastfield - begin > 15,15,lastfield - begin)
         name = FIELD[begin + i]
         IF TYPE("&name") = 'M'
            memoflag = .T.
            @ i+7,0 SAY FIELD[begin+i] + SPACE(10 - LEN(FIELD[begin+i]))
            SET COLOR TO /w
            @ i+7,COL()+1 SAY 'memo'
            SET COLOR TO w/
         ELSE
            @ i+7,0 SAY FIELD[begin+i]	 + SPACE(10 - LEN(FIELD[begin+i]));
            GET &name
         ENDIF
      NEXT
      READ
      * if interupt occurred replace data that could
      * possibly be lost  --> refer to article <--
      IF interupt
         REPLACE &temp_var WITH contents
      ENDIF

      * Determine which key was used to exit READ
      * and take appropriate action
      DO CASE
         CASE LASTKEY() = esc
            EXIT
         CASE LASTKEY() = pageup .AND. page = 1
            IF record > 1
               SKIP -1
               record = record -1
            ELSE
               ? bel		 && changed 8/17 /86 RFH
               @ 23,0 SAY "You're at the first record now!"
               WAIT
               @ 23,0
               @ 24,0
            ENDIF
         CASE LASTKEY() = pageup
            page = page - 1
         CASE (LASTKEY() = pagedown .AND. page = maxpage) .OR. ;
            (begin + 14 > lastfield)
            IF record < LASTREC()
               record = record + 1  && keep track of pos relative to eof
               page = 1
               SKIP
            ELSE
               ? bel	  && changed 8/17/86 RFH
               @ 23,0 SAY "You're at the last record now!"
               WAIT
               @ 23,0
               @ 24,0
            ENDIF
         OTHERWISE
            page = page + 1
      ENDCASE
   ENDDO
ENDDO
CLOSE DATABASES
CLEAR
RETURN


PROCEDURE del  && called if cntrl_u is pressed
parameters a,b,input_var  && must be declared if call from SET KEY
temp_var = input_var
interupt = .T.
contents = &temp_var
IF DELETE()
   @ 1,45 SAY '    '
   RECALL
ELSE
   @ 1,45 SAY 'Del'
   DELETE
ENDIF
RETURN

PROCEDURE memoread
parameters a,b,input_var  && must be declared if call from SET KEY
IF memoflag
   SET INTENSITY OFF
   @ 23,0 SAY 'Name of memo field to edit: '
   pressed = 0
   memofield = ""
   p_col = 28
   * The following gets the name of the memo field using the INKEY()
   * function since you cannot have nested READ's.
   DO WHILE pressed <> 13 .AND. LEN(memofield) < 10
      pressed = INKEY()
      DO CASE
         CASE pressed = 8 .OR. pressed = 19  && moveing cursor right
            memofield = ;
            IF(""	<> memofield,SUBSTR(memofield,1,LEN(memofield)-1),"")
            p_col = IF(p_col > 28,p_col -1,p_col)
            @ 23,p_col SAY ' '
            @ 23,p_col SAY ""
            CASE pressed <>0 .AND. pressed <> 13
               memofield = memofield + CHR(pressed)
               @ 23,p_col SAY CHR(pressed)
               p_col = p_col + 1
         ENDCASE
      ENDDO
      @ 23,0
      SET INTENSITY ON
      IF TYPE("&memofield") = 'M'
         SAVE SCREEN
         @ 2,0 CLEAR
         @ 1,0 SAY 'Edit: '+UPPER(memofield)
         *******************************************************************
         @ 3,1 SAY "  CURSOR   <-- -->           UP   DOWN       DELETE "+;
         "     Insert Mode:  Ins"
         @ 4,1 SAY "   Char:            Field:             Char:   "+;
         "Del    Abort:        Esc"
         @ 5,1 SAY "   Line:  Home End   Page:  PgUp  PgDn    Word:   ^T "+;
         "    Save:        ^W"
         @ 6,1 SAY "   Word:  ^   ^                          Line:   ^Y "
         @ 4,16 SAY CHR(26)
         @ 6,17 SAY CHR(26)
         DO boxing
         MEMO = memoedit(&memofield,9,0,23,65,.T.)
         REPLACE &memofield WITH MEMO
         RESTORE SCREEN
      ELSE
         ? bel
         @ 23,0 SAY 'No such memo field exists in this file.'
         WAIT
         @ 23,0
         @ 24,0
      ENDIF
   ELSE  
      ? bel
      @ 23,0 SAY 'This file has no memo fields!'
      WAIT
      @ 23,0
      @ 24,0
   ENDIF
   RETURN

   FUNCTION not_2_many
   PARAMETER number
   flag = .T.
   IF number > LASTREC()
      @ 23,45 SAY 'Record number too large'
      WAIT
      @ 23,45
      @ 24,0
      flag = .F.
   ENDIF
   RETURN(flag)

   PROCEDURE boxing
   frame = "ͻȺ"
   @ 2,0,7,79 BOX frame
   @ 2,20,7,20 BOX frame
   @ 2,41,7,41 BOX frame
   @ 2,56,7,56 BOX frame
   @ 2,20 SAY ''	&& fix up the points of intersection
   @ 2,41 SAY ''	&& of the three boxes
   @ 2,56 SAY ''	&& changed 8/17/86 RFH
   @ 7,20 SAY ''
   @ 7,41 SAY ''
   @ 7,56 SAY ''
   RETURN
   **********************  EOF EDIT.PRG  ****************************
