EBCDIC.prg

* Program: EBCDIC.prg
* Author:  Gerry Braganza with Richard McConnell
* Version: Clipper Summer '87
* Note(s): Illustrates the EBCDIC Index user-defined functions.
*
* Copyright (c) 1988 Nantucket Corp.
*
USE memo

* Initialize Extended Binary Coded Decimal Interchange Code
* (IBM's EBCDIC) table to corresponding American Standard
* Code for Information Interchange (ASCII) - ANSI X3.4.

EBCDIC =  CHR(0)+;           && NULL  : Space filler character.
          CHR(1)+;           && SCH   : ^A  Start of header.
          CHR(2)+;           && STX   : ^B  Start of text.
          CHR(3)+;           && ETX   : ^C  End of text.
          ' '+;              && PF    : No ASCII value.
          CHR(9)+;           && HT    : ^I  Horizontal tab.
          ' '+;              && LC    : No ASCII value.
          CHR(127)+;         && DEL   : Delete.
          ' '+;              && GE    : No ASCII value.
          ' '+;              && RLF   : No ASCII value.
          ' '+;              && SMM   : No ASCII value.
          CHR(11)+;          && VT    : ^K  Vertical tab.
          CHR(12)+;          && FF    : ^L  Form Feed.
          CHR(13)+;          && CR    : ^M  Carriage return.
          CHR(14)+;          && SO    : ^N  Shift out.
          CHR(15)+;          && SI    : ^O  Shift in.
          CHR(16)+;          && DLE   : ^P  Data link escape.
          CHR(17)+;          && DC1   : ^Q  Device control 1.
          CHR(18)+;          && DC2   : ^R  Device control 2.
          ' '+;              && TM    : No ASCII value.
          ' '+;              && RES   : No ASCII value.
          ' '+;              && NL    : No ASCII value.
          CHR(8)+;           && BS    : ^H  Backspace.
          ' '+;              && IL    : No ASCII value.
          ' '+;              && CAN   : No ASCII value.
          CHR(25)+;          && EM    : ^ Y End of medium.
          ' '+;              && CC    : No ASCII value.
          ' '+;              && CU1   : No ASCII value.
          ' '+;              && IFS   : No ASCII value.
          ' '+;              && IGS   : No ASCII value.
          ' '+;              && IRS   : No ASCII value.
          ' '+;              && IUS   : No ASCII value.
          ' '+;              && DS    : No ASCII value.
          ' '+;              && SOS   : No ASCII value.
          CHR(28)+;          && FS    : ^ \  File Separator.
          ' '+;              && Reserved.
          ' '+;              && BYP   : No ASCII value.
          CHR(10)+;          && LF    : ^J   Line feed.
          CHR(23)+;          && ETB   : ^W   Up/down to line.
          CHR(27)+;          && ESC   : Left Arr; end trans block.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && SM    : No ASCII value.
          ' '+;              && CU2   : No ASCII value.
          ' '+;              && Reserved.
          CHR(5)+;           && ENQ   : ^E  Inquiry.
          CHR(6)+;           && ACK   : ^F  Acknowledgement.
          CHR(7)+;           && BEL   : ^G  Bell.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(22)+;          && SYN   : ^V  Synchronous idle.
          ' '+;              && Reserved.
          ' '+;              && PN    : No ASCII value.
          CHR(30)+;          && RS    : ^^  Record Separator.
          ' '+;              && UC    : No ASCII value.
          CHR(4)+;           && EOT   : ^D  End of transmission.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && CU3
          CHR(20)+;          && DC4   : ^T  Device control 4.
          CHR(21)+;          && NAK   : ^U  Negative acknow.
          ' '+;              && Reserved.
          CHR(26)+;          && SUB   : ^Z  Substitute.
          ' '+;              && SP    : No ASCII value.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && (cent): No ASCII value.
          CHR(46)+;          &&   .   : Period.
          CHR(60)+;          &&   <   : Less than sign.
          CHR(40)+;          &&   (   : Opening parenthesis.
          CHR(43)+;          &&   +   : Plus sign.
          CHR(124)+;         &&   |   : Vertical line.
          CHR(38)+;          &&   &   : Ampersand.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(33)+;          &&   !  : Exclamation point.
          CHR(36)+;          &&   $  : Dollar sign.
          CHR(42)+;          &&   *  : Asterisk.
          CHR(41)+;          &&   )  : Closing parenthesis.
          CHR(59)+;          &&   ;  : Semicolon.
          ' '+;              &&      : No ASCII value.
          CHR(45)+;          &&   -  : Hyphen or minus sign.
          CHR(47)+;          &&   /  : Slash.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(124)+;         &&   |  : Vertical line.
          CHR(44)+;          &&   ,  : Comma.
          CHR(37)+;          &&   %  : Percent sign.
          CHR(95)+;          &&   _  : Underscore.
          CHR(62)+;          &&   >  : Greater than sign.
          CHR(63)+;          &&   ?  : Question mark.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(58)+;          &&   :  : Colon.
          CHR(35)+;          &&   #  : Number sign.
          CHR(64)+;          &&   @  : At sign.
          CHR(39)+;          &&   '  : Apostrophe.
          CHR(61)+;          &&   =  : Equal sign.
          CHR(34)+;          &&   "  : Quotation mark.
          ' '+;              && Reserved.
          [abcdefghi]+;      && lower case characters.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          [jklmnopqr]+;      && lower case characters.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(126)+;         &&   ~  : Tilde.
          [stuvwxyz]+;       && Lower case characters.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(123)+;         &&   {  : Opening brace.
          [ABCDEFGHI]+;      && Upper case characters.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && No ASCII value.
          ' '+;              && Reserved.
          ' '+;              && No ASCII value.
          ' '+;              && Reserved.
          CHR(125)+;         &&   }  : Closing brace.
          [JKLMNOPQR]+;      && Upper case characters.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          CHR(92)+;          &&   \  : Backward slash.
          ' '+;              && Reserved.
          [STUVWXYZ]+;       && Upper case characters.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && No ASCII value.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          [0123456789]+;     && numerics
          CHR(124)+;         &&   |  : Vertical line.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '+;              && Reserved.
          ' '                &&   EO : No ASCII value.

*****
* Message while indexing.
@ 23,0 say "Indexing based on EBCDIC code ..."

INDEX ON CharCnt(name, LEN(name)) TO file
@ 23,0

* Function: CharCnt()
* Note(s):  Counts the number of characters in the field.
*
FUNCTION CharCnt

* Pass the field name and field length.
PARAMETERS f_name, f_len
PRIVATE ncount, ntotal
ntotal = 0

* Process the string.
FOR ncount = 1 TO f_len
   ntotal = ntotal + CharWt(f_name, ncount)
NEXT
RETURN(ntotal)


* Function: CharWt()
* Note(s):  Returns the weight of character based on EBCDIC table.
*
FUNCTION CharWt

* Pass the field name and character order.
PARAMETERS f_name, norder

RETURN(AT(SUBSTR(f_name, norder,1), EBCDIC)*(100000/10^norder))
