**************************************************************************
** Program name: DYNA.PRG   NTX Index / DBT-III compatibility           **
**                                                                      **
** Force 2.5 sample program, written 12/08/92.  For use by Force 2.5    **
** Beta testers. Modified 2/17/93 to include memo view and edit and     **
** forward and backward indexed progression thru database.              **
**                                                                      **
** Program Description:                                                 **
**  This program illustrates Force 2.5's ability to open any DBF file   **
**  without the need to declare it in a DBFDEF block.  It also shows    **
**  how the DYNAMIC database decalaration can be used in conjunction    **
**  with indexing to index structure unknown DBF files.  Full field     **
**  editing and memo editing has been added as well.
**                                                                      **
** Notes:                                                               **
**  The indexing type depends which index library you link with.        **
**  DYNA.EXE was linked with F_NTX.LIB to make this DBF editor          **
**  compatible with Clipper NTX indexes, and DBT memo files.            **
**  Please be advised this program will expect Clipper DBT compatible   **
**  MEMO fields.  dBASE IV DBT memo, and FoxPro FPT memo fields will    **
**  not be operable, and hence the DBF file will not be openable.       **               **
**  You can expect a runtime error.  NTX, NDX and FDX all default to    **
**  memo type DBT, CDX defaults to memo type FPT.                       **
**                                                                      **
** Linking with other index libs:                                       **
**  To link to other index libs with Blinker 2.0 or higher:             **
**            C>blinker fi dyna search f_memo+f_mdx+force               **
**  To link using DOS, Warplink, or FreeLink:                           **
**            C>link dyna,,,f_memo+f_cdx+force                          **
**                                                                      **
**  Note: you may need to increase your segments if using MS-LINK.      **
**        To do so: C>link /seg:256 dyna,,,f_memo+f_idx+force           **
**                                                                      **
** $Revision: 0.22 $     Index type NTX                                 **
**************************************************************************

#INCLUDE COLORS.HDR		&& Be SURE you use the new 2.5 HDR files!
#INCLUDE DATABASE.HDR
#INCLUDE DATE.HDR
#INCLUDE IO.HDR
#INCLUDE KEYS.HDR
#INCLUDE MATH.HDR
#INCLUDE MEMO.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE TSR.HDR

#define TRUE	.T.
#define FALSE	.F.

#define PGUP_BUTTON 12
#define PGDN_BUTTON 34
#define ESC_BUTTON  52

#define FIELD_WIDTH_MAX	50
#define NUM_FIELD_MAX		18

#pragma W_FUNC_PROC-
#pragma W_GET_LOCAL-
VARDEF
	* global variable to represent which field we are indexing on.
	INT		field_num	&& temp index place-holder
	CHAR( 128 )	filename = ""	&& command line input var
	CHAR( 50 )	MemoMessage
	LOGICAL		DisplayIndex = &TRUE
	UINT		HiBit = 0x0	&& if EGA system, use bright backgrounds
ENDDEF

DBFDEF db_alias dynamic		&& New DYNAMIC declaration.  No other info
				&& required.

FUNCTION CHAR(35) IndexExp PROTOTYPE

INDEXDEF
	CHAR( 35 )	generic		IndexExp( )
ENDDEF
*-------------------------------------------------------------------------
* Function:	IndexExp()
*
* Description:	IndexExp() returns our index expression to the database
*		engine.  It also displays an indexing message if the
*		global variable 'DisplayIndex' is True.  Note that
*		We used LEFT() to make sure that the index  key does not
*		exceed defined amount of CHAR( 35 ).  This is in case a
*		field selected is longer than 35.  Then used a GLOBAL
*		integer variable to represent the field that will be
*		indexed on.  No casting using _CHAR() is needed since
*		LEFT() expects type CHAR so the compiler will auto-cast
*		the field to be type CHAR.
*-------------------------------------------------------------------------
FUNCTION CHAR(35) IndexExp

	VARDEF
		CHAR(128)	IndexMessage
	ENDDEF

	IF DisplayIndex
		IndexMessage = "INDEXING [ " + ;
		i_str( a_recno( db_alias ) * 100 / a_reccount( db_alias ) ) + ;
		"% ] TO GENERIC."+__index_ext
		middle( 24, IndexMessage, &BLACK_LIGHT_RED )
	ENDIF

	RETURN left( db_alias->field_num, 35 )
ENDPRO
*-------------------------------------------------------------------------
* Function:	Show_Help( )
*
* Description:	Show_Help( ) displays a screenful of information, telling
*		the usage of this utility.
*-------------------------------------------------------------------------
PROCEDURE Show_Help		&& Display help if no command line args
	CLEAR			&& or ?, /?, /H, args

	__color_std = &black_white
	? "Usage: DYNA [drive:\path\] filename[.dbf]"
	__color_std = &black_light_grey
	?
	? "       Where filename.dbf is any valid DBF database file."
	? "       The [drive:], [\path\], [.dbf] are optional."
	? " "
	__color_std = &black_white
	? "Example:  C:\TEST>dyna datafile.dbf              "
	__color_std = &black_light_grey
	?? "--or--"
	__color_std = &black_white
	? "          D:\DATA>dyna c:\tables\county"
	? " "
	__color_std = &black_light_grey
	? "Notes: This DBF & Memo editor illustrates Force 2.5's ability to"
	? "       handle undeclared database files.  It also shows that "
	? "       it can index unknown database files, and access memo fields."
	?
	? "       See the accompanying DYNA.DOC file for more information"
	? "       on Force 2.5 and its use in this demonstration."
	?
	? "       This program could have just as easily used indexes of"
	? "       type CDX, MDX, NDX, IDX or FDX.  NTX was chosen to make"
	? "       this version compatible with Clipper's index file"
	? "       structure and DBT memo files."
	?
	? "  This program was compiled using "
	__color_std = &black_white
	?? "Force 2.5, Beta Two"
	__color_std = &black_light_grey
	? "  Compiled on 2/27/93.  Written by bored <g> engineers at Dvorak Dev."
	? " "
	? " "
	QUIT
ENDPRO
*-------------------------------------------------------------------------
* Function:	Type_String( )
*
* Description:	Type_String( ) returns the field type given the single
*		Xbase character descriptor.
*-------------------------------------------------------------------------
FUNCTION CHAR( 8 ) type_string		&& Field type report function
	PARAMETERS VALUE BYTE f_type	&& displays the TYPE for each
					&& field in unknown DBF

	VARDEF
		CHAR( 8 ) field_type
	ENDDEF

	DO CASE
	CASE f_type = 'C'
		field_type = "CHAR   "

	CASE f_type = 'D'
		field_type = "DATE   "

	CASE f_type = 'L'
		field_type = "LOGICAL"

	CASE f_type = 'N'
		field_type = "NUMERIC"

	CASE f_type = 'M'
		field_type = "MEMO   "

	OTHERWISE
		field_type = " ERROR!"

	ENDCASE

	RETURN field_type
ENDPRO
*-------------------------------------------------------------------------
* Function:	mInput( )
*
* Description:	This function waits for either keyboard or mouse input.
*		It returns 'M' if the input is mouse, or 'K' if the input
*		is keyboard.  If the input is mouse, then the parameter
*		aKey is undefined and aRow, aCol are the coordinates
*		of the mouse press and aButton is 'L'eft or 'R'ight.  If
*		the input is keyboard, then aKey is the keypress value,
*		and the other parameters are undefined.
*-------------------------------------------------------------------------
FUNCTION UINT mInput
	PARAMETERS UINT aKey, UINT aRow, UINT aCol, UINT aButton

	VARDEF
		UINT		waitKey
	ENDDEF

	DO WHILE &TRUE

		waitKey = inkey( )

		IF waitKey <> 0
			aKey = waitKey
			RETURN 'K'
		ENDIF

		IF mouse_right_button( )
			aRow = Mouse_Row( )
			aCol = Mouse_Col( )
			aButton = 'R'
			RETURN 'M'
		ENDIF

		IF mouse_left_button( )
			aRow = Mouse_Row( )
			aCol = Mouse_Col( )
			aButton = 'L'
			RETURN 'M'
		ENDIF

	ENDDO
ENDPRO
*-------------------------------------------------------------------------
* Function:	ShutDown( )
*
* Description:	This function allows us to exit cleanly from our utility
*		while still printing an appropriate closing message.
*-------------------------------------------------------------------------
PROCEDURE ShutDown
	PARAMETERS CONST CHAR szMessage

	deactivate_procs( )
	__color_std = &BLACK_LIGHT_GREY
	?
	? szMessage
	?
	Mouse_Cursor( &FALSE )
	CLOSE ALL
	cursor_on( )
	QUIT

ENDPRO
*-------------------------------------------------------------------------
* Function:	EditMemo
*
* Description:	Here we let the user edit memo fields via a FILTER
*		function.  If the user presses Ctrl-Home while on
*		this field, then the memo-editor is brought up.
*-------------------------------------------------------------------------
FUNCTION UINT EditMemo

	VARDEF
    BYTE    SaveStd, SaveEnh
		CHAR(10)	MemoFieldName
		UINT		aKey
	ENDDEF

	aKey = lastkey( )
	IF aKey <> &K_C_HOME
		RETURN aKey
	ENDIF

  saveEnh = __color_enhcd

  __color_hi_stat = &blue_light_magenta
  __color_lo_stat = &blue_magenta
  __color_bar     = &blue_light_grey
  __color_tab     = &blue_white
  __color_enhcd   = &blue_white

	MemoFieldName = a_nfield_name( db_alias, get_id( ) )
	saveStd = __color_std
	save_area( 9,6,17,70 )
  fill( 9,6,17,70, &DOUBLE_BOX, space(8), &BLUE_LIGHT_GREY, &BLUE_WHITE,6 )
  __color_std = &blue_light_grey
  @ 9, 9                          ?? CHR( 181 )
  @ 9, 12 + LEN( MemoFieldName )  ?? CHR( 198 )

  __color_std = &blue_light_magenta
  @ 9, 10                         ?? " " + MemoFieldName + " "

  __color_std = &blue_light_cyan
  m_edit( db_alias, MemoFieldName, 10,7,15,68, 69,16,.F.,.T. )
	restore_area( )
	Mouse_Cursor( &TRUE )
  __color_std   = saveStd
  __color_enhcd = saveEnh

	RETURN &K_C_END

ENDPRO
*-------------------------------------------------------------------------
* Function:	Idle( )
*
* Description:	In our idle time, we check for the mouse clicks and perform
*		actions based on clicks and locations.  We also update
*		the INSERT state of the keyboard.
*-------------------------------------------------------------------------
PROCEDURE Idle

	VARDEF
		UINT		mRow, mCol
		UINT		ax, bx, cx, dx, ds, si, es, di, bp
		UINT		r,c
		BYTE		SaveStd
	ENDDEF

	SaveStd = __color_std
	r = row( )
	c = col( )
*
*	To get around SET SCOREBOARD, we have to do this the hard
*	way, by reading information from the BIOS.  Interrupt 0x16
*	will tell us the status of the INSERT key.
*
	AX = 0x0200
	Interrupt( 0x16, ax, bx, cx, dx, si, di, bp, ds, es )
	__color_std = &BLACK_YELLOW
	IF and( ax, 0x80 ) = 0x80
		@ 2, 5 ?? " INSERT  "
	ELSE
		@ 2, 5 ?? "OVERWRITE"
	ENDIF

	@ r,c
	__color_std = SaveStd

	IF .NOT. mouse_left_button( )
		RETURN
	ENDIF

	REPEAT
		* nop *
	UNTIL .NOT. mouse_left_button( )

	mRow = Mouse_Row( )
	mCol = Mouse_Col( )
	IF mRow = 24
		IF mCol >= &PGUP_BUTTON .AND. mCol < &PGUP_BUTTON + 8
			key_int( &K_PG_UP )
			RETURN
		ENDIF

		IF mCol >= &PGDN_BUTTON .AND. mCol < &PGDN_BUTTON + 8
			key_int( &K_PG_DOWN )
			RETURN
		ENDIF

		IF mCol >= &ESC_BUTTON .AND. mCol < &ESC_BUTTON + 8
			key_int( &K_ESC )
			RETURN
		ENDIF
	ENDIF
ENDPRO
*-------------------------------------------------------------------------
* Function:	SetupMouse( )
*
* Description:	SetupMouse( ) initializes the mouse and changes its colors.
*-------------------------------------------------------------------------
PROCEDURE SetupMouse
	VARDEF
		UINT		ax, bx, cx, dx, si, di, bp, ds, es
	ENDDEF

	Mouse_Init( )
	IF __mouse_active = 0
		RETURN
	ENDIF

	Mouse_Cursor( .t. )

	IF .NOT. is_ega( )
		RETURN
	ENDIF
	blink_off( )
	HiBit = 0x80

	AX = 0x000A		&& Change our mouse cursor.
	BX = 0x0000		&& want software cursor
	CX = 0xFFFF		&& keep characters in cursor
 	DX = 0xE700		&& change to bright yellow/black

	Interrupt( 0x33, ax, bx, cx , dx, si, di, bp, ds, es )
ENDPRO
*-------------------------------------------------------------------------
PROCEDURE Force_Main
	PARAMETERS CONST CHAR( 128 ) xfilename	&& command line argument

	VARDEF
		CHAR( 128 )	filename
		CHAR( 80 )	temp_string
		CHAR( 20 )	rec_string
		CHAR( 20 )	PictureClause
		CHAR( 8 )	field_type
		LOGICAL		overflow, InputAcceptable
		INT		i,j, max_fields
		INT		row_marker, col_marker
		INT		FieldLen, FieldDec
		INT		StartingField, EndingField
		UINT		aKey
		UINT		mRow, mCol, mButton
		BYTE		f_type, saveStd, FieldType
	ENDDEF

	SET SCOREBOARD OFF
	filename = TRIM( UPPER( xfilename ) )	&& command line arg cleaned
						&& and ready to go

	IF LEN( filename ) = 0 .OR.;&& if help is requested on command
		filename = "?" .OR.;&& line by typing ?, /?, or /H
		filename = "/H" .OR.;    && display help screen
		filename = "/?"

		Show_Help()
	ENDIF

	IF ( .NOT. EXIST( filename ) ) .AND.; && If specified file does not
		( .NOT. EXIST( filename + ".DBF" ) )    && exist, report error.
		ShutDown( "The database file '" + filename + "' does not exist, cannot continue..." )
	ENDIF

	field_num = 1
	__color_std = &black_white

	CLEAR

	SET EXCLUSIVE ON
	OPEN filename ALIAS db_alias && open file in variable 'filename'

	__color_std = &black_light_cyan
	? "Select the field number to index on (no MEMO or LOGICAL fields please): "
	?

	col_marker = 0
	row_marker = 3
	max_fields = a_num_fields( db_alias ) && set var 'max_fields' using new
		&& 2.5 function, a_num_fields

	__color_std = &black_light_green
	@ 2,0 Say "< 0> Natural order, NO INDEX"
	FOR j = 1 TO max_fields		&& Display field names and types

		IF ( a_nfield_type( db_alias, j ) <> 'M' ) .AND.; && spot any fields
			(a_nfield_type( db_alias, j ) <> 'L' )   && of MEMO or LOGICAL

			__color_std = &black_white
		ELSE
			__color_std = &black_light_grey
		ENDIF

		f_type = a_nfield_type( db_alias, j )

		field_type = type_string( f_type )

		@ row_marker, col_marker SAY "<" + STR( j, 2, 0 ) + "> " +;
			a_nfield_name( db_alias, j ) +;
			" is type " + field_type
		row_marker = row_marker + 1
		IF row_marker >= 22
			IF col_marker = 40    && DBF has too many fields in it to display
			*- no room left!  Lets hop out of this loop!
				__color_std = &black_light_red
				@ 22, 40  SAY "- out of display space -"
				EXIT
			ENDIF

			IF row_marker = 23
			*- go to second column
				row_marker = 3
				col_marker = 40
			ENDIF

		ENDIF

	NEXT

	__color_std = &black_light_cyan

	SetupMouse( )

	@ 23, 0 ?? "Enter field number: "

	field_num = 0
	IF mInput( aKey, mRow, mCol, mButton ) = 'K'	&& keyboard?
	 	IF aKey = 27
      ShutDown( "User termination..." )
		ENDIF
		Mouse_Cursor( &FALSE )
		REPEAT
			IF aKey >= '0' .AND. aKey <= '9'
				?? chr( aKey )
				field_num = field_num * 10
				field_num = field_num + (aKey - '0')
			ENDIF
			IF aKey = &K_BS
				field_num = field_num / 10
				@ row(), col() - 1 ?? " "
				@ row(), col() - 1
			ENDIF
			aKey = get_key( )
		UNTIL aKey = 27 .OR. aKey = &K_ENTER
		IF aKey = 27
			ShutDown( "User termination..." )
		ENDIF
		Mouse_Cursor( &TRUE )
	ELSE	&& must be mouse position
		IF mButton = 'R'
			ShutDown( "User termination, right mouse button pressed." )
		ENDIF
		IF mCol > 39
			field_num = mRow - 2 + 20
		ELSE
			field_num = mRow - 2	&& calculate from screen position
		ENDIF
	ENDIF

	__color_std = &black_white

	IF ( field_num > max_fields ) .OR.;   && if user chooses a bogus
		( field_num < 0 )   && field number, quit.
		ShutDown( "That isn't a valid field number!  All files closed. Program terminates." )
	ENDIF

	IF ( a_nfield_type( db_alias, field_num ) = 'M' ) .OR. ;
		( a_nfield_type( db_alias, field_num ) = 'L' )
		ShutDown( "Cannot index on a MEMO or LOGICAL field! Closing all files, and DYNA." )
        ENDIF

	DO cursor_off 		&& turn off cursor
	IF field_num = 0	&& no index desired: natural order
		GOTO TOP
		CLEAR
		@ 0,  1 SAY "Index format is: NONE"
		@ 0, 40 SAY "Index filename is NOT APPLICABLE"
		@ 1,  1 SAY "Selected index field is: NONE"
		@ 1, 40 SAY "Index key field is of type: N/A"

	ELSE			&& index is desired, index on selected field
		__color_std = &black_white
		@24, 0 CLEAR TO 24, 79
		* Key field must be of type CHAR, DATE or NUMERIC.

		!db_alias INDEX generic && index DBF on selected filed number.  Force
		DisplayIndex = &FALSE

	*	2.5 can index on a field number and does
	*	not need to know the field name.  In this
	*	respect Force 2.5 is unique.

		f_type = a_nfield_type( db_alias, field_num )
		field_type = type_string( f_type )

		GOTO TOP               && goto first indexed record
		CLEAR

		@ 0,  1 SAY "Index format is: "  && show index type
		@ 0, 40 SAY "Index filename is '           '"   && show index filename
		@ 1,  1 SAY "Selected index field is: "    && show picked key
		@ 1, 40 SAY "Index key field is of type: " && show picked key field type

		__color_std = &black_white
		@ 0, 18 SAY __index_ext&& index type
		@ 0, 59 SAY "GENERIC." + __index_ext  && index filename
		@ 1, 26 SAY a_nfield_name( db_alias, field_num )&& picked key
		@ 1, 68 SAY field_type && picked key field type
	ENDIF

	__color_std = &black_light_grey
	@  2, 0 TO  2, 79
	@ 23, 0 TO 23, 79
*
*	Set up our buttons for movement through the database.
*
	__color_std = &WHITE_BLUE + HiBit
	@ 24, &PGUP_BUTTON ?? "[ PgUp ]"
	__color_std = &BLACK_LIGHT_RED
	@ 24, col() + 1 ?? "= Previous"
	__color_std = &WHITE_BLUE + HiBit
	@ 24, &PGDN_BUTTON ?? "[ PgDn ]"
	__color_std = &BLACK_LIGHT_RED
	@ 24, col() + 1 ?? "= Next"
	__color_std = &WHITE_BLUE + HiBit
	@ 24, &ESC_BUTTON  ?? "[ Esc  ]"
	__color_std = &BLACK_LIGHT_RED
	@ 24, col() + 1 ?? "= Quit"
*
*	Here's our main loop.  It displays the current record, and moves
*	the record pointer when necessary.  Note that just before we enter
*	our main loop, we set up our Idle() function to interpret mouse
*	clicks on our three buttons, PgUp, PgDn and Esc.
*
	Cursor_On( )
	IF __mouse_active <> 0
		IF timer_entry( Idle, 1, &TSR_TIME_TICKS, &TSR_CALL_ANY )
			activate_procs( )
		ELSE
			ShutDown( "Cannot install Idle() function.  Call us." )
		ENDIF
	ENDIF
	StartingField = 1
	EndingField = a_num_fields( db_alias )



	DO WHILE &TRUE
		@ 3,0 TO 22,79 CLEAR
		__color_std	= &BLACK_LIGHT_GREY
    __color_enhcd = &BLACK_WHITE
    __color_enhcd2  = &BLUE_WHITE
	*
	*	First, set up our GETS
	*
		IF EndingField - StartingField > &NUM_FIELD_MAX
			EndingField = StartingField + &NUM_FIELD_MAX - 1
		ENDIF
		FOR i = StartingField TO EndingField
			@ 4 + i - StartingField, 1 SAY "#"
			__color_std = &BLACK_WHITE
			IF i < 10
				?? "0" + i_str( i )
			ELSE
				?? i_str( i )
			ENDIF
			__color_std = &BLACK_LIGHT_GREY
			?? ": "
			__color_std = &BLACK_LIGHT_BLUE
			?? r_pad( a_nfield_name( db_alias, i ), 10 )
			__color_std = &BLACK_LIGHT_GREY
			?? " ["
			FieldType = a_nfield_type( db_alias, i )
			FieldLen  = a_nfield_len( db_alias, i )
			FieldDec  = a_nfield_dec( db_alias, i )
		*
		*	For each different type of field, set up a
		*	GET that will accomodate it.
		*
			DO CASE
			CASE FieldType = 'C'
				IF FieldLen > &FIELD_WIDTH_MAX
					PictureClause = replicate( "X", &FIELD_WIDTH_MAX )
					FieldLen = &FIELD_WIDTH_MAX
					@ row(), col() GET db_alias->i ID i FUNCTION "@S" + i_str( &FIELD_WIDTH_MAX )
				ELSE
					@ row(), col() GET db_alias->i ID i
				ENDIF
			CASE FieldType = 'N'
				PictureClause = replicate( "9", FieldLen )
				IF FieldDec > 0
					PictureClause = PictureClause + "." + replicate( "9", FieldDec )
				ENDIF
				@ row(), col() GET db_alias->i ID i PICTURE PictureClause
			CASE FieldType = 'D'
				@ row(), col() GET db_alias->i ID i PICTURE "99/99/99"
			CASE FieldType = 'L'
				@ row(), col() GET db_alias->i ID i PICTURE "T"
			CASE FieldType = 'M'
				FieldDec = 0
				FieldLen = 50
				IF m_exist( db_alias, a_nfield_name( db_alias, i ) )
					MemoMessage = "MEMO - Press Ctrl-Home to Access"
				ELSE
					MemoMessage = "Empty MEMO - Press Ctrl-Home to Access"
				ENDIF
				SaveStd = __color_enhcd
				__color_enhcd = &BLACK_LIGHT_GREEN
				@ row(), col() GET MemoMessage FILTER EditMemo( )
				__color_enhcd = SaveStd
			*
			*	Since this is a memo, we put its screen info
			*	into our arrays in case the user points and
			*	clicks on this field.
			*
			ENDCASE
			IF FieldDec > 0
				@ row(), col() + FieldLen + 1 + FieldDec ?? "]"
			ELSE
				@ row(), col() + FieldLen ?? "]"
			ENDIF
		NEXT

		__color_std = &BLACK_LIGHT_GREEN
		@ 23, 63 ?? " " + l_pad0( i_str( a_recno( db_alias ) ), 6 )
		__color_std = &BLACK_LIGHT_GREY
		?? "/"
		__color_std = &BLACK_YELLOW
		?? l_pad0( i_str( a_reccount( db_alias ) ), 6 ) + " "
		__color_std = &BLACK_LIGHT_GREY

		READ
		Mouse_Cursor( &TRUE )
	*
	*	Now we process the user's input.  mInput() will tell us
	*	whether the user presses the mouse button or a key.
	*	If we get a mouse button, we want to translate that
	*	into an acceptable keypress.  Securing the universal
	*	translator, captain.
	*
		aKey = lastkey( )

		DO CASE
		CASE aKey = &K_ESC
			CLEAR
			ShutDown( "User termination... all files successfully closed." )
		*
		*	When PG_DOWN is pressed, we move to the next screenful
		*	of information for the record.  If all the info has
		*	been displayed, we move to the next record.
		*
		CASE aKey = &K_PG_DOWN	    && look for PgDn key press

			IF EndingField <> a_num_fields( db_alias )
				StartingField = EndingField
				EndingField = a_num_fields( db_alias )
			ELSE
				SKIP
				IF .NOT. a_eof( db_alias )  && check for end-of-file
					__color_std = &black_light_grey
					@ 2,60 ?? ""
					StartingField = 1
					EndingField = a_num_fields( db_alias )
				ELSE
					!db_alias GOTO BOTTOM 	&& if true, stay on last rec
					sound(125,3)	&& lo tone indicates EOF
					__color_std = &black_yellow
					@ 2,60 ?? "END-OF-FILE!"
				ENDIF
			ENDIF
		*
		*	When PGUP is pressed, we display the previsous
		*	screenful of information for this record.  If there
		*	is none, then we skip back one.
		*
		CASE aKey = &K_PG_UP		&& look for PgUp key press
			IF StartingField = 1
				SKIP - 1
				IF .NOT. a_bof( db_alias )  && check for top of file
					__color_std = &black_light_grey
					@ 2,60 ?? ""
				ELSE
					!db_alias GOTO TOP	&& stay at top record
					sound(300,3)	&& hi tone indicates TOF
					__color_std = &black_yellow
					@ 2,60 ?? "TOP-OF-FILE!"
				ENDIF
			ENDIF
			StartingField = 1
			EndingField = a_num_fields( db_alias )
		ENDCASE
	ENDDO
ENDPRO
*--- EOF: dyna.prg -------------------------------------------------------
