*:*********************************************************************
*:
*:      Program: DTOS.PRG
*:
*:       System: DTOS U.D.F. for Foxbase+ Ver. 2.0
*:       Author: Tony Ray
*:    Copyright (c) 1987, Tony Ray
*:
*: Documented: 9/9/87       17:04                   SNAP! version 2.02a
*:*********************************************************************

***************************************
*    SEARCH can be used with DTOS
*           in the prg. as follows:
*
*           mgo = search(mdate)
*
*           where:
*           mdate is a date variable;
*           mgo will be .T. if a record
*           was found() and .F. if no
*           record was found().
*
*           You can also use as search(ctod(mdate))
*           when mdate is a char. var. as follows:
*
*        do while .t.
*           mdate = (space(8)
*           @ row, col say "Enter date (cr) to exit " ;
*               get mdate pict "99/99/99"
*           read
*           clear gets
*           if len(trim(mdate))=0
*              exit
*           endif
*           if search(ctod(mdate))    && will be .t. if you found() a match
*
*              do something
*
*           else                      && if search(ctod(mdate)) is .f.
*
*
*               @ row+1,col say "No records for that date, reenter"
*           endif
*        enddo
***************************************
PROCEDURE search
PARAMETER xdate
xdate = DTOS(xdate)
SEEK xdate
IF FOUND()
	RETURN .T.
ELSE
	RETURN .F.
	
	
	***************************************
	*    DTOS takes a date variable and
	*         converts it to a char. string
	*         in the form 8708/31 ( from
	*         08/31/87 ) to use with seek
	*         when the database is indexed on
	*         a date field plus a char. field, as follows:
	*         SUBSTR(DTOC(<field>),7,2)+SUBSTR(DTOC(<field>),1,5) + chra. var.
	*         (*plus* a char. variable.)  If you only index
	*         on a date field with no char.
	*         variables, you don't need this.
	***************************************
	PROCEDURE DTOS
	PARAMETER xdate
	RETURN SUBSTR(DTOC(xdate),7,2)+SUBSTR(DTOC(xdate),1,5)
	
	
	***************************************
	*    STOD takes the char string made by
	*         DTOS and converts it back to
	*         regular date memo. variable
	*         (you don't need this unless you
	*         have converted the variable to
	*         a char. string)
	***************************************
	PROCEDURE STOD
	PARAMETER xdate
	xdate = CTOD(SUBSTR(xdate,3,5)+"/"+SUBSTR(xdate,1,2))
	RETURN xdate
	
	
	
	
	
	
	******************
	*      clipper version
	*      delete this or fox
	*      version above
	*
	*      This seems to work in clipper
	*      when the database is indexed
	*      with dtos(date)+char.var.??
	*
	*******************
	
	
	FUNCTION DTOS
	PARAMETER xdate
	RETURN(SUBSTR(DTOC(xdate),7,2)+SUBSTR(DTOC(xdate),1,5))
	
	
	FUNCTION STOD
	PARAMETER xdate
	xdate = CTOD(SUBSTR(xdate,3,5)+"/"+SUBSTR(xdate,1,2))
	RETURN(xdate)
	
	
	
	FUNCTION search
	PARAMETER xdate
	xdate = DTOS(xdate)
	SEEK xdate
	IF FOUND()
		RETURN(.T.)
	ELSE
		RETURN(.F.)
	ENDIF
	
	
	*EOF DTOSclip
	
*: EOF: DTOS.PRG
