/*

 Ŀ
                                                                        
  File Name...: DICTPOP.PRG                                             
  Author......: Vern Six                                                
  Date created: 03-25-94                                                
  Time created: 11:25:04am                                              
  CopyRight...: (c) 1994 by FrontLine Software                          
  Version.....: 3.0                                                     
                                                                        
 
  

*/

#include "dbstruct.ch"

function DictPop( pcDbfName )

   local aStruct  := {}
   local nLength  := 0
   local nCntr    := 0
   local cDbfName := upper( padr(pcDbfName,8) )

   use (pcDbfName) alias source new exclusive

   use dct_flds alias dct_flds new exclusive

   dct_flds->( ordSetFocus("NAME") )     // dbfname + field_name

   sClrSeq(cDbfName)

   aStruct := source->( dbStruct() )

   nLength := len(aStruct)

   for nCntr := 1 to nLength

      sUpdDict( cDbfName, aStruct[nCntr], nCntr )

   next nCntr

   sDelSeq(cDbfName)

   dbCloseAll()

   return nil


static function sClrSeq( pcDbfName )

   dct_flds->( dbSeek(pcDbfName,.f.) )

   while .not. dct_flds->( eof() )

      if .not. dct_flds->dbfname == pcDbfName
         exit
      endif

      dct_flds->( rLock() )

      dct_flds->seq := "000"

      dct_flds->( dbUnlock() )

      dct_flds->( dbSkip() )

   enddo

   return nil



static function sDelSeq( pcDbfName )

   dct_flds->( dbSeek(pcDbfName,.f.) )

   while .not. dct_flds->( eof() )

      if .not. dct_flds->dbfname == pcDbfName
         exit
      endif

      if .not. dct_flds->seq == "000"
         dct_flds->( dbSkip() )
         loop
      endif

      dct_flds->( rLock() )

      dct_flds->( dbDelete() )

      dct_flds->( dbUnlock() )

      dct_flds->( dbSkip() )

   enddo

   dct_flds->( sPack() )

   return nil


static function sPack()
   pack
   return nil


static function sUpdDict( pcDbfName, paFldInfo, pnPos )

   if dct_flds->( dbSeek( pcDbfName + paFldInfo[DBS_NAME], .f. ) )
      dct_flds->( rLock() )
   else
      dct_flds->( dbAppend() )
   endif

   dct_flds->dbfname    := pcDbfName
   dct_flds->seq        := strzero( pnPos * 5, 3, 0 )
   dct_flds->field_name := paFldInfo[DBS_NAME]
   dct_flds->field_type := paFldInfo[DBS_TYPE]
   dct_flds->field_len  := paFldInfo[DBS_LEN ]
   dct_flds->field_dec  := paFldInfo[DBS_DEC ]

   dct_flds->( dbUnlock() )

   return nil

