/*

 Ŀ
                                                                        
  File Name...: DICTUPD.PRG                                             
  Author......: Vern Six                                                
  Date created: 03-29-94                                                
  Time created: 01:49:29pm                                              
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "dbstruct.ch"
#include "setcurs.ch"

function DictUpd()

   SetMode(25,80)

   c_NewScrn()
   SetCursor(SC_NONE)

   @ 00,00 say padc("DICTUPD.EXE v3.0 - Data Dictionary Structure Update Utility",80) color c_BoxColor(1)
   @ maxrow(),00 say padc("CopyRight (c) 1994 by FrontLine Software - All Rights Reserved World Wide",80) color c_BoxColor(1)

   use dct_dbfs alias dct_dbfs new exclusive
   use dct_flds alias dct_flds new exclusive
   use dct_chgs alias dct_chgs new exclusive

   dct_dbfs->( ordSetFocus("NAME") )   // dbfname
   dct_flds->( ordSetFocus("SEQ" ) )   // dbfname+seq
   dct_chgs->( ordSetFocus("NAME") )   // dbfname+new_field

   cmxAutoOpen(.f.)                    // don't open (.CDX) files

   dct_dbfs->( dbGoTop() )

   while .not. dct_dbfs->( eof() )

      sWorkDbf( dct_dbfs->dbfname )

      dct_dbfs->( dbSkip() )           // next dbf

   enddo

   SetCursor(SC_NORMAL)

   dbCloseAll()

   SetColor("W/N")
   cls

   return nil


static function sWorkDbf( pcDbfName )

   local aNewStru  := {}
   local aOldStru  := {}
   local cStr      := "Restructuring " + alltrim(pcDbfName) + ".DBF"

   c_SaveScrn()

   c_Wind( 9,9,13,71, "", "Press [Escape] to Abort", 3 )

   @ 10, 11 say padc(cStr,59) color c_StdColor()
   @ 11, 11 say replicate(chr(196), 59) color c_StdColor()

   // get the old structure
   if file(alltrim(pcDbfName)+".DBF")
      use (pcDbfName) alias old_file new exclusive
      aOldStru := old_file->( dbStruct() )
   endif

   // get the new structure
   aNewStru := sDictStru(pcDbfName)

   begin sequence

      // if it's not here, just create an empty structure
      if .not. file(alltrim(pcDbfName)+".DBF")
         dbCreate(pcDbfName,aNewStru)
         break
      endif

      // if they are EXACTLY the same, don't mess with it
      if sIsSame(aNewStru,aOldStru)
         old_file->( dbCloseArea() )
         break
      endif

      if file("NEW_FILE.DBF")
         fErase("NEW_FILE.DBF")
      endif

      if file("NEW_FILE.FPT")
         fErase("NEW_FILE.FPT")
      endif

      select 0
      dbCreate( "NEW_FILE", aNewStru )
      use new_file alias new_file new exclusive

      // walk thru the old file
      old_file->( dbGoTop() )

      while .not. old_file->( eof() )

         old_file->( sProgress() )

         sConvert( aOldStru, aNewStru, pcDbfName )

         old_file->( dbSkip() )

      enddo

      // delete old_file, rename new_file
      new_file->( dbCloseArea() )
      old_file->( dbCloseArea() )

      // erase the BAK files
      if file(alltrim(pcDbfName)+".BAK")
         fErase(alltrim(pcDbfName)+".BAK")
      endif

      if file(alltrim(pcDbfName)+".DBK")
         fErase(alltrim(pcDbfName)+".DBK")
      endif


      fRename( alltrim(pcDbfName)+".DBF", alltrim(pcDbfName)+".BAK")

      if file(alltrim(pcDbfName)+".FPT")
         fRename( alltrim(pcDbfName)+".FPT", alltrim(pcDbfName)+".FPK")
      endif


      fRename( "NEW_FILE.DBF", alltrim(pcDbfName) + ".DBF" )

      if file("NEW_FILE.FPT")
         fRename( "NEW_FILE.FPT", alltrim(pcDbfName)+".FPT" )
      endif

   end sequence

   c_RestScrn()

   if file( alltrim(pcDbfName) + ordBagExt() )
      fErase( alltrim(pcDbfName) + ordBagExt() )
   endif

   return nil


static function sProgress()

   local nPercent := min( recno() / recCount(), 1 )
   local cStr     := space(27) + str(nPercent * 100, 3, 0) + "%" + space(28)
   local nReverse := 59 * nPercent

   @ 12, 11 say left(cStr, nReverse) color c_EnhColor()

   @ 12, 11 + nReverse say substr(cStr, nReverse + 1) color c_StdColor()

   return .t.


static function sConvert( paOldStru, paNewStru, pcDbfName )

   local nLength  := len(paNewStru)
   local nCntr    := 0
   local nOldPos  := 0
   local cFldName := ""
   local xOldData := nil

   new_file->( dbAppend() )

   for nCntr := 1 to nLength

      cFldName := alltrim(paNewStru[nCntr,DBS_NAME]) // easier to read

      nOldPos := aScan( paOldStru, {|x|alltrim(x[DBS_NAME]) == cFldName } )

      // see if the field name has changed
      if nOldPos = 0
         nOldPos := sFind( cFldName, paOldStru, pcDbfName )
      endif

      // is this a new field?
      if nOldPos = 0
         loop
      endif

      xOldData := old_file->( fieldget(nOldPos) )

      do case

         case paNewStru[nCntr,DBS_TYPE] = "C"

            sCvtChar( paOldStru[nOldPos], paNewStru[nCntr], nCntr, xOldData )


         case paNewStru[nCntr,DBS_TYPE] = "M"

            sCvtMemo( paOldStru[nOldPos], paNewStru[nCntr], nCntr, xOldData )


         case paNewStru[nCntr,DBS_TYPE] = "L"

            sCvtLog( paOldStru[nOldPos], paNewStru[nCntr], nCntr, xOldData )


         case paNewStru[nCntr,DBS_TYPE] = "N"

            sCvtNmbr( paOldStru[nOldPos], paNewStru[nCntr], nCntr, xOldData )


         case paNewStru[nCntr,DBS_TYPE] = "D"

            sCvtDate( paOldStru[nOldPos], paNewStru[nCntr], nCntr, xOldData )


      endcase

   next nCntr

   return nil


static function sFind( pcNewFld, paOldStru, pcDbfName )

   local nOldPos := 0

   dct_chgs->( dbSeek(pcDbfName + pcNewFld,.f.) )

   while .not. dct_chgs->( eof() )

      if .not. dct_chgs->dbfname == pcDbfName
         exit
      endif

      if .not. alltrim(dct_chgs->new_field) == alltrim(pcNewFld)
         exit
      endif

      nOldPos := aScan( paOldStru,{|x| alltrim(x[DBS_NAME]) == alltrim(dct_chgs->old_field) } )

      if nOldPos > 0
         exit
      endif

      dct_chgs->( dbSkip() )

   enddo

   return nOldPos



static function sCvtChar( paOld, paNew, pnCntr, pxOldData )

   local cNewData := ""

   do case

      case paOld[DBS_TYPE] = "L"

         if pxOldData = .t.
            cNewData := "T"
         else
            cNewData := "F"
         endif


      case paOld[DBS_TYPE] = "M"

         cNewData := pxOldData


      case paOld[DBS_TYPE] = "C"

         cNewData := pxOldData


      case paOld[DBS_TYPE] = "N"

         cNewData := alltrim( str(pxOldData) )


      case paOld[DBS_TYPE] = "D"

         cNewData := dtoc(pxOldData)

   endcase

   new_file->( fieldPut(pnCntr,left(cNewData,paNew[DBS_LEN])) )

   return nil



static function sCvtMemo( paOld, paNew, pnCntr, pxOldData )

   local cNewData := ""

   do case

      case paOld[DBS_TYPE] = "L"

         if pxOldData = .t.
            cNewData := "T"
         else
            cNewData := "F"
         endif


      case paOld[DBS_TYPE] = "M"

         cNewData := pxOldData


      case paOld[DBS_TYPE] = "C"

         cNewData := pxOldData


      case paOld[DBS_TYPE] = "N"

         cNewData := alltrim( str(pxOldData) )


      case paOld[DBS_TYPE] = "D"

         cNewData := dtoc(pxOldData)

   endcase

   new_file->( fieldPut(pnCntr,cNewData) )

   return nil



static function sCvtLog( paOld, paNew, pnCntr, pxOldData )

   local lNewData := .f.

   do case

      case paOld[DBS_TYPE] = "L"

         lNewData := pxOldData


      case paOld[DBS_TYPE] = "M"

         if left(pxOldData,1) $ "Tt"
            lNewData := .t.
         else
            lNewData := .f.
         endif


      case paOld[DBS_TYPE] = "C"

         if left(pxOldData,1) $ "Tt"
            lNewData := .t.
         else
            lNewData := .f.
         endif


      case paOld[DBS_TYPE] = "N"

         if int(pxOldData) == 0
            lNewData := .f.
         else
            lNewData := .t.
         endif


      case paOld[DBS_TYPE] = "D"

         if pxOldData = ctod("  /  /  ")
            lNewData := .f.
         else
            lNewData := .t.
         endif


   endcase

   new_file->( fieldPut(pnCntr,lNewData) )

   return nil


static function sCvtNmbr( paOld, paNew, pnCntr, pxOldData )

   local nNewData := .f.

   do case

      case paOld[DBS_TYPE] = "L"

         if pxOldData
            nNewData := 1
         else
            nNewData := 0
         endif


      case paOld[DBS_TYPE] = "M"

         nNewData := val(pxOldData)


      case paOld[DBS_TYPE] = "C"

         nNewData := val(pxOldData)


      case paOld[DBS_TYPE] = "N"

         nNewData := pxOldData


      case paOld[DBS_TYPE] = "D"

         nNewData := 0

   endcase

   nNewData := val( left( alltrim(str(nNewData)), paNew[DBS_LEN] ) )

   new_file->( fieldPut(pnCntr,nNewData) )

   return nil


static function sCvtDate( paOld, paNew, pnCntr, pxOldData )

   local dNewData := .f.

   do case

      case paOld[DBS_TYPE] = "L"

         dNewData := ctod("  /  /  ")


      case paOld[DBS_TYPE] = "M"

         dNewData := ctod( left(pxOldData,8) )


      case paOld[DBS_TYPE] = "C"

         dNewData := ctod( left(pxOldData,8) )


      case paOld[DBS_TYPE] = "N"

         dNewData := ctod("  /  /  ")


      case paOld[DBS_TYPE] = "D"

         dNewData := pxOldData

   endcase

   new_file->( fieldPut(pnCntr,dNewData) )

   return nil



static function sDictStru( pcDbfName )

   local aStruct := {}

   dct_flds->( dbSeek(pcDbfName,.f.) )

   while .not. dct_flds->( eof() )

      if .not. alltrim(dct_flds->dbfname) == alltrim(pcDbfName)
         exit
      endif

      aAdd( aStruct, { ;
         dct_flds->field_name, ;
         dct_flds->field_type, ;
         dct_flds->field_len,  ;
         dct_flds->field_dec     }  )

      dct_flds->( dbSkip() )

   enddo

   return aStruct


static function sIsSame( paOne, paTwo )

   local lSame   := .f.
   local nCntr   := 0
   local nLength := 0

   begin sequence

      if .not. len(paOne) == len(paTwo)
         break
      endif

      nLength := len(paOne)

      for nCntr := 1 to nLength

         if .not. alltrim(paOne[nCntr,DBS_NAME]) == alltrim(paTwo[nCntr,DBS_NAME])
            break
         endif

         if .not. paOne[nCntr,DBS_TYPE] == paTwo[nCntr,DBS_TYPE]
            break
         endif


         if .not. paOne[nCntr,DBS_LEN] == paTwo[nCntr,DBS_LEN]
            break
         endif


         if .not. paOne[nCntr,DBS_DEC] == paTwo[nCntr,DBS_DEC]
            break
         endif

      next nCntr

      lSame := .t.

   end sequence

   return lSame


