/*

 Ŀ
                                                                        
  File Name...: DICT2NG.PRG                                             
  Author......: Vern Six                                                
  Date created: 03-29-94                                                
  Time created: 01:46:19pm                                              
  CopyRight...: (c) 1994 by FrontLine Software                          
  Version.....: 3.0                                                     
                                                                        
 
  

*/

#include "cmx.ch"

#xtranslate write   <expC> => fWrite( snHandle, <expC> )
#xtranslate writeln <expC> => fWrite( snHandle, <expC> + chr(13) + chr(10) )

static snHandle := 0

function Dict2Ng()

   set deleted on

   use dct_dbfs alias dct_dbfs new shared
   dct_dbfs->( ordSetFocus("NAME") )  // dbfname

   use dct_flds alias dct_flds new shared
   dct_flds->( ordSetFocus("SEQ") )  // dbfname+seq

   use dct_keys alias dct_keys new shared
   dct_keys->( ordSetFocus("NAME"))  // dbfname+tagname

   begin sequence

      if file("STRUCT.DAT")
         fErase("STRUCT.DAT")
      endif

      snHandle := fCreate( "STRUCT.DAT" )

      if snHandle <= 0
         break
      endif

      // main loop
      //
      dct_dbfs->( dbGoTop() )

      while .not. dct_dbfs->( eof() )

         writeln "!short:" + dct_dbfs->dbfname + " - " + dct_dbfs->desc
         writeln dct_dbfs->dbfname + " - " + dct_dbfs->desc
         writeln ""

         sStruct(dct_dbfs->dbfname)

         sKeys(dct_dbfs->dbfname)

         dct_dbfs->( dbskip() )

      enddo

   end sequence

   if snHandle > 0
      fClose(snHandle)
   endif

   return nil

static function sStruct( pcDbfName )

   writeln "FIELD_NAME  TYPE  LEN  DEC  DESCRIPTION"
   writeln ""

   dct_flds->( dbSeek(pcDbfName,.f.) )

   while .not. dct_flds->( eof() )

      if .not. dct_flds->dbfname == pcDbfName
         exit
      endif

      write padr(dct_flds->field_name,10) + "  "
      write padl(dct_flds->field_type, 4) + "  "
      write strzero(dct_flds->field_len,3,0) + "  "
      write strzero(dct_flds->field_dec,3,0) + "  "
      write dct_flds->desc
      writeln ""

      if .not. empty(dct_flds->notes)
         sNotes()
      endif

      dct_flds->( dbSkip() )

   enddo

   return nil

static function sNotes()

   local nLine  := 0
   local nTotal := mlCount( dct_flds->notes, 40 )

   for nLine := 1 to nTotal

      writeln space(30) + memoline(dct_flds->notes,40,nLine)

   next nLine

   writeln ""

   return nil

static function sKeys( pcDbfName )

   local cChunk1 := ""
   local cChunk2 := ""
   local cChunk3 := ""

   writeln ""
   writeln ""

   dct_keys->( dbSeek(pcDbfName,.f.) )

   while .not. dct_keys->( eof() )

      if .not. dct_keys->dbfname == pcDbfName
         exit
      endif

      writeln "TAGNAME...: " + dct_keys->tagname

      cChunk1 := substr(dct_keys->key_expr, 1,40)
      cChunk2 := substr(dct_keys->key_expr,41,40)
      cChunk3 := substr(dct_keys->key_expr,81,40)

      writeln "KEY EXPR..: " + cChunk1

      if .not. empty( cChunk2 )
         writeln "            " + cChunk2
      endif

      if .not. empty( cChunk3 )
         writeln "            " + cChunk3
      endif


      cChunk1 := substr(dct_keys->for_clause, 1,40)
      cChunk2 := substr(dct_keys->for_clause,41,40)
      cChunk3 := substr(dct_keys->for_clause,81,40)

      writeln "FOR CLAUSE: " + cChunk1

      if .not. empty( cChunk2 )
         writeln "            " + cChunk2
      endif

      if .not. empty( cChunk3 )
         writeln "            " + cChunk3
      endif

      writeln ""
      writeln ""

      dct_keys->( dbSkip() )

   enddo

   return nil




