/*

 Ŀ
                                                                        
  File Name...: COMMON.PRG                                              
  Author......: Vern Six                                                
  Date created: 03-25-94                                                
  Time created: 01:47:54pm                                              
  CopyRight...: (c) 1994 by FrontLine Software                          
  Version.....: 3.0                                                     
                                                                        
 
  

*/

#include "box.ch"

#define _CURSOR  1
#define _ROW     2
#define _COL     3
#define _COLOR   4
#define _SCREEN  5
#define _MAXROW  6
#define _MAXCOL  7
#define _PALETTE 8

#xtranslate ASSUME <memvar> IS <value> [IF MISSING] ;
   => <memvar> := IF( <memvar> == NIL, <value>, <memvar> )


static saColors := { ;
   { "RG+/B",  "N/BG",  "N/W", "W+/B"   }, ; // normal
   { "B/BG",   "W+/RB", "N/W", "W+/BG"  }, ; // help
   { "W+/R",   "N/W",   "N/W", "W+/R"   }, ; // serious info
   { "BG+/RB", "N/W",   "N/W", "W+/RB"  }, ; // misc msgs
   { "B/W",    "W+/B",  "W/B", "W+/W"   }, ; // pick lists
   { "W+/RB",  "W+/BG", "N/W", "W+/RB"  }, ; // sub-pick lists
   { "RG+/RG", "N/BG",  "N/W", "W+/RG"  }    } // input panels

static snPalette  := 1
static slMono     := .f.
static saScrnStck := {}


function c_Palette( pnPalette )

   local nCurrent := snPalette

   if pcount() > 0
      snPalette := pnPalette
   endif

   return nCurrent


function c_SetColor( pnPalette )

   local cColor := ""

   assume pnPalette is snPalette if missing

   snPalette := pnPalette

   cColor := c_StdColor(pnPalette) + [,]   + ;
      c_EnhColor(pnPalette) + [,,,] + ;
      c_UnsColor(pnPalette)

   return SetColor(cColor)


function c_StdColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "W+/N", saColors[pnPalette,1] )


function c_EnhColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "N/W", saColors[pnPalette,2] )


function c_UnsColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "N/W", saColors[pnPalette,3] )


function c_BoxColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "W+/N", saColors[pnPalette,4] )


function c_Mono( plMono )

   local lMono := slMono

   if pcount() > 0
      slMono := plMono
   endif

   return lMono


function c_NewScrn( pnPalette )

   c_SetColor( pnPalette )
   @ 00,00,MaxRow(),MaxCol() BOX replicate(chr(176),9)

   return nil


function c_Wind(pnTop,pnLeft,pnBottom,pnRight,pcTitle,pcFootNote,pnPalette)

   assume pnTop      is 0        if missing
   assume pnLeft     is 0        if missing
   assume pnBottom   is MaxRow() if missing
   assume pnRight    is MaxCol() if missing
   assume pcTitle    is ""       if missing
   assume pcFootNote is ""       if missing

   c_Dim( pnBottom+1, pnLeft+1,  pnBottom+1, pnRight+1 )
   c_Dim( pnTop+1,    pnRight+1, pnBottom+1, pnRight+1 )

   DispBox( pnTop, pnLeft, pnBottom, pnRight, B_DOUBLE + " ", ;
      c_BoxColor(pnPalette) )

   if .not. empty(pcTitle)

      @ pnTop, pnLeft+1 say padr( " " + pcTitle + " ", pnRight-pnLeft-1, ;
         "" ) color c_BoxColor(pnPalette)

   endif

   if .not. empty(pcFootNote)

      @ pnBottom,pnLeft+1 say padc( " " + pcFootNote + " ", ;
         pnRight-pnLeft-1, "" ) color c_BoxColor(pnPalette)

   endif

   c_SetColor(pnPalette)

   return nil


function c_Dim(pnTop, pnLeft, pnBottom, pnRight, pnAttribute)

   local nCntr     := 0
   local cScrImage := SaveScreen(pnTop, pnLeft, pnBottom, pnRight)
   local cDimArea  := ""
   local nLength   := 0

   assume pnAttribute is 8 if missing

   nLength := len(cScrImage)

   for nCntr := 1 to nLength step 2

      cDimArea += substr(cScrImage, nCntr, 1) + chr(pnAttribute)

   next nCntr

   RestScreen(pnTop, pnLeft, pnBottom, pnRight, cDimArea)

   return nil


function c_SaveScrn()

   aadd(saScrnStck,  { SetCursor(), ;
      row(),       ;
      col(),       ;
      SetColor(),  ;
      SaveScreen(0,0,MaxRow(),MaxCol()), ;
      MaxRow(),    ;
      MaxCol(),    ;
      c_Palette()    } )

   return nil


function c_RestScrn(plSave)

   local aScrn := nil

   if len(saScrnStck) > 0

      aScrn := aTail(saScrnStck)

      SetCursor( aScrn[_CURSOR] )

      @ aScrn[_ROW], aScrn[_COL] say ""

      SetColor( aScrn[_COLOR] )

      SetMode( aScrn[_MAXROW], aScrn[_MAXCOL] )

      RestScreen(0, 0, aScrn[_MAXROW], aScrn[_MAXCOL], aScrn[_SCREEN] )

      c_Palette( aScrn[_PALETTE] )

      if pcount() = 0
         aDel ( saScrnStck, len(saScrnStck)   )
         aSize( saScrnStck, len(saScrnStck)-1 )
      endif

   endif

   return nil


