/*

 Ŀ
                                                                        
  File Name...: REINDEX.PRG                                             
  Author......: Vern Six                                                
  Date created: 03-29-94                                                
  Time created: 01:57:30pm                                              
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "cmx.ch"
#include "box.ch"
#include "inkey.ch"
#include "setcurs.ch"

#define _TAGNAME   paCdxInfo[nCntr,1]
#define _KEYEXPR   paCdxInfo[nCntr,2]
#define _FORCLAUSE paCdxInfo[nCntr,3]

// These functions are needed for some of the tag keys
external strzero
external descend

static slAbort := .f.                  // If this ever goes .t., stop indexing

function Reindex()

   local nHandle := 0

   SetMode(25,80)

   c_NewScrn()
   SetCursor(SC_NONE)

   @ 00,00 say padc("REINDEX.EXE v3.0 - Indexing Utility",80) color c_BoxColor(1)
   @ maxrow(),00 say padc("CopyRight (c) 1994 by FrontLine Software - All Rights Reserved World Wide",80) color c_BoxColor(1)

   begin sequence

      // if someone else is already indexing, blow out of here
      if file("__INDEX.SEM")

         // wait for other guy to finish
         while file("__INDEX.SEM")
         enddo

         break

      endif

      // create the semaphore file
      nHandle := fCreate("__INDEX.SEM")

      // if we couldn't create it, blow out
      if nHandle <= 0
         break
      endif

      // put something in it
      fWrite( nHandle, "INDEXING SEMAPHORE - DO NOT DELETE UNLESS INSTRUCTED" + chr(13) + chr(10)  )
      fWrite( nHandle, "TO DO SO BY FRONTLINE SOFTWARE")

      // close it... no sense keeping a file handle hanging around
      fClose(nHandle)

      // Tell COMIX not to open the (.CDX) file automatically
      cmxAutoOpen(.f.)

      // open the dictionary or blow out if unsuccessful
      if .not. sOpenDict()
         sDelFile("__INDEX.SEM")
         break
      endif

      // walk thru the dictionary and index each dbf
      sWalkDict()

      sDelFile("__INDEX.SEM")

   end sequence

   SetCursor(SC_NORMAL)

   dbCloseAll()

   SetColor("W/N")
   cls

   return nil


static function sOpenDict()

   local lSuccess := .f.
   local nTries   := 0

   begin sequence

      nTries := 0

      while nTries <= 10

         use dct_dbfs alias dct_dbfs exclusive new

         if .not. neterr()
            exit
         endif

         inkey(1)

         nTries++

      enddo

      if nTries > 10
         break
      endif

      dct_dbfs->( sBldCdx( { ;
         { "NAME", "DBFNAME", "" } ;
         } )      )

      if slAbort
         break
      endif

      //

      nTries := 0

      while nTries <= 10

         use dct_keys alias dct_keys exclusive new

         if .not. neterr()
            exit
         endif

         inkey(1)

         nTries++

      enddo

      if nTries > 10
         break
      endif

      dct_keys->( sBldCdx( { ;
         { "NAME", "DBFNAME + TAGNAME", "" } ;
         } ))

      if slAbort
         break
      endif


      //

      nTries := 0

      while nTries <= 10

         use dct_flds alias dct_flds exclusive new

         if .not. neterr()
            exit
         endif

         inkey(1)

         nTries++

      enddo

      if nTries > 10
         break
      endif

      dct_flds->( sBldCdx( { ;
         { "NAME", "DBFNAME+FIELD_NAME", "" }, ;
         { "SEQ",  "DBFNAME+SEQ",        "" }  ;
         } )      )

      if slAbort
         break
      endif

      //

      nTries := 0

      while nTries <= 10

         use dct_chgs alias dct_chgs exclusive new

         if .not. neterr()
            exit
         endif

         inkey(1)

         nTries++

      enddo

      if nTries > 10
         break
      endif

      dct_chgs->( sBldCdx( { ;
         { "NAME", "DBFNAME+NEW_FIELD", "" } ;
         } )      )

      if slAbort
         break
      endif

      //

      lSuccess := .t.

   end sequence

   return lSuccess


static function sWalkDict()

   dct_dbfs->( dbGoTop() )

   while .not. dct_dbfs->( eof() )

      if dct_dbfs->( deleted() )
         dct_dbfs->( dbSkip() )
         loop
      endif

      sIndexFile( alltrim(dct_dbfs->dbfname) )

      if slAbort
         exit
      endif

      dct_dbfs->( dbSkip() )

   enddo

   return nil


static function sIndexFile( pcDbfName )

   local aCdxInfo := {}

   dct_keys->( dbSeek(pcDbfName,.f.) )

   while .not. dct_keys->(eof())

      if .not. alltrim(dct_keys->dbfname) == pcDbfName
         exit
      endif

      aAdd( aCdxInfo, {      ;
         dct_keys->tagname,  ;
         dct_keys->key_expr, ;
         dct_keys->for_clause  } )

      dct_keys->( dbSkip() )

   enddo

   aAdd( aCdxInfo, { ;
      "_DELETED_", ;
      "RECNO()",   ;
      "DELETED()"    }  )

   use (pcDbfName) alias (pcDbfName) exclusive new

   (pcDbfName)->( sBldCdx(aCdxInfo) )

   (pcDbfName)->( dbCloseArea() )

   return nil



static function sDelFile( pcFileName )

   if file(pcFileName)
      fErase(pcFileName)
   endif

   return nil



static function sBldCdx( paCdxInfo )   // { cTagName, cKeyExpr, cForClause }

   local nTags     := len( paCdxInfo )
   local nCntr     := 0
   local cStr      := ""
   local nRecCount := 0

   c_SaveScrn()

   c_Wind( 9,9,13,71, "", "Press [Escape] to Abort", 3 )

   @ 11, 11 say replicate(chr(196), 59) color c_StdColor()

   sDelFile( upper(alias()) + ordBagExt() )

   for nCntr := 1 to nTags

      cStr := "Building " + alias() + ordBagExt() + " - Tag: " + _TAGNAME

      @ 10, 11 say padc(cStr,59) color c_StdColor()

      nRecCount := reccount()

      if empty(_FORCLAUSE)

         xindex on (_KEYEXPR) tag (_TAGNAME) ;
            eval {||sProgress()} every nRecCount / 20

      else

         xindex on (_KEYEXPR) tag (_TAGNAME) for (_FORCLAUSE) ;
            eval {||sProgress()} every nRecCount / 20

      endif

      if slAbort
         exit
      endif

   next nCntr

   c_RestScrn()

   return nil



static function sProgress()

   local nPercent := min( recno() / recCount(), 1 )
   local cStr     := space(27) + str(nPercent * 100, 3, 0) + "%" + space(28)
   local nReverse := 59 * nPercent
   local lEsc     := ( inkey() == K_ESC )

   if lEsc
      slAbort := .t.
   endif

   @ 12, 11 say left(cStr, nReverse) color c_EnhColor()

   @ 12, 11 + nReverse say substr(cStr, nReverse + 1) color c_StdColor()

   return !lEsc



