;
;****************************************************************
;                                                               *
;               CLIPPER ROUTINE - DISK DRIVE STATUS             *
;                      By Kelly Mc Tiernan                      *
;                                                               *
;****************************************************************
;
;
;	This routine uses the lowest level BIOS interupt for disk
;	I/O to determine status of the drive in question, bypassing
;	the DOS error routines. Thus disk drive errors such as 
;	non - dos disk, drive door open, and write protected can
;	be handled at the application level. Call with a single
;	byte parameter containing the drive letter (CAPS!).
;	Returned in second variable parameter is status, e.g.->
;
;	DR = "A"
;	ST = "0"
;	CALL DRSTAT WITH DR,ST
;
;	ST |          ERROR DESCRIPTION
;	---+-------------------------------------
;	0  |	DRIVE READY - READ / WRITE
;	1  |    DRIVE READY - WRITE PROTECTED
;	2  |    DRIVE NOT READY - DOOR OPEN
;	3  |	DRIVE NOT READY - NON - DOS DISK
;	4  |    DRIVE NOT READY - MISC. ERROR
;	   |
;
;
;
PUBLIC  drstat
;
dskint		EQU	13h		; BIOS disk drive int.
read		EQU	02h		; disk read command
write		EQU	03h		; disk write command
dskrst		EQU	00h		; disk reset command
wrprot		EQU	03h		; write protect status bits
door		EQU	80h		; T.O. error, usually door open
nondos		EQU	02h		; address mark, not formatted
;
        _PROG SEGMENT BYTE
        ASSUME  CS:_PROG
;
drstat  PROC    FAR
        push    bp                      ; standard setup, param's
        mov     bp,sp                   ;
        push    es                      ; save seg.'s need for ptr.'s
	push	ds			;
        lds     si,dword ptr [bp + 6]   ; address of drive select byte
	push	cs			; read buffer is here in DS
	pop	es			; ES:BX is buff. ptr.
	mov	bx,offset cs:buffer	;
	lodsb				; get drive specifier
	sub	al,'A'			; A - A = 0, B - A = 1 .. etc.
	mov	dl,al			; for interupt
	mov	dh,0			; always use head 0
	mov	cx,1			; track 0, sector 1
	mov	al,1			; read 1 sector
	mov	ah,read			; read command
	int	dskint			;
	jc	error			; cy = error, report and process
	mov	ah,write		; write same back, write prot. chk.
	mov	al,1			; same number of sectors
	int	dskint			;
	jc	error			; cy = error, report and process
	mov	al,'0'			; return all O.K.
	jmp	done			;
error:
	mov	al,'1'			; first error condition
	cmp	ah,wrprot		; write protected disk ?
	jz	reset			;		
	inc	al			; next error condition
	cmp	ah,door			; door open ?
	jz	reset			;
	inc	al			;
	cmp	ah,nondos		; non - dos disk ?
	jz	reset			;
	inc	al			; fall through, general error
reset:
	push	ax			; save, need to issue reset
	mov	ah,dskrst		; reset disk controller
	int	dskint			;
 	pop	ax			; get back return value
done:
	les	di,dword ptr [bp + 10]	; address of status return byte
	stosb				; set return code
	pop	ds			; restore state
        pop     es                      ; 
        pop     bp                      ;
        ret
drstat  ENDP
;
buffer	DB	1024 DUP(0)		; 1K buffer ( 512 bytes = 1 sector )
;
_PROG   ENDS
        END
