; Program: DRV_.ASM
; Date   : 01/20/90
; Author : Copyright(c)1990 Randy W. Fogg and TekWare Associates
; Purpose: A general CLIPPER function DRIVES()
; Returns: A Clipper character string listing of ALL logical and SUBST drives
;          on a system.
; Syntax : drvstr = DRIVES()
; Remarks: I had searched for a routine to accurately return ALL the valid
;          drives in a system. It seems all I could find were functions using
;          INT 21 Function 14, which will return the number of drives on a system.
;          However; in DOS 3.x this function returns a 5 if less than 5 drives
;          exist. It also cannot take into account the many combinations of
;          Substituted drives on a system. It is possible in DOS to have non-
;          contigous drives such as A: B: C: D: H: J: on a system with drive
;          letters substituted for directories. I needed a function that would
;          return all currently assigned logical drives in a system. I decided to
;          write one to serve my purpose and found it quite easy with the use
;          of DOS INT 21h Function 29h. This is an FCB function for parsing
;          a valid filename. By cycling through all 26 letters I could build
;          a list of valid drives easily. This Clipper function has proved
;          indespensible to me and I hope you find as much use for it.
;
; Use    :  DRIVES() returns a character string containing all valid drive
;           letters on a system. Example: A system with 2 floppies, a 40MB
;           Hard Drive partitioned to C: and D:, a RAM disk as drive E:, an
;           EMS disk as drive F:, and a directory substituted as drive H:.
;                             drvstr = DRIVES()
;                             ? drvstr
;                Results:     ABCDEFH
;           The length of this string will give the count of drives:
;                             ? len(drvstr)
;                Results:           7
;           To check for a valid drive you might:
;                if "I" $ Drives()
;                    ? "Valid Drive"
;                else
;                    ? "Drive Does Not Exist"
;                endif
;
;   I use Borland's TASM for compilation and TLINK for linking but the
;   code should be generic enough to use any assembler. Just include the OBJ
;   file into your link statement and away you go.
;
;   I have many functions in ASM and C and Clipper in a library called
;   CityFogg.LIB that is distributed as shareware. If there is any interest
;   in specific functions or problems I'd be happy to here about them.
;
;   Randy W. Fogg
;   TekWare Associates
;   4242 Frizell Ave
;   Sacramento CA. 95842
;   CIS: 76530,530
;
;   Some example functions:
;                           WPCONV(<source>,<destination>)
;             Written in ASM, converts any comma deli file to WordPerfect
;             secondary merge file at about 40,000 records per minute.
;
;                           Deli2DIF(<source>,<destination>)
;             Written in ASM, converts comma deli file to DIF format.
;             VERY Fast....
;                           Deli2DBF(<source>,<destination>)
;             Written in ASM, converts comma deli file to DBF structure
;             automatically finding field TYPES and LENGTHS.
;             Great for import routines
;
;  PLUS:      String Functions, Menus, Directory listing for File Picking,
;             Numeric Functions, Math functions, Date Functions, DOS commands,
;             ( never use RUN to CD, MD, or RD again), Memory Swapping ( swap
;             out all but 4k to run ANYTHING from within your application;
;             works with EMS), Popup calenders, Multiple row and column menus;
;             (all directions work), etc, etc.....
;
;      Comments, Remarks and Critisism always welcome...<grin>
;




PUBLIC  DRIVES
EXTRN     __RETCLEN:FAR
DGROUP    GROUP     DSEG
DSEG      SEGMENT   PUBLIC 'DATA'
my_fcb    db      60 dup(' '),0        ; Will contain valid drive string
numdrv    db      10 dup(0)            ; small buffer area
mynum     dw      0                    ; Keep count of string len for Clipper
DSEG      ENDS
CSEG      SEGMENT   'CODE'
          ASSUME    cs:CSEG, ds:DGROUP

DRIVES  proc      far
          push      bp
          mov       bp,sp
          push      ds
          push      es
          push      si
          push      di

          mov       si,offset numdrv              ; Line it all up
          mov       di,offset my_fcb
          mov       byte ptr[si],40h
agin1:    inc     byte ptr[si]                    ; Let's check a drive
          mov     byte ptr[si+1],3ah
          mov     ax,2906h                        ; Int 21 Func 29h Sub 06h
          int     21h
          mov     si,offset numdrv
          cmp     al,0ffh                         ; Valid or Not?
          je      nextry                          ; Nope...
          mov     cx,01h
          rep     movsb
          inc     mynum                           ; How many we got so far...
;          movsb
nextry:   mov     si,offset numdrv
          cmp     byte ptr[si],5ah                ; Are we at Z yet?
          jne     agin1                           ; Nope...
          mov     ax,240ah                        ; Some end of string stuff..
          stosw
          mov     ax,mynum
          push    ax
          push    es
          mov     dx,offset my_fcb                ; Holds valid drive string
          push    dx
          call    __retclen
          add     sp,6

          pop       di                            ; Clean Up for Clipper
          pop       si
          pop       es
          pop       ds
          pop       bp
          ret
          DRIVES  endp

          CSEG      ends
          end



