/* getpath.c                                */
/* compile with MSC 5.0 or above:            */

/* cl /c /AL /Zl /FPa /Gs /Ox /W3 getpath.c */

#include "nandef.h"                 /* Nantucket C define's        */
#include "extend.h"                 /* Clipper Extend declarations */

extern int CurrPath(char *);         /* Microsoft ASM routine       */
CLIPPER GetPath(void);

/*
    Function:       GetPath
    Parameters:     None
    Returns:        char * - the current path using the Clipper Summer 87 method
    Author:         Mike Taylor
    Date:           16 December 1988

    Description:    Returns to a Clipper caller the current path

    Called By:      Clipper Summer 87 code
*/

CLIPPER GetPath()
{
    char CurrentPath[65];
    int  i;

    /* get the current path from DOS */

    i = CurrPath(CurrentPath);

    if ( i == 0 )    /* no error returned from CurrPath */
    {
        for (i = 65; i > 0; i--)                    /* insert space at start */
            CurrentPath[i] = CurrentPath[i - 1];

        CurrentPath[0] = '\\';                      /* add leading \\        */
    }
    else
        CurrentPath[0] = '\0';

    _retc( CurrentPath );
}
