    TITLE   "Get Current Drive Letter"
    PAGE    60,132

.MODEL LARGE
.CODE

;
;   compile:    masm /mx driveltr;
;

;
;   Function:       DriveLtr()
;   Parameters:     None
;   Returns:        char - The current drive letter
;   Author:         Mike Taylor
;   Date:           16 December 1988
;
;   Description:    This function call DOS int 21h function 19h to find out the
;                     current drive letter.  Function 19h returns a drive code
;                     that has this pattern:  0 = A:, 1 = B:, etc.
;
;   Called By:      Microsoft C large memory model routine

            PUBLIC  _DriveLtr
_DriveLtr   PROC

    push    bp              ; save the caller's base pointer register
    mov     bp,sp           ; establish our stack frame by saving the current
                            ;   stack pointer

    xor     ax,ax           ; clear the ax register
    mov     ah,19h          ; set up the call to DOS's Get Current Disk function
    int     21h             ;   ah = function 19h of interrupt 21h
    mov     ah,0            ; clear out high byte of ax

    pop     bp              ; restore callers base pointer

    ret

_DriveLtr   ENDP

    END
