    TITLE   "Get Current Path"
    PAGE    60,132

.MODEL LARGE
.CODE

;
;   compile:    masm /mx currpath;
;

;
;   Function:       CurrPath()
;   Parameters:     char * - place to store the current path
;   Returns:        ax = error code or 0 if successful
;   Author:         Mike Taylor
;   Date:           16 December 1988
;
;   Description:    This function call DOS int 21h function 47h to find out the
;                     current path.
;
;   Called By:      Microsoft C large memory model routine

            PUBLIC  _CurrPath
_CurrPath   PROC

    push    bp              ; save the caller's base pointer register
    mov     bp,sp           ; establish our stack frame by saving the current
                            ;   stack pointer
    push    si              ; save caller's registers that we will use
    push    ds

    mov     si,[bp + 6]     ; set up buffer's offset
    mov     ax,[bp + 8]     ; set up buffer's segment
    push    ax
    pop     ds
    xor     ax,ax           ; clear the ax register
    mov     dl,0            ; dl = drive to get path for:  0 = current drive
    mov     ah,47h          ; set up the call to DOS's Get Current Path function
    int     21h             ;   ah = function 47h of interrupt 21h

    jc      _cp1            ; if error returned, exit routine with ax = error
    xor     ax,ax           ;   else clear ax to show no error

_cp1:
    pop     ds              ; restore caller's registers
    pop     si
    pop     bp              ; restore caller's base pointer

    ret

_CurrPath   ENDP

    END
