*--- Header --------------------------------------------------------------
*    Function  DOTS()
*    Date .... December 29, 1988
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... Returns character string with embedded trailer
*    Notice .. Copyright 1988, Data Management Systems. All Rights Reserved
*--------------------------------------------------------------------------
*
*--- Ops Notes ------------------------------------------------------------
* Syntax
*
*    DOTS(dot_line, dot_len, <dot_spaces>, <dot_skip>, <dot_char>)
*
* Parameters
*
*    dot_line       C    character string to add trailer to
*
*    dot_len        C    desired length of dot_line + trailer
*
*    dot_spaces     N    # of spaces between dots
*                         (optional, default = 0)
*
*    dot_skip       L    .T. = first character after dot_line = SPACE(0)
*                        .F. = first character after dot_line can be a
*                              dot if it fits
*                         (optional, default = .T.)
*
*    dot_char       C    character to use as a 'dot'
*                         (optional, default = ".")
*
* Private
*
*    t_line         C    trailer to add to dot_line
*    t_reps         N    # of dots & spaces needed for trailer (approx.)
*
*
* Miscellaneous
*
*    Dots are always right aligned.
*
*-------------------------------------------------------------------------
*
*--- Updates -------------------------------------------------------------
*
*-------------------------------------------------------------------------

FUNCTION DOTS

PARAMETERS dot_line, dot_len, dot_spaces, dot_skip, dot_char

PRIVATE t_line, t_reps

* Assign defaults to parameters if needed
IF TYPE("dot_spaces") = "U"
     dot_spaces = 0
ENDIF

IF TYPE("dot_skip") = "U"
     dot_skip = .T.
ENDIF

IF TYPE("dot_char") = "U"
     dot_char = "."
ENDIF


* Determine approx. # of dots/spaces needed in trailer
t_reps = ROUND((dot_len - LEN(dot_line)) / (dot_spaces + 1),0) + 1

* Build trailer line
t_line = REPLICATE(SPACE(dot_spaces) + dot_char, t_reps)
t_line = LTRIM(t_line)
t_line = SUBSTR(t_line,(LEN(t_line) - (dot_len - LEN(dot_line)) + 1))

* Take out leading dot if desired
IF dot_skip .AND. SUBSTR(t_line,1,1) = dot_char
     t_line = SPACE(1) + SUBSTR(t_line,2)
ENDIF

RETURN(dot_line + t_line)

*-------------------------------------------------------------------------
*    EOF  DOTS()
*-------------------------------------------------------------------------
