;--- Header ---------------------------------------------------------------
;    Procedure SCRNPRT.ASM
;    Date .... January 27, 1987
;    Author .. Bob Laszko, Data Management Systems
;    Desc .... Write characters to screen w/out disturbing color attributes
;    Note .... Works with color or mono systems
;    Notice .. Copyright 1987, Data Management Systems. All Rights Reserved
;--------------------------------------------------------------------------
;
;--- Ops Notes ------------------------------------------------------------
;
;    Syntax
;         SCRNPRT(row, col, string)
;
;         row      - row on screen to start
;         col      - column on screen to start
;         string   - string to write
;
;--- Updates --------------------------------------------------------------
;    06-13-88  Modified for Clipper S'87
;    10/19/90  Ensured compatiblity with Clipper v.5.0
;--------------------------------------------------------------------------

PUBLIC SCRNPRT

EXTRN          __PARC:FAR               ; clipper function to get character
EXTRN          __PARNI:FAR              ; clipper function to get integer
EXTRN          __PARCLEN:FAR            ; clipper function to get string length
EXTRN          __RET:FAR                ; clipper function to "clean up"

_PROG          SEGMENT   BYTE 'CODE'
ASSUME         CS:_PROG,DS:_PROG

SCRNPRT        PROC      FAR            ; standard clipper requirements
               PUSH      BP             ;  to save stack and registers
               MOV       BP,SP          ;  .
               PUSH      DS             ;  .
               PUSH      ES             ;  .
               PUSH      CX             ;  .
               PUSH      DX             ;  .
               PUSH      SI             ;  .
               PUSH      DI             ;  .

               MOV       AX,2           ; setup to get second variable
               PUSH      AX             ;  passed from clipper (column)
               CALL      __PARNI        ; call clipper function, AX = column
               ADD       SP,2           ; restore stack pointer
               MOV       CX,02d         ; start of video memory computation
               MUL       CX             ;  (column * 2) + (160 * row)
               MOV       DI,AX          ; put column * 2 into DI

               MOV       AX,1           ; setup to get first variable
               PUSH      AX             ;  passed from clipper (row)
               CALL      __PARNI        ; call clipper function, AX = row
               ADD       SP,2           ; restore stack
               MOV       CX,160d        ; finish video memory computation
               MUL       CX             ;  .
               ADD       DI,AX          ; DI = location of video memory
                                        ;  for MOVSB (moving to)
               SUB       DX,DX          ; clear DX
               SUB       CX,CX          ; clear CX

               MOV       AX,3           ; setup to get third variable
               PUSH      AX             ;  passed from clipper (len of string)
               CALL      __PARCLEN      ; call clipper function, AX = len
               ADD       SP,2           ; restore stack
               MOV       DX,AX          ; DX = length of string to print
               MOV       CX,DX          ; CX = length of string to print

               PUSH      CX             ; save CX, gets clobbered w/next routine

               MOV       AX,3           ; setup to get third variable
               PUSH      AX             ;  passed from clipper (string to print)
               CALL      __PARC         ; call clipper function, DX = segment
               ADD       SP,2           ;  AX = offset of string to print in memory
               MOV       DS,DX          ; DS = segment of string in memory
               MOV       SI,AX          ; SI = offset of string in memory

               POP       CX             ; ok to restore CX now

               PUSH      BX             ; save BX, gets clobbered w/next routine

               MOV       AH,15          ; video check routine, taken from
               INT       10h            ; ISCOLOR(), Clipper's  EXTENDA.ASM
               XOR       BX,BX          ;  .
               CMP       AL,07          ; equals 07 = mono
               JE        MONO           ;  .
               MOV       AX,0B800h      ; AX set to start of color video
               JMP       SETVIDSEG

MONO:          MOV       AX,0B000h      ; AX set to start of mono video

SETVIDSEG:     MOV       ES,AX          ; ES = start of video

               POP       BX             ; restore BX from above

               CLD                      ; clear direction flag for MOVSB

MOVESTR:       MOVSB                    ; move first char from SI to DI
               INC       DI             ; increment DI to skip attribute byte
               LOOP      MOVESTR        ; loop until CX = 0

               POP       DI             ; restore stack & registers before
               POP       SI             ;  returning to clipper
               POP       DX             ;  .
               POP       CX             ;  .
               POP       ES             ;  .
               POP       DS             ;  .
               POP       BP             ;  .
               CALL      __RET          ; clipper function to "clean up"
               RET                      ; return to clipper
SCRNPRT        ENDP                     ;

_PROG          ENDS                     ;
               END                      ;