;--- Header ---------------------------------------------------------------
;    Procedure SCRNATTR.ASM
;    Date .... January 27, 1987
;    Author .. Bob Laszko, Data Management Systems
;    Desc .... Change screen color attributes w/out disturbing characters
;    Note .... Works with color or mono systems
;    Notice .. Copyright 1987, Data Management Systems. All Rights Reserved
;--------------------------------------------------------------------------
;
;--- Ops Notes ------------------------------------------------------------
;
;    Syntax
;         SCRNATTR(row, col, length, new_attr)
;
;         row      - row on screen to start
;         col      - column on screen to start
;         length   - length of color change
;         new_attr - new color, expressed as a number from 0 - 255
;
;--- Updates --------------------------------------------------------------
;    06-13-88  Modified for Clipper S'87
;    10/19/90  Ensured compatiblity with Clipper v.5.0
;--------------------------------------------------------------------------

PUBLIC SCRNATTR

EXTRN          __PARNI:FAR              ; clipper function to get integer
EXTRN          __RET:FAR                ; clipper function to "clean up"

_PROG          SEGMENT   BYTE 'CODE'
ASSUME         CS:_PROG, DS:_PROG

SCRNATTR       PROC      FAR            ; standard clipper requirements
               PUSH      BP             ;  to save stack & registers
               MOV       BP,SP          ;  .
               PUSH      DS             ;  .
               PUSH      ES             ;  .
               PUSH      CX             ;  .
               PUSH      DX             ;  .
               PUSH      SI             ;  .
               PUSH      DI             ;  .


               MOV       AX,2           ; setup to get second variable
               PUSH      AX             ;  passed from clipper (column)
               CALL      __PARNI        ; call clipper function, AX = column
               ADD       SP,2           ; restore stack pointer
               MOV       CX,02d         ; start of video memory computation
               MUL       CX             ;  (column * 2) + (160 * row)
               MOV       DI,AX          ; put (column * 2) into DI

               MOV       AX,1           ; setup to get first variable
               PUSH      AX             ;  passed to clipper (row)
               CALL      __PARNI        ; call clipper function, AX = row
               ADD       SP,2           ; restore stack
               MOV       CX,160d        ; finish video memory computation
               MUL       CX             ;  .
               ADD       DI,AX          ; DI = location of video memory (char displayed)
               CLD                      ; clear direction flags
               INC       DI             ; add 1 to DI to point to attribute byte


               MOV       AX,4           ; setup to get fourth variable
               PUSH      AX             ;  passed to clipper (attribute)
               CALL      __PARNI        ; call clipper function, AX = attribute
               ADD       SP,2           ; restore stack
               MOV       BX,AX          ; BX = attribute

               SUB       DX,DX          ; clear DX
               SUB       CX,CX          ; clear CX
               PUSH      BX             ; save BX, gets clobbered w/next routine

               MOV       AX,3           ; setup to get third variable
               PUSH      AX             ;  passed to clipper (len of change)
               CALL      __PARNI        ; call clipper function, AX = len of change
               ADD       SP,2           ; restore stack
               MOV       CX,AX          ; CX = len of change

               MOV       AH,15          ; video check routine, taken from
               INT       10h            ; ISCOLOR(), Clipper's  EXTENDA.ASM
               XOR       BX,BX          ;  .
               CMP       AL,07          ; equals 07 = mono
               JE        MONO           ;  .
               MOV       AX,0B800h      ; AX set to start of color video
               JMP       SETVIDSEG

MONO:          MOV       AX,0B000h      ; AX set to start of mono video

SETVIDSEG:     MOV       ES,AX          ; ES = start of video

               POP       BX             ; restore BX from above

MOVEATTR:      MOV       ES:[DI],BL     ; move attrib (BL) to mono video pointed to by ES[DI]
               ADD       DI,02d         ; increment DI by two to skip character byte
               DEC       CX             ; decrement CX towards 0
               JNZ       MOVEATTR       ;  loop until CX = 0

               POP       DI             ; restore stack & registers before
               POP       SI             ;  returning to clipper
               POP       DX             ;  .
               POP       CX             ;  .
               POP       ES             ;  .
               POP       DS             ;  .
               POP       BP             ;  .
               CALL      __RET          ; clipper function to "clean up"
               RET                      ; return to clipper
SCRNATTR       ENDP                     ;

_PROG          ENDS                     ;
               END                      ;