*-- Header ---------------------------------------------------------------
*    Program . DEMOJUL.PRG
*    Date .... June 16, 1989
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... Demonstration routine for CAL2JUL() / JUL2CAL()
*    Notes ...
*    Notice .. Copyright 1989, Data Management Systems. All Rights Reserved
*-------------------------------------------------------------------------
*
*-- Ops Notes ------------------------------------------------------------
*
*    To compile this demo
*
*         CLIPPER DEMOJUL
*
*    To link
*
*         TLINK DEMOJUL,,,CLIPPER EXTEND          (TLINK)
*
*         PLINK86 FI DEMOJUL LIB CLIPPER, EXTEND  (PLINK86)
*
*    EXTEND.LIB is only required for DEMOJUL.PRG - neither CAL2JUL() or
*    JUL2CAL() requires EXTEND.LIB themselves.
*
*-------------------------------------------------------------------------
*
*-- Updates --------------------------------------------------------------
*
*-------------------------------------------------------------------------

CLEAR

SET PROCEDURE TO DMSJUL            && Contains CAL2JUL() / JUL2CAL()

SET CENTURY ON                     && allows input / display of entire year data
                                   &&  this line can be deleted if only twentieth
                                   &&  century dates are to be used

* Initialize memvars
t_cal_date = CTOD(SPACE(8))        && calendar date for demo
t_jul_date = 0                     && julian date for demo
conv_type = SPACE(1)               && type of conversion
scroll_row = 0                     && row to display conversion results

* Assign memvars
scroll_row = 10                    && start conversion display on row 10


* Setup screen
@ 01,00 SAY "Calendar / Julian Date Routines"
@ 09,14 TO 24,65                   && draw single line box for conversion display

* Demo main loop
DO WHILE .T.

     * Re-initialize memvars w/each loop
     t_cal_date = CTOD(SPACE(8))
     t_jul_date = 0
     conv_type = SPACE(1)

     * Get type of conversion
     @ 03,05 SAY 'Calendar to julian or Julian to calendar     (J/C/ESC)'
     @ 03,47 GET conv_type PICTURE "!" VALID(conv_type $'JC')
     READ

     IF LASTKEY() = 27
          EXIT
     ENDIF

     * Get data to convert
     @ 03,05 SAY SPACE(54)
     IF conv_type = 'C'            && convert calendar to julian

          @ 03,05 SAY 'Calendar date              (01/01/0100 - 12/31/2999)'
          @ 03,20 GET t_cal_date VALID(t_cal_date >= CTOD('01/01/0100') .AND. t_cal_date <= CTOD('12/31/2999'))
          READ

          * Do conversion, display results
          IF scroll_row = 24            && max lower row for results display + 1
               SCROLL(10,16,23,63,1)    && scroll one line up
               scroll_row = scroll_row - 1
          ENDIF

          @ scroll_row,16 SAY 'Calendar date'
          @ scroll_row,31 SAY t_cal_date
          @ scroll_row,42 SAY '='
          @ scroll_row,44 SAY CAL2JUL(t_cal_date) PICTURE "99,999,999"
          @ scroll_row,56 SAY 'Julian'

          scroll_row = scroll_row + 1

          @ 03,05 SAY SPACE(52)

     ELSE                          && convert julian to calendar

          @ 03,05 SAY 'Julian date           (36,160 - 1,095,384)'
          @ 03,18 GET t_jul_date PICTURE "9999999" VALID(t_jul_date >= 36160 .AND. t_jul_date <= 1095384)
          READ

          * Do conversion, display results
          IF scroll_row = 24            && max lower row for results display + 1
               SCROLL(10,16,23,63,1)    && scroll one line up
               scroll_row = scroll_row - 1
          ENDIF

          @ scroll_row,16 SAY 'Julian date'
          @ scroll_row,31 SAY t_jul_date PICTURE "99,999,999"
          @ scroll_row,42 SAY '='
          @ scroll_row,44 SAY JUL2CAL(t_jul_date)
          @ scroll_row,56 SAY 'Calendar'

          scroll_row = scroll_row + 1

          @ 03,05 SAY SPACE(42)

     ENDIF

ENDDO

SET CENTURY OFF
CLEAR
QUIT

*------------------------------------------------------------------------------
*    EOP  DEMOJUL.PRG
*------------------------------------------------------------------------------