*--- Header ---------------------------------------------------------------
*    Procedure OOPSDEMO.PRG
*    Date .... August 18, 1988
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... Demonstration code for DMSOOPS.PRG
*    Notice .. Copyright 1988, Data Management Systems. All Rights Reserved
*--------------------------------------------------------------------------
*
*--- Updates --------------------------------------------------------------
*    09/09/88  Modified to work with updated DMSOOPS.PRG of 09/09/88
*--------------------------------------------------------------------------

* Setup colors
C_FRAME = IF(ISCOLOR(),"BG/ ","W/ ")      && cyan on black or white on black
C_HEADER = IF(ISCOLOR(),"R/ ","W+/ ")     && red on black or hi white on black
C_DEFAULT = IF(ISCOLOR(),"R+/ ,W+/BG,,,B/BG","W/ ")    && standard = hi red on black or white on black
                                                       && enhanced = hi white on cyan or white on black
                                                       && unselected = blue on cyan or white on black
CLEAR

SET COLOR TO (C_FRAME)
@ 01,00 SAY "ͻ"
@ 02,00 SAY "                                                                              "
@ 03,00 SAY "͹"
@ 04,00 SAY "                                                                              "
@ 05,00 SAY "                                                                              "
@ 06,00 SAY "                                                                              "
@ 07,00 SAY "                                                                              "
@ 08,00 SAY "                                                                              "
@ 09,00 SAY "                                                                              "
@ 10,00 SAY "                                                                              "
@ 11,00 SAY "                                                                              "
@ 12,00 SAY "                                                                              "
@ 13,00 SAY "                                                                              "
@ 14,00 SAY "                                                                              "
@ 15,00 SAY "                                                                              "
@ 16,00 SAY "                                                                              "
@ 17,00 SAY "                                                                              "
@ 18,00 SAY "                                                                              "
@ 19,00 SAY "                                                                              "
@ 20,00 SAY "                                                                              "
@ 21,00 SAY "                                                                              "
@ 22,00 SAY "͹"
@ 23,00 SAY "                                                                              "
@ 24,00 SAY "ͼ"

SET COLOR TO (C_HEADER)
@ 02,02 SAY "OOPSDEMO.PRG - Copyright 1988 Data Managment Systems"
SET COLOR TO (C_DEFAULT)



* OOPS.PRG example #1
*
DECLARE OOPS_MSG[2]
OOPS_MSG[1] = "Printer is not ready. Make sure"
OOPS_MSG[2] = "it is on-line and has paper"

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "R"
OOPS_RESP[2] = "A"

OOPS_ACTION = SPACE(1)

DO DMSOOPS WITH "Printer Not Ready", 1,"R = Retry   A = Abort", "UL", .T., .T., .T., .T.,"", "R"

RELEASE OOPS_MSG, OOPS_RESP

* - or -

DECLARE OOPS_MSG[2]
OOPS_MSG[1] = "Printer is not ready. Make sure"
OOPS_MSG[2] = "it is on-line and has paper"

DECLARE OOPS_RESP[2]

OOPS_RESP[1] = "R"
OOPS_RESP[2] = "A"

OOPS_ACTION = SPACE(1)

title = "Printer Not Ready"
frame = 1
instruction = "R = Retry   A = Abort"
location = "UR"
rest_scrn = .T.
explode = .T.
implode = .T.
shad_show = .T.
shad_char = ""
shad_side = "R"

DO DMSOOPS

RELEASE OOPS_MSG, OOPS_RESP, title, frame, instruction
RELEASE location, rest_scrn, explode, implode, shad_show
RELEASE shad_char, shad_side

* - either results in:

*                  [ Printer Not Ready ]Ŀ
*                                                   
*                   Printer is not ready. Make sure 
*                   it is on-line and has paper     
*                                                   
*                  [ R = Retry   A = Abort ]ٱ
*                   


* OOPS.PRG example #2
*
DECLARE OOPS_MSG[2]
OOPS_MSG[1] = "Customer John Smith"
OOPS_MSG[2] = "does not exist."

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "Y"
OOPS_RESP[2] = "N"

OOPS_ACTION = SPACE(1)

instruction = "Add ?  Y = Yes   N = No"
location = "LL"
shad_show = .F.

DO DMSOOPS

RELEASE OOPS_MSG, OOPS_RESP, instruction, location, shad_show

* - results in:
*
*                  [ OOPS ]Ŀ
*                                               
*                       Customer John Smith     
*                       does not exist          
*                                               
*                  [ Add ?  Y = Yes   N = No ]


* OOPS.PRG example #3
*
DECLARE OOPS_MSG[2]
OOPS_MSG[1] = "This customer has sales"
OOPS_MSG[2] = "Cannot delete at this time"

DO DMSOOPS

RELEASE OOPS_MSG

* - results in:
*
*                  [ OOPS ]Ŀ
*                                               
*                   This customer has sales     
*                   Cannot delete at this time  
*                                               
*                  [ Press Any Key to Continue ]ٱ
*                   


SET COLOR TO (C_FRAME)
CLEAR

@ 01,01 SAY "Please send any comments, suggestions, or gripes to:"
@ 03,01 SAY "Bob Laszko                    BBS - The File Bank"
@ 04,01 SAY "Data Management Systems             Clipper Support Conference"
@ 05,01 SAY "PO Box 3104                         Fallbrook, Ca"
@ 06,01 SAY "Fallbrook, Ca  92028                (619) 728-4318"
@ 07,01 SAY "(619) 728-0984"
@ 09,01

QUIT

*--------------------------------------------------------------------------
*    EOP  OOPSDEMO.PRG
*--------------------------------------------------------------------------