*--- Header ---------------------------------------------------------------
*    Program . DMSERROR.PRG
*    Version . 1.00
*    Date .... September 15, 1988
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... Runtime error system to replace Nantucket's ERRORSYS.PRG
*    Notice .. Copyright 1988, Data Management Systems. All Rights Reserved
*--------------------------------------------------------------------------
*
*--- Ops Notes ------------------------------------------------------------
*
*    Functions included:
*         EXPR_ERROR()   expression error
*         UNDEF_ERROR()  undefined error
*         MISC_ERROR()   miscellaneous error
*         OPEN_ERROR()   open errors
*         DB_ERROR()     database error
*         PRINT_ERROR()  printer error
*         ETOC()         returns a character expression for any type of input 
*                         (numeric, date, character, or logical) expression
*
*    The following external routines are also required:
*         DMSOOPS.PRG    standard "dialog" box error reporting routine,
*                         also written by Data Management Systems
*         EXXTEND.OBJ    C routines that return the status of some SET
*                         commands. Written by J. Scott Emerich.
*         PRT_SCRN.OBJ   CALLable print screen routine by Ray Love
*
*    Parameters passed by Clipper to error functions:
*         NAME      C    Procedure name in which error occured
*         LINE      N    Line number (in NAME) at which error occured
*         INFO      C    Type of error encountered
*         MODEL     C    Fragment of source code that caused error
*         _1        Any  Value supplied to the failed operation
*         _2        Any  Value supplied to the failed operation
*         _3        Any  Value supplied to the failed operation
*
*
*    Private memvars used by DMSERROR, requiring functions in EXXTEND.OBJ
*         CURR_CON  L    GETCONSOLE()
*                        .T. = CONSOLE is SET ON
*                        .F. = CONSOLE is SET OFF
*         CURR_DEV  L    GETDEVICE_()
*                        .T. = DEVICE = PRINT
*                        .F. = DEVICE = SCREEN
*         CURR_PRN  L    GETPRINT()
*                        .T. = PRINT is SET ON
*                        .F. = PRINT is SET OFF
*
*    Memvars used by DMSOOPS, set in DMSERROR
*         TITLE          C    Title to display on top line of box
*         INSTRUCTION    C    Instructions to display on bottom line of box
*         OOPS_MSG[]     C    Message lines to display in box
*         OOPS_RESP[]    C    Valid responses to instruction line prompts
*         OOPS_ACTION    C    Validated response returned from DMSOOPS
*         OOPS_SCRN      C    Screen saved before DMSOOPS is called
*         REST_SCRN      L    Flag to have DMSOOPS restore screen before returning
*--------------------------------------------------------------------------
*
*--- Updates --------------------------------------------------------------
*
*--------------------------------------------------------------------------

*--------------------------------------------------------------------------
*    EXPR_ERROR(NAME, LINE, INFO, MODEL, _1, _2, _3)
*--------------------------------------------------------------------------

FUNCTION EXPR_ERROR

PRIVATE NAME, LINE, INFO, MODEL, _1, _2, _3
PARAMETERS NAME, LINE, INFO, MODEL, _1, _2, _3    && Passed by Clipper

* Divide by zero error
IF M->INFO = "zero divide"
     IF "%" $ M->model        && error from modulus operation (%)
          RETURN M->_1        && return the dividend
     ELSE
          RETURN 0            && return 0
     ENDIF
ENDIF

* Make sure output is to screen
SET DEVICE TO SCREEN
SET PRINT OFF
SET CONSOLE ON

* Setup DMSOOPS parameters & memvars
TITLE = "Runtime Error - Expression"
REST_SCRN = .F.
INSTRUCTION = "Print Screen For Programmer  (Y/N)"
OOPS_SCRN = SPACE(1)
OOPS_ACTION = SPACE(1)

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "Y"
OOPS_RESP[2] = "N"

DECLARE OOPS_MSG[14]
OOPS_MSG[1] = "An error has occured while running this program."
OOPS_MSG[2] = "Following is information that the programmer will"
OOPS_MSG[3] = "require to correct this problem:"
OOPS_MSG[4] = " "
OOPS_MSG[5] = "     Procedure  = " + name
OOPS_MSG[6] = "     Line #     = " + LTRIM(STR(line))
OOPS_MSG[7] = "     Error Type = " + info
OOPS_MSG[8] = "     Expression = " + model
OOPS_MSG[9] = "         _1 (" + TYPE("_1") + ") = " + IF(TYPE("_1") <> "U", ETOC(_1), SPACE(1))
OOPS_MSG[10] = "         _2 (" + TYPE("_2") + ") = " + IF(TYPE("_2") <> "U", ETOC(_2), SPACE(1))
OOPS_MSG[11] = "         _3 (" + TYPE("_3") + ") = " + IF(TYPE("_3") <> "U", ETOC(_3), SPACE(1))
OOPS_MSG[12] = " "
OOPS_MSG[13] = "This program cannot continue, though a printout of"
OOPS_MSG[14] = "this screen should be saved for the programmer."

DO DMSOOPS

RELEASE TITLE, REST_SCRN, INSTRUCTION, OOPS_MSG, OOPS_RESP

* Print screen if desired
IF OOPS_ACTION = "Y"
     CALL PRT_SCRN                         && print DMSOOPS screen
     RESTORE SCREEN FROM OOPS_SCRN
     CALL PRT_SCRN                         && print screen of app @ point of error
     EJECT
ENDIF

RELEASE OOPS_SCRN, OOPS_ACTION

QUIT

RETURN(.T.)

* EOF EXPR_ERROR()




*--------------------------------------------------------------------------
*    UNDEF_ERROR(NAME, LINE, INFO, MODEL, _1)
*--------------------------------------------------------------------------

FUNCTION UNDEF_ERROR

PRIVATE NAME, LINE, INFO, MODEL, _1
PARAMETERS NAME, LINE, INFO, MODEL, _1       && Passed by Clipper

* Make sure output is to screen
SET DEVICE TO SCREEN
SET PRINT OFF
SET CONSOLE ON

* Setup DMSOOPS parameters & memvars
TITLE = "Runtime Error - Undefined"
REST_SCRN = .F.
INSTRUCTION = "Print Screen For Programmer  (Y/N)"
OOPS_SCRN = SPACE(1)
OOPS_ACTION = SPACE(1)

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "Y"
OOPS_RESP[2] = "N"

DECLARE OOPS_MSG[12]
OOPS_MSG[1] = "An error has occured while running this program."
OOPS_MSG[2] = "Following is information that the programmer will"
OOPS_MSG[3] = "require to correct this problem:"
OOPS_MSG[4] = " "
OOPS_MSG[5] = "     Procedure  = " + name
OOPS_MSG[6] = "     Line #     = " + LTRIM(STR(line))
OOPS_MSG[7] = "     Error Type = " + info
OOPS_MSG[8] = "     Expression = " + model
OOPS_MSG[9] = "         _1 (" + TYPE("_1") + ") = " + IF(TYPE("_1") <> "U", ETOC(_1), SPACE(1))
OOPS_MSG[10] = " "
OOPS_MSG[11] = "This program cannot continue, though a printout of"
OOPS_MSG[12] = "this screen should be saved for the programmer."

DO DMSOOPS

RELEASE TITLE, REST_SCRN, INSTRUCTION, OOPS_MSG, OOPS_RESP

* Print screen if desired
IF OOPS_ACTION = "Y"
     CALL PRT_SCRN                         && print DMSOOPS screen
     RESTORE SCREEN FROM OOPS_SCRN
     CALL PRT_SCRN                         && print screen of app @ point of error
     EJECT
ENDIF

RELEASE OOPS_SCRN, OOPS_ACTION

QUIT

RETURN(.T.)

* EOF UNDEF_ERROR()




*--------------------------------------------------------------------------
*    MISC_ERROR(NAME, LINE, INFO, MODEL)
*--------------------------------------------------------------------------

FUNCTION MISC_ERROR

PRIVATE NAME, LINE, INFO, MODEL
PARAMETERS NAME, LINE, INFO, MODEL      && Passed by Clipper

* Make sure output is to screen
SET DEVICE TO SCREEN
SET PRINT OFF
SET CONSOLE ON

IF INFO = "type mismatch"
     INFO = INFO + " in field REPLACE"
ENDIF

* Setup DMSOOPS parameters & memvars
TITLE = "Runtime Error - Miscellaneous"
REST_SCRN = .F.
INSTRUCTION = "Print Screen For Programmer  (Y/N)"
OOPS_SCRN = SPACE(1)
OOPS_ACTION = SPACE(1)

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "Y"
OOPS_RESP[2] = "N"

DECLARE OOPS_MSG[10]
OOPS_MSG[1] = "An error has occured while running this program."
OOPS_MSG[2] = "Following is information that the programmer will"
OOPS_MSG[3] = "require to correct this problem:"
OOPS_MSG[4] = " "
OOPS_MSG[5] = "     Procedure  = " + name
OOPS_MSG[6] = "     Line #     = " + LTRIM(STR(line))
OOPS_MSG[7] = "     Error Type = " + info
OOPS_MSG[8] = " "
OOPS_MSG[9] = "This program cannot continue, though a printout of"
OOPS_MSG[10] = "this screen should be saved for the programmer."

DO DMSOOPS

RELEASE TITLE, REST_SCRN, INSTRUCTION, OOPS_MSG, OOPS_RESP

* Print screen if desired
IF OOPS_ACTION = "Y"
     CALL PRT_SCRN                         && print DMSOOPS screen
     RESTORE SCREEN FROM OOPS_SCRN
     CALL PRT_SCRN                         && print screen of app @ point of error
     EJECT
ENDIF

RELEASE OOPS_SCRN, OOPS_ACTION

QUIT

RETURN(.T.)

* EOF MISC_ERROR()




*--------------------------------------------------------------------------
*    OPEN_ERROR(NAME, LINE, INFO, MODEL, _1)
*--------------------------------------------------------------------------

FUNCTION OPEN_ERROR

PRIVATE NAME, LINE, INFO, MODEL, _1 
PARAMETERS NAME, LINE, INFO, MODEL, _1            && Passed by Clipper
PRIVATE CURR_DEV, CURR_PRN, CURR_CON     && private to this function

* Allow local handling of network error
IF NETERR() .AND. MODEL == "USE"
     RETURN(.F.)
END

* Open errors could be recovered, save current output devices
CURR_DEV = GETDEVICE_()
CURR_PRN = GETPRINT()
CURR_CON = GETCONSOLE()

* Make sure output is to screen
SET DEVICE TO SCREEN
SET PRINT OFF
SET CONSOLE ON

* Run DMSOOPS first time, try to recover

* Setup DMSOOPS parameters & memvars
TITLE = "Runtime Error"
INSTRUCTION = "R = Retry   P = Print Screen and Quit   Q = Quit"
OOPS_ACTION = SPACE(1)

DECLARE OOPS_RESP[3]
OOPS_RESP[1] = "R"
OOPS_RESP[2] = "P"
OOPS_RESP[3] = "Q"

DECLARE OOPS_MSG[14]
OOPS_MSG[1] = "An Open Error has occured. Some causes of this are:"
OOPS_MSG[2] = ""
OOPS_MSG[3] = "     A disk drive door is open"
OOPS_MSG[4] = "     A diskette is not in place"
OOPS_MSG[5] = "     A serial printer is not responding"
OOPS_MSG[6] = ""
OOPS_MSG[7] = "If it helps, the computer is trying to:"
OOPS_MSG[8] = ""
OOPS_MSG[9] = "    " + model + " " + IF(TYPE("_1") <> "U", ETOC(_1), SPACE(1))
OOPS_MSG[10] = ""
OOPS_MSG[11] = "If the problem can be corrected, please do so and"
OOPS_MSG[12] = "press R (Retry). Otherwise this program cannot"
OOPS_MSG[13] = "continue, though a printout of this screen should be"
OOPS_MSG[14] = "saved for the programmer."

DO DMSOOPS

RELEASE TITLE, INSTRUCTION, OOPS_MSG, OOPS_RESP

DO CASE
     CASE OOPS_ACTION = "R"             && retry (recover)

          * Reset output devices first
          IF CURR_DEV
               SET DEVICE TO PRINT
          ENDIF
          IF CURR_PRN
               SET PRINT ON
          ENDIF
          IF .NOT. CURR_CON
               SET CONSOLE OFF
          ENDIF

          RETURN(.T.)                   && .T. = retry operation that triggered error

     CASE OOPS_ACTION = "Q"             && quit
          QUIT

ENDCASE

* Show actual error message, print screens - OOPS_ACTION = "P"

* Setup DMSOOPS parameters & memvars
TITLE = "Runtime Error - Open"
REST_SCRN = .F.
INSTRUCTION = "Runtime Error - Open"
OOPS_SCRN = SPACE(1)
OOPS_ACTION = SPACE(1)

DECLARE OOPS_MSG[12]
OOPS_MSG[1] = "An error has occured while running this program."
OOPS_MSG[2] = "Following is information that the programmer will"
OOPS_MSG[3] = "require to correct this problem:"
OOPS_MSG[4] = " "
OOPS_MSG[5] = "     Procedure  = " + name
OOPS_MSG[6] = "     Line #     = " + LTRIM(STR(line))
OOPS_MSG[7] = "     Error Type = " + info
OOPS_MSG[8] = "     Expression = " + model
OOPS_MSG[9] = "         _1 (" + TYPE("_1") + ") = " + IF(TYPE("_1") <> "U", ETOC(_1), SPACE(1))
OOPS_MSG[10] = " "
OOPS_MSG[11] = "This program cannot continue, though a printout of"
OOPS_MSG[12] = "this screen should be saved for the programmer."

KEYBOARD CHR(13)         && simulate key press in OOPS
DO DMSOOPS

RELEASE TITLE, REST_SCRN, INSTRUCTION, OOPS_MSG, OOPS_RESP

CALL PRT_SCRN                              && print DMSOOPS screen
RESTORE SCREEN FROM OOPS_SCRN
CALL PRT_SCRN                              && print screen of app @ point of error
EJECT

RELEASE OOPS_SCRN, OOPS_ACTION

QUIT

RETURN(.T.)

* EOF OPEN_ERROR()




*--------------------------------------------------------------------------
*    DB_ERROR(NAME, LINE, INFO)
*--------------------------------------------------------------------------

FUNCTION DB_ERROR

PRIVATE NAME, LINE, INFO
PARAMETERS NAME, LINE, INFO        && Passed by Clipper

* Make sure output is to screen
SET DEVICE TO SCREEN
SET PRINT OFF
SET CONSOLE ON

* Setup DMSOOPS parameters & memvars
TITLE = "Runtime Error - Database"
REST_SCRN = .F.
INSTRUCTION = "Print Screen For Programmer  (Y/N)"
OOPS_SCRN = SPACE(1)
OOPS_ACTION = SPACE(1)

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "Y"
OOPS_RESP[2] = "N"

DECLARE OOPS_MSG[10]
OOPS_MSG[1] = "An error has occured while running this program."
OOPS_MSG[2] = "Following is information that the programmer will"
OOPS_MSG[3] = "require to correct this problem:"
OOPS_MSG[4] = " "
OOPS_MSG[5] = "     Procedure  = " + name
OOPS_MSG[6] = "     Line #     = " + LTRIM(STR(line))
OOPS_MSG[7] = "     Error Type = " + info
OOPS_MSG[8] = " "
OOPS_MSG[9] = "This program cannot continue, though a printout of"
OOPS_MSG[10] = "this screen should be saved for the programmer."

DO DMSOOPS

RELEASE TITLE, REST_SCRN, INSTRUCTION, OOPS_MSG, OOPS_RESP

* Print screen if desired
IF OOPS_ACTION = "Y"
     CALL PRT_SCRN                         && print DMSOOPS screen
     RESTORE SCREEN FROM OOPS_SCRN
     CALL PRT_SCRN                         && print screen of app @ point of error
     EJECT
ENDIF

RELEASE OOPS_SCRN, OOPS_ACTION

QUIT

RETURN(.T.)

* EOF DB_ERROR()




*--------------------------------------------------------------------------
*    PRINT_ERROR(NAME, LINE)
*--------------------------------------------------------------------------

FUNCTION PRINT_ERROR

PRIVATE NAME, LINE 
PARAMETERS NAME, LINE                             && Passed by Clipper
PRIVATE CURR_DEV, CURR_PRN, CURR_CON     && private to this function

* Save current output devices
CURR_DEV = GETDEVICE_()
CURR_PRN = GETPRINT()
CURR_CON = GETCONSOLE()

* Make sure output is to screen
SET DEVICE TO SCREEN
SET PRINT OFF
SET CONSOLE ON

* Setup DMSOOPS parameters & memvars
TITLE = "Printer Error"
INSTRUCTION = "Retry Printout (Y/N)"
OOPS_ACTION = SPACE(1)

DECLARE OOPS_RESP[2]
OOPS_RESP[1] = "Y"
OOPS_RESP[2] = "N"

DECLARE OOPS_MSG[11]
OOPS_MSG[1] = "The printer does not respond. Any of the following"
OOPS_MSG[2] = "may be causing this problem:"
OOPS_MSG[3] = " "
OOPS_MSG[4] = "     The power is off"
OOPS_MSG[5] = "     It is out of paper"
OOPS_MSG[6] = "     The Online or Select light is not on"
OOPS_MSG[7] = "     The cable is disconnected at the printer"
OOPS_MSG[8] = "      or the computer"
OOPS_MSG[9] = " "
OOPS_MSG[10] = "If you can correct the problem, do so. Otherwise"
OOPS_MSG[11] = "the printout will be aborted."

DO DMSOOPS

RELEASE TITLE, INSTRUCTION, OOPS_MSG, OOPS_RESP

IF OOPS_ACTION = "Y"          && retry

     * Restore output devices first
     IF CURR_DEV
          SET DEVICE TO PRINT
     ENDIF
     IF CURR_PRN
          SET PRINT ON
     ENDIF
     IF .NOT. CURR_CON
          SET CONSOLE OFF
     ENDIF

     RETURN(.T.)         && .T. = retry failed print operation
ELSE

     BREAK               && aborts printout if printing operation is bracketed
                         &&  by BEGIN SEQUENCE...END SEQUENCE. Could replace
                         &&  this line with RETURN(.F.) to skip failed print
                         &&  operation and continue rest of program.
ENDIF

RETURN(.F.)

* EOF PRINT_ERROR()




*--------------------------------------------------------------------------
*    ETOC(EXPRESSION)       && any Expression TO Character conversion
*--------------------------------------------------------------------------

FUNCTION ETOC

PRIVATE EXPRESSION, EXPC
PARAMETERS EXPRESSION
PRIVATE EXPC                  && private to this function

DO CASE
     CASE TYPE("EXPRESSION") = "C"           && character
          EXPC = EXPRESSION

     CASE TYPE("EXPRESSION") = "D"           && date
          EXPC = DTOC(EXPRESSION)

     CASE TYPE("EXPRESSION") = "L"           && logical
          IF EXPRESSION
               EXPC = ".T."
          ELSE
               EXPC = ".F."
          ENDIF

     CASE TYPE("EXPRESSION") = "N"           && numeric
          EXPC = LTRIM(STR(EXPRESSION))      && decimal places not important

     CASE TYPE("EXPRESSION") = "M"           && memo field
          EXPC = "<Memo field>"

     CASE TYPE("EXPRESSION") = "A"           && array
          EXPC = "<array>"

     CASE TYPE("EXPRESSION") = "U"           && undefined
          EXPC = "<undefined>"

     CASE TYPE("EXPRESSION") = "UE"          && syntax error
          EXPC = "<syntax error>"

     CASE TYPE("EXPRESSION") = "UI"          && indeterminate error
          EXPC = "<indeterminate error>"
ENDCASE

RETURN(EXPC)

* EOF ETOC()


*--------------------------------------------------------------------------
*    EOF  DMSERROR.PRG
*--------------------------------------------------------------------------