*********************************************
* FUNCTIONS FOR BOXES FOR Clipper SUMMER '87
* and Compatible with Clipper 5.0
* >> dltbox() <<
**
** Contains the following boxes:
*
* ebox(), mbox(), pbox(), dbox(), lbox(), rbox()
***
*
* ALL box funtions return the string for restoring the screen
* with RESTSCREEN().
*
* ALL boxes have exactly the same syntax.
*
* If there are more than 8 parameters, you must specify a top title and color 
* as well as a bottom title and color.
*
* If you find these functions useful, please let me know.
* A contribution of $5.00 would'nt hurt either.  ENJOY!!
*
*
* by: DAVID TESSITORE
*     15 Teed Street
*     Huntington Station, NY  11746
*********************************************
*> Parameters for all boxes:
*>							Expression types:
*> 1-4: top,left,bottom right of box 				- [Nexp]
*>   5: color of box 									- [Cexp]
*>   6: design of box	(e,m,p,d,l,r)				- [expC]
*>   7: speed of effect 								- [Nexp]
*>   8: type of box ( 1 - 10) 						- [Nexp]
*>   9: shadow? .T. or .F. 							- [Lexp]
*>  10: RETURN savescreen coordinates? .T. or .F. 	- [Lexp]
*>  11: Top row title name 							- [Cexp]
*>  12: Color of top row title		 				- [Cexp]
*>  13: Bottom row title name 						- [Cexp]
*>  14: Color of bottom row title 					- [Cexp]
*>
*>  That's it!!
***********************************************
**
**** Example: 
**** ee = dltbox(5,0,20,79,"e","GR+/R",30,1,.T.,.T.,"Dave's Menu","R/W","Press <ENTER> to continue.","R/W")
**** rest_scr(ee)
***************
FUNCTION dltbox
***************
PARAMETERS top,left,bottom,right,design,color,speed,boxtype,shadow,bsavescr,btitle,bcolor,bbtitle,bbcolor
PRIVATE t,b,l,r,s,oldcolor,retscr,boxframe,seed1,seed2

retscr=""
IF bsavescr
   retscr=boxscr(top,left,bottom,right)
ENDIF
oldcolor=SETCOLOR()
boxframe=getbox(boxtype)
design = UPPER(design)
DO CASE
	CASE design == "E"
			e_box(top,left,bottom,right,color,speed,boxframe)
	CASE design == "M"
			m_box(top,left,bottom,right,color,speed,boxframe)
	CASE design == "P"
			p_box(top,left,bottom,right,color,speed,boxframe)
	CASE design == "D"
			d_box(top,left,bottom,right,color,speed,boxframe)
	CASE design == "L"
			l_box(top,left,bottom,right,color,speed,boxframe)
	CASE design == "R"
			r_box(top,left,bottom,right,color,speed,boxframe)
	CASE design == "N"
			n_box(top,left,bottom,right,color,speed,boxframe)
	OTHERWISE 
			TONE(500.10)
			RETURN(.F.)
ENDCASE
IF shadow 
   boxshadow(top,left,bottom,right)
ENDIF
IF TYPE("btitle") != "U"
   SETCOLOR(bcolor)
   lenscr=((right-left)/2)+left
   @ top,lenscr - (LEN(btitle)/2) SAY btitle
ENDIF
IF TYPE("bbtitle") != "U"
   SETCOLOR(bbcolor)
   lenscr=((right-left)/2)+left
   @ bottom,lenscr - (LEN(bbtitle)/2) SAY bbtitle
ENDIF
SETCOLOR(oldcolor)
RETURN(retscr)

**************************************
** BOX SHADOW- GREY ON BLACK
****
FUNCTION boxshadow
**************************************
PARAMETERS top,left,bottom,right
PRIVATE stop,sleft,sbottom,sright,GREY_ON_BLACK

GREY_ON_BLACK="X"+CHR(8)
stop=bottom+1
sbottom=stop
sleft=left+1
sright=IF(right >= 78,79,right+2)

DO CASE
   CASE bottom < 24 .AND. right < 79 
        RESTSCREEN( sbottom, sleft,sbottom,sright,;
        TRANSFORM( SAVESCREEN(stop, sleft, sbottom, sright),;
        REPLICATE(GREY_ON_BLACK, sright - sleft + 1 ) ) )
        stop   = top + 1
        sleft  = right + 1
        sbottom= bottom +1
        RESTSCREEN( stop, sleft,sbottom,sright,;
        TRANSFORM( SAVESCREEN(stop, sleft, sbottom, sright),;
        REPLICATE(GREY_ON_BLACK, ((sbottom - stop + 1)*2) ) ) )
   CASE bottom = 24 .AND. right < 79
        stop   = top + 1
        sleft  = right + 1
        sbottom = bottom
        RESTSCREEN( stop, sleft,sbottom,sright,;
        TRANSFORM( SAVESCREEN(stop, sleft, sbottom, sright),;
        REPLICATE(GREY_ON_BLACK, ((sbottom - stop + 1)*2)) ) )
      CASE bottom < 24 .AND. right = 79
        sright=right
        RESTSCREEN( sbottom, sleft,sbottom,sright,;
        TRANSFORM( SAVESCREEN(stop, sleft, sbottom, sright),;
        REPLICATE(GREY_ON_BLACK, sright - sleft + 1 ) ) )
ENDCASE
RETURN ("")

***************
FUNCTION boxscr
***************
PARAMETERS top,left,bottom,right
PRIVATE retval,sright,rtop,rleft,rbottom,rright
sright=IF(right >= 78,79,right+2)
DO CASE
   CASE bottom < 24 .AND. right < 79 
        retval=SAVESCREEN(top, left, bottom+1, sright)
		  rbottom=bottom+1
		  rright=sright
   CASE bottom = 24 .AND. right < 79
        retval=SAVESCREEN(top, left, bottom, sright)
		  rbottom=bottom
		  rright=sright
   CASE bottom < 24 .AND. right = 79
        retval=SAVESCREEN(top, left, bottom+1, right)
		  rbottom=bottom+1
		  rright=right
   CASE bottom = 24 .AND. right = 79
        retval=SAVESCREEN(top, left, bottom, right)
		  rbottom=bottom
		  rright=right
ENDCASE
rtop=RIGHT(STR(top),2)
rleft=RIGHT(STR(left),2)
rbottom=RIGHT(STR(rbottom),2)
rright=RIGHT(STR(rright),2)
RETURN(rtop+rleft+rbottom+rright+retval)

*********************
FUNCTION rest_scr
*********************
PARAMETERS rscr
PRIVATE t,l,b,r

t=VAL(SUBSTR(rscr,1,2))
l=VAL(SUBSTR(rscr,3,2))
b=VAL(SUBSTR(rscr,5,2))
r=VAL(SUBSTR(rscr,7,2))
RETURN(RESTSCREEN(t,l,b,r,SUBSTR(rscr,9)))

*********************
FUNCTION save_scr
*********************
PARAMETERS t,l,b,r
PRIVATE top,left,bottom,right,scr

top    = SUBSTR(STR(t),-2)
left   = SUBSTR(STR(l),-2)
bottom = SUBSTR(STR(b),-2)
right  = SUBSTR(STR(r),-2)
RETURN(top+left+bottom+right+SAVESCREEN(t,l,b,r))

**************************************
FUNCTION getbox
*****************************************
*	Example:
*	scrframe=getbox(1)
****************************************
PARAMETERS btype

****< BOXES DEFINED > ****

******
** An empty box
B_EMPTY = SPACE(9)

**< Single-line box >**
* Ŀ
*    
* 
B_SINGLE=( CHR(218) + CHR(196) + CHR(191) + CHR(179) + ;  
	CHR(217) + CHR(196) + CHR(192) + CHR(179) + " ")

**< Double-line box >**
* ͻ 
*    
* ͼ
B_DOUBLE=( CHR(201) + CHR(205) + CHR(187) + CHR(186) + ;
	CHR(188) + CHR(205) + CHR(200) + CHR(186) + " ")

**< Single-line top, double-line sides >**
* ķ
*    
* Ľ
B_SINGLE_DOUBLE=( CHR(214) + CHR(196) + CHR(183) + CHR(186) + ;
		CHR(189) + CHR(196) + CHR(211) + CHR(186) + " ")

**< Double-line top, single-line sides >**
* ͸
*    
* ;
B_DOUBLE_SINGLE=( CHR(213) + CHR(205) + CHR(184) + CHR(179) + ;
		CHR(190) + CHR(205) + CHR(212) + CHR(179) + " ")

**< Thick box border all around >**
* 
*    
* 
B_THICK=(REPLICATE(CHR(219),8)+" ")

**< Single-top and left, double-bottom and right-side >**
* ķ
*    
* ͼ 
B_SINGLE_DOUBLE_B=( CHR(218) + CHR(196) + CHR(183) + CHR(186) + ;  
	CHR(188) + CHR(205) + CHR(212) + CHR(179) + " ")

**< Double-top and left-side, single-bottom and right
* ͸
*    
* 
B_DOUBLE_SINGLE_B=( CHR(201) + CHR(205) + CHR(184) + CHR(179) + ;
	CHR(217) + CHR(196) + CHR(211) + CHR(186) + " ")

**< Music symbol >**
B_MUSIC=(REPLICATE(CHR(14),8)+" ")

**< Heart symbol >**
B_HEART=(REPLICATE(CHR(3),8)+" ")

**< Diamond symbol >**
B_DIAMOND=(REPLICATE(CHR(4),8)+" ")

************************
DO CASE
	CASE btype=0
		  RETURN(B_EMPTY)
   CASE btype=1
        RETURN(B_SINGLE)
   CASE btype=2
		  RETURN(B_DOUBLE) 
   CASE btype=3
        RETURN(B_SINGLE_DOUBLE)
   CASE btype=4
        RETURN(B_DOUBLE_SINGLE)
   CASE btype=5
        RETURN(B_THICK)
   CASE btype=6
        RETURN(B_SINGLE_DOUBLE_B)
   CASE btype=7
        RETURN(B_DOUBLE_SINGLE_B)
   CASE btype=8
        RETURN(B_MUSIC)
   CASE btype=9
        RETURN(B_HEART)
   CASE btype=10
        RETURN(B_DIAMOND)
ENDCASE

****************
FUNCTION e_box
****************
PARAMETERS top,left,bottom,right,color,speed,boxframe
PRIVATE seed1,seed2,t,l,b,r,s

seed1=INT((bottom-top)/2)
seed2=INT((right-left)/2)
t=top+seed1
l=left+seed2
b=t
r=l
SETCOLOR(color)
SET CURSOR OFF
DO WHILE ( t > top .AND. l > left) .AND. ( b < bottom .AND. r < right)
   @ t, l, b, r BOX boxframe
   t = t - 1
   l = l - ( seed2 / seed1)
   b = b + 1
   r = r + ( seed2 / seed1)
   FOR s= 1 TO speed
   NEXT s
ENDDO
@ top,left,bottom,right BOX boxframe
RETURN("")

********************
FUNCTION m_box
********************
PARAMETERS top,left,bottom,right,color,speed,boxframe
PRIVATE t,l,b,r,s

t=INT(top+(bottom-top)/2)
b=t
l=left
r=right
SETCOLOR(color)
SET CURSOR OFF
DO WHILE t > top .AND. b < bottom
   FOR s= 1 TO speed
   NEXT s
   @ t,l,b,r BOX boxframe
   t=t-1
   b=b+1
ENDDO
@ top,left,bottom,right BOX boxframe
RETURN("")

*****************
FUNCTION p_box
*****************
PARAMETERS top,left,bottom,right,color,speed,boxframe
PRIVATE t,l,b,r,s

t=bottom
b=t
l=left
r=right
SETCOLOR(color)
SET CURSOR OFF
DO WHILE t >= top
   FOR s=1 TO speed
   NEXT s
   @ t,l,b,r BOX boxframe
   t=t-1
ENDDO
RETURN("")

*****************
FUNCTION d_box
*****************
PARAMETERS top,left,bottom,right,color,speed,boxframe
PRIVATE t,l,b,r,s

t=top
b=t
l=left
r=right
SETCOLOR(color)
SET CURSOR OFF
DO WHILE b <= bottom
   FOR s= 1 TO speed
   NEXT s
   @ t,l,b,r BOX boxframe
   b=b+1
ENDDO
RETURN("")

*****************
FUNCTION l_box
*****************
PARAMETERS top,left,bottom,right,color,speed,boxframe
PRIVATE t,l,b,r,s
t=top
b=bottom
l=left
r=left
SETCOLOR(color)
SET CURSOR OFF
DO WHILE r <= right
   FOR s= 1 TO speed
   NEXT s
   @ t,l,b,r BOX boxframe
   r=r+1
ENDDO
RETURN("")

*****************
FUNCTION r_box
*****************
PARAMETERS top,left,bottom,right,color,speed,boxframe
PRIVATE t,l,b,r,s

t=top
b=bottom
l=right
r=right
SETCOLOR(color)
SET CURSOR OFF
DO WHILE l >= left
   FOR s= 1 TO speed
   NEXT s
   @ t,l,b,r BOX boxframe
   l=l-1
ENDDO
RETURN("")

*****************
FUNCTION n_box
*****************
PARAMETERS top,left,bottom,right,color,speed,boxframe

SETCOLOR(color)
SET CURSOR OFF
@ top,left,bottom,right BOX boxframe
RETURN("")
