/*

 DISPMEM.c       Bruce Hammerberg

 Shows the contents of a Clipper .MEM file

 Enhancement to article published in Reference(Clipper), October 1988
 Published by Pinnacle Publishing, Inc.  Written by Rick Spence.

 Syntax:  DISPMEM memfile[.mem]

*/

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <io.h>
#include <alloc.h>

#define O_RAW O_BINARY      /* for Turbo-C */

typedef struct
 {char mname[11];
  char mtype;
  char mfiller1[4];
  char mlen;
  char mdec;
  char mfiller[14];
 }MEM_REC;

MEM_REC mem_rec;

main(argc, argv)

int argc;
char *argv[];
{int mem_handle;
 char *cstr,ctype,*memfile="";
 unsigned csize;
 double num;
 int log,clen,ndec,mon,day_mon,yrs,day_year;
 int months[13]={0,31,59,90,121,151,181,212,243,273,304,334,366};
 if (argc!=2)
 {printf("SYNTAX: Dispmem file[.mem]\n\n");
  exit(1);
 }
 strcpy(memfile,argv[1]);
 if (strchr(memfile,'.')==NULL) strcat(memfile,".MEM");
 mem_handle=open(memfile,O_RAW|O_RDONLY);
 if (mem_handle==-1)
 {printf("Error opening file %s\n",memfile);
  exit(1);
 }

 while (read(mem_handle,(char *) &mem_rec, sizeof(MEM_REC))==sizeof(MEM_REC))
 {ctype=mem_rec.mtype&127;
  clen=mem_rec.mlen;
  ndec=mem_rec.mdec;
  printf("\n%-10s ",mem_rec.mname);

  switch (ctype)
  {case 'C':
        csize=clen+ndec*256;
        printf("%5d  ",csize-1);
        cstr=malloc(csize);
        read(mem_handle,cstr,csize);
        printf("'%s'",cstr);
        free(cstr);
        break;
   case 'N':
        printf("%5d  ",clen);
        read(mem_handle,(char *)&num,8);
        printf("%g",num);
        break;
   case 'D':
        /* dates are represented as Julian dates */
        /* first value being 2415021 for 1/1/0   */
        /* null date has value of 0              */
        printf("%5d  ",8);
        read(mem_handle,(char *)&num,8);
        yrs=0;
        mon=0;
        day_mon=0;
        num=num-2415020;
        if (num>0)
         {yrs=num/365.25;
          day_year=num-yrs*365.25+(yrs%4!=0);
          mon=1;
          while (day_year>months[mon]) mon++;
          day_mon=day_year-months[mon-1];
         }
        printf("%2u/%2u/%2u",mon,day_mon,yrs);
        break;
   case 'L':
        printf("%5d  ",clen);
        read(mem_handle,&log,1);
        printf("%s",(log==0)?".f.":".t.");
  }
 }
}
