        PAGE    66, 80
        TITLE   Subroutines for the dispfile() routine

.MODEL LARGE

;
; filename - dispsub.asm
;
; compile  - masm /mx dispsub;
;
; written by:  Mike Taylor
;              September 10th, 1988
;
; updated:     December 23, 1990
;

.CODE


;  Function:    unsigned d_vconfig(void);
;  Parameters:  none
;
;               call with C style parameter passing
;
;  Purpose:     to return the segment address of the active video device
;

        PUBLIC  _d_vconfig
_d_vconfig PROC

        xor     ax,ax           ; clear ax
        mov     ah,0fh          ; bios function 0fh, get video mode
        int     10h

        cmp     al,7            ; did bios return mono (= 7)?
        jnz     v1              ; if no, then color
        mov     ax,0b000h       ; yes, switch to mono segment
        jmp     v2              ; bypass color assignment
v1:
        mov     ax,0b800h       ; color segment
v2:
        ret                     ; return segment in ax to caller
_d_vconfig ENDP


;
;  Function:    void d_gotoxy(int, int)
;  Parameters:  int - x coordinate for the new cursor position
;               int - y coordinate for the new cursor position
;
;               0 > x > 79   and   0 > y > 24
;
;               call with C style parameter passing
;
;  Purpose:     to place the cursor at the x,y coordinates
;

        PUBLIC  _d_gotoxy
_d_gotoxy PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack
        push    bx              ; save bx and dx registers
        push    dx

        xor     ax,ax           ; clear ax register
        xor     bx,bx           ; bx = 0 means video page 0
        mov     dh, [bp + 8]    ; get y coordinate
        mov     dl, [bp + 6]    ; get x coordinate
        mov     ah,2            ; bios function 02h, set cursor position
        int     10h

        xor     ax,ax           ; clear ax register

        pop     dx              ; restore caller's registers
        pop     bx
        pop     bp
        ret
_d_gotoxy ENDP



;
;  Function:    int d_fileopen(char *, int mode)
;  Parameters:  char * - filename
;               access - file access mode       0 = read only
;                                               1 = write only
;                                               2 = read/write
;
;               call with C style parameter passing
;
;  Purpose:     to open a DOS file and return it's handle.
;

        PUBLIC  _d_fileopen
_d_fileopen PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack

        push    bx              ; save caller's registers
        push    dx
        push    ds

        mov     dx,[bp + 6]     ; offset of filename
        mov     ax,[bp + 8]     ; segment of filename
        push    ax              ; make filename segment into default segment
        pop     ds
        mov     ax,[bp + 10]    ; access mode for file, stored in ah

        mov     ah,3dh          ; dos function 3dh, file open
        int     21h

        jnc     _fo1            ; if carry flag set then error occured
        xor     ax,ax

_fo1:
        pop     ds              ; restore caller's registers
        pop     dx
        pop     bx
        pop     bp

        ret

_d_fileopen ENDP


;
;  Function:    int d_fileread(int, char *, int)
;  Parameters:  int    - dos file handle
;               char * - char pointer to read buffer (pass as a FAR pointer)
;               int    - # of characters to read in
;
;               call with C style parameter passing
;
;  Purpose:     to read in from a file the specified number of bytes
;               into the buffer address passed.  Returns the # of bytes
;               actually read in.
;

        PUBLIC  _d_fileread
_d_fileread PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack

        push    bx              ; save caller's registers
        push    cx
        push    dx
        push    ds

        mov     bx,[bp + 6]     ; file handle
        mov     dx,[bp + 8]     ; offset of buffer
        mov     ax,[bp + 10]    ; segment of buffer
        push    ax              ; make buffer segment into default data segment
        pop     ds
        mov     cx,[bp + 12]    ; byte count to read in
        xor     ax,ax           ; clear ax register
        mov     ah,3fh          ; dos function 3fh, file block read
        int     21h

        jnc     _fr1            ; if carry flag set then error occured
        xor     ax,ax           ;   and notify by returning 0 bytes
                                ; otherwise ax will contain the actual
                                ; bytes read in.

_fr1:
        pop     ds              ; restore caller's registers
        pop     dx
        pop     cx
        pop     bx
        pop     bp

        ret

_d_fileread ENDP


;
;  Function:    long d_fileseek(int, long, int)
;  Parameters:  int  - dos file handle
;               long - new offset to position file pointer
;               int  - direction of offset
;
;               direction 0 = seek from start of file
;                         1 = seek from current position
;                         2 = seek from end of file
;
;               call with C style parameter passing
;
;  Purpose:     to place the file pointer at the specified offset
;               and return the new offset as a long variable in dx, ax
;

        PUBLIC  _d_fileseek
_d_fileseek PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack
        push    bx              ; save bx and cx registers
        push    cx

        mov     bx,[bp + 6]     ; file handle
        mov     cx,[bp + 10]    ; msb of long offset parameter
        mov     dx,[bp + 8]     ; lsb of long offset parameter
        mov     al,[bp + 12]    ; seek direction code
        mov     ah,42h          ; dos function 42h, set file pointer
        int     21h

        jnc     _f1             ; if carry flag not set, no error
        xor     ax,ax           ; if error, clear pointer msb and lsb
        xor     dx,dx
_f1:
        pop     cx              ; restore caller's registers
        pop     bx
        pop     bp
        ret
_d_fileseek ENDP

;
;  Function:    long d_filepos(int)
;  Parameters:  int    - dos file handle
;
;               call with C style parameter passing
;
;  Purpose:     to return the current file pointer value.  This is done
;               by calling the set file pointer function with an offset
;               of 0 from the current position.  The new position (the
;               same since the offset was 0,) will be returned as a long
;               variable in the ax and dx registers.
;

        PUBLIC  _d_filepos
_d_filepos PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack
        push    bx              ; save caller's registers
        push    cx

        mov     ah,42h          ; dos function 42h, set file pointer
        mov     al,1            ; seek from current position
        xor     cx,cx           ; for 0 bytes (long value in cx and dx)
        xor     dx,dx
        mov     bx,[bp + 6]     ; file handle
        int     21h

        jnc     _fp1
        xor     ax,ax
        xor     dx,dx

_fp1:
        pop     cx              ; restore caller's registers
        pop     bx
        pop     bp
        ret
_d_filepos ENDP

;
;  Function:    int d_fileclose(int)
;  Parameters:  int - valid file handle
;
;               call with C style parameter passing
;
;  Purpose:     to close a DOS file handle.
;

        PUBLIC  _d_fileclose
_d_fileclose PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack

        push    bx              ; save caller's registers

        mov     bx,[bp + 6]     ; file handle
        xor     ax,ax
        mov     ah,3eh          ; dos function 3eh, file close
        int     21h

        jc      _fc1            ; if carry flag set then error occured
                                ;  ax will contain error number
        xor     ax,ax           ; else return 0
_fc1:
        pop     bx              ; restore caller's registers
        pop     bp

        ret

_d_fileclose ENDP

;
;  Function:    char d_getkey(void)
;  Parameters:  none
;
;               call with C style parameter passing
;
;  Purpose:     to return the current key pressed
;

        PUBLIC  _d_getkey
_d_getkey PROC

        xor     ax,ax           ; clear ax register
        mov     ah,07h          ; dos function 07h, get key pressed
        int     21h

        mov     ah,0            ; zero out msb of ax to make sure returned

        ret                     ;   value is only a byte value

_d_getkey ENDP


        END
