/* display.h */

    // defines and prototypes for display.c

#define FP_SEG(fp) (*((unsigned *)&(fp) + 1))   // copied from MSC 5.1
#define FP_OFF(fp) (*((unsigned *)&(fp)))       //  include file 'dos.h'

#define BUFFERSIZE 4096     // maximum size of the file buffer
#define MAXLINE    255      // default maximum size of a line

#define OFF 0
#define ON  (!OFF)
#define NO  0
#define YES (!NO)
#define OK  0

#define CR   ((char) 13)
#define LF   ((char) 10)
#define FEOF ((char) 26)

#define SEEK_END 2              // file seek directions
#define SEEK_CUR 1
#define SEEK_SET 0

#define READONLY  0             // open file modes
#define WRITEONLY 1
#define READWRITE 2

#define MDASEG 0x0b000          // mono video memory segment
#define CGASEG 0x0b800          // color video memory segment

long d_buffoffset;              // offset into buffer of current line
long d_fsize;                   // file size in bytes
int  d_bufftop, d_buffbot;      // first and last character in buffer
int  d_wintop, d_winbot;        // first and last character in window
int  d_winrow, d_wincol;        // row and column of window highlight
int  d_sline, d_eline;          // start and end line of window
int  d_scol, d_ecol;            // start and end col of window
int  d_height, d_width;         // height and width of window
int  d_infile;                  // input file handle
int  d_maxlin;                  // line size
int  d_buffsize;                // buffer size
char d_refresh;                 // YES means refresh screen

#ifdef CLIPPER5
    char far *d_buffer;             // file buffer pointer
    char far *d_lbuff;              // line buffer pointer
#else
    char d_buffer[BUFFERSIZE];
    char d_lbuff[MAXLINE];          // line buffer
#endif

char far *d_vseg;               // video segment variable

    // prototypes


CLIPPER dispfile(void);

unsigned char d_keyin(void);
void          d_chattr(int x, int y, int len, int attr);
long          d_getblock(long offset);
void          d_buff_align(void);
void          d_win_align(void);
void          d_disp_update(int offset);
void          d_windown(void);
void          d_winup(void);
void          d_linedown(void);
void          d_lineup(void);
void          d_filetop(void);
void          d_filebot(void);
char far *    d_vconfig(void);
void          d_gotoxy(int x, int y);
char          d_getkey(void);

    // found in dispsub.asm

int           aint86(int, union REGS *, union REGS *);
int           d_fileopen(char far *filename, int mode);
int           d_fileread(int handle, char far *buffer, int bytes);
long          d_fileseek(int handle, long offset, int direction);
long          d_filepos(int handle);
int           d_fileclose(int handle);

    // this is defined because I found out that CLIPPER has a version
    //   strcpy linked in normally - this just shut's up the LINT check

extern char *strcpy(char far *, char far *);

