; Program ...: Disk.ASM
; Author ....: Kenneth N. Getz
; Date ......: 22 October 1986
; modified to reset error condition for retry by Dick Whiteley 14 June 1988
;
; .BIN file to be loaded from within dBASE III PLUS (or Developer's Release) to verify that a disk drive has a disk in it 
; before trying to write to it.  The program expects to be passed a character variable (not a constant) and returns an 'X'
; in that variable if an error occurred (if the disk isn't ready).  This is done by calling the BIOS routine to verify a
; specific disk sector.  If this can't be done, an error is returned without relying on DOS' "ABORT, RETRY, IGNORE" message.
;
; While ASM programs given in TechNotes are usually written for conditional assembly to run either from DOS (as COM files) or 
; from dBASE III PLUS (as BIN files), this program is meaningless except as a direct LOAD/CALL.  There are, therefore, no 
; instructions given for conditional assembly.
;
; To use this program, type it in using an editor that produces pure ASCII text (dBASE's editor will work fine).  You'll then 
; need IBM or Microsoft's MACRO assembler (not the smaller ASM.EXE), LINK.EXE, and EXE2BIN.EXE.
;
; Type the following commands to assemble, link, and convert the code:
;
;	MASM DISK;
;	LINK DISK;
;	EXE2BIN DISK
;	ERASE DISK.EXE
;
; To use it from within dBASE III PLUS, type:
;
;	LOAD DISK
;	STORE 'A' TO drivename     && for example
;	CALL DISK WITH drivename
;	IF drivename = 'X'
;	   DO error routine
;	ELSE
;	   DO whatever
;	ENDIF			
;
CODE	SEGMENT	BYTE PUBLIC	'CODE'	

FILES	PROC	FAR
	ASSUME	CS:code

	MOV	DL,BYTE PTR [BX]	; Get the parameter (drive letter).
	AND	DL,0DFH			; Convert to upper case.
	SUB	DL,'A'			; Convert to integer value.
	MOV	CX,2				; Get ready for two loops.
	PUSH	CX 				; save retry counter
LOOPER:	PUSH	CX			; Save CX for loop.
	MOV	AH,04 			; BIOS service for disk verification.
	MOV	DH,0				; Head 0.
	MOV	CH,0				; Track 0.
	MOV	CL,1				; Sector 1.
	MOV	AL,1				; Number of sectors to verify.
	INT	13H				; Call BIOS.
	POP	CX 				; Restore loop counter.
	LOOP	LOOPER			; And do it again for drive motor.
	POP	CX 				; Restore retry counter.
	JNC	OK 				; If no error, Carry flag clear.
	DEC	CX 				; decrement retry counter
   JZ    PSTERR         ; no more retries, post error
	PUSH	CX 				; save retry counter
	MOV	AH,00 			; reset diskette system
	INT	13H				; Call BIOS
	MOV	CX,2				; Give it two more tries
	JMP	LOOPER			; go do it
PSTERR:	MOV	BYTE PTR [BX],'X' ; error, set parameter to 'X'.
OK:	RET				; Return to dBASE.
FILES	ENDP
CODE	ENDS
	END	
	
	
