********************************************************************************
*                             DirSeek.Prg                                      *
********************************************************************************
Parameters TopDir

Store "W/b,R/g" to Color
STORE 24 TO Dn_Key
STORE 5  TO Up_Key
STORE 4  TO Rt_Key
STORE 19 TO Lt_Key
STORE 18 to PgUp_Key
STORE 3  to PgDn_Key
STORE 6  to End_Key
STORE 1  to Home_Key
STORE 22 to Ins_key
STORE 7  to Del_key 
STORE 8  to Bk_key
STORE 30 TO CTRL_PGDN
STORE 31 TO CTRL_PGUP
Store 23 TO Ctrl_End
STORE 29 TO Ctrl_Home
STORE 13 TO ENTER
STORE 27 TO ESC
Store 32 to Space_Bar

Set color to &Color
Set Cursor Off
Clear

if type("TopDir") = "U"
    Store "\" to TopDir
Else
    If Substr(TopDir,len(TopDir),1) # "\"
        TopDir = TopDir + "\"
    Endif
Endif

Store TopDir to InitDir

Store 1000 to MaxFiles
Store 1 to Begin, DirSel, FileSel

Declare SubDirs[300]  && Assume no more than 300 unique sub-dirs

Declare Dirs[MaxFiles], Names[MaxFiles], Sizes[MaxFiles]
Declare Dates[MaxFiles], Times[MaxFiles], Attribs[MaxFiles]

********************************************************************************
*                             Get Sub-Directory List                           *
********************************************************************************
Set color to I
@ 0,0 Say "Reading Directory Structure"

* Vars:
* ThisDir   Number of entries in File Specs Arrays
* Dirs      SubDir name for each file
* Names,sizes,dates,times,attribs   Arrays for individual files
* SubDirs   Array that stores unique subdir names (1 each)
* TDirs     Total number of Subdirs[] entries

*** Top Dir Initial Names Load
Set color to I
@ 1,0 Say "\"
Set color to &Color

ThisDir = Subdir(0,TopDir,"*.*","D",@SubDirs,@Names,@Sizes,@Dates,@Times,@Attribs)
For J = 1 to ThisDir
    Subdirs[J] = SubDirs[J] + Names[J]
Next

* TopDir should be set to initial value when in root (InitDir)
* In root when a branch search is exhausted... 
* When 

*** Sub-Dirs in root loaded into SubDirs[]
*** Dir Pointing at First sub-dir in root

Store 1 to TDirs

Do while TDirs <= thisDir       && For all Sub-dirs in list
                                && Note that ThisDir may increase as we go.

    *** Follow this subdirectory branch
    *** Insert Sub-Dirs of Subdirs[dir] just afters Subdirs[Dir]

    @ 1,0 Clear to 2,79
    Set color to I
    @ 1,0 Say SubDirs[TDirs] + "\"
    Set color to &Color

    *** Check to current SubDir[] Dir spec for new Dirs within it.
    *** Inser After current SubDir[] Dir spec if there are any.
    NewDirs = Subdir(TDirs+1,SubDirs[TDirs]+"\","*.*","D",@SubDirs,@Names,@Sizes,@Dates,@Times,@Attribs)

    If NewDirs > 0
        For J = TDirs+1 to TDirs+NewDirs    && for new ones only...
            SubDirs[J] = SubDirs[J] + Names[J]  && Build Full Sub-dir Spec
        Next
    Endif

    ThisDir = ThisDir + NewDirs
    TDirs = TDirs + 1

EndDo

@ 0,0 Clear to 2,79                         && Clear Initial Message Area

********************************************************************************
*                             Select Directory                                 *
********************************************************************************
Asort(SubDirs,1,Tdirs)

Top     = 3
Left    = 0
Bottom  = 23
Right   = 79

MakeBox(Top,Left,Bottom,Right,"DLB","CLEAR")
MakeBox(Top,Left,Top+3,Right,"SDLB","NO CLEAR")

Set color to I
@ Top+1,Left+1 Say Space(78)
@ Top+2,left+1 Say Pad("Select A Directory",78)
Set color to &Color

DirSel = 1
FileSel = 1

Do while DirSel # 0
    DirSel = AChoice(Top+4,Left+1,Bottom-1,Right-1,SubDirs,.T.,"KeyInt",DirSel)
    If DirSel = 0
        Loop
    Endif
    FileSel = FileList(SubDirs[DirSel]+"\",.T.)
EndDo

Set Cursor On
Return

Function KeyInt
Parameters Mode, Element, RelRow

if Mode # 3
    Return(2)
Endif

Do Case
Case Lastkey() = End_Key
    Return(2)
Case LastKey() = Home_Key
    Return(2)
Case LastKey() = Esc
    Return(0)
Case LastKey() = Rt_Key .or. LastKey() = Lt_Key .or. LastKey() = Enter .or. LastKey() = Space_Bar
    Return(1)
OtherWise
    Return(3)
EndCase

********************************************************************************
*                             SubDisp Function                                 *
********************************************************************************
Function SubDisp
Parameters Mode, Element, RelRow
Private Ret_Val

Ret_Val = 2     && Default Return Value = Continue

* Ret_Val: 0=Abort 1=Make Selection 2=Continue 3=Go To Matching Key Char

Do Case
Case Mode = 0   && Idle - cursor mave have been moved
    If Element # DirSel
        ** Cursor Moved
        Store Element to DirSel
        FileSel = FileList(SubDirs[DirSel]+"\",.F.)
    Endif
Case Mode = 1   && Cursor Past Top
Case Mode = 2   && Cursor Past End
Case Mode = 3   && Keystroke Exception
    Do Case
    Case LastKey() = Enter .or. LastKey() = Rt_Key
        Ret_Val = 1     && Select Item
    Case LastKey() = Esc
        Ret_Val = 0     && Abort Process
    EndCase
Case Mode = 4   && No Item Selectable
EndCase

Return( Ret_Val )

********************************************************************************
*                             Select File in Directory                         *
********************************************************************************
Function FileList
Parameters Dir, Selectable

*** if .not. Selectable, only display one page (no selecting)

Private Top, Left, Bottom, Right, Pos, Counter, J, PrevScr
Private Heading1, Heading2, FileSel, SubCount, Footer, SizeCount

*** Zero Out Arrays to eliminate Garbage that may follow next directory load:
Release Dirs, Names, Sizes, Dates, Times, Attribs
Public Dirs[MaxFiles], Names[MaxFiles], Sizes[MaxFiles]
Public Dates[MaxFiles], Times[MaxFiles], Attribs[MaxFiles]

@ 1,0 Say ""
SubCount = Subdir(0,Dir,"*.*","",@Dirs,@Names,@Sizes,@Dates,@Times,@Attribs)
@ 1,0 Clear to 1,79

*** Remove Directory References
Store ascan(Attribs,"D",1,SubCount) to Pos
Do while Pos > 0
    Adel(Dirs,Pos)
    Adel(Names,Pos)
    Adel(Sizes,Pos)
    Adel(Dates,Pos)
    Adel(Times,Pos)
    Adel(Attribs,Pos)
    SubCount = SubCount - 1
    Store ascan(Attribs,"D",1,SubCount) to Pos
EndDo

Top     = 3
Left    = 32
Bottom  = 23
Right   = 79

*Subdir: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
*Name             Size   Date     Time   Attrib     
*XXXXXXXX.XXX 99999999 MM/dd/yy HH:mm:ss   X   

If Selectable
    Declare Choices[SubCount]
Else
    Declare Choices[Bottom-Top]
    Store Min( Bottom-Top,SubCount ) to SubCount
Endif

Store 0 to SizeCount

For J = 1 to SubCount
    SizeCount = SizeCount + Sizes[J]
    Choices[J] = Pad(Names[J],12) + " " + Transform(Sizes[J],"99999999") + " " + DtoC(Dates[J]) + " " + Times[J] + "   "  + Attribs[J] + space(3)
Next

PrevScr = SaveScreen(Top,Left,Bottom,Right)

Heading1 = "Subdir: " + Pad(Dir,38)
Heading2 = "Name             Size   Date     Time   Attrib"
*Footer  = "Number of Files: 999999  -  Bytes: 999,999,999"

Footer = "Number of Files: " + transform(SubCount,"999999") + ;
         "  -  Bytes: " + transform(SizeCount,"999,999,999")

MakeBox(Top,Left,Bottom,Right,"DLB","CLEAR")
MakeBox(Top,Left,Bottom-2,Right,"SDLB","NO CLEAR")
MakeBox(Top,Left,Top+3,Right,"SDLB","NO CLEAR")

Set color to I
@ Top+1,Left+1 Say Heading1
@ Top+2,left+1 Say Heading2
@ Bottom-1,Left+1 Say Footer
Set color to &Color

Asort(Choices,1,SubCount)

Store 1 to FileSel
FileSel = AChoice(Top+4,Left+1,Bottom-3,Right-1,Choices,Selectable,"FileInt",FileSel)

RestScreen(Top,Left,Bottom,Right,PrevScr)

Return(FileSel)

Function FileInt
Parameters Mode, Element, RelRow

if Mode # 3
    Return(2)
Endif

Do Case
Case Lastkey() = End_Key
    Return(2)
Case LastKey() = Home_Key
    Return(2)
Case LastKey() = Esc
    Return(0)
Case LastKey() = Rt_Key .or. LastKey() = Lt_Key .or. LastKey() = Enter .or. LastKey() = Space_Bar
    Return(1)
OtherWise
    Return(3)
EndCase

********************************************************************************
*                             SubDir                                           *
********************************************************************************
Function SubDir
Parameters Begin, DirSpec, FileSpec, FileType, Dirs, Names, Sizes, Dates, Times, Attribs

*** Loads Names,Sizes,Dates,Times,Attribs with file info specific to DirSpec
*** starting at location indicated by BEGIN.
*** Will Insert Data Starting at BEGIN if BEGIN > 0 otherwise will Start at 1, overwriting.

Private J, Files, DirSkel, ThisRow, ThisCol, GoodDir

Store Row() to ThisRow
Store Col() to ThisCol

*** Get File Names
Store DirSpec + FileSpec to DirSkel
Declare At[1]
Files = Adir(DirSkel,"","","","",At)

Declare SD[Files], NA[Files], SI[Files], DA[Files], TI[Files], AT[Files]
Adir(DirSkel,NA,Si,Da,Ti,At)

Store 1 to J

Do while J <= Files

*   *** Display File
*   Set color to I
*   @ ThisRow,ThisCol Say Pad(Na[J],12)
*   Set Color to &Color

    Do Case
    Case Empty(FileType)
        Store .T. to GoodDir
    Case FileType $ At[J]
        If FileType == "D"
            Do Case
            Case Na[J] == ".."
                Store .F. to GoodDir
            Case Na[J] == "."
                If DirSpec == "\"
                    Store "\" to Na[J]
                    Store .T. to GoodDir
                Else
                    Store .F. to goodDir
                Endif
            OtherWise
                Store .T. to GoodDir
            EndCase
        Else
            Store .T. to GoodDir
        Endif
    OtherWise
        Store .F. to GoodDir
    EndCase

    If GoodDir
        *** A Selected File Type

        If Begin > 0            && Make room in object arrays
            Ains(Dirs,Begin)
            Ains(Names,Begin)
            Ains(Sizes,Begin)
            Ains(Dates,Begin)
            Ains(Times,Begin)
            Ains(Attribs,Begin)
        Endif

        J = J + 1           && Increment Pointer

    Else

        * Remove unwanted files - don't increment pointer
        Adel(Na,J)
        Adel(Si,J)
        Adel(Da,J)
        Adel(Ti,J)
        Adel(At,J)

        Files = Files - 1   && Decrement End Condition
                            && Don't Increment Pointer

    Endif

EndDo

If Begin = 0                && Calling Proc doesn't want insert to object
    Store 1 to Begin        && Copy over start of object arrays
Endif

If Files > 0
    Acopy(Na,Names,1,Files,Begin)
    Acopy(Si,Sizes,1,Files,Begin)
    Acopy(Da,Dates,1,Files,Begin)
    Acopy(Ti,Times,1,Files,Begin)
    Acopy(At,Attribs,1,Files,Begin)
    Afill(Dirs,DirSpec,Begin,Files)
Endif

Return(Files)

********************************************************************************
*                             MAKEBOX FUNCTION                                 *
********************************************************************************
FUNCTION MAKEBOX

PARAMETERS BTOP, BLEFT, BBOTTOM, BRIGHT, BOXTYPE, CLEAR

PRIVATE BOXTYPE, DOUBLE, SINGLE, FRAME

* 
* Description:  Creates a box on the screen with top, left, bottom and right
*               side locations as parameters.

*               BOXTYPES: SLB, SSLB, NSLB, DLB, SDLB, NDLB...
*               SINGLE LINE BOX
*               SHORT SINGLE LINE BOX INSIDE SLB STARTING AT TOP OF SLB
*               NARROW SINGLE LINE BOX INSIDE SLB STARTING AT LEFT OF SLB
*               DOUBLE LINE BOX
*               SHORT DLB INSIDE DLB STARTING AT TOP OF DLB
*               NARROW DLB INSIDE DLB STARTING AT LEFT OF DLB

*               The CLEAR parameter determines if the inside of the box should
*               be cleared after making the box or not. CLEAR = 'CLEAR'

STORE UPPER(BOXTYPE) TO LTYPE

DO CASE
CASE LTYPE = "SLB" .OR. LTYPE = "SINGLE"
    * SINGLE LINE BOX (SLB)
    STORE "Ŀ" TO FRAME

CASE LTYPE = "SSLB"
    * SHORTER SINGLE LINE BOX INSIDE LARGER SINGLE LINE BOX STARTING AT TOP (SSLB)
    STORE "Ŀó" TO FRAME

CASE LTYPE = "NSLB"
    * NARROWER SINGLE LINE BOX INSIDE LARGER SINGLE LINE BOX STARTING AT LEFT (NSLB)
    STORE "³" TO FRAME

CASE LTYPE = "DLB" .OR. LTYPE = "DOUBLE"
    * DOUBLE LINE BOX (DLB)
    STORE "ͻȺ" TO FRAME

CASE LTYPE = "SDLB"
    * SHORTER DOUBLE LINE BOX INSIDE LARGER DOUBLE LINE BOX STARTING AT TOP (SDLB)
    STORE "ͻ̺" TO FRAME

CASE LTYPE = "NDLB"
    * NARROWER DOUBLE LINE BOX INSIDE LARGER DOUBLE LINE BOX STARTING AT LEFT (NDLB)
    STORE "˺Ⱥ" TO FRAME

CASE LTYPE = "BFB"
    * Big Fat Box
    STORE "" TO FRAME

ENDCASE


IF CLEAR = 'CLEAR'
    FRAME = FRAME + CHR(32)
ENDIF

@ Btop,Bleft,Bbottom,Bright BOX frame
