TITLE chdrv.asm - CHDRV
; Usage:
;
;       x_drive = chr(0) (for drive A)
;       load chdrv
;       call chdrv with x_drive
;
;       sets the current drive to the drive number selected    
;
PUSHALL   MACRO
          PUSH AX
          PUSH BX
          PUSH CX
          PUSH DX
          PUSH SI
          PUSH DI
          PUSH BP
          PUSH ES
          PUSH DS
ENDM

POPALL    MACRO
          POP  DS
          POP  ES
          POP  BP
          POP  DI
          POP  SI
          POP  DX
          POP  CX
          POP  BX
          POP  AX
ENDM

_PROG   SEGMENT   BYTE
        ASSUME    CS:_PROG
CHDRV   PROC      FAR
        PUSHALL
        MOV DX,[BX]         ; Put drive number in DL
        MOV AH,0Eh          ; Setup DOS select drive function
        INT 21h             ; call DOS
        POPALL
        RET
CHDRV   ENDP
_PROG   ENDS
        END
