/* Indent.c

	Indent a clipper PRG file based on looping commands.


	IN Quick 'C' use SMALL MODEL with dbused.obj in make...

	Use the following for MSC5.1

		CL /t /AS /Zl /Oalt indent.c
		link indent,,,slibce


	Use SMALL Memory Model....

*/
#include <stdio.h>
#include <string.h>

#define MAX     500

struct table1
	{
		char  ttext[10];
		int   tnumb;
		int   tstep;
		long  tcount;
	};

int lookup( struct table1 looker[], char *out_line, int nlook );
FILE *fopen(const char *path, const char *type);
int atoi(const char *string);
int unlink(const char *path);
int odata(char *string, int fextra, int echo, FILE *out);
int memicmp(void *buf1, void *buf2, unsigned int count);





int lookup( struct table1 looker[], char *out_line, int nlook )
{
	int i = 0, x = 0;    /* temp */
	int z = 0;           /* value to return */
	char  *comp;

	for(i = 0; x == 0 && i <= nlook ; i++ )
	{
		z     =  looker[i].tnumb;
		if ( memicmp(looker[i].ttext, out_line , z )  == 0 )
		{
			/* match found */
			looker[i].tcount++;
			x = looker[i].tstep;
		}
	}
	return ( x );
}

int odata( char *line, int fextra,  int echo, FILE *out )
{
	int   i = 0,x = 0;

	if ( fextra == 1)          /* test if prior line had ; at end */
	{
		if( echo == 1)
			printf("  ");
		for (i = 0; i < 2 ; i++)
			putc(' ',out);
		fextra = 0;             /* clear extra ; flag */
		x = 2;
	}
	/* Output Data till end of line... */
	for( i = 0; line[i] != '\0'; i++)
	{
		if(echo == 1 )
			printf("%c",line[i]); /* Output to screen to show action */
		putc(line[i],out);
		x++;           /* Number of charater output */
	}
	return( x );
}


main(argc,argv)
	int  argc;
	char *argv[];
	{
		int   c,id = 3;          /* c = character  id = Number of space per level */
		int   lvl;           /* current level of indent */
		FILE  *in;           /* use this file for input */
		FILE  *out;          /* use this one for output */
		long  nin = 0, nout = 0;     /* counts of chars in and out */
		long  lin = 0, lout = 0;     /* count of lines in and out */
		char  line[MAX];  /* Temp Line to Hold Input for Trimming */
		char  xline[MAX]; /* another temp line if restore required */
		int   count;         /* number of characters in current line */
		int   i,x;             /* Temp Var */
		long  b_line = 0,c_line = 0; /* blank line and comment line counters */
		int   echo = 0;      /* echo to screen flag if = 1 yes else no */
		int   ftext  = 0;
		int   fextra = 0; /* Extra 2 space indent because of a ';' at end of */
								/*   a line */
		int   bypass = 0;
		char  *s;
		int   arcount;

		static char outname[] = "TEMP.IND";  /* tempory file name */

		static struct table1 begin[36] =
		{  { "endd",   4, -1, 0 },
			{ "endi",   4, -1, 0 },
			{ "else",   4, -1, 0 },
			{ "endc",   4, -2, 0 },
			{ "case",   4, -1, 0 },
			{ "otherw", 6, -1, 0 },
			{ "end ",   4, -1, 0 },
			{ "next",   4, -1, 0 },
			{ "endt",   4,  0, 0 } };


		 static struct table1 end[36] =
		 { {  "do wh",    5, 1, 0 },
			{  "if ",      3, 1, 0 },
			{  "else",     4, 1, 0 },
			{  "do case",  7, 2, 0 },
			{  "case",     4, 1, 0 },
			{  "otherw",   6, 1, 0 },
			{  "begin",    5, 1, 0 },
			{  "for ",     4, 1, 0 },
			{  "text",     4, 0, 0 } };


		printf("\ndIndent Indent dBase/Clipper file Utiltiy   Version 0.1  08-01-89\n");
		printf("Copyright 1989 The Computer Chip  All Rights Reserved. dIndent/h for help\n");
		arcount = argc;

		while ( --argc > 0 && (*++argv)[0] == '-' )
			for ( s = argv[0] + 1; *s != '\0'; s++ )
				switch (*s)
				{
				case 'E':
				case 'e':
					echo = 1;
					break;
				case 'i':
				case 'I':
					id = atoi(++s);
					if( id > 9 )
						++s;
					if( id > 99 )
						++s;
					break;
				default:
					printf("\nIndent: illegal option %c\n",*s);
					argc = 0;
					break;
				}



		if ( argc != 1 )     /* be sure command line has enough words */
		{
			printf("\nUseage - INDENT [options] input-file \n");
			printf("Options are:\n");
			printf("  -e = Set echo output to screen \n");
			printf("  -i[n] = Set indent factor to n. Default factor is 3.\n");
			printf("\ninput-file = path/filename to indent\n");
			printf("\nIf you find dIndent fast, easy, and convenient to use, a registration of $10\n");
			printf("would be appreciated.  If you send $30 or more you will receive, when\n");
			printf("available, the next version of dIndent program.\n");
			printf("Please state version of the software that you currently have. Send\n");
			printf("check or money order to:    The Computer Chip\n");
			printf("                            HCR #2, Box 99A\n");
			printf("                            Del Rio, Tx   78840\n");

			exit(1);
		}
		in = fopen(*argv,"rb");   /* open input file [read binary] */
		if ( in == NULL )
		{
			printf(" can't open input file - %s \n",*argv);
			exit(2);
		}
		out = fopen(outname,"wb");  /* open output file [write binary] */
		if ( out == NULL )
		{
			printf(" can't open temporary output file - TEMP.IND\n");
			exit(3);
		}

		printf("Working Program %s Standby.....\n",*argv);


		lvl = 0;       /* Level to indent */
		;
		nin = 0;
		nout = 0;
		lout = 0;
		lin = 0;


		c = getc(in);


		count = 0;              /* number of characters in line */


		while ( c != EOF )       /* get character until end reached */
		{
			nin = nin + 1;          /* count total char input */
			if ( c == '\n' )        /* end of line */
			{
				/* Finish off input line */
				line[count] = c;     /* Should be EOL */
				xline[count] = c;
				line[count+1] = '\0'; /* Put Null Terminator */
				xline[count+1] = '\0';

				lin = lin + 1;       /* count lines in */

				/* strip leading blanks and tabs */
				i = 0;
				if( line[0] != '\n' )
				{
					while( line[0] == ' ' || line[0] == '\t' )
					{
						x = 0;
						while ( line[x] != '\0' )
						{
							line[x] = line[x+1];
							x = x + 1;
						}
					}
				}

				/* stip trailing blanks */
				i = strlen(line);  /* may need + 1 */
				while(line[i] == ' ')
				{
					line[i] = line[i+1];
					line[i+1] = line[i+2];
					i = i -1;
				}

				if ( line[0] != '*')
				{
					if ( strlen(line) > 4 )
					{
						/* Determine end of indent needed..... */
						/*    blank line and do some counting  */
						lvl = lvl + lookup( begin,line, 8 ) ;
						if (memicmp("endt",line,4) == 0 )
							ftext = 0;

					}
				}

				lout++;           /* number of lines out */

				/* check indent lvl for less than 0 */
				if(lvl < 0 )
					lvl = 0;       /* repair level for less than 0 */

				if( ftext == 0 )
				{
					/* Output Indent */
					if (line[0] != '\r')             /* Don't output Indent if blank line */
					{
						if( lvl > 0 )                 /* if level = 0 no indent needed */
						{
							i = id * lvl;              /* determine level and spaces */
							while(i != 0)
							{
								if(echo == 1 )
									printf(" ");            /* output spaces   */
								putc(' ',out);
								i = i -1;
								nout++;                 /* count characters output */
							}
						}
					}
					else
					{
						b_line++;          /* count blank lines */
					}

					/* count comment lines */
					if(line[0] == '*')
						c_line = c_line + 1;

					nout = odata( line, fextra, echo, out) + nout;

				}
				else     /* in text area */
				{
					nout = odata(xline,fextra,echo,out) + nout;
				}

				if (fextra == 1)
					fextra = 0;

				count = 0;        /* reset line charter counter */

				/* check if add indent next line ... */
				/*    and do some counting           */
				if ( line[0] != '\r' )
				{
					if ( line[0] != '*' )
					{
						if (strlen(line) > 2)
						{
							lvl = lvl + lookup( end,line, 8 ) ;

							/* special cases */
							if ((i = memicmp("text",line,4)) == 0 )
							{
								ftext = 1;
							}
							else if (strlen(line) > 3)
							{
								if ( ( line[ strlen(line) - 3 ]) == ';')
									fextra = 1;
							}
						}  /* line len > 2 */
					}  /* comment line */
				}  /* line != \r */
			}
			else  /* if c != '\n'  */
			{
					line[count] = c;
					xline[count] = c;
					count++;
					if( count > MAX)
					{
						printf("To Many Characters In a Line\n");
						exit(2);
					}
			}     /*    if c != '\n'  */
			c = getc(in);
		}        /* While !EOF */
		fclose(in);
		fclose(out);
		in = fopen(outname,"rb");        /* open old output as input */
		if ( in == NULL )
		{
			printf(" can't open input file - %s \n",argv[1]);
			exit(2);
		}
		out = fopen(*argv,"wb");    /* open old input for output */
		if ( out == NULL )
		{
			printf(" can't open output file - TEMP.IND\n");
			exit(3);
		}
		c = getc(in);
		while( c != EOF )
		{
			putc(c,out);
			c = getc(in);
		}
		fclose(in);
		fclose(out);
		unlink(outname);          /* Delete Temp File */

		printf("\n\n %10ld Blank Lines        ",b_line);
		printf(" %10ld Comment Lines \n",c_line);
		printf(" %10ld Program Lines      ",lout - b_line - c_line);
		printf(" %10ld Lines read \n",lin);
		printf(" %10ld Lines written      ",lout);
		printf(" %10ld characters read \n",nin);
		printf(" %10ld characters written ",nout);
		printf(" %10d Indent factor \n",id);
		printf(" %10ld Do While's         ",end[0].tcount);
		printf(" %10ld Endo's",begin[0].tcount);
		if (end[0].tcount != begin[0].tcount)
			printf("\n            <=== Do - Enddo Mismatch\a");
		printf("\n %10ld If's               ",end[1].tcount);
		printf(" %10ld Endif's",begin[1].tcount);
		if ( end[1].tcount != begin[1].tcount)
			printf("\n            <=== If - Endif Mismatch\a");
		printf("\n %10ld Do Case's          ",end[3].tcount);
		printf(" %10ld Endcase's",begin[3].tcount);
		if (end[3].tcount != begin[3].tcount )
			printf("\n            <=== Do Case - Endcase Mismatch\a");
		printf("\n %10ld Begin's            ",end[6].tcount);
		printf(" %10ld End Begin's",begin[6].tcount);
		if ( end[6].tcount != begin[6].tcount)
			printf("\n            <=== Begin Sequence - End Sequence Mismatch\a");
		printf("\n %10ld Text's             ",end[8].tcount);
		printf(" %10ld End Text's",begin[8].tcount);
		if ( end[8].tcount != begin[8].tcount )
			printf("\n            <=== Text - Endtext Mismatch\a");

		printf("\n %10ld For's              ",end[7].tcount);
		printf(" %10ld Next's",begin[7].tcount);
		if ( end[7].tcount != begin[7].tcount )
			printf("\n            <=== For - Next Mismatch\a");


		printf("\n\n The modified, indented version is stored in %s \n",*argv);
	  exit(0);
	}
