* ============================================================================
* ============================================================================
* Syntax:   P_REST()
* Usage:    Used to Restore backup sets made using P_BACK()
*
*           This program was written using Clipper S87.
*
*           This file includes the following functions:
*
*           HSORRY() - Places a message in a centered box.
*
* Copyright: (c) 1991 by Per Kjellqvist
*                        Le Caddie 4
*                        CH - 1936 VERBIER
*                        Switzerland            CompuServe 71540,2311
* ============================================================================
  PRIV lbyte_tot,lbyte_cop,lfile_no,lin,lread,ldrive,lbackno,ldisk_no,ltemp,;
       linc,lbuffer,lout,lpos,lwrite,lname,lscreen,lkey,lerror,lsize,lpath,;
       l_01,l_02,l_03,l_04,l_05,l_06,l_07,l_08,l_09,ltext

  l_01  = " HOTSOFT RESTORE UTILITY "                      && max 76 ch.
  l_02  = SPAC(30)+"Press [ESC] to Quit"+SPAC(29)          && MUST BE 78 ch.
  l_03  = "Source drive:"                                  && max 15 ch.
  l_04  = "Target path: "                                  && max 15 ch.
  l_05  = "PLEASE Put Disk No ["                           && max 30 ch.
  l_06  = "] in Drive ["                                   && max 30 ch.
  l_07  = "Sorry, Wrong Disk"                              && max 76 ch.
  l_08  = "DONE !"                                         && max 76 ch.
  l_09  = "Sorry, Error or [ESC] backup is NOT COMPLETE"   && max 76 ch.
  ltemp = "hrestore.000"                                   && TEMPORARY FILE

  SETCANCEL(.F.)
  SET SCOR OFF
  SET ESCA ON
  SET EXAC OFF
  SET CONF ON
  SET BELL OFF
  SET CURS OFF

DO WHIL .T.

   lpath   = "C:\"+CURDIR()+IF(EMPTY(CURDIR()),"","\")
   lpath   = LEFT(lpath+SPAC(60-LEN(lpath)),60)
   ldrive  = "A"

   * -- DRAW SCREEN AND GET USER INPUT ---------------------------------------
   CLEAR
   @ 0,0 TO 24,79 DOUB
   @ 7,48 TO 23,63 DOUB
   @ 15,17 TO 23,32
   @ 17,17 SAY ""+REPL("",14)+""
   @ 19,17 SAY ""+REPL("",14)+""
   @ 21,17 SAY ""+REPL("",14)+""
   SET COLO TO n/w
   @ 0,(80-LEN(l_01))/2 SAY l_01
   @ 24,1 SAY l_02
   SET COLO TO w/n
   @ 3,2 SAY l_03
   @ 5,2 SAY l_04
   @ 3,18 GET ldrive PICT "@!" VALID ldrive = "A" .OR. ldrive = "B"
   @ 5,18 GET lpath  PICT "@K! A:\"+REPL("X",57)
   SET CURS ON
   READ
   SET CURS OFF
   IF LASTKEY() = 27
      CLEA
      SET CURS ON
      RETU
   ENDI
   * -------------------------------------------------------------------------

   lpath     = UPPE(TRIM(lpath))
   lpath     = IF(RIGHT(lpath,1)="\",lpath,lpath+"\")
   ldisk_no  = 1
   linc      = 4096
   lname     = ""
   lbyte_tot = 0
   lbyte_cop = 0

   @ 3,18 CLEA TO 5,78
   @ 3,18 SAY ldrive
   @ 5,18 SAY lpath

   DO WHIL ldisk_no <> 0
      lscreen = SAVESCREEN(15,0,17,79)
      ltext = l_05+LTRIM(STR(ldisk_no))+l_06+ldrive+"]"
*      @ 15,(76-LEN(ltext))/2 CLEA TO 17,(82+LEN(ltext))/2
      @ 15,(76-LEN(ltext))/2,        17,(82+LEN(ltext))/2 BOX ""
      @ 16,(78-LEN(ltext))/2 SAY " "+ltext+" "
      lkey = INKEY(0)
      RESTSCREEN(15,0,17,79,lscreen)
      IF lkey = 27
         EXIT
      ENDI
      IF ! FILE(ldrive+":p_back.mem")
         HSORRY(l_07)
      ELSE
         REST FROM &ldrive.:p_back.mem ADDI
         * ---- FIRST DISK ---------------------------------------------------
         IF ldisk_no = 1
            lbyte_tot = PX_byte
            lbackno   = PX_number
            @ 16,19 SAY TRAN(lbyte_tot,"999,999,999")
            @ 18,19 SAY TRAN(lbyte_tot,"999,999,999")
            @ 20,29 SAY "%"
         ENDI
         * -------------------------------------------------------------------
         IF PX_disk <> ldisk_no .OR. PX_number <> lbackno
            HSORRY(l_07+" ["+LTRIM(STR(PX_disk))+"]")
         ELSE
               * =============================================================
               lpos = 0                                                    && nothing has been copied yet
               PRIV ARcopy[ADIR(ldrive+":"+PX_wcard)]
               ADIR(ldrive+":"+PX_wcard,ARcopy)
               FOR lfile_no = 1 TO LEN(ARcopy)
                   IF ! UPPE(ARcopy[lfile_no]) = "P_BACK.MEM"
                   IF lname = ARcopy[lfile_no]                             && APPEND TO FILE
                      lout = FOPEN(lpath+ltemp,2)                          && open target
                      FSEEK(lout,0,2)                                      && move to end of file
                   ELSE                                                    && MAKE NEW FILE
                      IF lpos > 0
                         ERASE  &lpath.&lname
                         RENAME &lpath.&ltemp TO &lpath.&lname
                         @ 22,19 SAY SPAC(12)
                         SCROLL(8,49,22,62,1)
                         @ 22,50 SAY lname
                      ENDI
                      * -- Start a new file ----------------------------------
                      lpos  = 0
                      lname = ARcopy[lfile_no]
                      lout  = FCREATE(lpath+ltemp)                         && Create temporary file
                      @ 22,19 SAY lname
                      * ------------------------------------------------------
                   ENDI
                   lsize  = 0
                   lerror = FERROR()
                   IF lerror = 0
                      lin    = FOPEN(ldrive+":"+lname)                     && Open the source file
                      lsize  = FSEEK(lin,0,2)
                      FSEEK(lin,0)
                      lerror = FERROR()
                      lpos   = 0
                      DO WHIL lerror = 0
                         lbuffer   = SPAC(linc)
                         lread     = FREAD(lin,@lbuffer,linc)
                         lwrite    = FWRITE(lout,lbuffer,lread)
                         lerror    = FERROR()
                         IF lerror = 0
                            lpos      = lpos+lwrite
                            lbyte_cop = lbyte_cop+lwrite
                            @ 18,19 SAY TRAN(lbyte_tot-lbyte_cop,"999,999,999")
                            @ 20,25 SAY TRAN(ROUND(lbyte_cop/lbyte_tot*100,0),"@Z 999")
                            IF lread = 0                                   && File has been successfully copied
                               EXIT
                            ENDI
                            lkey = NEXTKEY()
                            KEYBOARD CHR(0)                                && clear buffer
                            INKEY()                                        && clear buffer
                            IF lkey = 27                                   && [ESC] was pressed while in the loop
                               lerror = 1
                               EXIT
                            ENDI
                         ENDI
                      ENDD
                      FCLOSE(lin)
                   ENDI
                   FCLOSE(lout)
                   IF lerror<>0 .OR. lsize<>lpos
                      ERASE &lpath.&ltemp
                      HSORRY(l_09)
                      ldisk_no = 0
                      EXIT
                   ELSEIF lbyte_cop = lbyte_tot
                      ** == COPY COMPLETE ==
                      IF lsize > 0
                         ERASE  &lpath.&lname
                         RENAME &lpath.&ltemp TO &lpath.&lname
                         @ 22,19 SAY SPAC(12)
                         SCROLL(8,49,22,62,1)
                         @ 22,50 SAY lname
                      ENDI
                      HSORRY(l_08)
                      ldisk_no = 0
                      EXIT
                   ENDI
                   ENDI
               NEXT
               IF ldisk_no <> 0
                  ldisk_no = ldisk_no + 1                                  && increment disk number
               ENDI
               * =============================================================
         ENDI
      ENDI
   ENDD
   ERASE &lpath.&ltemp                                                     && just in case
ENDD


* ============================================================================
* ============================================================================
* Syntax:   HSORRY(<expC>)                                                   *
* Argument: <expC> is string to be shown on screen.                          *
* Return:   .F. if ESC was pressed, otherwise .T.                            *
* Usage:    Used to display a message when the user has made a misstake.     *
* Note:     The message is placed in a box, and is displayed on line 21      *
* Example:  HSORRY("Sorry, The name is not valid")                           *
* ============================================================================
  FUNC HSORRY
  PARA ltext
  PRIV lscreen,lkey

  lscreen = SAVESCREEN(20,0,24,79)
  TONE(900,1)
  TONE(900,1)
  TONE(900,1)
  TONE(900,2)
  @ 20,(76-LEN(ltext))/2 TO 22,(82+LEN(ltext))/2 DOUB
  @ 21,(78-LEN(ltext))/2 SAY " "+ltext+" "
  lkey = INKEY(0)
  RESTSCREEN(20,0,24,79,lscreen)
  RETU lkey<>27
