*:*********************************************************************
*:
*: Procedure file: D:\DIALER\DIALER.PRG
*:
*:         System: Phone Auto-Dialer
*:         Author: David L. Smith
*:      Copyright (c) 1991, David L. Smith
*:  Last modified: 10/29/91     10:05
*:
*:  Procs & Fncts: SBOX()
*:               : MAKE_FILE()
*:               : DB_EDIT()
*:               : DB_DIAL()
*:
*:          Calls: SBOX()             (function  in DIALER.PRG)
*:               : MAKE_FILE()        (function  in DIALER.PRG)
*:               : DB_EDIT()          (function  in DIALER.PRG, called from dbeditit())
*:               : DB_DIAL()          (function  in DIALER.PRG, called from dbeditit())
*:               : P_BACK.PRG
*:
*:           Uses: &LIST_NAME         
*:               : D_SETUP.DBF        
*:
* Comments      :I captured this message fragment from the Clipper Echo
*                and used it as a basis for starting the program:
*
*    Rtn         =  chr(13)+chr(10)
*     DialString  = "AT"+Rtn+"AT~"+Rtn+CnfgDial+CnfgPrefix+TelNum+Rtn
*     for InCount =  1 to len(DialString)
*        fwrite(DialHandle,substr(DialString,InCount,1))
*        iif(CnfgPace>0,inkey(CnfgPace),inkey())
*    next
*     Message('Wait for connection, pick up phone and press a key.',0)
*     inkey(60)
*     fwrite(DialHandle,'~+++~ATH0'+Return)
*     fclose(DialHandle)
*
*   You don't need the chr(10) and a ";" will allow the modem to
*   disconnect after dialing:
*
*   fwrite(dialhandle, dialstring+';'+CHR(13))
*              ---OR---
*   fwrite(dialhandle, dialstring+';H0'+CHR(13))
*
*:      Documented 10/29/91 at 10:15                SNAP!  version 4.97
*:*********************************************************************

*Set Environment
SET BELL OFF
SET SCOR OFF
SET CURS OFF
SET ESCA OFF
SET SOFT ON
SET WRAP ON
SET CONF ON
SET MESSAGE TO 23 CENTER
SETCANCEL(.T.)

*Setup Arrays and memvars
DECL FILE_CK[3],PORTS[4],TYPES[2],DIALS[2]
FILE_CK[1]="STOP - Change Name                "
FILE_CK[2]="OK   - I'll Edit that List        "
FILE_CK[3]="ZAP  - Erase Old List and Continue"
PORTS[1]="COM1"
PORTS[2]="COM2"
PORTS[3]="COM3"
PORTS[4]="COM4"
TYPES[1]="Tone "
TYPES[2]="Pulse"
DIALS[1]="ON -Hook"
DIALS[2]="OFF-Hook"
MARKDEL=.F.
MESS1="Listen for ringing and pick up the phone when ready ..."
MESS2="Pickup the phone but DONT put it too close to your ear!"

*Check for color card and set colors
IF ISCOLOR()
   COL1="W+/B,N/BG,B,B,W+/B"                     && Normal
   COL2="B+/W"                                   && Inverse
   COL3="W+*/B"                                  && Blinking
   COL4="W+/R,N/W"                               && Pop-up Boxes
ELSE
   COL1="w+/n,n/W,n,n,W+/n"                      && Ditto in mono
   COL2="n/w,W/N"
   COL3="w+*/n"
   COL4="N/W,W+/N"
ENDI (ISCOLOR())

*Save DOS screen for nice clean exit
DOS_SCRN=SAVESCREEN(0,0,24,79)

SETCOLOR(COL1)

CLEA
@ 0, 0 TO 24,79 DOUB
@ 4, 1 TO  4,78 DOUB
@ 2,29 SAY "A U T O   D I A L E R"
@ 3,72 SAY "V 1.0"

*Main Program Loop
DO WHIL .T.
   @ 5,1 CLEA TO 23,78
   @ 7 ,25 PROM "  1. Create a New Phone List  "
   @ 9 ,25 PROM "  2. Edit a Phone List        "
   @ 11,25 PROM "  3. Dial a Phone List        "
   @ 13,25 PROM "  4. Setup Dialing Program    "
   @ 15,25 PROM "  5. Backup Files             "
   @ 17,25 PROM "  6. Exit Program             "
   MENU TO CHOICE
   DO CASE
   CASE CHOICE = 6
      SET CURS ON
      RESTSCREEN(0,0,24,79,DOS_SCRN)
      QUIT
      
   CASE CHOICE = 1
      *Create a new list
      OLD_SCREEN=SAVESCREEN(5,1,23,78)
      DO WHIL .T.
         LIST_NAME=SPAC(6)
         SBOX(8,14,17,66,COL4)
         @ 10,20 SAY "Select a name for this NEW Phone List: "
         @ 12,37 GET LIST_NAME PICT "@A!"
         SET CURS ON
         READ
         SET CURS OFF
         LIST_NAME="PH"+TRIM(LIST_NAME)+".DBF"
         IF FILE(LIST_NAME)
            *Whoops name already exists!
            @ 9,15 CLEA TO 16,65
            @ 9,19 SAY "You already have a Phone List by that name!"
            SBOX(11,22,15,58,COL4)
            @ 11,25 SAY "[ Please Select Next Action ]"
            @ 15,32 SAY "[ ESC = Panic ]"
            PEEK=ACHOICE(12,23,14,57,FILE_CK)
            IF PEEK=1
               *LOOP around to rename
            ELSE
               EXIT
            ENDI (PEEK=1)
         ELSE
            PEEK=3
            EXIT
         ENDI (FILE(LIST_NAME))
      ENDD (.T.)
      @ 9,15 CLEA TO 16,65
      IF PEEK=0
         *Esc Pressed
         SETCOLOR(COL1)
         LOOP
      ELSEIF PEEK=3
         OLD_COLOR=SETCOLOR("W+*/R")
         @ 12,35 SAY "Creating Database"
         SETCOLOR(OLD_COLOR)
         MAKE_FILE(LIST_NAME)
         ANS=.F.
         @ 9,15 CLEA TO 16,65
         @ 12,20 SAY "Would you like to add phone numbers now? ";
            GET ANS PICT "Y"
         SET CURS ON
         READ
         SET CURS OFF
      ELSE
         ANS=.T.
      ENDI (PEEK=0)
      IF ANS
         USE &LIST_NAME
         SAY_NAME="[ "+SUBS(LIST_NAME,3,AT(".",LIST_NAME)-3)+" Phone List ]"
         SBOX(5,14,22,66,COL4)
         @ 5 ,40-LEN(SAY_NAME)/2  SAY SAY_NAME
         @ 22,22 SAY "[ F2=Add  F6=Edit  F7=Del  F9=Exit ]"
         DECL ARRYF[2]
         ARRYF[1]="NAME"
         ARRYF[2]="PHONE"
         dbedit(6,15,21,65,ARRYF,"db_edit",.T.,.T.,""," ",.T.)
         IF MARKDEL
            ANS=.F.
            @ 9,20 CLEA TO 14,60
            SBOX(9,20,14,60,COL4)
            @ 11,22 SAY "Would you like to PERMANENTLY remove"
            @ 12,22 SAY "records marked for deletion now? " GET ANS PICT "Y"
            SET CURS ON
            READ
            SET CURS OFF
            IF ANS
               PACK
               MARKDEL=.F.
            ENDI (ans)
         ENDI (markdel)
      ENDI (ANS)
      CLOS DATABASES
      SETCOLOR(COL1)
      RESTSCREEN(5,1,23,78,OLD_SCREEN)
      RELE ARRYF,SAY_NAME,LIST_NAME,ANS,PEEK,OLD_SCREEN,OLD_COLOR
      
   CASE CHOICE = 2
      *Edit an existing List
      OLD_SCREEN=SAVESCREEN(5,1,23,78)
      DECL FILE_LIST[ADIR("PH*.DBF")]
      ADIR("PH*.DBF",FILE_LIST)
      ASORT(FILE_LIST)
      FOR X=1 TO LEN(FILE_LIST)
         FILE_LIST[x]=SUBS(FILE_LIST[x],3,AT(".",FILE_LIST[x])-3)
      NEXT
      SBOX(5,14,22,66,COL4)
      @ 6 ,28  SAY "Select Phone List to Edit"
      SBOX(7,35,21,45,COL4)
      *      @ 21,36 SAY IIF(LEN(FILE_LIST)>13,"[More]","")
      PEEK=ACHOICE(8,36,20,44,FILE_LIST)
      IF PEEK=0
         *ESC Pressed
      ELSE
         LIST_NAME="PH"+FILE_LIST[peek]+".DBF"
         USE &LIST_NAME
         SAY_NAME="[ "+SUBS(LIST_NAME,3,AT(".",LIST_NAME)-3)+" Phone List ]"
         SBOX(5,14,22,66,COL4)
         @ 5 ,40-LEN(SAY_NAME)/2  SAY SAY_NAME
         @ 22,22 SAY "[ F2=Add  F6=Edit  F7=Del  F9=Exit ]"
         DECL ARRYF[2]
         ARRYF[1]="NAME"
         ARRYF[2]="PHONE"
         dbedit(6,15,21,65,ARRYF,"db_edit",.T.,.T.,""," ",.T.)
         IF MARKDEL
            ANS=.F.
            @ 9,20 CLEA TO 14,60
            SBOX(9,20,14,60,COL4)
            @ 11,22 SAY "Would you like to PERMANENTLY remove"
            @ 12,22 SAY "records marked for deletion now? " GET ANS PICT "Y"
            SET CURS ON
            READ
            SET CURS OFF
            IF ANS
               PACK
               MARKDEL=.F.
            ENDI (ans)
         ENDI (markdel)
      ENDI (PEEK=0)
      CLOS DATABASES
      SETCOLOR(COL1)
      RESTSCREEN(5,1,23,78,OLD_SCREEN)
      RELE ARRYF,SAY_NAME,LIST_NAME,FILE_LIST,PEEK,OLD_SCREEN,X,ANS
      
   CASE CHOICE = 3
      *Dial the phone
      OLD_SCREEN=SAVESCREEN(5,1,23,78)
      DECL FILE_LIST[ADIR("PH*.DBF")]
      ADIR("PH*.DBF",FILE_LIST)
      ASORT(FILE_LIST)
      FOR X=1 TO LEN(FILE_LIST)
         FILE_LIST[x]=SUBS(FILE_LIST[x],3,AT(".",FILE_LIST[x])-3)
      NEXT
      SBOX(5,13,21,67,COL4)
      @ 6 ,28  SAY "Select Phone List to Dial"
      SBOX(7,35,20,45,COL4)
      *      @ 21,36 SAY IIF(LEN(FILE_LIST)>13,"[More]","")
      PEEK=ACHOICE(8,36,19,44,FILE_LIST)
      IF PEEK=0
         *ESC Pressed
      ELSE
         SELECT A
         USE D_SETUP
         LIST_NAME="PH"+FILE_LIST[peek]+".DBF"
         SELECT B
         USE &LIST_NAME
         SAY_NAME="[ "+SUBS(LIST_NAME,3,AT(".",LIST_NAME)-3)+" Phone List ]"
         SBOX(5,13,21,67,COL4)
         @ 5 ,40-LEN(SAY_NAME)/2  SAY SAY_NAME
         @ 23,3 SAY "[F2=Dial Entry  F3=Dial All  F4=Dial Tags  F5=Tag  F6=Clear Tags  F9=Exit]"
         DECL ARRYF[3],ARRYP[3],ARRYN[3]
         ARRYF[3]="IIF(CHECK,CHR(17),' ')"
         ARRYF[1]="NAME"
         ARRYF[2]="PHONE"
         ARRYN[3]=" "
         ARRYN[1]="Name"
         ARRYN[2]="Phone Number"
         dbedit(6,14,20,66,ARRYF,"db_dial",.T.,ARRYN,""," ",.T.)
      ENDI (PEEK=0)
      CLOS DATABASES
      SETCOLOR(COL1)
      RESTSCREEN(5,1,23,78,OLD_SCREEN)
      RELE ARRYF,SAY_NAME,LIST_NAME,FILE_LIST,PEEK,OLD_SCREEN,X,BEFO
      
   CASE CHOICE = 4
      *Setup
      OLD_SCREEN=SAVESCREEN(5,1,23,78)
      SBOX(5,10,22,70,COL4)
      @ 7,13 SAY "Select the Communication Port your Modem is assigned,"
      @ 8,13 SAY "if you don't know try COM2, it is the most common ..."
      SBOX(10,37,15,42,COL4)
      PORT_TYPE=ACHOICE(11,38,14,41,PORTS)
      IF PORT_TYPE=0
         LOOP
      ENDI (PORT_TYPE=0)
      @ 6,11 CLEA TO 21,69
      @ 7,13 SAY "Select the type of Phone Line you have, if you don't"
      @ 8,13 SAY "know try TONE, it is the most common ..."
      SBOX(12,37,15,43,COL4)
      TONE_TYPE=ACHOICE(13,38,14,42,TYPES)
      IF TONE_TYPE=0
         LOOP
      ENDI (TONE_TYPE=0)
*      @  6,11 CLEA TO 21,69
*      @  7,14 SAY "Finally you need to select the type of Dialing you"
*      @  8,14 SAY "prefer.  ON-Hook means the modem will dial and the"
*      @  9,14 SAY "speaker will be on to check for ringing or a busy "
*      @ 10,14 SAY "signal, the modem will cut out as soon as you pick"
*      @ 11,14 SAY "up the phone.  OFF-Hook means you will pick up the"
*      @ 12,14 SAY "phone and monitor the call in the phone speaker,  "
*      @ 13,14 SAY "the modem will cut out right after dialing."
*      SBOX(15,35,18,44,COL4)
*      DIALS_TYPE=ACHOICE(16,36,17,43,DIALS)
*      IF DIALS_TYPE=0
*         LOOP
*      ENDI (DIALS_TYPE=0)
      @ 6,11 CLEA TO 21,69
      OLD_COLOR=SETCOLOR("W+*/R")
      @ 12,34 SAY "Saving Setup"
      SETCOLOR(OLD_COLOR)
      USE D_SETUP
      REPL PORT WITH PORTS[port_type],TYPE WITH IIF(TONE_TYPE=1,"DT","PT")
*         DIAL WITH IIF(DIALS_TYPE=1,.T.,.F.)
      CLOS DATABASES
      SETCOLOR(COL1)
      RESTSCREEN(5,1,23,78,OLD_SCREEN)
      RELE PORT_TYPE,TONE_TYPE,OLD_COLOR,OLD_SCREEN
      
   CASE CHOICE=5
      BEFO=SAVESCREEN(0,0,24,79)
      DO P_BACK WITH "PH*.DBF"
      RESTSCREEN(0,0,24,79,BEFO)
      RELE BEFO
      
   ENDC
   
ENDD (.T.)
                    
*!*********************************************************************
*!
*!       Function: MAKE_FILE()
*!
*!      Called by: DIALER.PRG                        
*!
*!           Uses: TEMP.DBF           
*!               : &LIST_NAME         
*!
*!*********************************************************************
PROC MAKE_FILE
PARA LIST_NAME
SELECT 9
CREA TEMP
USE TEMP
APPE BLAN
REPL FIELD_NAME WITH "NAME",FIELD_TYPE WITH "C",FIELD_LEN WITH 25
APPE BLAN
REPL FIELD_NAME WITH "PHONE",FIELD_TYPE WITH "C",FIELD_LEN WITH 25
APPE BLAN
REPL FIELD_NAME WITH "CHECK",FIELD_TYPE WITH "L",FIELD_LEN WITH 1
USE
CREA &LIST_NAME FROM TEMP
USE
ERAS TEMP
RETU

*!*********************************************************************
*!
*!       Function: DB_EDIT()
*!
*!      Called by: DIALER.PRG                        
*!
*!*********************************************************************
FUNC DB_EDIT
PARA DBMODE,FLD
GETIT=ARRYF[fld]
DO CASE
CASE DBMODE=0
   @ 7,35 SAY IIF(DELETED(),"[Deleted]","")
   RETU 1
CASE DBMODE=1 .OR. DBMODE=2
   TONE(349,3)
   TONE(300,5)
   RETU 1
CASE LASTKEY() = 27 .OR. LASTKEY() = -8
   RETU 0
CASE LASTKEY() = -1
   SET CURS ON
   APPE BLAN
   @ ROW(),15 GET NAME
   @ ROW(),41 GET PHONE
   READ
   SKIP -13
   SET CURS OFF
   RETU 2
CASE LASTKEY() = -5
   *Edit
   SET CURS ON
   @ ROW(),COL() GET &GETIT
   READ
   SET CURS OFF
   RETU 2
CASE LASTKEY() = -6
   IF DELETED()
      RECA
   ELSE
      DELE
      MARKDEL=.T.
   ENDI (DELETED())
   @ 7,35 SAY IIF(DELETED(),"[Deleted]","")
   RETU 1
OTHE
   RETU 1
ENDC

*!*********************************************************************
*!
*!       Function: DB_DIAL()
*!
*!      Called by: DIALER.PRG                        
*!
*!          Calls: SBOX()             (function  in DIALER.PRG)
*!
*!    Other Files: A->PORT
*!
*!*********************************************************************
FUNC DB_DIAL
PARA DBMODE,FLD
*GETIT=ARRYF[fld]
DO CASE
CASE DBMODE=0
   @ 7,35 SAY IIF(DELETED(),"[Deleted]","")
   RETU 1
CASE DBMODE=1 .OR. DBMODE=2
   TONE(349,3)
   TONE(300,5)
   RETU 1
CASE LASTKEY() = 27 .OR. LASTKEY() = -8
   RETU 0
CASE LASTKEY() = -4                              && F5 = TAG
   IF CHECK
      REPL CHECK WITH .F.
   ELSE
      REPL CHECK WITH .T.
   ENDI (CHECK)
   RETU 1
CASE LASTKEY() = -5                              && F6 = CLEA Tags
   REC_RETURN=RECN()
   REPL ALL CHECK WITH .F.
   GOTO REC_RETURN
   RETU 2
CASE LASTKEY() = -1                              && F2 = Dial
   * Dial Selected Entry
   BEFO=SAVESCREEN(10,10,17,72)
   SBOX(10,10,16,70,COL4)
   @ 16,29 SAY "[ Press ESC to Abort ]"
   @ 12,12 SAY IIF(A->DIAL,MESS1,MESS2)
   @ 14,40-(30+LEN(TRIM(B->NAME)))/2  SAY ;
      "Press almost any key to dial: "+TRIM(B->NAME)
   INKEY(0)
   IF LASTKEY()=27
      RESTSCREEN(10,10,17,72,BEFO)
      RETU 1
   ENDI (LASTKEY()=27)
   DIALHANDLE=FOPEN(A->PORT,1)
   IF DIALHANDLE=-1
      TONE(349,3)
   ELSE
      DIALSTRING="AT"+A->TYPE+TRIM(B->PHONE)+IIF(A->DIAL,";",";H0")
      IF_ERROR=FWRITE(DIALHANDLE, DIALSTRING+CHR(13))
      IF IF_ERROR=0
         TONE(349,3)
         TONE(349,3)
      ELSE
         @ 11,11 CLEA TO 15,69
         IF A->DIAL
            @ 13,23 SAY "Press any key to disconnect modem"
            INKEY(0)
            DIALSTRING='~~~+++~~~AT;H0'
            FWRITE(DIALHANDLE, DIALSTRING+CHR(13)) 
         ELSE
            INKEY(6)
         ENDIF
      ENDI (IF_ERROR=0)
      FCLOSE(DIALHANDLE)
   ENDI (DIALHANDLE=-1)
   RESTSCREEN(10,10,17,72,BEFO)
   RETU 1
CASE LASTKEY() = -2                              && Dial ALL
   * Dial All Entries
   GO TOP
   BEFO=SAVESCREEN(10,10,17,72)
   DO WHIL !EOF()
      SBOX(10,10,16,70,COL4)
      @ 16,19 SAY "[ ESC=Abort    SPACEBAR=Skip This Number ]"
      @ 12,12 SAY IIF(A->DIAL,MESS1,MESS2)
      @ 14,40-(30+LEN(TRIM(B->NAME)))/2 SAY ;
         "Press almost any key to dial: "+TRIM(B->NAME)
      INKEY(0)
      IF LASTKEY()=27
         EXIT
      ELSEIF LASTKEY()=32
         SKIP
         LOOP
      ELSE
         * Keep going
      ENDI (LASTKEY()=27)
      DIALHANDLE=FOPEN(A->PORT,1)
      IF DIALHANDLE=-1
         TONE(349,3)
      ELSE
         DIALSTRING="AT"+A->TYPE+TRIM(B->PHONE)+IIF(A->DIAL,";",";H0")
         IF_ERROR=FWRITE(DIALHANDLE, DIALSTRING+CHR(13))
         IF IF_ERROR=0
            TONE(349,3)
            TONE(349,3)
         ELSE
            @ 11,11 CLEA TO 15,69
            IF A->DIAL
               @ 13,26 SAY "Press any key for next call."
               INKEY(0)
               DIALSTRING='~~~+++~~~AT;H0'
               FWRITE(DIALHANDLE, DIALSTRING+CHR(13)) 
            ELSE
               INKEY(6)
            ENDIF
         ENDI (IF_ERROR=0)
         FCLOSE(DIALHANDLE)
      ENDI (DIALHANDLE=-1)
      SKIP
   ENDD (!EOF())
   RESTSCREEN(10,10,17,72,BEFO)
   RETU 1
CASE LASTKEY() = -3                              && Dial Tags
   * Dial Tagged Entries
   GO TOP
   BEFO=SAVESCREEN(10,10,17,72)
   DO WHIL !EOF()
      IF CHECK
         SBOX(10,10,16,70,COL4)
         @ 16,19 SAY "[ ESC=Abort    SPACEBAR=Skip This Number ]"
         @ 12,12 SAY IIF(A->DIAL,MESS1,MESS2)
         @ 14,40-(30+LEN(TRIM(B->NAME)))/2 SAY ;
            "Press almost any key to dial: "+TRIM(B->NAME)
         INKEY(0)
         IF LASTKEY()=27
            EXIT
         ELSEIF LASTKEY()=32
            SKIP
            LOOP
         ELSE
            * Keep going
         ENDI (LASTKEY()=27)
         DIALHANDLE=FOPEN(A->PORT,1)
         IF DIALHANDLE=-1
            TONE(349,3)
         ELSE
            DIALSTRING="AT"+A->TYPE+TRIM(B->PHONE)+IIF(A->DIAL,";",";H0")
            IF_ERROR=FWRITE(DIALHANDLE, DIALSTRING+CHR(13))
            IF IF_ERROR=0
               TONE(349,3)
               TONE(349,3)
            ELSE
               @ 11,11 CLEA TO 15,69
               IF A->DIAL
                  @ 13,26 SAY "Press any key for next call."
                  INKEY(0)
                  DIALSTRING='~~~+++~~~AT;H0'
                  FWRITE(DIALHANDLE, DIALSTRING+CHR(13)) 
               ELSE
                  INKEY(6)
               ENDIF
            ENDI (IF_ERROR=0)
            FCLOSE(DIALHANDLE)
         ENDI (DIALHANDLE=-1)
      ENDI (CHECK)
      SKIP
   ENDD (!EOF())
   RESTSCREEN(10,10,17,72,BEFO)
   RETU 1
OTHE
   RETU 1
ENDC


*!*********************************************************************
*!
*!       Function: SBOX()
*!
*!      Called by: DIALER.PRG                        
*!               : DB_DIAL()          (function  in DIALER.PRG, called from dbeditit())
*!
*!*********************************************************************
FUNC SBOX
PARA X1,Y1,X2,Y2,CLR,TEXTSCR
PRIV V,H,I
IF PCOUNT()=6
   RESTSCREEN(X1,Y1,X2,Y2,TEXTSCR)
ENDI (PCOUNT()=6)
V=SAVESCREEN(X1+1,Y2+1,X2+1,Y2+2)
H=SAVESCREEN(X2+1,Y1+2,X2+1,Y2+2)
FOR I=2 TO LEN(H) STEP 2
   H=STUFF(H,I,1,CHR(7))
NEXT (I)
FOR I=2 TO LEN(V) STEP 2
   V=STUFF(V,I,1,CHR(7))
NEXT (I)
SETCOLOR(CLR)
IF PCOUNT() < 6
   @ X1,Y1 CLEA TO X2,Y2
ENDI (PCOUNT() < 6)
@ X1,Y1 TO X2,Y2 DOUB
RESTSCREEN(X1+1,Y2+1,X2+1,Y2+2,V)
RESTSCREEN(X2+1,Y1+2,X2+1,Y2+2,H)
RETU .F.
*: EOF: DIALER.PRG
