*:*********************************************************************
*:
*: Procedure file: D:\DIALER\P_BACK.PRG
*:
*:         System: Phone Auto-Dialer
*:
*:  Procs & Fncts: PBACK()
*                  HSORRY()   - Places a message in a centered box.
*                  HPROMPT()  - Displays a prompt at the bottom of the screen.
*                  HYES()     - Asks for YES or NO.
*                  PADR()     - Pad a string to the right. (take out for Clipper 5.0)
*                  PADL()     - Pad a string to the left.  (take out for Clipper 5.0)
*:
*:         Set by: DIALER.PRG                        
*:
*:          Calls: PBACK()            (function  in P_BACK.PRG)
*:
* Comments       :This program was written using Clipper S87.
*                 For Clipper 5.0 take out functions PADL() and PADR()
*
* Copyright: (c) 1991 by Per Kjellqvist
*                        Le Caddie 4
*                        CH - 1936 VERBIER
*                        Switzerland            CompuServe 71540,2311
* ============================================================================
*
*:      Documented 10/29/91 at 10:15                SNAP!  version 4.97
*:*********************************************************************

PARA FILE_MASK
PBACK(FILE_MASK)
RETU

FUNC PBACK
PARA LWCARD
PRIV LROW,LCLM,LBYTE_TOT,LBYTE_COP,LFILE_NO,LIN,LXX,LREAD,LDRIVE,LBACKNO,;
   LDISK_NO,LINC,LBUFFER,LOUT,LPOS,LWRITE,LNAME,LFILES,LKEY,LERROR,LTIME,;
   LTEXT,LDEL,LOK,LTARGET,LLOG,LSCREEN,LPICK[2],LPATH,;
   PX_DISK, PX_NUMBER, PX_BYTE, PX_WCARD, PX_FILES,;
   L_01,L_02,L_03,L_04,L_05,L_06,L_07,L_08,L_09,L_10,;
   L_11,L_12,L_13,L_14,L_15,L_16,L_17,L_18,L_19,L_20

* - INITIALIZE TEXT STRINGS ------------------------------------------------
L_01 = " BACKUP FILES TO REMOVABLE MEDIA "
L_02 = "Estimated Time"
L_03 = "Bytes to Copy"
L_04 = "Bytes Copied"
L_05 = "Remains"
L_06 = "Completed"
L_07 = "Diskettes Needed:"
L_08 = "PLEASE Put Backup Disk No ["
L_09 = "] in drive ["
L_10 = "Kb"
L_11 = "Mb"
L_12 = "Confirmation:                          [Letter] ["+CHR(27)+"] ["+CHR(26)+"] []-Select [ESC]-Quit"
L_13 = "Drive:                                 [Letter] ["+CHR(24)+"] ["+CHR(25)+"] []-Select [ESC]-Quit"
L_14 = "Wait Mode:                 Press ANY KEY to Continue                [ESC]-Quit"
L_15 = "Backup:                          DISK ACCESS                        [ESC]-Quit"
L_16 = "Do you really want to abandon this operation ?"
L_17 = "SUCCESSFUL BACKUP"
L_18 = "Sorry, This disk has already been used"
L_19 = "Sorry, No disk in drive or Write-protected / Unformatted disk"
L_20 = "Sorry, Error or [ESC] backup is NOT COMPLETE"
LPICK[1] = " Drive A: "
LPICK[2] = " Drive B: "
* --------------------------------------------------------------------------

SET CURS OFF
CLEA
@ 00,00 TO 24,79 DOUB
@ 05,43 TO 23,78 DOUB
@ 12,44 TO 21,77
SETCOLOR(COL2)
@ 0,(80-LEN(L_01))/2 SAY L_01
SETCOLOR(COL1)

* ---- LOAD ARRAY WITH FILENAMES AND COUNT BYTES ---------------------------
LROW      = 2
LCLM      = 2
LBYTE_TOT = 0                                    && bytes TO be backed up
LFILES    = ADIR(LWCARD)                         && COUN FILES
LPATH     = LEFT(LWCARD,RAT("\",LWCARD))

IF LFILES = 0
   RETU .F.
ENDI (lfiles = 0)

PRIV ARNAME[lfiles], ARSIZE[lfiles]
ADIR(LWCARD,ARNAME,ARSIZE)                       && place filenames IN ARRA and
FOR LXX = 1 TO LFILES                            && DISP ALL names
   @ LROW,LCLM SAY SUBS(ARNAME[lxx],3,AT(".",ARNAME[lxx])-3)
   LCLM      = IF(LROW<>22,LCLM,LCLM+18)
   LROW      = IF(LROW<>22,LROW+1,2)
   LBYTE_TOT = LBYTE_TOT + ARSIZE[lxx]
NEXT (lxx)
* --------------------------------------------------------------------------

* NOTE:-----------------------------------------------------------------------
* I found the transfer speed to be approx 5600 bytes/sec with buffer size
* 4096. It might depend on your hardware so you might want to test it.
* ----------------------------------------------------------------------------
LTIME     = LBYTE_TOT/5600                       && 5600 bytes/SECO
LBACKNO   = SECO()                            && A serial NUMB FOR the backup set
LBYTE_COP = 0                                    && bytes copied so far
LINC      = 4096                                 && buffer SIZE IN bytes
LDISK_NO  = 0                                    && initialize DISK counter

@ 06,45 SAY PADR(L_02,20,".")+SPAC(4)+PADL(INT(LTIME/3600%24),2,"0")+":"+; && Hours ( % -> MOD() )
PADL(INT(LTIME/60%60),2,"0")+":"+;               && Minutes
PADL(INT(LTIME%60),2,"0")                        && Seconds
@ 07,45 SAY PADR(L_03,20,".")+TRAN(LBYTE_TOT,"99999999,999") && Bytes TO Copy.......
@ 09,45 SAY PADR(L_04,20,".")
@ 10,45 SAY PADR(L_05,20,".")
@ 11,45 SAY PADR(L_06,20,".")+SPAC(11)+"%"
@ 13,46 SAY L_07
@ 15,46 SAY PADR('5 " 360 '+L_10,20,".")+STR(INT(LBYTE_TOT/360000)+1,5)
@ 16,51 SAY PADR('1.2 '+L_11,15,".")+STR(INT(LBYTE_TOT/1200000)+1,5)
@ 18,46 SAY PADR('3 " 720 '+L_10,20,".")+STR(INT(LBYTE_TOT/720000)+1,5)
@ 19,51 SAY PADR('1.4 '+L_11,15,".")+STR(INT(LBYTE_TOT/1400000)+1,5)

* ---- USER INPUT OF DRIVE TO BACKUP TO ------------------------------------
HPROMPT(L_13)
LSCREEN = SAVESCREEN(14,34,17,45)
@ 14,34 TO 17,45
LXX     = ACHOICE(15,35,16,44,LPICK)
RESTSCREEN(14,34,17,45,LSCREEN)
* --------------------------------------------------------------------------

IF LXX > 0
   LDRIVE = CHR(64+LXX)
   LLOG   = .T.
   LROW   = 2
   LCLM   = 2
   FOR LFILE_NO = 1 TO LFILES
      LPOS    = 0
      LNAME   = ARNAME[lfile_no]
      LIN     = FOPEN(LPATH+LNAME)               && OPEN the source FILE
      LERROR  = FERROR()
      LTARGET = .T.
      DO WHIL LERROR = 0
         * -- LOG NEW DISKETTE --------------------------------------------
         IF LLOG
            LLOG     = .F.
            LTARGET  = .T.
            LDISK_NO = LDISK_NO + 1              && increment DISK NUMB
            LSCREEN  = SAVESCREEN(15,0,23,79)
            LTEXT    = L_08+LTRI(STR(LDISK_NO))+L_09+LDRIVE+"]"
            LOK      = .T.
            DO WHIL .T.
               @ 15,(76-LEN(LTEXT))/2,17,(82+LEN(LTEXT))/2 BOX ""
               *                  @ 15,(76-LEN(ltext))/2 TO 17,(82+LEN(ltext))/2 DOUB
               @ 16,(78-LEN(LTEXT))/2 SAY " "+LTEXT+" "
               HPROMPT(L_14)
               IF INKEY(0) = 27
                  LOK = .F.
                  EXIT
               ENDI (INKEY(0) = 27)
               HPROMPT(L_15)
               PX_DISK   = LDISK_NO
               PX_NUMBER = 0
               IF FILE(LDRIVE+":p_back.mem")
                  REST FROM &LDRIVE.:P_BACK.MEM ADDI
               ENDI (FILE(ldrive+":p_back.mem"))
               IF PX_DISK < LDISK_NO .AND. PX_NUMBER = LBACKNO
                  HSORRY(L_18)
               ELSE
                  IF ! FCLOSE(FCREATE(LDRIVE+":x"))
                     HSORRY(L_19)
                  ELSE
                     * --- ERASE EXISTING FILES ---------------------------
                     LXX = ADIR(LDRIVE+":*.*")
                     IF LXX > 0
                        PRIV LTMP[lxx]
                        ADIR(LDRIVE+":*.*",LTMP)
                        FOR LXX = 1 TO LEN(LTMP)
                           LDEL = LDRIVE+":"+LTMP[lxx]
                           ERAS &LDEL
                        NEXT (lxx)
                     ENDI (lxx > 0)
                     * ----------------------------------------------------
                     PX_DISK   = LDISK_NO
                     PX_NUMBER = LBACKNO
                     PX_BYTE   = LBYTE_TOT
                     PX_WCARD  = SUBS(LWCARD,RAT("\",LWCARD)+1)
                     PX_FILES  = LFILES
                     SAVE TO &LDRIVE.:P_BACK.MEM ALL LIKE PX_*
                     EXIT
                  ENDI (! FCLOSE(FCREATE(ldrive+":x")))
               ENDI (PX_disk < ldisk_no .AND. PX_number = lbackno)
            ENDD (.T.)
            RESTSCREEN(15,0,23,79,LSCREEN)
            IF ! LOK
               EXIT
            ENDI (! lok)
         ENDI (llog)
         * ----------------------------------------------------------------
         * -- OPEN TARGET FILE --------------------------------------------
         IF LTARGET
            LTARGET = .F.
            LOUT    = FCREATE(LDRIVE+":"+LNAME)
            IF FERROR() <> 0
               EXIT
            ENDI (FERROR() <> 0)
         ENDI (ltarget)
         * ----------------------------------------------------------------
         LBUFFER   = SPAC(LINC)
         LREAD     = FREAD(LIN,@LBUFFER,LINC)
         LERROR    = FERROR()
         IF LERROR = 0
            IF LREAD = 0
               FCLOSE(LOUT)
               EXIT
            ELSE
               LWRITE    = FWRITE(LOUT,LBUFFER,LREAD)
               LERROR    = FERROR()
               IF LERROR = 0
                  LPOS      = LPOS      + LWRITE
                  LBYTE_COP = LBYTE_COP + LWRITE
                  @ LROW,LCLM+13 SAY CHR(IF(INT(SECO()%2)=0,250,7))
                  @ 09,66 SAY TRAN(LBYTE_COP,"999,999,999")
                  @ 10,66 SAY TRAN(LBYTE_TOT-LBYTE_COP,"999,999,999")
                  @ 11,72 SAY TRAN(ROUN(LBYTE_COP/LBYTE_TOT*100,0),"@Z 999")
                  IF LWRITE < LREAD              && THE WHOLE FILE DID NOT FIT
                     FSEEK(LIN,LPOS)             && position pointer WHER text ended
                     FCLOSE(LOUT)                && CLOS the outfile
                     LLOG = .T.                  && LOG new DISK
                  ENDI (lwrite < lread                                     && THE WHOLE FILE DID NOT FIT)
               ENDI (lerror = 0)
            ENDI (lread = 0)
         ENDI (lerror = 0)
         LKEY = NEXTKEY()                        && READ KEYB buffer, and clear it
         KEYB CHR(0)                         && CLEA KEYB buffer
         INKEY()                                 && - " -
         IF LKEY = 27                            && [ESC] was pressed WHIL in the loop
            TONE(900,5)
            TONE(900,5)
            LERROR = IF(HYES(19,L_16),1,LERROR)
         ENDI (lkey = 27                                                   && [ESC] was pressed)
         IF LERROR <> 0
            @ LROW,LCLM+13 SAY " "
            IF FCLOSE(LOUT)
               ERAS &LDRIVE.:&LNAME
            ENDI (FCLOSE(lout))
         ENDI (lerror <> 0)
      ENDD (lerror = 0)
      FCLOSE(LIN)
      IF ARSIZE[lfile_no] <> LPOS .OR. LERROR <> 0
         EXIT
      ELSE
         @ LROW,LCLM+13 SAY ""
         LCLM = IF(LROW<>22,LCLM,LCLM+18)
         LROW = IF(LROW<>22,LROW+1,2)
      ENDI (ARsize[lfile_no] <> lpos .OR. lerror <> 0)
   NEXT (lfile_no)
   IF LBYTE_TOT = LBYTE_COP
      HSORRY(L_17)
   ELSE
      HSORRY(L_20)
   ENDI (lbyte_tot = lbyte_cop)
ENDI (lxx > 0)

SET CURS ON
RETU (LBYTE_TOT = LBYTE_COP)


* ============================================================================
* ============================================================================
* Syntax:   HSORRY(<expC>)
* Argument: <expC> is string to be shown on screen.
* Return:   .F. if ESC was pressed, otherwise .T.
* Usage:    Used to display a message when the user has made a misstake.
* Note:     The message is placed in a box, and is displayed on line 21
* Example:  HSORRY("Sorry, The name is not valid")
* ============================================================================
FUNC HSORRY
PARA LTEXT
PRIV LSCREEN,LKEY

LSCREEN = SAVESCREEN(20,0,24,79)
TONE(900,1)
TONE(900,1)
TONE(900,1)
TONE(900,2)
@ 20,(76-LEN(LTEXT))/2 TO 22,(82+LEN(LTEXT))/2 DOUB
@ 21,(78-LEN(LTEXT))/2 SAY " "+LTEXT+" "
LKEY = INKEY(0)
RESTSCREEN(20,0,24,79,LSCREEN)
RETU LKEY<>27


* ============================================================================
* ============================================================================
* Syntax:   HPROMPT(<expC>)
* Argument: <expC> is the text to be displayed on line 24 in inverse text.
* Return:   .T.
* Usage:    To display a prompt line corresponding to current action.
* Note:
* Example:  HPROMPT(Px005)
* ============================================================================
FUNC HPROMPT
PARA LTEXT

SETCOLOR(COL2)
@ 24,1 SAY PADR(LTEXT,78)
SETCOLOR(COL1)
RETU .T.


* ============================================================================
* ============================================================================
* Syntax:   HYES(<expN>,<expC>)
* Argument: <expN1> row for text
*           <expC>  question string
* Return:   .T. for answer=YES  .F. for answer=.F. or [ESC]
* Usage:    Used to prompt a YES or NO question to the user.
* Note:     selecting NO and pressing [ESC] gives the same result
* Example:  lanswer = HYES(20,"Do you want to quit?")
* ============================================================================
FUNC HYES
PARA LROW, LSTRING
PRIV LKEY, LSCREEN, LNO

LSCREEN = SAVESCREEN(LROW-1,0,LROW+1,79)
LNO     = LEN(LSTRING)
@ LROW-1,(67-LNO)/2 TO LROW+1,(91+LNO)/2 DOUB
@ LROW,(71-LNO)/2 SAY LSTRING + SPAC(10)
@ LROW,(74+LNO)/2 PROM "YES"
@ LROW,(83+LNO)/2 PROM "NO "
HPROMPT(L_12)
MENU TO LKEY
RESTSCREEN(LROW-1,0,LROW+1,79,LSCREEN)
RETU LKEY = 1


* ============================================================================
* ============================================================================
* Syntax:   PADR(exp,expN,<expC>)
* Argument: exp    = character, numeric or date value to pad
*           expN   = lenght of character string to return
*           <expC> = character to pad, if not specified spaces are used
* Return:   String
* Usage:    pad a character string on the right with a fill character
* Example:  ? "["+PADR("per",10)+"]"
*           gives   [per       ]
*           ? PADR("per",10,".")
*           gives    per.......
* ============================================================================
FUNC PADR
PARA LEXP, LNO, LPAD
RETU LEFT(ALLTRIM(TRANS(LEXP,""))+REPLICATE(IF(PCOUNT()=3,LPAD," "),LNO),LNO)


* ============================================================================
* ============================================================================
* Syntax:   PADL(exp,expN,<expC>)
* Argument: exp    = character, numeric or date value to pad
*           expN   = lenght of character string to return
*           <expC> = character to pad, if not specified spaces are used
* Return:   String
* Usage:    pad a character string on the left with a fill character
* Example:  ? "["+PADL("per",10)+"]"
*           gives   [       per]
*           ? PADL("per",10,"0")
*           gives    0000000per
* ============================================================================
FUNC PADL
PARA LEXP, LNO, LPAD
RETU RIGHT(REPLICATE(IF(PCOUNT()=3,LPAD," "),LNO)+ALLTRIM(TRANS(LEXP,"")),LNO)
*: EOF: P_BACK.PRG
