*** MAKECALL.PRG
*** Displays phone number(s) in window, scrolls, selects and dials
*** MJE Associates/DAISYWHEEL, INC.
*** Written by Marshall Ewig
*** Last revised:  6/01/88
*** Language: dBXL/Quicksilver

PROCEDURE MAKECALL
PRIVATE nctr,sctr,row,key,dialwtr,num

*  Note: colors are for mono only;  adjust for color


* ----------------------------------------------------------------------------
*  Determine number of available phone numbers, if any
SELECT 1
SEEK m->idno
IF .NOT. FOUND()                                && highly unlikely
   * in window area 1... prompt
   @ 0,0
   ?? CHR(7)
   @ 0,0 SAY "NO PHONE NUMBER ON FILE"          && or other error routine
ELSE
   nctr = 1

   * Initialize phone numbers, locations to subscripted variables
   DO WHILE idno = m->idno
      sctr=STR(nctr,1)
      phone&sctr = phone
      phoneloc&sctr = phoneloc
      nctr = nctr+1
      SKIP
   ENDDO

   * -------------------------------------------------------------------------
   *  POINT X
   *  Regardless of what method used to store phone number data, you must
   *  have, at this point, n number of phone numbers and a corresponding
   *  number of phone locations stored to subscripted memory variables:
   *  phone[n], phoneloc[n].  Numeric variable nctr-1 should equal the
   *  the available numbers

   nctr=nctr-2                                  && adjust counter
   dialwtr=4                                    && set top row of window

   *---------------------------------------------------------------------------
   * set up windows  (hardcoded columns can, of course, be changed;  35 column
   * spaces are needed with this design)

   WSET WINDOW numbers TO dialwtr,43,dialwtr+nctr,78 COLOR w/n,i/n,w+/n DOUBLE

   WSET WINDOW dialmsg TO dialwtr+nctr+2,43,dialwtr+nctr+2,78 COLOR w+/n,,w+n;
   FRAME CHR(204),CHR(205),CHR(185),CHR(186),CHR(186),CHR(200),CHR(205),CHR(188)


   *---------------------------------------------------------------------------
   * Select next available window area
   windno = 0
   DO WHILE WACTIVE()
      windno = windno+1
      WSELECT windno
   ENDDO

   *---------------------------------------------------------------------------
   * Open numbers window
   WUSE numbers TITLE "AVAILABLE NUMBERS"


   *---------------------------------------------------------------------------
   * Display and keypress for a single phone number
   IF nctr = 0
      SET COLOR TO i/n
      @ 0,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+"  "+phoneloc&sctr

      WSELECT windno+1                                  && display instructions
      WUSE dialmsg
      @ 0,0 SAY "PRESS <Enter>"+CHR(17)+CHR(196)+CHR(217)+" TO DIAL"

      WSELECT windno
      * keypress loop
      key = 0
      DO WHILE key <> 13
         IF key = 27                                    && Escape
            WCLOSE WINDNO TO WINDNO+1
            RETURN
         ENDIF
         key = inkey()
     ENDDO

   * Display and keypress for more than one number
   ELSE
      FOR row = 0 to nctr                               && initial display
         sctr=STR(row+1,1)
         @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+"  "+phoneloc&sctr
      NEXT row
      row = 0
      SET COLOR TO i/n
      sctr=STR(row+1,1)
      @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+"  "+phoneloc&sctr
 
      WSELECT windno+1                                  && display instructions
      WUSE dialmsg
      @ 0,0 SAY "SELECT WITH "+CHR(25)+" "+CHR(24)+"  <Enter> "+CHR(17)+;
               CHR(196)+CHR(217)+" TO DIAL"

      WSELECT windno
      * keypress loop
      key = 0
      DO WHILE key <> 13                                && return key
         DO CASE
         CASE key = 27                                  && Escape
            WCLOSE WINDNO TO WINDNO+1
            RETURN
         CASE key = 5                                   && up arrow
            IF row <> 0                                 && not top row
               SET COLOR TO w/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                 "  "+phoneloc&sctr
               row = row-1
               sctr=STR(row+1,1)
               SET COLOR TO i/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                "  "+phoneloc&sctr
            ELSE                                        && top row
               SET COLOR TO w/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                 "  "+phoneloc&sctr
               row = nctr
               sctr=STR(nctr+1,1)
               SET COLOR TO i/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                "  "+phoneloc&sctr
            ENDIF
         CASE key = 24                                  && down arrow
            IF row < nctr                               && not bottom row
               SET COLOR TO w/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                   "  "+phoneloc&sctr
               row = row+1
               sctr=STR(row+1,1)
               SET COLOR TO i/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                   "  "+phoneloc&sctr
            ELSE                                        && bottom row
               SET COLOR TO w/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                     "  "+phoneloc&sctr
               row = 0
               sctr=STR(row+1,1)
               SET COLOR TO i/n
               @ row,0 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")+;
                   "  "+phoneloc&sctr
            ENDIF
         ENDCASE
         key = inkey()
      ENDDO (keypress loop)
   ENDIF (one number)


   *---------------------------------------------------------------------------
   * initialize and adjust number to dial
   IF nctr = 0
      num = phone1
   ELSE
      sctr=STR(row+1,1)
      num= phone&sctr
   ENDIF

   IF SUBSTR(num,1,3) = m->loc_ac
      num=SUBSTR(num,4,7)
   ELSE
      num=m->ld_pfx+num
   ENDIF

   *  display dialing message
   WSELECT windno+1
   SET COLOR TO w+*/n
   @ 0,0
   @ 0,2 SAY " DIALING -->"
   SET COLOR TO w+/n
   @ 0,COL()+2 SAY TRANSFORM(phone&sctr,"@R (999) 999-9999")

   *  Call dialing routine
   DO DIALNUM with num,m->dialport

ENDIF (no number)
WCLOSE WINDNO TO WINDNO+1
RETURN
* eof MAKECALL



* ----------------------------------------------------------------------------
PROCEDURE DIALNUM
* from Phil Hill
* annotated by Marshall Ewig

PARA num,com
PRIV numlen,ax,bx,cx,dx,char,i

*---------------------------------------------------------------------------
* Phil has hardcoded Hayes commands here.  Perhaps they too should be in the
* dial.def file for user modification.  How about a table of appropriate
* commands and strings for a variety of modems, much like printer tables??
*---------------------------------------------------------------------------

num = "ATDT" + M->num                   && Hayes tone dial command.
numlen = LEN(M->num)
store 0 to bx, cx
dx = MIN(MAX(M->com - 1, 0),3)          && Only COM1 - COM4 allowed.

*---------------------------------------------------------------------------
* At this point, several tests would be appropriate:
*    1)  test to see if serial port is installed
*    2)  test to see that modem is connected to serial port
*    3)  test to see that line is NOT off hook (i.e., not in use)
*
* failure of each test in succession should branch to appropriate error msgs
*---------------------------------------------------------------------------

*-- Initialize the modem.
ax = 131                                && 1200,N,8,1
DOSINT 20, ax, bx, cx, dx

*  Another failure test should go here

*-- Remove any "non-dialable" characters and send the string to the modem.
FOR i = 1 TO M->numlen
    char = ASC(SUBS(M->num, M->i, 1))
    IF M->i <= 4 .OR. (M->char >= 48 .AND. M->char <= 57)
       ax = HTOI("01" + ITOH(M->char))
       DOSINT 20, ax, bx, cx, dx
    ENDIF
NEXT
ax = 269                                && cr
DOSINT 20, ax, bx, cx, dx

*---------------------------------------------------------------------------
*  This is where a test for a "busy" line should go, which should offer user
*  a choice to "try again", using the ON EVENT syntax, for example, to redial 
*  every n minutes for n times.  Another variation could put the number and
*  name into a temporary file of "still trying to reach..." for later use.
*  There are numerous posibilities!
*---------------------------------------------------------------------------

SLEEP 3                                         && adjust to suit
*  Still in dial instruction window
@ 0,0
@ 0,0 SAY "PICK UP PHONE... THEN PRESS ANY KEY"

*-- Wait for a keypress.
SET CONS OFF
WAIT
SET CONS ON

*-- Tell the modem to hang up.
ax = 321                                && "A"
DOSINT 20, ax, bx, cx, dx
ax = 340                                && "T"
DOSINT 20, ax, bx, cx, dx
ax = 328                                && "H"
DOSINT 20, ax, bx, cx, dx
ax = 269                                && cr
DOSINT 20, ax, bx, cx, dx

RETURN
* eof DIALNUM
