*** DIALDEMO.PRG
*** Demonstrates use of MAKECALL to display, select and dial phone numbers
*** MJE Associates/DAISYWHEEL, INC.
*** Written by Marshall Ewig
*** Last revised:  6/01/88
*** Language: dBXL/Quicksilver

CLEAR
SET TALK OFF
SET ESCAPE OFF
SET EXACT OFF
WCLOSE ALL
SET PROCEDURE TO MAKECALL

* ----------------------------------------------------------------------------
* Load your own flavor of cursor control.  I use the one from AT's Programmer
* Utilities , V1 which also has corresponding .obj files
LOAD CURSOR2

* ----------------------------------------------------------------------------
* The following three variables should be kept in a default table for the 
* application:
*   loc_ac                                       && the users own area code
*   ld_pfx                                       && the long distance prefix
*   dialport                                     && the com port
*
* The first two variables allow uniform data entry of phone numbers, all
* with area codes, but without dialing prefixes.  Logic in the subroutine
* strips the area code if it is local, or adds the prefix if the area
* code is not local.

USE DIAL.DEF
STORE AUTOMEM

* Other values could be kept in the default table:  modem strings for
* example (as I've noted in the subroutine DIALNUM) or to add "intelligence"
* to this application, one could keep alternative prefix strings... for MCI,
* Sprint, etc., (assuming you have these services).  Add times, specific area
* codes to the table and with additional logic in the subroutines and you can
* take advantage of lower rates.  There's a lot of possibilities here!
* ----------------------------------------------------------------------------


* ----------------------------------------------------------------------------
* The code from this point opens a name file with one record (for this demo).
* In a real application, you might select a name in many ways.  This demo
* code presuposes that you've done the selection/lookup.
*
* Also, for simplification, the windowing parameters HERE may not jive with
* existing applications.  In the subroutine, however, the windowing syntax
* is PRIMITIVE.

* Open data files
SELECT 1
USE PHONDEMO INDEX PHONDEMO                     && phone list indexed on idno
SELECT 2
USE NAMEDEMO                                    && no need for index here
STORE AUTOMEM
* ----------------------------------------------------------------------------
* Set up windows
WSET WINDOW name TO 3,1,18,53 color w/n,i/n,w+/n
WSET WINDOW prompt to 22,1,23,78 color w+/n,i/n,w+/n

WSELECT 2
WUSE name TITLE "NAME SELECTED" LEFT
DO NAMES3                                       && display selected name

WSELECT 1                                       && display a user prompt
WUSE prompt
@ 0,0 say "F9 - LOOKUP PHONE NUMBERS/MAKE CALL"
@ 0,68 SAY "<Esc> QUIT"

* The choice of F9 is arbitrary, however, it should be consistent throughout
* the application, i.e, F9 only will do phone numbers.  By using F keys, you
* can trap exits from full screen reads and do special functions, like
* making calls, while in the middle of an edit.

* ----------------------------------------------------------------------------
*  number lookup/call loop
CALL CURSOR2 WITH "OFF"
callmode = .T.
DO WHILE callmode
   key = 0
   DO WHILE key = 0
      key = inkey()
   ENDDO
   DO CASE
   CASE key = -8                                && F9
      DO MAKECALL
      WSELECT 1
   CASE key = 27                                && Escape
      callmode = .F.
   ENDCASE
ENDDO (callmode)


* ----------------------------------------------------------------------------
* Shut down
CALL CURSOR2 WITH "NORMAL"
WCLOSE ALL
CLOSE DATABASES
CLOSE PROCEDURE
SET TALK ON
SET ESCAPE ON
RELEASE MODULE CURSOR2
CANCEL
* eof DIALDEMO
