;John T. Opincar, Jr.
;CID: 71631,541
;07/06/90
;
;Donated to the public domain.
;
;WARNING.  The author makes no guarantees about the proper functioning of this
;program.  You will be using it at your own risk.  TSR programs are inherently
;risky, although care has been taken to make DIAL.COM as safe as possible.  The
;author has been using this program for several months in combination with
;several other TSR programs with no ill-effects.  If you are having
;difficulties, try loading DIAL.COM without any other TSRs, or loading your TSRs
;in a different order.
;
;Please see accompanying file, DIAL.MAN, for instructions on using DIAL.COM.
;These comments are only intended to help you understand how the CLIPPER
;specific portions of DIAL.COM work.  For information on creating TSR programs
;generally, see Prosise, J.  "Utilities: Desktop Filing and Dialing," PC
;Magazine Volume 6 Number 17: pp. 401-435 (October 13, 1987).
;
;DIAL.COM is a TSR utility which will search a CLIPPER index file for a
;specified name, present a window of matching entries, and dial the selected
;telephone number.  The index key of the specified index must be in the
;following format:
;
;    <     Name    ><  Phone #  >
;             1         2
;    1234567890123456789012345678
;
;The name portion of the key should be 15 characters long and in upper case.
;The phone # portion should be in the following format "(555)555-9898".  If the
;database which you are going to use with DIAL.COM uses a different picture
;for storing phone numbers, you should write a function which will convert it to
;the format expected by DIAL.COM.  If you are more adventurous (or have more
;time to burn), you could modify this program to work with the format you use.
;
;Clipper indices are B-Tree type structures using a 1024 byte page size.  The
;first page contains all the information necessary to operate on the structure:
;key expression, key size, entry size (key size + 8), maximum keys per page,
;offset to the root node, etc. All subsequent pages are in the following format:
;
;<number of keys in current page> 2 byte integer
;<offsets from top of current page to page entries> series of 2 byte integers
;<page entries> series of entries which consist of:
;
;     <child page offset><corresponding record # in database><index key>
;byte        0 - 3                  4 - 7                   8 - (8 + keysize - 1)
;
;If there are index keys greater than the last entry in a page, then the last
;offset will point to the child page containing those keys.  An entry without
;any children will contain a zero for its child page pointer.
;
;If you have ever noticed that skipping backwards through a large database with
;a controlling index is slower than skipping forward, the lack of a parent page
;pointer should explain this discrepancy to you.
;
;If you are unfamiliar with B-Trees, see Korth, H. F.; Silberschatz, A. Database
;System Concepts pp. 275-282 for an introduction to the topic.
;
;DIAL.COM does not take advantage of the dynamic nature of Clipper's B-Tree
;index structure.  It assumes that the file specified as the name+phone # index
;is in the expected format.  Although a more flexible, conceptually-pleasing
;index search routine could have been used by DIAL.COM, the size constraints
;imposed by its TSR nature and the time constraints on the programmer made such
;an implementation impractical.
;
;If you have any questions or comments on DIAL.COM, send e-mail or NANFORUM
;messages to John T. Opincar, Jr., CID: 71631,541.

;-------------------------------------------------------------------------------
;-----------------------------------MACROS--------------------------------------
;-------------------------------------------------------------------------------

charout     MACRO char
            mov     ah,02h
            mov     dl,char
            int     21h
ENDM

messout     MACRO str, len
            mov     ah,40h
            mov     bx,1
            mov     cx,len
            mov     dx,OFFSET str
            int     21h
ENDM

dispstr     MACRO str, row
            mov     si,OFFSET str
            mov     cx,row
            call    PUTSTR
ENDM

error       MACRO   messno
            dispstr mess&messno, 0
            dispstr mess5, 1
            CALL    INKEY
ENDM

fread       MACRO   handle, buffer, size
            mov     ah,3fh
            mov     bx,handle
            mov     dx,OFFSET buffer
            mov     cx,size
            int     21h
ENDM

fseek       MACRO   handle, hi, lo, origin
            mov     ah,42h
            mov     al,origin
            mov     bx,handle
            mov     cx,hi
            mov     dx,lo
            int     21h
ENDM

;-------------------------------------------------------------------------------
;-----------------------------RESIDENT PORTION----------------------------------
;-------------------------------------------------------------------------------

bios_data   segment at 40h
rs232_base  dw      4 dup(?)
bios_data   ENDS

code        segment para public 'code'
            assume cs:code
            org 2ch
ENVSEG      dw  ?
            org 100h

start:      jmp     initialize

signature   db      "Dial.com v 1.0",13,10
dos_seg     dw      ?
indos_ofs   dw      ?
errflag_ofs dw      ?
dos_version db      ?
popped_up   db      0
flag10h     db      0
flag13h     db      0
requestflag db      0
ss_reg      dw      ?
sp_reg      dw      ?
oldpsp      dw      ?
zflag       db      ?

timer_int   label   dword
old8h       dw      2 dup(?)
kbd_int     label   dword
old9h       dw      2 dup(?)
video_int   label   dword
old10h      dw      2 dup(?)
disk_int    label   dword
old13h      dw      2 dup(?)
mux_int     label   dword
old28h      dw      2 dup(?)

old1bh_ofs  dw      ?
old1bh_seg  dw      ?
old23h_ofs  dw      ?
old23h_seg  dw      ?
old24h_ofs  dw      ?
old24h_seg  dw      ?

;Warning.  You must not change any data prior to this point.
;Furthermore, if you change the values below, you must make sure that
;the distance between comport and mess2 is EXACTLY 74 bytes!
;Failure to comply with these requirements will cause the /p option to hose
;the com file!

comport     dw      0                       ;com1
area        db      "512",0                 ;Austin, TX area code
ntxname     db      "phone.ntx",0           ;name of phone index file
ntxpad      db      56 dup(0)               ;filler for long path/file names
ntxnamelen  dw      9                       ;length of default index file name

mess2       db      " Could not open index file     "
mess3       db      " Could not find that name      "
mess4       db      " Dialing                       "
mess5       db      " Press any key...              "
mess6       db      " Error initializing modem      "
mess7       db      " Error writing to modem        "
mess8       db      " Enter name:                   "
crlf        db      13,10
buffptr     db      4 dup(?)
dial        db      "atdt"
one         db      "1"
hangup      db      "ath",13
lastname    db      16 dup(?)
ntx         dw      ?
root        dd      ?
lastroot    dd      ?
ntxpage     db      1024 dup(?)
entrynum    dw      ?
entry       dw      ?
scrnbuff    db      330 dup(66)
matches     db      93 dup(?)
matchcount  dw      ?
matchptr    dw      ?
pushcount   dw      ?
popped      dw      ?
cursor_pos  dw      ?
cursor_shape dw     ?
video_seg   dw      ?
stackspace  db      256 dup(?)
calltype    db      ?

;-------------------------------------------------------------------------------
;------------------------------INTERRUPT HANDLERS-------------------------------
;-------------------------------------------------------------------------------

;----------------------------------KEYBOARD-------------------------------------

KEYBOARD    proc    near
            sti
            pushf
            call    kbd_int
            push    ax
            mov     ah,2
            int     16h
            and     al,0fh
            cmp     al,9
            pop     ax
            jne     kbdexit
            cmp     popped_up,0
            jne     kbdexit
            mov     requestflag,18
kbdexit:    iret
KEYBOARD    ENDP

;-----------------------------------TIMER---------------------------------------

TIMER       proc    near
            pushf
            call    timer_int
            cmp     requestflag,0
            je      timer_exit
            cmp     flag10h,0
            jne     dectime
            cmp     flag13h,0
            jne     dectime
            push    es
            push    di
            mov     es,dos_seg
            mov     di,indos_ofs
            cmp     byte ptr es:[di],0
            jne     poptime
            mov     di,errflag_ofs
            cmp     byte ptr es:[di],0
            jne     poptime
            pop     di
            pop     es
            mov     requestflag,0
            call    main
timer_exit: iret
poptime:    pop     di
            pop     es
dectime:    dec     requestflag
            iret
TIMER       ENDP

;-----------------------------------VIDEO---------------------------------------

VIDEO       proc    near
            pushf
            inc     flag10h
            call    video_int
            dec     flag10h
            iret
VIDEO       ENDP

;-----------------------------------BDISK---------------------------------------

BDISK       proc    far
            pushf
            inc     flag13h
            call    disk_int
            pushf
            dec     flag13h
            popf
            ret     2
BDISK       ENDP

;------------------------------------MUX----------------------------------------

MUX         proc    near
            pushf
            call    mux_int
            cmp     requestflag,0
            je      mux_exit
            cmp     flag10h,0
            jne     mux_exit
            cmp     flag13h,0
            jne     mux_exit
            push    es
            push    di
            mov     es,dos_seg
            mov     di,errflag_ofs
            cmp     byte ptr es:[di],0
            pop     di
            pop     es
            jne     mux_exit
            mov     requestflag,0
            call    main
mux_exit:   iret
MUX         ENDP

;-----------------------------------IOERR---------------------------------------

IOERR       proc    near
            mov     al,3
nullint:    iret
IOERR       ENDP

;------------------------------------MAIN---------------------------------------

MAIN        proc    near
            mov     popped_up,1
            cli
            mov     ss_reg,ss               ;switch to internal stack
            mov     sp_reg,sp
            push    cs
            pop     ss
            mov     sp,OFFSET calltype
            sti
            push    ax                      ;save all registers
            push    bx
            push    cx
            push    dx
            push    si
            push    di
            push    ds
            push    es
            push    bp

            push    cs                      ;set up data addressability
            pop     ds
            assume  ds:code
            push    cs
            pop     es
            assume  es:code

            mov     ntx,0                   ;reset ntx handle

            mov     ah,3                    ;save cursor shape & position
            xor     bh,bh
            int     10h
            mov     cursor_shape,cx
            mov     cursor_pos,dx

            push    es                      ;save active psp & restore ours
            mov     zflag,0
            cmp     dos_version,2
            jne     main5
            mov     es,dos_seg
            mov     di,indos_ofs
            cmp     byte ptr es:[di],0
            je      main5
            mov     di,errflag_ofs
            cmp     byte ptr es:[di],0
            jne     main5
            mov     byte ptr es:[di],1
            mov     zflag,1
main5:      mov     ah,51h
            int     21h
            mov     oldpsp,bx
            mov     ah,50h
            push    cs
            pop     bx
            int     21h
            cmp     zflag,0
            je      main6
            mov     di,errflag_ofs
            mov     byte ptr es:[di],0
main6:      pop     es

            call    IOSET                   ;temporarily divert interrupts

            call    SAVESCRN                ;save screen region & setup window

            cmp     calltype,0              ;see if already have name
            je      needname
            jmp     havename

needname:   dispstr mess8,0
            mov     ah,2                    ;position cursor for entry
            xor     bh,bh
            mov     dh,10
            mov     dl,37
            int     10h

            mov     dh,10
            mov     bx,0
            mov     di,OFFSET lastname      ;get name
            push    es
            assume  es:nothing
            mov     ax,video_seg
            mov     es,ax
            mov     si,1674

iloop:      call    INKEY

            or      al,al                   ;check for extended key
            jz      iloop                   ;extended key so get another

            cmp     al,27                   ;escape pressed?
            jne     notesc
            jmp     exit

notesc:     cmp     al,13                   ;check for cr
            jne     notcr
falsecr:    shr     bx,1
            mov     [di + bx],al
            jmp     pop_es

notcr:      cmp     al,8                    ;check for backspace
            jne     notbs
            or      bx,bx
            jz      iloop
            sub     bx,2
            mov     ax,5f20h
            mov     es:[si + bx],ax
            jmp     movecursor

notbs:      cmp     al,32
            jb      iloop

            mov     ah,5fh                  ;handle regulare characters
            mov     es:[si + bx],ax
            shr     bx,1
            mov     [di + bx],al
            shl     bx,1
            add     bx,2
            mov     al,13
            cmp     bx,30
            je      falsecr

movecursor: mov     dl,bl
            shr     dl,1
            add     dl,37
            mov     ah,2
            int     10h
            jmp     iloop

pop_es:     pop     es
            assume  es:code

havename:   mov     ah,1                    ;shut cursor off
            xor     bh,bh
            mov     cx,1f1fh
            int     10h

            mov     di,OFFSET lastname      ;convert name to upper case
            dec     di
uloop:      inc     di
            mov     al,[di]
            cmp     al,'a'
            jb      iscr
            cmp     al,'z'
            ja      uloop
            sub     al,32
            mov     [di],al
iscr:       cmp     al,13
            jne     uloop
            mov     byte ptr [di],0

            mov     ah,3dh                  ;open index file
            mov     al,0
            mov     dx,OFFSET ntxname
            int     21h
            jnc     fileopen
            error   2
            jmp     exit

fileopen:   mov     ntx,ax                  ;find root
            fseek   ntx, 0, 4, 0
            fread   ntx, root, 4

            mov     ax,OFFSET matches       ;initialize tree traversal loops
            mov     matchptr,ax
            xor     ax,ax
            mov     word ptr lastroot[0],ax
            mov     word ptr lastroot[2],ax
            mov     pushcount,ax
            mov     matchcount,ax
            mov     popped,ax

outloop:    mov     entrynum,1
            mov     ax,word ptr root[0]     ;check for null root
            mov     dx,word ptr root[2]
            or      ax,dx
            jnz     pageread                ;good root, so read it
            cmp     pushcount,0             ;otherwise, see if roots on stack
            jg      poproot                 ;yes, then pop it
            jmp     outloopdone             ;no, done traversing index

poproot:    pop     word ptr root[2]        ;pop the root
            pop     word ptr root[0]
            pop     entrynum
            dec     pushcount
            inc     popped                  ;set popped flag

pageread:   mov     ax,word ptr lastroot[0] ;make sure we really need to read
            cmp     ax,word ptr root[0]     ;this page
            jne     newpage
            mov     ax,word ptr lastroot[2]
            cmp     ax,word ptr root[2]
            jne     newpage
            jmp     checkpopped
newpage:    mov     ax,word ptr root[0]     ;save new root to oldroot
            mov     word ptr lastroot[0],ax
            mov     ax,word ptr root[2]
            mov     word ptr lastroot[2],ax ;read the page
            fseek   ntx, <word ptr root[2]>, <word ptr root[0]>, 0
            fread   ntx, ntxpage, 1024
checkpopped:cmp     popped,0                ;if root was popped, we need to
            je      inloop                  ;record name in popped node
            mov     bx,OFFSET ntxpage
            mov     si,entrynum
            shl     si,1
            mov     si,[si + bx]
            add     si,bx
            add     si,8
            mov     di,matchptr
            mov     ax,matchcount
            add     ax,49
            mov     byte ptr [di],' '
            mov     [di + 1],al
            mov     byte ptr [di + 2],' '
            add     di,3
            mov     cx,14
            cld
            rep     movsw
            mov     matchptr,di
            inc     matchcount
            cmp     matchcount,3            ;if we have 3 matches, we're done
            jge     outloopdone
            inc     entrynum
            dec     popped

inloop:     mov     di,entrynum             ;calculate offset into page
            shl     di,1
            mov     bx,OFFSET ntxpage
            mov     di,[di + bx]
            add     di,bx
            mov     entry,di                ;save pointer to current entry in
            mov     ax,entrynum             ;node
            cmp     ax,[bx]                 ;is this the last entry in this node?
            jg      notequal                ;yes, then exit inner loop
            add     di,8                    ;no, then point to last name
            mov     si,OFFSET lastname      ;prepare to compare with target last name
            call    STRCMP                  ;compare strings
            inc     entrynum
            cmp     ax,0                    ;test result of comparison
            je      equal                   ;equal
            jl      notequal                ;less than
            jmp     inloop                  ;greater than, so stay in loop

equal:      dec     entrynum                ;equal, so push this page
            push    entrynum
            push    word ptr root[0]
            push    word ptr root[2]
            inc     pushcount

notequal:   mov     bx,entry                ;set up new root
            mov     ax,[bx]
            mov     word ptr root[0],ax
            mov     ax,[bx + 2]
            mov     word ptr root[2],ax
            jmp     outloop


outloopdone:cmp     pushcount,0             ;pop excess finds
            je      popdone
            pop     ax
            pop     ax
            pop     ax
            dec     pushcount
            jmp     outloopdone

popdone:    cmp     matchcount,0            ;check for matches
            jg      namefound
            error   3                       ;if none, then exit
            jmp     exit

namefound:  mov     entrynum,1
            cmp     matchcount,1            ;if only one match
            je      dialnow                 ;jump over selection loop
            mov     si,OFFSET matches       ;otherwise, display matches
            xor     bx,bx
chloop:     mov     cx,bx
            call    PUTSTR
            inc     bx
            cmp     bx,matchcount
            jl      chloop

keyloop:    call    INKEY                   ;wait for selection
            or      al,al
            jz      keyloop
            xor     ah,ah
            cmp     ax,27
            jne     notesc2
            jmp     exit
notesc2:    sub     ax,48
            cmp     ax,1
            jl      keyloop
            cmp     ax,matchcount
            jg      keyloop
            mov     entrynum,ax

dialnow:    dispstr mess4, 0                ;display dialing messages
            mov     ax,entrynum
            dec     ax
            mov     cl,31
            mul     cl
            mov     si,OFFSET matches
            add     si,ax
            mov     entry,si
            mov     cx,1
            call    PUTSTR
            dispstr mess5, 2

            call    COMINIT                 ;initialize com port
            or      ax,ax
            jnz     cominitted
            error   6
            jmp     exit

cominitted: mov     si,OFFSET dial          ;send "atdt"
            mov     cx,4
            call    COMSEND
            or      ax,ax
            jz      exit

            mov     si,OFFSET area          ;check for local area code
            mov     di,entry
            add     di,19
            call    STRCMP
            or      ax,ax
            jnz     notlocal
            mov     si,di                   ;local, so skip area code
            mov     cx,8
            call    COMSEND
            jmp     waitforkey

notlocal:   mov     si,OFFSET one           ;not local, so send "1"
            mov     cx,1
            call    COMSEND
            mov     si,entry                ;and send entire phone number
            add     si,19
            mov     cx,12
            call    COMSEND

waitforkey: or      ax,ax
            jz      exit
            mov     si,OFFSET crlf          ;send carriage return/line feed
            mov     cx,2
            call    COMSEND
            or      ax,ax
            jz      exit

            call    INKEY                   ;wait for keypress before
                                            ;hanging up
            mov     si,OFFSET hangup        ;now hang up
            mov     cx,4
            call    COMSEND

            call    COMREST                 ;restore com port to initial state

exit:       cmp     ntx,0                   ;was index file opened?
            je      ntxnotopen              ;no, then don't close
            mov     ah,3eh                  ;yes, then close index file
            mov     bx,ntx
            int     21h
ntxnotopen: call    RESTSCRN                ;restore screen

            mov     ah,50h                  ;restore active PSP
            mov     bx,oldpsp
            int     21h

            call    IORESET                 ;restore interrupt vectors

            mov     ah,2                    ;restore cursor shape & position
            xor     bh,bh
            mov     dx,cursor_pos
            int     10h
            mov     ah,1
            mov     cx,cursor_shape
            int     10h

            pop     bp                      ;restore registers
            pop     es
            assume  es:nothing
            pop     ds
            assume  ds:nothing
            pop     di
            pop     si
            pop     dx
            pop     cx
            pop     bx
            pop     ax
            cli
            mov     ss,ss_reg               ;switch back to normal stack
            mov     sp,sp_reg
            sti
            mov     popped_up,0
            ret
MAIN        ENDP

            assume  ds:code,es:code

;-----------------------------------INKEY---------------------------------------
;
;COMMENTS: can't use DOS keyboard functions when popped up
;
; RETURNS: key pressed in AX
;
INKEY       proc    near
            mov     ah,1
            int     16h
            jne     inkey1
            int     28h
            jmp     inkey
inkey1:     mov     ah,0
            int     16h
            ret
INKEY       ENDP

;-----------------------------------PUTSTR--------------------------------------
;
;COMMENTS: write string to window, length assumed to be 31
;
;      IN: DS:SI points to string to be output, CX is row of window (0-2)
;

PUTSTR      proc    near
            push    es
            mov     ax,video_seg
            mov     es,ax
            mov     ax,160
            mul     cl
            mov     di,ax
            add     di,1648
            mov     cx,31
ploop:      mov     al,[si]
            mov     es:[di],al
            inc     si
            add     di,2
            dec     cx
            jnz     ploop
            pop     es
            ret
PUTSTR      ENDP

;----------------------------------SAVESCRN-------------------------------------
;
;COMMENTS: saves screen region and draws window border & initializes
;
SAVESCRN    proc    near
            mov     di,OFFSET scrnbuff
            mov     ax,video_seg
            push    ds
            mov     ds,ax
            assume  ds:nothing

            mov     si,1486             ;save screen
            mov     bx,5
sloop2:     mov     cx,33
            rep     movsw
            add     si,94
            dec     bx
            jnz     sloop2

            mov     bx,640
            mov     si,1488
            mov     cx,31
            mov     al,''
            mov     ah,5fh
sloop:      mov     [si],ax
            mov     [si + bx],ax
            add     si,2
            dec     cx
            jnz     sloop

            mov     bx,64
            mov     si,1646
            mov     cx,3
            mov     al,''
sloop3:     mov     [si],ax
            mov     [si + bx],ax
            add     si,160
            dec     cx
            jnz     sloop3

            mov     bx,640
            mov     si,1486
            mov     al,''
            mov     [si],ax
            mov     al,''
            mov     [si + bx],ax
            mov     si,1550
            mov     al,''
            mov     [si],ax
            mov     al,''
            mov     [si + bx],ax
            pop     ds
            assume  ds:code

            push    es
            assume  es:nothing
            mov     ax,video_seg
            mov     es,ax
            mov     di,1648
            mov     bx,3
            mov     ax,5f20h
scrnloop:   mov     cx,31
            rep     stosw
            add     di,98
            dec     bx
            jnz     scrnloop
            pop     es
            assume  es:code
            ret
SAVESCRN    ENDP

;----------------------------------RESTSCRN-------------------------------------
;
;COMMENTS: restore window screen region
;
RESTSCRN    proc    near
            mov     si,OFFSET scrnbuff
            mov     ax,video_seg
            push    es
            mov     es,ax
            assume  es:nothing
            mov     di,1486
            mov     bx,5
restloop:   mov     cx,33
            rep     movsw
            add     di,94
            dec     bx
            jnz     restloop
            pop     es
            assume  es:code
            ret
RESTSCRN    ENDP

;-----------------------------------STRCMP--------------------------------------
;
;COMMENTS: compares two strings, string pointed to by DS:SI must be null
;          terminated
;
;      IN: DS:SI points to string1, ES:DI points to string2
;
;  RETURN: AX, s1 < s2 = -1, s1 = s2 = 0, s1 > s2 = 1
;
STRCMP      proc    near
            mov     cx,28
            cld
            repe    cmpsb
            dec     si
            xor     ax,ax
            cmp     byte ptr [si],0
            je      strcmpdone
            dec     di
            dec     ax
            mov     bl,[si]
            cmp     bl,es:[di]
            jb      strcmpdone
            add     ax,2
strcmpdone: ret
STRCMP      ENDP

;----------------------------------COMINIT--------------------------------------
;
;COMMENTS: save state of com port and initialize com port
;
;  RETURN: AX, 1 if successful, 0 otherwise
;
COMINIT     proc    near
            mov     si,comport
            shl     si,1
            mov     ax,bios_data
            push    es
            mov     es,ax
            assume  es:bios_data
            mov     dx,rs232_base[si]
            pop     es
            assume  es:code
            or      dx,dx
            jnz     installed
            xor     ax,ax
            jmp     cominitdone

installed:  mov     bx,OFFSET buffptr
            add     dx,3
            in      al,dx
            mov     [bx],al
            or      al,80h
            out     dx,al
            sub     dx,3
            in      al,dx
            mov     [bx + 1],al
            inc     dx
            in      al,dx
            mov     [bx + 2],al
            mov     al,[bx]
            and     al,0f7h
            add     dx,2
            out     dx,al
            sub     dx,2
            in      al,dx
            mov     [bx + 3],al

            mov     ah,0
            mov     al,10000011b
            mov     dx,comport
            int     14h
            mov     ax,1

cominitdone:ret
COMINIT     ENDP

;----------------------------------COMSEND--------------------------------------
;
;COMMENTS: sends string pointed to by DS:SI to com port
;
;      IN: DS:SI string to send, CX length of string to send
;
;  RETURN: AX, 1 if sent, 0 if failed to send
;
COMSEND     proc    near
            mov     dx,comport
loop1:      mov     al,[si]
            mov     ah,1
            int     14h
            test    ah,80h
            jnz     csnotsent
            inc     si
            dec     cx
            jnz     loop1
            mov     ax,1
            jmp     csdone
csnotsent:  error   7
            xor     ax,ax
csdone:     ret
COMSEND     ENDP

;----------------------------------COMREST--------------------------------------
;
;COMMENT: restore com port
;
COMREST     proc    near
            mov     si,comport
            shl     si,1
            mov     ax,bios_data
            push    es
            mov     es,ax
            assume  es:bios_data
            mov     dx,rs232_base[si]
            pop     es
            assume  es:code
            add     dx,3
            mov     al,80h
            out     dx,al
            sub     dx,3
            mov     bx,OFFSET buffptr
            mov     al,[bx + 1]
            out     dx,al
            inc     dx
            mov     al,[bx + 2]
            out     dx,al
            add     dx,2
            xor     al,al
            out     dx,al
            sub     dx,2
            mov     al,[bx + 3]
            out     dx,al
            add     dx,2
            mov     al,[bx]
            out     dx,al
            ret
COMREST     ENDP

;-----------------------------------IOSET---------------------------------------
;
;COMMENTS: temporarily divert certain interrupts
;
IOSET       proc    near
            push    es

            mov     ax,351bh
            int     21h
            mov     old1bh_ofs,bx
            mov     old1bh_seg,es
            mov     dx,OFFSET nullint
            mov     ah,25h
            int     21h

            mov     ax,3523h
            int     21h
            mov     old23h_ofs,bx
            mov     old23h_seg,es
            mov     dx,OFFSET nullint
            mov     ah,25h
            int     21h

            mov     ax,3524h
            int     21h
            mov     old24h_seg,bx
            mov     old24h_ofs,es
            mov     dx,OFFSET ioerr
            mov     ah,25h
            int     21h

            pop     es
            ret
IOSET       ENDP

;----------------------------------IORESET--------------------------------------
;
;COMMENTS: restore diverted interrupts
;
IORESET     proc    near
            mov     ax,2524h
            mov     dx,old24h_ofs
            push    ds
            assume  ds:nothing
            mov     ds,old24h_seg
            int     21h

            mov     ax,2523h
            mov     dx,old23h_ofs
            mov     ds,old23h_seg
            int     21h

            mov     ax,251bh
            mov     dx,old1bh_ofs
            mov     ds,old1bh_seg
            int     21h

            pop     ds
            assume  ds:code
            ret
IORESET     ENDP

            assume  ds:nothing,es:nothing

;-------------------------------------------------------------------------------
;----------------------------NON-RESIDENT PORTION-------------------------------
;-------------------------------------------------------------------------------

initialize: jmp     init

ierror1     db      "Dial already resident",13,10
lierror1    equ     $ - ierror1
ierror2     db      "Critical error flag not found",13,10
lierror2    equ     $ - ierror2
ierror3     db      "Invalid parameter",13,10
lierror3    equ     $ - ierror3
imess1      db      "Dial.com resident.  Press <Alt>-<RightShift> to invoke.",13,10
limess1     equ     $ - imess1
imess2      db      "3-Save Changes",13,10,"4-Abort",13,10,"Please select one of the above..."
limess2     equ     $ - imess2
commess     db      " COM Port: "
areamess    db      "Area Code: "
filemess    db      "File Name: "
imess4      db      "Could not open dial.com.  It must be in the current directory.",13,10
limess4     equ     $ - imess4
imess5      db      "Error writing dial.com",13,10
limess5     equ     $ - imess5
imess6      db      "Changes written to dial.com.  If dial.com is already resident, the changes will not take effect until you re-boot and re-load the program.",13,10
limess6     equ     $ - imess6
comfilename db      "dial.com",0
comfile     dw      ?
rbuffer     db      68 dup(?)

init:       mov     ah,0fh                  ;determine type of monitor
            int     10h
            cmp     al,7
            je      mono
            mov     ax,0b800h
            jmp     checkparms
mono:       mov     ax,0b000h

checkparms: mov     video_seg,ax
            mov     si,80h
            mov     cl,[si]                 ;check for command line parameters
            or      cl,cl
            jz      noparms

spaceloop:  inc     si                      ;skip initial spaces in command-line
            cmp     byte ptr [si],32
            jne     parms
            dec     cl
            jz      noparms
            jmp     spaceloop

noparms:    push    cs
            mov     calltype,0
            call    MAIN
            jmp     noresexit

parms:      cmp     byte ptr [si],'/'
            je      checkr

            xor     ch,ch                   ;parm is name to look up
            mov     ax,cs
            mov     es,ax
            assume  es:code
            mov     di,OFFSET lastname
            cld
            rep     movsb
            mov     byte ptr [di],0
            mov     ds,ax
            assume  ds:code
            mov     calltype,1
            call    MAIN
            jmp     noresexit


checkr:     inc     si                      ;parm is slash directive
            mov     al,[si]
            cmp     al,'a'
            jb      notlower2
            cmp     al,'z'
            ja      notlower2
            sub     al,32
            mov     [si],al
notlower2:  cmp     byte ptr [si],'R'
            je      init1
            cmp     byte ptr [si],'P'
            jne     badparam
            jmp     setoptions
badparam:   messout ierror3, lierror3
            jmp     noresexit

;----------------------------PREPARE FOR RESIDENCY------------------------------

init1:      push    cs
            pop     ds
            assume  ds:code
            mov     word ptr [start],0
            xor     bx,bx
            mov     ax,cs
init2:      inc     bx
            cmp     ax,bx
            je      init3
            mov     es,bx
            mov     si,OFFSET start
            mov     di,si
            mov     cx,16
            cld
            repe    cmpsb
            jne     init2
            messout ierror1, lierror1
            jmp     noresexit

init3:      mov     ah,30h              ;determine dos version
            int     21h
            mov     dos_version,al

            mov     ah,34h              ;get and save address of INDOS flag
            int     21h
            mov     dos_seg,es
            mov     indos_ofs,bx

            mov     ax,3e80h
            mov     cx,2000h
            mov     di,bx
init4:      repne   scasw
            jcxz    init5
            cmp     byte ptr es:[di + 5],0bch
            je      found
            jmp     init4
init5:      mov     cx,2000h
            inc     bx
            mov     di,bx
init6:      repne   scasw
            jcxz    notfound
            cmp     byte ptr es:[di + 5],0bch
            je      found
            jmp     init6
notfound:   messout ierror2, lierror2
            jmp     noresexit

found:      mov     ax,es:[di]
            mov     errflag_ofs,ax
            mov     calltype,0

            mov     ax,3508h                ;save & replace interrupt vectors
            int     21h
            mov     old8h,bx
            mov     old8h[2],es
            mov     ah,25h
            mov     dx,OFFSET timer
            int     21h

            mov     ax,3509h
            int     21h
            mov     old9h,bx
            mov     old9h[2],es
            mov     ah,25h
            mov     dx,OFFSET keyboard
            int     21h

            mov     ax,3510h
            int     21h
            mov     old10h,bx
            mov     old10h[2],es
            mov     ah,25h
            mov     dx,OFFSET video
            int     21h

            mov     ax,3513h
            int     21h
            mov     old13h,bx
            mov     old13h[2],es
            mov     ah,25h
            mov     dx,OFFSET bdisk
            int     21h

            mov     ax,3528h
            int     21h
            mov     old28h,bx
            mov     old28h[2],es
            mov     ah,25h
            mov     dx,OFFSET mux
            int     21h

            messout imess1, limess1

            mov     ax,ENVSEG               ;deallocate envnmt space
            mov     es,ax
            mov     ah,49h
            int     21h

            mov     dx,OFFSET initialize    ;terminate & stay resident
            int     27h

;--------------------------------SET OPTIONS------------------------------------

setoptions: push    cs
            pop     ds
            assume  ds:code
            push    cs
            pop     es
            assume  es:code

oloop:      messout crlf, 2
            messout crlf, 2
            charout '0'
            charout '-'
            messout commess, 11
            mov     cx,comport
            add     cl,49
            charout cl
            messout crlf, 2

            charout '1'
            charout '-'
            messout areamess, 11
            messout area, 3
            messout crlf, 2

            charout '2'
            charout '-'
            messout filemess, 11
            messout ntxname, ntxnamelen
            messout crlf, 2

            messout imess2, limess2

keyin:      call    GETKEY
            cmp     al,'0'
            jb      keyin
            cmp     al,'4'
            ja      keyin
            cmp     al,'4'
            jne     notabort
            jmp     noresexit
notabort:   cmp     al,'3'
            jne     notsave
            jmp     savechanges

notsave:    push    ax
            messout crlf, 2
            pop     ax
            cmp     al,'0'
            ja      nott0

            messout commess, 11
comkey:     call    GETKEY
            cmp     al,'1'
            jb      comkey
            cmp     al,'4'
            ja      comkey
            push    ax
            mov     dx,ax
            mov     ah,02h
            int     21h
            pop     ax
            sub     ax,49
            mov     comport,ax
            jmp     oloop

nott0:      cmp     al,'1'
            ja      nott1
            messout areamess, 11
            mov     di,OFFSET area
            mov     cx,3
            call    READ
            jmp     oloop

nott1:      messout filemess, 11
            mov     di,OFFSET ntxname
            mov     cx,66
            call    READ
            mov     ntxnamelen,cx
            jmp     oloop

savechanges:messout crlf, 2
            mov     ah,3dh                  ;open command file
            mov     al,2
            mov     dx,OFFSET comfilename
            int     21h
            jnc     comfileopen
            messout imess4, limess4
            jmp     noresexit

comfileopen:mov     comfile,ax
            fseek   comfile, 0, 69, 0
            mov     ah,40h
            mov     bx,comfile
            mov     dx,OFFSET comport
            mov     cx,74
            int     21h
            jnc     writeok
            messout imess5, limess5
writeok:    mov     ah,3eh
            mov     bx,comfile
            int     21h
            messout imess6, limess6

noresexit:  mov     ah,4ch
            int     21h

;-----------------------------------GETKEY--------------------------------------

GETKEY      proc    near
            mov     ah,08h
            int     21h
            or      al,al
            jnz     notextended
            mov     ah,08h
            int     21h
            xor     al,al
notextended:xor     ah,ah
            ret
GETKEY      ENDP

;------------------------------------READ---------------------------------------

READ        proc    near
            mov     si,OFFSET rbuffer
            mov     [si],cl
            inc     byte ptr [si]
            mov     dx,si
            mov     ah,0ah
            int     21h
            mov     si,OFFSET rbuffer
            inc     si
            mov     cl,[si]
            or      cl,cl
            jnz     notempty
            dec     si
            mov     cl,[si]
            xor     ch,ch
            dec     cx
            push    cx
            jmp     buffempty
notempty:   inc     si
            xor     ch,ch
            push    cx
            cld
            rep     movsb
            mov     byte ptr [di],0
buffempty:  pop     cx
            ret
READ        ENDP

code        ENDS
END start
